/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service;

import com.jeesite.common.callback.MethodCallback;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.entity.Page;
import com.jeesite.common.mybatis.mapper.query.QueryOrder;
import com.jeesite.common.mybatis.mapper.query.QueryType;
import com.jeesite.common.service.CrudService;
import com.jeesite.modules.sys.dao.RoleDao;
import com.jeesite.modules.sys.dao.RoleDataScopeDao;
import com.jeesite.modules.sys.dao.RoleMenuDao;
import com.jeesite.modules.sys.dao.UserRoleDao;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.RoleDataScope;
import com.jeesite.modules.sys.entity.RoleMenu;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.entity.UserRole;
import com.jeesite.modules.sys.service.G;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.service.m;
import com.jeesite.modules.sys.utils.CorpUtils;
import com.jeesite.modules.sys.utils.RoleUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RoleService
extends CrudService<RoleDao, Role> {
    @Autowired
    private UserService userService;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleDataScopeDao roleDataScopeDao;
    @Autowired
    private RoleMenuDao roleMenuDao;

    @Override
    public void addDataScopeFilter(Role role, String ctrlPermi) {
        role.getSqlMap().getDataScope().addFilter(RoleUtils.ALLATORIxDEMO("R\u0015P"), QueryOrder.ALLATORIxDEMO("E2{8"), RoleUtils.ALLATORIxDEMO("WHD\tZ\u0003i\u0005Y\u0002S"), ctrlPermi);
    }

    @Transactional(readOnly=false)
    public void saveAuthDataScope(Role role) {
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)role.getRoleCode())) {
            return;
        }
        ((RoleDao)this.dao).updateDataScope(role);
        RoleDataScope a2 = new RoleDataScope();
        a2.setRoleCode(role.getRoleCode());
        this.roleDataScopeDao.deleteByEntity(a2);
        Role role2 = role;
        ListUtils.pageList(role2.getRoleDataScopeList(), (int)100, (MethodCallback)new m(this));
        this.clearUserCacheByRoleCode(role2);
    }

    @Transactional(readOnly=false)
    public void saveAuthUser(Role role) {
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)role.getRoleCode())) {
            return;
        }
        for (UserRole a2 : role.getUserRoleList()) {
            if (this.userRoleDao.get(a2) != null) continue;
            this.userRoleDao.insert(a2);
        }
        this.clearUserCacheByRoleCode(role);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(readOnly=false)
    public void delete(Role role) {
        void role2;
        RoleService roleService = this;
        super.delete(role2);
        roleService.clearUserCacheByRoleCode(role);
    }

    @Override
    public Page<Role> findPage(Page<Role> page, Role role) {
        return super.findPage(page, role);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(readOnly=false)
    public void updateStatus(Role role) {
        void role2;
        RoleService roleService = this;
        super.updateStatus(role2);
        roleService.clearUserCacheByRoleCode(role);
    }

    static /* synthetic */ RoleDataScopeDao access$100(RoleService x0) {
        return x0.roleDataScopeDao;
    }

    static /* synthetic */ RoleMenuDao access$000(RoleService x0) {
        return x0.roleMenuDao;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Role> findList(Role role) {
        void role2;
        void v0 = role2;
        role2.getSqlMap().getWhere().disableAutoAddCorpCodeWhere();
        v0.getSqlMap().getWhere().andBracket(QueryOrder.ALLATORIxDEMO("~.H.n."), QueryType.EQ, "1").or(RoleUtils.ALLATORIxDEMO("U\tD\u0016i\u0005Y\u0002S"), QueryType.EQ, CorpUtils.getCurrentCorpCode()).endBracket();
        return super.findList(v0);
    }

    @Override
    public Role get(Role role) {
        return super.get(role);
    }

    private /* synthetic */ void clearUserCacheByRoleCode(Role role) {
        Iterator<User> iterator;
        User a2 = new User();
        a2.setRoleCode(role.getRoleCode());
        Iterator<User> iterator2 = iterator = this.userService.findListByRoleCode(a2).iterator();
        while (iterator2.hasNext()) {
            UserUtils.clearCache(iterator.next());
            iterator2 = iterator;
        }
    }

    public List<RoleDataScope> findDataScopeList(RoleDataScope roleDataScope) {
        return this.roleDataScopeDao.findList(roleDataScope);
    }

    @Transactional(readOnly=false)
    public void saveAuth(Role role) {
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)role.getRoleCode())) {
            return;
        }
        RoleMenu a2 = new RoleMenu();
        a2.setRoleCode(role.getRoleCode());
        this.roleMenuDao.deleteByEntity(a2);
        Role role2 = role;
        ListUtils.pageList(role2.getRoleMenuList(), (int)100, (MethodCallback)new G(this));
        this.clearUserCacheByRoleCode(role2);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Role role) {
        if (StringUtils.isBlank((CharSequence)role.getUserType())) {
            role.setUserType("none");
        }
        RoleService roleService = this;
        Role role2 = role;
        super.save(role2);
        roleService.clearUserCacheByRoleCode(role2);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void deleteAuthUser(Role role) {
        Iterator<UserRole> iterator;
        Global.assertDemoMode();
        Iterator<UserRole> iterator2 = iterator = role.getUserRoleList().iterator();
        while (iterator2.hasNext()) {
            void a2;
            UserRole userRole = iterator.next();
            iterator2 = iterator;
            this.userRoleDao.delete(a2);
        }
        this.clearUserCacheByRoleCode(role);
    }

    public List<Role> findListByUserCode(Role role) {
        return ((RoleDao)this.dao).findListByUserCode(role);
    }

    public Role getByRoleName(Role role) {
        Role a2 = new Role();
        a2.setRoleName(role.getRoleName());
        return ((RoleDao)this.dao).getByEntity(a2);
    }
}

