/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.config.CoreConfig;
import com.jeesite.modules.file.utils.FileUploadUtils;
import com.jeesite.modules.sys.entity.Module;
import com.jeesite.modules.sys.service.ModuleService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/module"})
public class ModuleController
extends BaseController {
    @Autowired
    private ModuleService moduleService;

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", CoreConfig.ALLATORIxDEMO("\u8dd5\u672c\u6492\u4f33\uff53\u5385\u6756\u8dea\u7ef8\u7bce\u7459\u5437\u6212\u8092\u4fb1\u6556\u6b3b\u651f\u6331\uff6e"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", FileUploadUtils.ALLATORIxDEMO("\u6824\u5ff6\u6a3d\u5762\uff10\u4e38\u515d\u8b8d\u799d\u751d\uff1d"));
        }
        this.moduleService.delete(module);
        return this.renderResult("true", CoreConfig.ALLATORIxDEMO("\u524f\u963b\u6a4e\u5708\u627f\u52c0\uff6e"));
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", FileUploadUtils.ALLATORIxDEMO("\u8dbf\u675f\u64f8\u4f40\uff39\u53f6\u673c\u8d99\u7e92\u7bbd\u7433\u5444\u6278\u80e1\u4fdb\u6525\u6b51\u656c\u635b\uff1d"));
        }
        module.setStatus("0");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, CoreConfig.ALLATORIxDEMO("\u5470\u7547\u6a7e\u5738")).append(module.getModuleName()).append(FileUploadUtils.ALLATORIxDEMO("\u6225\u5283")).toString());
    }

    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Module> listData(Module module, HttpServletRequest request, HttpServletResponse response) {
        return this.moduleService.findPage(new Page<Module>(request, response), module);
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", CoreConfig.ALLATORIxDEMO("\u8dd5\u672c\u6492\u4f33\uff53\u5385\u6756\u8dea\u7ef8\u7bce\u7459\u5437\u6212\u8092\u4fb1\u6556\u6b3b\u651f\u6331\uff6e"));
        }
        this.moduleService.save(module);
        return this.renderResult("true", FileUploadUtils.ALLATORIxDEMO("\u4fc1\u5b6d\u6a3d\u5762\u620c\u52aa\uff1d"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"list"})
    public String list(Module module, Model model) {
        void module2;
        module2.setStatus("");
        return CoreConfig.ALLATORIxDEMO("2\u0000;\u001a3\n,@,\u0016,@2\u0000;\u001a3\n\u0013\u0006,\u001b");
    }

    @ModelAttribute
    public Module get(String moduleCode, boolean isNewRecord) {
        return (Module)this.moduleService.get(moduleCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"checkModuleCode"})
    @ResponseBody
    public String checkModuleCode(String oldCode, String moduleCode) {
        Module a2 = new Module();
        String string = moduleCode;
        a2.setModuleCode(string);
        if (string != null && moduleCode.equals(oldCode)) {
            return "true";
        }
        if (moduleCode != null && this.moduleService.get(a2) == null) {
            return "true";
        }
        return "false";
    }

    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"form"})
    public String form(Module module, Model model) {
        if (StringUtils.isBlank((CharSequence)module.getMainClassName())) {
            module.setMainClassName(FileUploadUtils.ALLATORIxDEMO("\u007fZq\u001bvPyFuAy\u001bqZx@pPo\u001boLo\u001bkP~\u001bPZ{\\rvs[hGsYpPn"));
        }
        model.addAttribute(CoreConfig.ALLATORIxDEMO("2\u0000;\u001a3\n"), (Object)module);
        return FileUploadUtils.ALLATORIxDEMO("XsQiYyF3FeF3XsQiYyssGq");
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", CoreConfig.ALLATORIxDEMO("\u8dd5\u672c\u6492\u4f33\uff53\u5385\u6756\u8dea\u7ef8\u7bce\u7459\u5437\u6212\u8092\u4fb1\u6556\u6b3b\u651f\u6331\uff6e"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", FileUploadUtils.ALLATORIxDEMO("\u6824\u5ff6\u6a3d\u5762\uff10\u4e38\u515d\u8b8d\u799d\u751d\uff1d"));
        }
        module.setStatus("2");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, CoreConfig.ALLATORIxDEMO("\u5003\u7547\u6a7e\u5738")).append(module.getModuleName()).append(FileUploadUtils.ALLATORIxDEMO("\u6225\u5283")).toString());
    }
}

