/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.cache.C;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.v.d.D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    private static final String SYS_CACHE = "sysCache";

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove((Object)key);
    }

    public static Object get(String key) {
        return CacheUtils.get(SYS_CACHE, key);
    }

    public static void put(String cacheName, String key, Object value) {
        CacheUtils.getCache(cacheName).put((Object)key, value);
    }

    public static Object get(String key, Object defaultValue) {
        Object a = CacheUtils.get(key);
        if (a != null) {
            return a;
        }
        return defaultValue;
    }

    public static String[] getCacheNames() {
        return C.ALLATORIxDEMO().getCacheNames();
    }

    public static void removeAll(String cacheName) {
        Iterator a;
        Cache<String, Object> a2 = CacheUtils.getCache(cacheName);
        Set a3 = a2.keys();
        Iterator iterator = a = a3.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = a;
            iterator = iterator2;
            a2.remove(iterator2.next());
        }
        logger.info(com.jeesite.modules.job.v.C.ALLATORIxDEMO("\u6e4c\u7470\u7f5a\u5b2e\uff53V2\u000biKwV2\u000b"), (Object)cacheName, (Object)a3);
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static void removeByKeyPrefix(String cacheName, String keyPrefix) {
        String a = keyPrefix;
        Cache<String, Object> a2 = CacheUtils.getCache(cacheName);
        Set a3 = a2.keys();
        HashSet a4 = SetUtils.newHashSet();
        for (String a5 : a3) {
            if (!StringUtils.startsWith((CharSequence)a5, (CharSequence)a)) continue;
            a2.remove((Object)a5);
            a4.add(a5);
        }
        logger.info(D.ALLATORIxDEMO("\u6e56\u7410\u7f40\u5b4e\uff496(ks+m6(k"), (Object)cacheName, (Object)a4);
    }

    public static void clearCache() {
        int n;
        String a = Global.getConfig(com.jeesite.modules.job.v.C.ALLATORIxDEMO(",\u001e*\u0017*\u001e,X*\u001a,\u0017;8(\u001b,\u0005"));
        if (StringUtils.isBlank((CharSequence)a)) {
            return;
        }
        String[] stringArray = a.split(D.ALLATORIxDEMO(":"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            CacheUtils.removeAll(stringArray[n++]);
            n3 = n;
        }
    }

    public static Object get(String cacheName, String key) {
        return CacheUtils.getCache(cacheName).get((Object)key);
    }

    public static Cache<String, Object> getCache(String cacheName) {
        Cache a = C.ALLATORIxDEMO().getCache(cacheName);
        if (a == null) {
            throw new RuntimeException(new StringBuilder().insert(0, com.jeesite.modules.job.v.C.ALLATORIxDEMO("\u5f1a\u523b\u7cb2\u7ea9\u4e64\u6cd7\u6740\u5bec\u4e00\u206a")).append(cacheName).append(D.ALLATORIxDEMO("\u204e\u8fcf\u4e79\u7f05\u5b0b\u3014")).toString());
        }
        return a;
    }

    public static Object get(String cacheName, String key, Object defaultValue) {
        Object a = CacheUtils.get(cacheName, key);
        if (a != null) {
            return a;
        }
        return defaultValue;
    }

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }
}

