/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.query.QueryTable;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.modules.state.web.StateServerController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public class JedisUtils {
    private static JedisPool jedisPool;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsObject(String key) {
        boolean a = false;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.exists(JedisUtils.getBytesKey(key));
            logger.debug(StateServerController.ALLATORIxDEMO("\u00114\u001d?\u0000?;.\u001e)\u00178T7\t"), (Object)key);
            return a;
        }
        catch (Exception a3) {
            logger.warn(QueryTable.ALLATORIxDEMO("a(m#p#K2n5g$$+y"), (Object)key, (Object)a3);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value, int cacheSeconds) {
        String a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.set(JedisUtils.getBytesKey(key), JedisUtils.toBytes(value));
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(StateServerController.ALLATORIxDEMO("\u0007)\u0000\u0003\u0016&\u0011/\u0000l\u000f1TqT7\t"), (Object)key, value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(QueryTable.ALLATORIxDEMO("w5p\u001ff:a3pp\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String setObjectMap(String key, Map<String, Object> value, int cacheSeconds) {
        String a = null;
        Jedis a2 = null;
        try {
            Iterator<Map.Entry<String, Object>> iterator;
            a2 = JedisUtils.getResource();
            if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a2.del(key);
            }
            HashMap a3 = MapUtils.newHashMap();
            Iterator<Map.Entry<String, Object>> iterator2 = iterator = value.entrySet().iterator();
            while (iterator2.hasNext()) {
                void a4;
                Map.Entry<String, Object> entry = iterator.next();
                iterator2 = iterator;
                a3.put(JedisUtils.getBytesKey(a4.getKey()), JedisUtils.toBytes(a4.getValue()));
            }
            a = a2.hmset(JedisUtils.getBytesKey(key), (Map)a3);
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(StateServerController.ALLATORIxDEMO("?\u00118;.\u001e)\u001789-\u0004l\u000f1TqT7\t"), (Object)key, value);
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a5;
            logger.warn(QueryTable.ALLATORIxDEMO("#a$K2n5g$I1tp\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getList(String key) {
        List a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(key).booleanValue()) {
                a = a2.lrange(key, 0L, -1L);
                logger.debug(StateServerController.ALLATORIxDEMO("\u0013)\u0000\u0000\u001d?\u0000l\u000f1TqT7\t"), (Object)key, (Object)a);
            }
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a3;
            logger.warn(QueryTable.ALLATORIxDEMO("c5p\u001cm#pp\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String mapObjectPut(String key, Map<String, Object> value) {
        String a = null;
        Jedis a2 = null;
        try {
            Iterator<Map.Entry<String, Object>> iterator;
            a2 = JedisUtils.getResource();
            HashMap a3 = MapUtils.newHashMap();
            Iterator<Map.Entry<String, Object>> iterator2 = iterator = value.entrySet().iterator();
            while (iterator2.hasNext()) {
                void a4;
                Map.Entry<String, Object> entry = iterator.next();
                iterator2 = iterator;
                a3.put(JedisUtils.getBytesKey(a4.getKey()), JedisUtils.toBytes(a4.getValue()));
            }
            a = a2.hmset(JedisUtils.getBytesKey(key), (Map)a3);
            logger.debug(StateServerController.ALLATORIxDEMO("!\u0015<;.\u001e)\u00178$9\u0000l\u000f1TqT7\t"), (Object)key, value);
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a5;
            logger.warn(QueryTable.ALLATORIxDEMO("=e K2n5g$T%pp\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setList(String key, List<String> value, int cacheSeconds) {
        long a = 0L;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(key).booleanValue()) {
                a2.del(key);
            }
            a = a2.rpush(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(StateServerController.ALLATORIxDEMO("\u0007)\u0000\u0000\u001d?\u0000l\u000f1TqT7\t"), (Object)key, value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(QueryTable.ALLATORIxDEMO("w5p\u001cm#pp\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSet(String key, Set<String> value, int cacheSeconds) {
        long a = 0L;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(key).booleanValue()) {
                a2.del(key);
            }
            a = a2.sadd(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(StateServerController.ALLATORIxDEMO("?\u00118')\u0000l\u000f1TqT7\t"), (Object)key, value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(QueryTable.ALLATORIxDEMO("#a$W5pp\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String key) {
        boolean a = false;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.exists(key);
            logger.debug(StateServerController.ALLATORIxDEMO("\u00114\u001d?\u0000?T7\t"), (Object)key);
            return a;
        }
        catch (Exception a3) {
            logger.warn(QueryTable.ALLATORIxDEMO("a(m#p#$+y"), (Object)key, (Object)a3);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long delObject(String key) {
        Jedis jedis;
        long a;
        block7: {
            a = 0L;
            Jedis a2 = null;
            try {
                a2 = JedisUtils.getResource();
                if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                    Jedis jedis2 = a2;
                    jedis = jedis2;
                    a = jedis2.del(JedisUtils.getBytesKey(key));
                    logger.debug(StateServerController.ALLATORIxDEMO("(\u0011 ;.\u001e)\u00178T7\t"), (Object)key);
                    break block7;
                }
                logger.debug(QueryTable.ALLATORIxDEMO("`5h\u001ff:a3pp\u007f-$>k$$5|9w$w"), (Object)key);
                jedis = a2;
            }
            catch (Exception a3) {
                logger.warn(StateServerController.ALLATORIxDEMO("(\u0011 ;.\u001e)\u00178T7\t"), (Object)key, (Object)a3);
                return a;
            }
            finally {
                JedisUtils.returnResource(a2);
            }
        }
        JedisUtils.returnResource(jedis);
        return a;
    }

    public static Jedis getResource() throws JedisException {
        Jedis a = null;
        try {
            a = jedisPool.getResource();
            return a;
        }
        catch (JedisException a2) {
            logger.warn(QueryTable.ALLATORIxDEMO("7a$V5w?q\"g5*"), (Throwable)a2);
            JedisUtils.returnResource(a);
            throw a2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mapPut(String key, Map<String, String> value) {
        String a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.hmset(key, value);
            logger.debug(StateServerController.ALLATORIxDEMO("!\u0015<$9\u0000l\u000f1TqT7\t"), (Object)key, value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(QueryTable.ALLATORIxDEMO("=e T%pp\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetObjectAdd(String key, Object ... value) {
        long a = 0L;
        Jedis a2 = null;
        try {
            int n;
            a2 = JedisUtils.getResource();
            HashSet a3 = SetUtils.newHashSet();
            Object[] objectArray = value;
            int n2 = value.length;
            int n3 = n = 0;
            while (n3 < n2) {
                Object a4 = objectArray[n];
                a3.add(JedisUtils.toBytes(a4));
                n3 = ++n;
            }
            a = a2.rpush(JedisUtils.getBytesKey(key), (byte[][])a3.toArray());
            logger.debug(StateServerController.ALLATORIxDEMO("\u0007)\u0000\u001f\u00118;.\u001e)\u001785(\u0010l\u000f1TqT7\t"), (Object)key, (Object)value);
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a5;
            logger.warn(QueryTable.ALLATORIxDEMO("w5p\u0003a$K2n5g$E4`p\u007f-$m$+y"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key) {
        String a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(key).booleanValue()) {
                a = a2.get(key);
                a = StringUtils.isNotBlank((CharSequence)a) && !StateServerController.ALLATORIxDEMO("\u001a%\u0018").equalsIgnoreCase(a) ? a : null;
                logger.debug(QueryTable.ALLATORIxDEMO("c5pp\u007f-$m$+y"), (Object)key, (Object)a);
            }
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0013)\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    public static byte[] toBytes(Object object) {
        return ObjectUtils.serializeFst((Object)object);
    }

    public static Object getObjectKey(byte[] key) {
        try {
            return ObjectUtils.toString((Object)key);
        }
        catch (UnsupportedOperationException a) {
            try {
                return JedisUtils.toObject(key);
            }
            catch (UnsupportedOperationException a2) {
                a2.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List<Object> getObjectList(String key) {
        ArrayList a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                List a3 = a2.lrange(JedisUtils.getBytesKey(key), 0L, -1L);
                a = ListUtils.newArrayList();
                Iterator iterator2 = iterator = a3.iterator();
                while (iterator2.hasNext()) {
                    void a4;
                    byte[] byArray = (byte[])iterator.next();
                    iterator2 = iterator;
                    a.add(JedisUtils.toObject((byte[])a4));
                }
                logger.debug(QueryTable.ALLATORIxDEMO("c5p\u001ff:a3p\u001cm#pp\u007f-$m$+y"), (Object)key, (Object)a);
            }
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a5;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0013)\u0000\u0003\u0016&\u0011/\u0000\u0000\u001d?\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Set<Object> getObjectSet(String key) {
        HashSet a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                a = SetUtils.newHashSet();
                Set a3 = a2.smembers(JedisUtils.getBytesKey(key));
                Iterator iterator2 = iterator = a3.iterator();
                while (iterator2.hasNext()) {
                    void a4;
                    byte[] byArray = (byte[])iterator.next();
                    iterator2 = iterator;
                    a.add(JedisUtils.toObject((byte[])a4));
                }
                logger.debug(QueryTable.ALLATORIxDEMO("7a$K2n5g$W5pp\u007f-$m$+y"), (Object)key, (Object)a);
            }
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a5;
            logger.warn(StateServerController.ALLATORIxDEMO("+\u00118;.\u001e)\u00178')\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapRemove(String key, String mapKey) {
        long a = 0L;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            String[] stringArray = new String[1];
            stringArray[0] = mapKey;
            a = a2.hdel(key, stringArray);
            logger.debug(QueryTable.ALLATORIxDEMO("=e V5i?r5$+yp$+y"), (Object)key, (Object)mapKey);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("!\u0015<&)\u0019#\u0002)T7\tlT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listObjectAdd(String key, Object ... value) {
        long a = 0L;
        Jedis a2 = null;
        try {
            int n;
            a2 = JedisUtils.getResource();
            ArrayList a3 = ListUtils.newArrayList();
            Object[] objectArray = value;
            int n2 = value.length;
            int n3 = n = 0;
            while (n3 < n2) {
                Object a4 = objectArray[n];
                a3.add(JedisUtils.toBytes(a4));
                n3 = ++n;
            }
            a = a2.rpush(JedisUtils.getBytesKey(key), (byte[][])a3.toArray());
            logger.debug(QueryTable.ALLATORIxDEMO("h9w$K2n5g$E4`p\u007f-$m$+y"), (Object)key, (Object)value);
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a5;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0018%\u00078;.\u001e)\u001785(\u0010l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    static {
        logger = LoggerFactory.getLogger(JedisUtils.class);
        jedisPool = SpringUtils.getBean(JedisPool.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMap(String key) {
        Map a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(key).booleanValue()) {
                a = a2.hgetAll(key);
                logger.debug(QueryTable.ALLATORIxDEMO("7a$I1tp\u007f-$m$+y"), (Object)key, (Object)a);
            }
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("+\u001189-\u0004l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectSet(String key, Set<Object> value, int cacheSeconds) {
        long a = 0L;
        Jedis a2 = null;
        try {
            Iterator<Object> iterator;
            a2 = JedisUtils.getResource();
            if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a2.del(key);
            }
            HashSet a3 = SetUtils.newHashSet();
            Iterator<Object> iterator2 = iterator = value.iterator();
            while (iterator2.hasNext()) {
                Iterator<Object> iterator3 = iterator;
                iterator2 = iterator3;
                Object a4 = iterator3.next();
                a3.add(JedisUtils.toBytes(a4));
            }
            a = a2.sadd(JedisUtils.getBytesKey(key), (byte[][])a3.toArray());
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(QueryTable.ALLATORIxDEMO("#a$K2n5g$W5pp\u007f-$m$+y"), (Object)key, value);
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a5;
            logger.warn(StateServerController.ALLATORIxDEMO("?\u00118;.\u001e)\u00178')\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listAdd(String key, String ... value) {
        long a = 0L;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.rpush(key, value);
            logger.debug(QueryTable.ALLATORIxDEMO("h9w$E4`p\u007f-$m$+y"), (Object)key, (Object)value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0018%\u000785(\u0010l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSet(String key) {
        Set a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(key).booleanValue()) {
                a = a2.smembers(key);
                logger.debug(QueryTable.ALLATORIxDEMO("7a$W5pp\u007f-$m$+y"), (Object)key, (Object)a);
            }
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("+\u00118')\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapObjectRemove(String key, String mapKey) {
        long a = 0L;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            byte[][] byArrayArray = new byte[1][];
            byArrayArray[0] = JedisUtils.getBytesKey(mapKey);
            a = a2.hdel(JedisUtils.getBytesKey(key), (byte[][])byArrayArray);
            logger.debug(QueryTable.ALLATORIxDEMO("=e K2n5g$V5i?r5$+yp$+y"), (Object)key, (Object)mapKey);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("!\u0015<;.\u001e)\u00178&)\u0019#\u0002)T7\tlT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setMap(String key, Map<String, String> value, int cacheSeconds) {
        String a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(key).booleanValue()) {
                a2.del(key);
            }
            a = a2.hmset(key, value);
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(QueryTable.ALLATORIxDEMO("#a$I1tp\u007f-$m$+y"), (Object)key, value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("?\u001189-\u0004l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String key) {
        Object a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a = JedisUtils.toObject(a2.get(JedisUtils.getBytesKey(key)));
                logger.debug(QueryTable.ALLATORIxDEMO("c5p\u001ff:a3pp\u007f-$m$+y"), (Object)key, a);
            }
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0013)\u0000\u0003\u0016&\u0011/\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String set(String key, String value, int cacheSeconds) {
        String a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.set(key, value);
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(QueryTable.ALLATORIxDEMO("w5pp\u007f-$m$+y"), (Object)key, (Object)value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0007)\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapExists(String key, String mapKey) {
        boolean a = false;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.hexists(key, mapKey);
            logger.debug(QueryTable.ALLATORIxDEMO("=e A(m#p#$+yp$+y"), (Object)key, (Object)mapKey);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("!\u0015<14\u001d?\u0000?T7\tlT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectList(String key, List<Object> value, int cacheSeconds) {
        long a = 0L;
        Jedis a2 = null;
        try {
            Iterator<Object> iterator;
            a2 = JedisUtils.getResource();
            if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a2.del(key);
            }
            ArrayList a3 = ListUtils.newArrayList();
            Iterator<Object> iterator2 = iterator = value.iterator();
            while (iterator2.hasNext()) {
                Iterator<Object> iterator3 = iterator;
                iterator2 = iterator3;
                Object a4 = iterator3.next();
                a3.add(JedisUtils.toBytes(a4));
            }
            a = a2.rpush(JedisUtils.getBytesKey(key), (byte[][])a3.toArray());
            if (cacheSeconds != 0) {
                a2.expire(key, cacheSeconds);
            }
            logger.debug(QueryTable.ALLATORIxDEMO("w5p\u001ff:a3p\u001cm#pp\u007f-$m$+y"), (Object)key, value);
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a5;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0007)\u0000\u0003\u0016&\u0011/\u0000\u0000\u001d?\u0000l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getObjectMap(String key) {
        HashMap a = null;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            if (a2.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                a = MapUtils.newHashMap();
                Map a3 = a2.hgetAll(JedisUtils.getBytesKey(key));
                Iterator iterator2 = iterator = a3.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry a4 = iterator.next();
                    a.put(ObjectUtils.toString(a4.getKey()), JedisUtils.toObject((byte[])a4.getValue()));
                    iterator2 = iterator;
                }
                logger.debug(QueryTable.ALLATORIxDEMO("7a$K2n5g$I1tp\u007f-$m$+y"), (Object)key, (Object)a);
            }
            return a;
        }
        catch (Exception a5) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a;
            objectArray[2] = a5;
            logger.warn(StateServerController.ALLATORIxDEMO("+\u00118;.\u001e)\u001789-\u0004l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapObjectExists(String key, String mapKey) {
        boolean a = false;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.hexists(JedisUtils.getBytesKey(key), JedisUtils.getBytesKey(mapKey));
            logger.debug(QueryTable.ALLATORIxDEMO("=e K2n5g$A(m#p#$+yp$+y"), (Object)key, (Object)mapKey);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("!\u0015<;.\u001e)\u0017814\u001d?\u0000?T7\tlT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetAdd(String key, String ... value) {
        long a = 0L;
        Jedis a2 = null;
        try {
            a2 = JedisUtils.getResource();
            a = a2.sadd(key, value);
            logger.debug(QueryTable.ALLATORIxDEMO("w5p\u0003a$E4`p\u007f-$m$+y"), (Object)key, (Object)value);
            return a;
        }
        catch (Exception a3) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a3;
            logger.warn(StateServerController.ALLATORIxDEMO("\u0007)\u0000\u001f\u001185(\u0010l\u000f1TqT7\t"), objectArray);
            return a;
        }
        finally {
            JedisUtils.returnResource(a2);
        }
    }

    public static byte[] getBytesKey(Object key) {
        if (key instanceof String) {
            return StringUtils.getBytes((String)((String)key));
        }
        return JedisUtils.toBytes(key);
    }

    public static Object toObject(byte[] bytes) {
        return ObjectUtils.unserializeFst((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long del(String key) {
        Jedis jedis;
        long a;
        block7: {
            a = 0L;
            Jedis a2 = null;
            try {
                a2 = JedisUtils.getResource();
                if (a2.exists(key).booleanValue()) {
                    Jedis jedis2 = a2;
                    jedis = jedis2;
                    a = jedis2.del(key);
                    logger.debug(QueryTable.ALLATORIxDEMO("4a<$+y"), (Object)key);
                    break block7;
                }
                logger.debug(StateServerController.ALLATORIxDEMO("\u0010)\u0018l\u000f1T\"\u001b8T)\f%\u00078\u0007"), (Object)key);
                jedis = a2;
            }
            catch (Exception a3) {
                logger.warn(QueryTable.ALLATORIxDEMO("4a<$+y"), (Object)key, (Object)a3);
                return a;
            }
            finally {
                JedisUtils.returnResource(a2);
            }
        }
        JedisUtils.returnResource(jedis);
        return a;
    }
}

