/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.config;

import com.jeesite.common.codec.AesUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.C;
import com.jeesite.common.datasource.DataSourceHolder;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.io.PropertiesUtils;
import com.jeesite.common.io.ResourceUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.state.web.StateServerController;
import com.jeesite.modules.sys.service.M;
import com.jeesite.modules.sys.utils.ConfigUtils;
import com.jeesite.modules.sys.utils.DictUtils;
import com.jeesite.modules.sys.web.ValidCodeController;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;

public class Global {
    private static final Global INSTANCE;
    public static final String HIDE = "0";
    private static Logger logger;
    public static final String SHOW = "1";
    public static final String OP_ADD = "add";
    public static final String OP_AUTH = "auth";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    public static final String USERFILES_BASE_URL = "/userfiles/";
    public static final String YES = "1";
    public static final String NO = "0";
    public static final String OP_EDIT = "edit";
    private static Map<String, String> props;

    public static Boolean isUseCorpModel() {
        if (!ObjectUtils.toBoolean(M.ALLATORIxDEMO().get(StateServerController.ALLATORIxDEMO("*\u001a\u001f\u0015-\u0007"))).booleanValue()) {
            return false;
        }
        return TRUE.equals(Global.getProperty(ValidCodeController.ALLATORIxDEMO("\u0019_\t^BY\u001fI/C\u001e\\!C\bI\u0000")));
    }

    public static String getDbName() {
        String a = Global.getJdbcInfo(StateServerController.ALLATORIxDEMO("8\r<\u0011"));
        if (ValidCodeController.ALLATORIxDEMO("D\u0005K\u0004K\u0003").equals(a)) {
            return StateServerController.ALLATORIxDEMO("#\u0006-\u0017 \u0011");
        }
        if (ValidCodeController.ALLATORIxDEMO("\u0001_\u001f]\u0000\u001e\\\u001d^").equals(a)) {
            return StateServerController.ALLATORIxDEMO("\u0019?\u0007=\u0018");
        }
        return a;
    }

    public static void setLang(String lang, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)DictUtils.getDictLabel(ValidCodeController.ALLATORIxDEMO("\u001fU\u001fs\u0000M\u0002K3X\u0015\\\t"), lang, null))) {
            Locale a = null;
            try {
                a = LocaleUtils.toLocale((String)lang);
            }
            catch (IllegalArgumentException a2) {
                a = Locale.CHINA;
            }
            C.ALLATORIxDEMO().setLocale(request, response, a);
            return;
        }
        C.ALLATORIxDEMO().setLocale(request, response, Locale.CHINA);
    }

    public static String getLang() {
        Locale a = null;
        HttpServletRequest a2 = ServletUtils.getRequest();
        if (a2 != null) {
            a = C.ALLATORIxDEMO().resolveLocale(a2);
        }
        if (a != null) {
            return a.toString();
        }
        return Locale.CHINA.toString();
    }

    public static String getConfig(String key, String defValue) {
        String a = Global.getConfig(key);
        if (StringUtils.isBlank((CharSequence)a)) {
            return defValue;
        }
        return a;
    }

    public static String getFrontPath() {
        return Global.getProperty(StateServerController.ALLATORIxDEMO("\u0012>\u001b\"\u0000\u001c\u00158\u001c"));
    }

    public static String getJdbcType() {
        return Global.getJdbcInfo(ValidCodeController.ALLATORIxDEMO("X\u0015\\\t"));
    }

    public static Global getInstance() {
        return INSTANCE;
    }

    static {
        logger = LoggerFactory.getLogger(Global.class);
        props = MapUtils.newHashMap();
        INSTANCE = new Global();
    }

    public static String getProperty(String key) {
        String a = props.get(key);
        if (a == null) {
            a = PropertiesUtils.getInstance().getProperty(key);
            if (a != null) {
                props.put(key, a);
                return a;
            }
            if (StateServerController.ALLATORIxDEMO("<\u0006#\u00109\u00178\")\u0006?\u001d#\u001a").equals(key)) {
                a = new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO(":")).append(com.jeesite.common.d.C.ALLATORIxDEMO()).toString();
                props.put(key, a);
                return a;
            }
            a = "";
            props.put(key, a);
        }
        return a;
    }

    public static String getText(String code, String ... params) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return code;
        }
        Locale a = null;
        try {
            a = LocaleUtils.toLocale((String)Global.getLang());
        }
        catch (IllegalArgumentException a2) {
            a = Locale.CHINA;
        }
        try {
            return C.ALLATORIxDEMO().getMessage(code, params, a);
        }
        catch (NoSuchMessageException a3) {
            if (params != null && params.length > 0) {
                return new MessageFormat(code != null ? code : "", LocaleContextHolder.getLocale()).format(params);
            }
            return code;
        }
    }

    public static String getUserfilesBaseDir(String path) {
        String string;
        String a = Global.getProperty(StateServerController.ALLATORIxDEMO("*\u001d \u0011b\u0016-\u0007)0%\u0006"));
        if (StringUtils.isBlank((CharSequence)a)) {
            try {
                string = a = ServletUtils.getRequest().getSession().getServletContext().getRealPath(ValidCodeController.ALLATORIxDEMO("C"));
            }
            catch (Exception a2) {
                return "";
            }
        } else {
            string = a;
        }
        if (!string.endsWith(StateServerController.ALLATORIxDEMO("["))) {
            a = new StringBuilder().insert(0, a).append(ValidCodeController.ALLATORIxDEMO("C")).toString();
        }
        if (path != null) {
            return FileUtils.path((String)new StringBuilder().insert(0, a).append(USERFILES_BASE_URL).append(path).toString());
        }
        return FileUtils.path((String)a);
    }

    public static String getJdbcInfo(String key) {
        String a = DataSourceHolder.getDataSourceName();
        String a2 = new StringBuilder().insert(0, StateServerController.ALLATORIxDEMO("&\u0010.\u0017")).append(a == null ? "" : new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO("B")).append(a).toString()).append(StateServerController.ALLATORIxDEMO("Z")).append(key).toString();
        String a3 = Global.getProperty(a2);
        if (StringUtils.isBlank((CharSequence)a3)) {
            throw new RuntimeException(new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO("\u001c^\u0003\\\t^\u0018E\t_L\u65ab\u4e9a\u4e01\u7f56\u5c3dL")).append(a2).append(StateServerController.ALLATORIxDEMO("T\u653c\u631a\u6edc\u53b6\u653c\u9139\u7f22Z")).toString());
        }
        return a3;
    }

    public static String getConfig(String key) {
        String a = props.get(key);
        if (a == null) {
            a = PropertiesUtils.getInstance().getProperty(key);
            if (a != null) {
                props.put(key, a);
            } else {
                a = ConfigUtils.getConfig(key).getConfigValue();
                if (a != null) {
                    props.put(key, ValidCodeController.ALLATORIxDEMO("\u001eI\rH3_\u0015_3O\u0003B\nE\u000bs\u0018M\u000e@\t"));
                    return a;
                }
                if (StateServerController.ALLATORIxDEMO("<\u0006#\u00109\u00178\")\u0006?\u001d#\u001a").equals(key)) {
                    a = new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO(":")).append(com.jeesite.common.d.C.ALLATORIxDEMO()).toString();
                    props.put(key, a);
                    return a;
                }
                a = "";
                props.put(key, a);
                return a;
            }
        }
        if (StateServerController.ALLATORIxDEMO("\u0006)\u0015(+?\r?+/\u001b\"\u0012%\u0013\u0013\u0000-\u0016 \u0011").equals(a)) {
            a = ConfigUtils.getConfig(key).getConfigValue();
        }
        return a;
    }

    public static boolean isTestProfileActive() {
        Environment a = SpringUtils.getBean(Environment.class);
        return StringUtils.inString((String)ValidCodeController.ALLATORIxDEMO("X\t_\u0018"), (String[])a.getActiveProfiles());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getConst(String field) {
        try {
            if (StateServerController.ALLATORIxDEMO("3 \u001b.\u0015 Z\n\u001d)\u0018(\u0007").equals(field)) {
                Field a;
                int n;
                String a2 = props.get(new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO("s3")).append(field).toString());
                if (a2 != null) return a2;
                StringBuilder a3 = new StringBuilder();
                Field[] fieldArray = Global.class.getFields();
                int n2 = fieldArray.length;
                int n3 = n = 0;
                while (n3 < n2) {
                    Field field2 = fieldArray[n];
                    a3.append(a.getName() + StateServerController.ALLATORIxDEMO("vS") + a.get(null) + ValidCodeController.ALLATORIxDEMO("\u000b@"));
                    n3 = ++n;
                }
                fieldArray = DataEntity.class.getFields();
                n2 = fieldArray.length;
                int n4 = n = 0;
                while (n4 < n2) {
                    a = fieldArray[n];
                    a3.append(new StringBuilder().insert(0, a.getName()).append(StateServerController.ALLATORIxDEMO("vS")).append(a.get(null)).append(ValidCodeController.ALLATORIxDEMO("\u000b@")).toString());
                    n4 = ++n;
                }
                int a4 = a3.length();
                a2 = a4 > 1 ? a3.substring(0, a4 - 1) : "";
                props.put(new StringBuilder().insert(0, StateServerController.ALLATORIxDEMO("\u0013+")).append(field).toString(), a2);
                return a2;
            }
            Object a = Global.class.getField(field).get(null);
            if (a != null) return a;
            return DataEntity.class.getField(field).get(null);
        }
        catch (Exception a) {
            return null;
        }
    }

    public static void assertDemoMode() {
        if (ObjectUtils.toBoolean((Object)Global.getProperty(ValidCodeController.ALLATORIxDEMO("H\tA\u0003a\u0003H\t"))).booleanValue()) {
            throw new RuntimeException(StateServerController.ALLATORIxDEMO("\u0019?\u0013v\u6f60\u7976\u6a55\u5f43\uff78\u4e41\u5135\u8bf4\u64b9\u4f10\uff75"));
        }
    }

    public static String getAdminPath() {
        return Global.getProperty(ValidCodeController.ALLATORIxDEMO("\rH\u0001E\u0002|\rX\u0004"));
    }

    public static String getTablePrefix() {
        return Global.getProperty(StateServerController.ALLATORIxDEMO("&\u0010.\u0017b\u0000-\u0016 \u0011\u001c\u0006)\u0012%\f"));
    }

    public static void clearCache() {
        PropertiesUtils.releadInstance();
        ConfigUtils.clearCache();
        props.clear();
    }

    public static String getProperty(String key, String defValue) {
        String a = Global.getProperty(key);
        if (StringUtils.isBlank((CharSequence)a)) {
            return defValue;
        }
        return a;
    }

    public static String getPropertyDecodeAndEncode(String ascKey, String key, String value) {
        if (value == null) {
            value = Global.getProperty(key);
        }
        try {
            value = AesUtils.decode((String)value, (String)ascKey);
            return value;
        }
        catch (Exception a) {
            int n;
            String a2 = AesUtils.encode((String)value, (String)ascKey);
            String[] stringArray = PropertiesUtils.DEFAULT_CONFIG_FILE;
            int n2 = PropertiesUtils.DEFAULT_CONFIG_FILE.length;
            int n3 = n = 0;
            while (n3 < n2) {
                block10: {
                    CharSequence a3;
                    String a4;
                    File a5;
                    String a6;
                    block11: {
                        a6 = stringArray[n];
                        Resource a7 = ResourceUtils.getResource((String)a6);
                        if (!a7.exists()) break block10;
                        a5 = a7.getFile();
                        a4 = FileUtils.getFileExtension((String)a6);
                        if (!ValidCodeController.ALLATORIxDEMO("\\\u001eC\u001cI\u001eX\u0005I\u001f").equals(a4)) break block11;
                        File file = a5;
                        String string = FileUtils.readFileToString((File)file, (String)"UTF-8");
                        a3 = ((String)a3).replaceAll(StateServerController.ALLATORIxDEMO("d~") + key + ValidCodeController.ALLATORIxDEMO("\u0011E\u0004B\u0006E"), new StringBuilder().insert(0, StateServerController.ALLATORIxDEMO("hE")).append(a2).toString());
                        FileUtils.writeStringToFile((File)file, (String)a3, (String)"UTF-8");
                        logger.debug(new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO("9\\\bM\u0018IL")).append(a5.getPath()).append(StateServerController.ALLATORIxDEMO("T")).append(key).append(ValidCodeController.ALLATORIxDEMO("L_\u0019O\u000fI\u001f_B")).toString());
                    }
                    try {
                        if (StateServerController.ALLATORIxDEMO("\r!\u0018").equals(a4)) {
                            a3 = new StringBuilder(FileUtils.readFileToString((File)a5, (String)"UTF-8"));
                            int a8 = 0;
                            String[] a9 = StringUtils.split((String)key, (String)ValidCodeController.ALLATORIxDEMO("B"));
                            for (int a10 = 0; a10 < a9.length; ++a10) {
                                int a11;
                                String a12 = a9[a10];
                                String a13 = "";
                                int n4 = a11 = 0;
                                while (n4 < a10 * 2) {
                                    a13 = new StringBuilder().insert(0, a13).append(StateServerController.ALLATORIxDEMO("T")).toString();
                                    n4 = ++a11;
                                }
                                a12 = new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO("f")).append(a13).append(a12).append(StateServerController.ALLATORIxDEMO("N")).toString();
                                a8 = ((StringBuilder)a3).indexOf(a12, a8);
                                if (a8 == -1 || a10 != a9.length - 1) continue;
                                CharSequence charSequence = a3;
                                a11 = ((StringBuilder)charSequence).indexOf(ValidCodeController.ALLATORIxDEMO("V"), a8);
                                int a14 = ((StringBuilder)charSequence).indexOf(StateServerController.ALLATORIxDEMO("~"), a11);
                                ((StringBuilder)charSequence).replace(a11, a14, new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO("\u0016L")).append(a2).toString());
                                FileUtils.writeStringToFile((File)a5, (String)((StringBuilder)a3).toString(), (String)"UTF-8");
                                logger.debug(new StringBuilder().insert(0, StateServerController.ALLATORIxDEMO("!<\u0010-\u0000)T")).append(a5.getPath()).append(ValidCodeController.ALLATORIxDEMO("L")).append(key).append(StateServerController.ALLATORIxDEMO("l\u0011\"\u0017>\r<\u0000%\u001b\"T?\u0001/\u0017)\u0007?Z")).toString());
                            }
                        }
                    }
                    catch (Exception a15) {
                        if (a15 instanceof FileNotFoundException) break block10;
                        logger.error(new StringBuilder().insert(0, ValidCodeController.ALLATORIxDEMO("9\\\bM\u0018IL")).append(a6).append(StateServerController.ALLATORIxDEMO("T)\u001a/\u00065\u00048\u001d#\u001al\u0012-\u001d \u0001>\u0011bT")).toString(), (Throwable)a15);
                    }
                }
                n3 = ++n;
            }
            return value;
        }
    }
}

