/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.file.entity;

import com.jeesite.common.config.Global;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.lang.ByteUtils;
import com.jeesite.common.mybatis.annotation.Column;
import com.jeesite.common.mybatis.annotation.Table;
import com.jeesite.common.v.d.L;
import com.jeesite.modules.file.utils.FileUploadUtils;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@Table(name="${_prefix}sys_file_entity", alias="a", columns={@Column(name="file_id", attrName="fileId", label="\u6587\u4ef6\u7f16\u53f7", isPK=true), @Column(name="file_md5", attrName="fileMd5", label="\u6587\u4ef6MD5"), @Column(name="file_path", attrName="filePath", label="\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84"), @Column(name="file_content_type", attrName="fileContentType", label="\u6587\u4ef6\u5185\u5bb9\u7c7b\u578b"), @Column(name="file_extension", attrName="fileExtension", label="\u6587\u4ef6\u540e\u7f00\u6269\u5c55\u540d"), @Column(name="file_size", attrName="fileSize", label="\u6587\u4ef6\u5927\u5c0f", comment="\u6587\u4ef6\u5927\u5c0f(\u5355\u4f4dB)")}, orderBy="a.file_id DESC")
public class FileEntity
extends DataEntity<FileEntity> {
    private String filePath;
    private Long fileSize;
    private String fileId;
    private String fileExtension;
    private String fileMd5;
    private String fileContentType;
    private static final long serialVersionUID = 1L;

    public String getFileRealPath() {
        return Global.getUserfilesBaseDir(new StringBuilder().insert(0, L.ALLATORIxDEMO("efojv\u007fo`bk,")).append(this.filePath).append(FileUploadUtils.ALLATORIxDEMO("\u0019")).toString()) + this.fileId + L.ALLATORIxDEMO("-") + this.fileExtension;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    @NotNull(message="\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a")
    public Long getFileSize() {
        return this.fileSize;
    }

    @Length(min=0, max=64, message="\u6587\u4ef6\u7f16\u53f7\u4e0d\u80fd\u8d85\u8fc7 64 \u4e2a\u5b57\u7b26")
    public String getFileId() {
        return this.fileId;
    }

    @NotBlank(message="\u6587\u4ef6\u540e\u7f00\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=100, message="\u6587\u4ef6\u540e\u7f00\u6269\u5c55\u540d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26")
    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileUrl() {
        return FileUtils.path((String)new StringBuilder().insert(0, FileUploadUtils.ALLATORIxDEMO("\u0019DETDW_]SB\u0019\u001ePXZTCAZ^WU\u0019")).append(this.filePath).append(L.ALLATORIxDEMO(",")).toString()) + this.fileId + FileUploadUtils.ALLATORIxDEMO("\u0018") + this.fileExtension;
    }

    @NotBlank(message="\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=1000, message="\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 1000 \u4e2a\u5b57\u7b26")
    public String getFilePath() {
        return this.filePath;
    }

    @NotBlank(message="\u6587\u4ef6MD5\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=64, message="\u6587\u4ef6MD5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 64 \u4e2a\u5b57\u7b26")
    public String getFileMd5() {
        return this.fileMd5;
    }

    @NotBlank(message="\u6587\u4ef6\u5185\u5bb9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=200, message="\u6587\u4ef6\u5185\u5bb9\u7c7b\u578b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public String getFileContentType() {
        return this.fileContentType;
    }

    public void setFileContentType(String fileContentType) {
        this.fileContentType = fileContentType;
    }

    public String getFileSizeFormat() {
        if (this.fileSize == null) {
            return null;
        }
        return ByteUtils.formatByteSize((long)this.fileSize);
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public FileEntity() {
    }

    public FileEntity(String string) {
        this.fileId = string;
    }

    public void setFileMd5(String fileMd5) {
        this.fileMd5 = fileMd5;
    }
}

