/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.service;

import com.beust.jcommander.internal.Lists;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.RoutingDataSource;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.v.d.K;
import com.jeesite.modules.config.CoreConfig;
import com.jeesite.modules.job.dao.JobDao;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.listener.JobDetalListener;
import com.jeesite.modules.job.listener.JobSchedulerListener;
import com.jeesite.modules.job.listener.JobTriggerListener;
import com.jeesite.modules.job.service.JobLogService;
import com.jeesite.modules.job.v.C;
import com.jeesite.modules.sys.web.ValidCodeController;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"dbUpgrade"})
@Transactional(readOnly=true)
public class JobService
extends CrudService<JobDao, JobEntity> {
    private SchedulerFactoryBean scheduler;
    @Autowired
    private JobLogService jobLogService;
    @Autowired
    private RoutingDataSource dataSource;

    public boolean isRunning() {
        block3: {
            try {
                if (this.getScheduler().isInStandbyMode() || !this.getScheduler().isStarted()) break block3;
                return true;
            }
            catch (Exception a) {
                this.logger.error(CoreConfig.ALLATORIxDEMO("\u83c2\u5385\u5bef\u65a5\u561d\u72e5\u6074\u65a5\u5944\u8d76\uff74"), (Throwable)a);
                return false;
            }
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(ValidCodeController.ALLATORIxDEMO("\nB&C\u000e"))).booleanValue()) {
            return;
        }
        job.setStatus("0");
        super.updateStatus(job);
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a2 = jobService.getScheduler().getTrigger(a);
            jobService.getScheduler().resumeJob(a2.getJobKey());
            jobService.getScheduler().resumeTrigger(a2.getKey());
            return;
        }
        catch (SchedulerException a) {
            throw new ServiceException(CoreConfig.ALLATORIxDEMO("\u6017\u595e\u8fa5\u881f\u5944\u8d76\uff74"), a);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler.getScheduler();
    }

    @Transactional(readOnly=false)
    public void runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(ValidCodeController.ALLATORIxDEMO("\nB&C\u000e"))).booleanValue()) {
            return;
        }
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a2 = jobService.getScheduler().getTrigger(a);
            jobService.getScheduler().triggerJob(a2.getJobKey());
            return;
        }
        catch (SchedulerException a) {
            throw new ServiceException(CoreConfig.ALLATORIxDEMO("\u8fa5\u881f\u4e75\u6b72\u5944\u8d76\uff74"), a);
        }
    }

    public boolean stopAll() {
        if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(ValidCodeController.ALLATORIxDEMO("\nB&C\u000e"))).booleanValue()) {
            return false;
        }
        try {
            this.scheduler.stop();
        }
        catch (Exception a) {
            this.logger.error(CoreConfig.ALLATORIxDEMO("\u500f\u6b17\u5bc9\u6583\u563b\u5944\u8d76\uff74"), (Throwable)a);
            return false;
        }
        return true;
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(ValidCodeController.ALLATORIxDEMO("\nB&C\u000e"))).booleanValue()) {
            return;
        }
        super.delete(job);
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            Trigger a2 = this.getScheduler().getTrigger(a);
            if (a2 != null) {
                JobService jobService = this;
                jobService.getScheduler().deleteJob(a2.getJobKey());
                jobService.getScheduler().unscheduleJob(a2.getKey());
                return;
            }
        }
        catch (SchedulerException a) {
            throw new ServiceException(CoreConfig.ALLATORIxDEMO("\u5255\u9637\u5944\u8d76\uff74"), a);
        }
    }

    @Override
    public JobEntity get(JobEntity job) {
        JobEntity a = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)job.getJobName()) && StringUtils.isNotBlank((CharSequence)job.getJobGroup())) {
                TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
                Trigger a3 = this.getScheduler().getTrigger(a2);
                if (a3 instanceof CronTriggerImpl) {
                    a = new JobEntity().convert(this.getScheduler(), (CronTriggerImpl)a3);
                }
            }
        }
        catch (SchedulerException a4) {
            this.logger.error(ValidCodeController.ALLATORIxDEMO("\u83db\u53fa\u595d\u8d09\uff6d"), (Throwable)a4);
        }
        return a;
    }

    @Override
    public List<JobEntity> findList(JobEntity job) {
        List a = Lists.newArrayList();
        try {
            Scheduler a2 = this.getScheduler();
            Iterator iterator = a2.getTriggerGroupNames().iterator();
            while (iterator.hasNext()) {
                GroupMatcher a3 = GroupMatcher.groupEquals((String)((String)iterator.next()));
                for (TriggerKey a4 : a2.getTriggerKeys(a3)) {
                    Trigger a5 = a2.getTrigger(a4);
                    if (!(a5 instanceof CronTriggerImpl)) continue;
                    a.add(new JobEntity().convert(a2, (CronTriggerImpl)a5));
                }
            }
        }
        catch (Exception a6) {
            this.logger.error(CoreConfig.ALLATORIxDEMO("\u6790\u8bb1\u4e8e\u52f2\u5262\u883b\u5944\u8d76\uff74"), (Throwable)a6);
        }
        return a;
    }

    @PostConstruct
    private /* synthetic */ void initialize() throws Exception {
        JobEntity a;
        if (Global.isTestProfileActive()) {
            return;
        }
        JobService jobService = this;
        jobService.scheduler = new SchedulerFactoryBean();
        jobService.scheduler.setAutoStartup(ObjectUtils.toBoolean((Object)Global.getProperty(ValidCodeController.ALLATORIxDEMO("\u0006C\u000e\u0002\rY\u0018C?X\r^\u0018Y\u001c"), "true")).booleanValue());
        jobService.scheduler.setStartupDelay(ObjectUtils.toInteger((Object)Global.getProperty(CoreConfig.ALLATORIxDEMO("9\u001a1[ \u00012\u0007'\u0000#16\u00192\f"), ValidCodeController.ALLATORIxDEMO("\u001a\\"))).intValue());
        if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(CoreConfig.ALLATORIxDEMO("\u0013=?<\u0017"))).booleanValue()) {
            this.scheduler.afterPropertiesSet();
            return;
        }
        JobService jobService2 = this;
        jobService2.scheduler.setQuartzProperties(C.ALLATORIxDEMO());
        JobService jobService3 = this;
        jobService2.scheduler.setDataSource((DataSource)((Object)jobService3.dataSource));
        jobService3.scheduler.afterPropertiesSet();
        if (jobService2.scheduler.isAutoStartup()) {
            this.scheduler.start();
        }
        JobEntity jobEntity = a = new JobEntity();
        jobEntity.setStatus("");
        for (JobEntity a2 : super.findList(jobEntity)) {
            if ("1".equals(a.getStatus())) {
                this.delete(a);
                continue;
            }
            try {
                this.save(a2, false);
            }
            catch (Exception a3) {
                this.logger.warn(a3.getMessage(), (Throwable)a3);
            }
        }
        try {
            ListenerManager a4;
            ListenerManager listenerManager = a4 = this.getScheduler().getListenerManager();
            a4.addJobListener((JobListener)new JobDetalListener(this.jobLogService));
            listenerManager.addTriggerListener((TriggerListener)new JobTriggerListener(this.jobLogService));
            a4.addSchedulerListener((SchedulerListener)new JobSchedulerListener(this.jobLogService));
            return;
        }
        catch (SchedulerException a5) {
            this.logger.error(ValidCodeController.ALLATORIxDEMO("\u4f30\u4e36\u76bd\u5400\u4ee7\u4eda\u5f6e\u5e14\uff6d"), (Throwable)a5);
            return;
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void save(JobEntity job) {
        this.save(job, true);
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void save(JobEntity job, boolean isSaveToDb) {
        block6: {
            block7: {
                if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(CoreConfig.ALLATORIxDEMO("\u0013=?<\u0017"))).booleanValue()) {
                    return;
                }
                v0 = job;
                a = C.ALLATORIxDEMO(v0);
                a = C.ALLATORIxDEMO(v0, a);
                if (!isSaveToDb) break block6;
                if (!job.getIsNewRecord()) break block7;
                v1 = this;
                v2 = v1;
                super.insert(job);
                ** GOTO lbl17
            }
            super.update(job);
        }
        try {
            v2 = this;
lbl17:
            // 2 sources

            v2.getScheduler().addJob(a, true);
            v3 = this;
            if (this.getScheduler().getTrigger(a.getKey()) != null) {
                v3.getScheduler().rescheduleJob(a.getKey(), (Trigger)a);
            } else {
                v3.getScheduler().scheduleJob((Trigger)a);
            }
            if ("2".equals(job.getStatus())) {
                v4 = this;
                v4.getScheduler().pauseJob(a.getJobKey());
                v4.getScheduler().pauseTrigger(a.getKey());
                return;
            }
        }
        catch (Exception a) {
            throw new ServiceException(ValidCodeController.ALLATORIxDEMO("\u6d97\u528c\u8bcd\u523e\u4e97\u528d\u595d\u8d09\uff6d"), a);
        }
    }

    public boolean startAll() {
        if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(CoreConfig.ALLATORIxDEMO("\u0013=?<\u0017"))).booleanValue()) {
            return false;
        }
        try {
            JobService jobService = this;
            jobService.scheduler.setStartupDelay(0);
            jobService.scheduler.start();
        }
        catch (Exception a) {
            this.logger.error(ValidCodeController.ALLATORIxDEMO("\u5403\u52c4\u5bb6\u659a\u5644\u595d\u8d09\uff6d"), (Throwable)a);
            return false;
        }
        return true;
    }

    @Transactional(readOnly=false)
    public void pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(K.ALLATORIxDEMO().get(CoreConfig.ALLATORIxDEMO("\u0013=?<\u0017"))).booleanValue()) {
            return;
        }
        job.setStatus("2");
        super.updateStatus(job);
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a2 = jobService.getScheduler().getTrigger(a);
            jobService.getScheduler().pauseJob(a2.getJobKey());
            jobService.getScheduler().pauseTrigger(a2.getKey());
            return;
        }
        catch (SchedulerException a) {
            throw new ServiceException(ValidCodeController.ALLATORIxDEMO("\u66ee\u5070\u8fbc\u8860\u595d\u8d09\uff6d"), a);
        }
    }
}

