/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.cache.D;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.modules.config.DataSourceConfig;
import com.jeesite.modules.file.entity.FileUploadParms;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    private static final String SYS_CACHE = "sysCache";

    public static void clearCache() {
        int n;
        String a2 = Global.getConfig(FileUploadParms.ALLATORIxDEMO("N\u0018H\u0011H\u0018N^H\u001cN\u0011Y>J\u001dN\u0003"));
        if (StringUtils.isBlank((CharSequence)a2)) {
            return;
        }
        String[] stringArray = a2.split(DataSourceConfig.ALLATORIxDEMO("\u0000"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            CacheUtils.removeAll(stringArray[n++]);
            n3 = n;
        }
    }

    public static void removeAll(String cacheName) {
        Iterator a2;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        Iterator iterator = a2 = a4.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = a2;
            iterator = iterator2;
            a3.remove(iterator2.next());
        }
        logger.info(FileUploadParms.ALLATORIxDEMO("\u6e2e\u7476\u7f38\u5b28\uff31PP\r\u000bM\u0015PP\r"), (Object)cacheName, (Object)a4);
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static Cache<String, Object> getCache(String cacheName) {
        Cache a2 = D.ALLATORIxDEMO().getCache(cacheName);
        if (a2 == null) {
            throw new RuntimeException(new StringBuilder().insert(0, DataSourceConfig.ALLATORIxDEMO("\u5f2b\u5261\u7c83\u7ef3\u4e55\u6c8d\u6771\u5bb6\u4e31\u2030")).append(cacheName).append(FileUploadParms.ALLATORIxDEMO("\u2036\u8fa9\u4e01\u7f63\u5b73\u3072")).toString());
        }
        return a2;
    }

    public static Object get(String key) {
        return CacheUtils.get(SYS_CACHE, key);
    }

    public static void removeByKeyPrefix(String cacheName, String keyPrefix) {
        String a2 = keyPrefix;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        HashSet a5 = SetUtils.newHashSet();
        for (String a6 : a4) {
            if (!StringUtils.startsWith((CharSequence)a6, (CharSequence)a2)) continue;
            a3.remove((Object)a6);
            a5.add(a6);
        }
        logger.info(DataSourceConfig.ALLATORIxDEMO("\u6e7d\u742a\u7f6b\u5b74\uff62\f\u0003QX\u0011F\f\u0003Q"), (Object)cacheName, (Object)a5);
    }

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove((Object)key);
    }

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }

    public static void put(String cacheName, String key, Object value) {
        CacheUtils.getCache(cacheName).put((Object)key, value);
    }

    public static Object get(String cacheName, String key) {
        return CacheUtils.getCache(cacheName).get((Object)key);
    }

    public static Object get(String key, Object defaultValue) {
        Object a2 = CacheUtils.get(key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static Object get(String cacheName, String key, Object defaultValue) {
        Object a2 = CacheUtils.get(cacheName, key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static String[] getCacheNames() {
        return D.ALLATORIxDEMO().getCacheNames();
    }
}

