/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.realm;

import com.beust.jcommander.internal.Maps;
import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.codec.Sha1Utils;
import com.jeesite.common.config.Global;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.M;
import com.jeesite.common.n.v.a;
import com.jeesite.common.shiro.authc.FormToken;
import com.jeesite.common.shiro.cas.CasCreateUser;
import com.jeesite.common.shiro.cas.CasOutHandler;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.ByteSource;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class BaseAuthorizingRealm
extends AuthorizingRealm {
    private CasOutHandler casOutHandler;
    private TicketValidator ticketValidator;
    private SessionDAO sessionDAO;
    private String casServerCallbackUrl;
    private String casServerUrl;
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    public static final String HASH_ALGORITHM = "SHA-1";

    public final boolean supports(AuthenticationToken token) {
        if (token != null && FormToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(FormToken.class);
            return true;
        }
        if (token != null && CasToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(CasToken.class);
            return true;
        }
        return false;
    }

    public static boolean validatePassword(String plainPassword, String password) {
        try {
            String string = EncodeUtils.decodeHtml((String)plainPassword);
            byte[] a2 = EncodeUtils.decodeHex((String)password.substring(0, 16));
            byte[] a3 = Sha1Utils.sha1((byte[])string.getBytes(), (byte[])a2, (int)1024);
            return password.equals(EncodeUtils.encodeHex((byte[])a2) + EncodeUtils.encodeHex((byte[])a3));
        }
        catch (Exception a4) {
            return false;
        }
    }

    public void setCasServerUrl(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    public static String encryptPassword(String plainPassword) {
        String a2 = EncodeUtils.decodeHtml((String)plainPassword);
        byte[] a3 = Sha1Utils.genSalt((int)8);
        byte[] a4 = Sha1Utils.sha1((byte[])a2.getBytes(), (byte[])a3, (int)1024);
        return new StringBuilder().insert(0, EncodeUtils.encodeHex((byte[])a3)).append(EncodeUtils.encodeHex((byte[])a4)).toString();
    }

    public void setCasServerCallbackUrl(String casServerCallbackUrl) {
        this.casServerCallbackUrl = casServerCallbackUrl;
    }

    private final /* synthetic */ SimpleAuthenticationInfo newAuthenticationInfo(User user, FormToken token) {
        int a2;
        if (Global.isUseCorpModel().booleanValue()) {
            token.getParams().put(BaseEntity.ALLATORIxDEMO("1v i\u0011v6|"), user.getCorpCode_());
        }
        if (StringUtils.equals((CharSequence)((CharSequence)M.ALLATORIxDEMO().get(a.ALLATORIxDEMO("%K!W"))), (CharSequence)"0") && !user.isAdmin() && (a2 = this.sessionDAO.getActiveSessions(true, true).size()) >= 10) {
            throw new AuthenticationException(BaseEntity.ALLATORIxDEMO("?j5#\u7629\u5f4c\u5963\u8d3c\uff5e\u60b1\u76d6\u5f4a\u521f\u7662\u5f07\u4ea3\u6522\u5deb\u8dd7\u8fde\u9602\u522f\uff5e\u8bee\u8006\u7ce2\u7bf3\u741f\u540a\uff18"));
        }
        if (!"0".equals(user.getStatus())) {
            if ("2".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, a.ALLATORIxDEMO("<A6\b")).append(Global.getText(BaseEntity.ALLATORIxDEMO("j+j|u=~;w|x1z=l<m\u0016p!x0u7}"), new String[0])).toString());
            }
            if ("3".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, a.ALLATORIxDEMO("<A6\b")).append(Global.getText(BaseEntity.ALLATORIxDEMO("!`!7>v5p<73z1v'w&_ |7c7}"), new String[0])).toString());
            }
            if ("4".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, a.ALLATORIxDEMO("<A6\b")).append(Global.getText(BaseEntity.ALLATORIxDEMO("!`!7>v5p<73z1v'w&X'};m7}"), new String[0])).toString());
            }
            throw new AuthenticationException(new StringBuilder().insert(0, a.ALLATORIxDEMO("<A6\b")).append(Global.getText(BaseEntity.ALLATORIxDEMO("!`!7>v5p<73z1v'w&P<o3u;}"), new String[0])).toString());
        }
        byte[] a22 = EncodeUtils.decodeHex((String)user.getPassword().substring(0, 16));
        return new SimpleAuthenticationInfo((Object)new LoginInfo(user, token.getParams()), (Object)user.getPassword().substring(16), ByteSource.Util.bytes((byte[])a22), this.getName());
    }

    public BaseAuthorizingRealm() {
        BaseAuthorizingRealm baseAuthorizingRealm = this;
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher(HASH_ALGORITHM);
        hashedCredentialsMatcher.setHashIterations(1024);
        baseAuthorizingRealm.setCredentialsMatcher((CredentialsMatcher)hashedCredentialsMatcher);
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean isPermitted(Permission permission, AuthorizationInfo info) {
        try {
            String a2 = StringUtils.substringBefore((String)permission.toString(), (String)a.ALLATORIxDEMO("\b"));
            if (a2 != null) {
                void a3;
                String string = (String)M.ALLATORIxDEMO().get(BaseEntity.ALLATORIxDEMO("t=}'u7j"));
                if (StringUtils.contains((CharSequence)a3, (CharSequence)(a.ALLATORIxDEMO("\u001e") + a2 + BaseEntity.ALLATORIxDEMO("5"))) && !StringUtils.contains((CharSequence)((String)M.ALLATORIxDEMO().get(a.ALLATORIxDEMO("]!W?\u007f>V$^4A"))), (CharSequence)new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("5")).append(a2).append(a.ALLATORIxDEMO("\u001e")).toString())) {
                    throw new RuntimeException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("B")).append(a2).append(a.ALLATORIxDEMO("\f\u6a13\u5706\u6c93\u6758\u63ba\u6712\uff33")).toString());
                }
            }
        }
        catch (Exception a4) {
            throw new UnauthorizedException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("?j5#")).append(a4.getMessage()).toString());
        }
        return super.isPermitted(permission, info);
    }

    public void onLogoutSuccess(User logoutUser, HttpServletRequest request) {
    }

    public void onLoginSuccess(PrincipalCollection principals) {
    }

    protected final void assertCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) throws AuthenticationException {
        if (authcToken instanceof FormToken) {
            FormToken a2 = (FormToken)authcToken;
            if (StringUtils.isNotBlank((CharSequence)a2.getSsoToken())) {
                FormToken formToken = a2;
                String a3 = UserUtils.getSsoToken(formToken.getUsername());
                if (StringUtils.equals((CharSequence)formToken.getSsoToken(), (CharSequence)a3)) {
                    return;
                }
                throw new IncorrectCredentialsException(a.ALLATORIxDEMO("_\"Uk\u63ba\u6712\u4ed6\u721d\u952b\u8bbe\uff3e\u8ba6\u51bf\u8b84\u4e32\u6b70\u6224\u8005\u7cc9\u7bf0\u7434\u5409\u3030"));
            }
            super.assertCredentialsMatch((AuthenticationToken)a2, info);
            return;
        }
        if (authcToken instanceof CasToken) {
            return;
        }
        throw new IncorrectCredentialsException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("t!~h\u4e14\u657d\u6318\u76d6\u6391\u6711\u4efd\u721e\u7c62\u57d9\uff03")).append(authcToken).toString());
    }

    protected abstract void casCreateEmpUser(User var1, Map<String, Object> var2);

    /*
     * WARNING - void declaration
     */
    protected final AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Serializable a22;
        Object a3;
        String a4;
        Object a5;
        void a6;
        LoginInfo a7 = (LoginInfo)this.getAvailablePrincipal(principals);
        String a8 = a7.getParam(a.ALLATORIxDEMO("5W'[2W\u0005K!W"));
        if (StringUtils.isNotBlank((CharSequence)a8)) {
            long a9 = ObjectUtils.toLong((Object)Global.getProperty(BaseEntity.ALLATORIxDEMO("!|!j;v<7!|!j;v<M;t7v'm")));
            long a10 = ObjectUtils.toLong((Object)Global.getProperty(new StringBuilder().insert(0, a.ALLATORIxDEMO("\"W\"A8]?\u001c")).append(a8).append(BaseEntity.ALLATORIxDEMO("\u0001|!j;v<M;t7v'm")).toString()));
            UserUtils.getSession().setTimeout(a10 > 0L ? a10 : a9);
        }
        HttpServletRequest a11 = ServletUtils.getRequest();
        String string = a7.getParam("ticket");
        this.casOutHandler.recordSession(a11, (String)a6);
        if (!ObjectUtils.toBoolean((Object)Global.getConfig(a.ALLATORIxDEMO("A9[#]\u007f[\"s=^>E\u001cG=F8s5V#~>U8\\"), "true")).booleanValue() && (a5 = this.sessionDAO.getActiveSessions(false, true, a4 = UserUtils.getSession().getId().toString(), null, a7.getId())).size() > 0) {
            if (UserUtils.getSubject().isAuthenticated()) {
                Iterator iterator = a5.iterator();
                while (iterator.hasNext()) {
                    a3 = (Session)iterator.next();
                    PrincipalCollection a12 = (PrincipalCollection)a3.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                    a22 = a12 != null ? (LoginInfo)a12.getPrimaryPrincipal() : null;
                    if (a22 == null || !StringUtils.equals((CharSequence)((LoginInfo)a22).getParam(BaseEntity.ALLATORIxDEMO("6|$p1|\u0006`\"|")), (CharSequence)a7.getParam(a.ALLATORIxDEMO("5W'[2W\u0005K!W")))) continue;
                    this.sessionDAO.delete((Session)a3);
                }
            } else {
                UserUtils.getSubject().logout();
                throw new AuthenticationException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("?j5#")).append(Global.getText(a.ALLATORIxDEMO("\"Z8@>\u001c<G=F8s5V#\u007f4A\"S6W"), new String[0])).toString());
            }
        }
        if ((a = UserUtils.get(a7.getId())) == null) {
            return null;
        }
        a5 = UserUtils.getSession();
        Session session = a5;
        a5.setAttribute((Object)BaseEntity.ALLATORIxDEMO("'j7k\u0011v6|"), (Object)a.getUserCode());
        session.setAttribute((Object)a.ALLATORIxDEMO("$A4@\u001fS<W"), (Object)a.getUserName());
        session.setAttribute((Object)BaseEntity.ALLATORIxDEMO("'j7k\u0006`\"|"), (Object)a.getUserType());
        SimpleAuthorizationInfo a13 = new SimpleAuthorizationInfo();
        a3 = UserUtils.getMenuList();
        for (Serializable a22 : a3) {
            int n;
            if (!StringUtils.isNotBlank((CharSequence)((Menu)a22).getPermission())) continue;
            String[] stringArray = StringUtils.split((String)((Menu)a22).getPermission(), (String)a.ALLATORIxDEMO("\u001e"));
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                void a14;
                String string2 = stringArray[n];
                a13.addStringPermission((String)a14);
                n3 = ++n;
            }
        }
        a13.addStringPermission(BaseEntity.ALLATORIxDEMO("'j7k"));
        Iterator<DataEntity> iterator = a.getRoleList().iterator();
        Iterator<DataEntity> iterator2 = iterator;
        while (iterator2.hasNext()) {
            a22 = (Role)iterator.next();
            iterator2 = iterator;
            a13.addRole(((Role)a22).getRoleCode());
        }
        return a13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) {
        Object a2;
        Object a3;
        FormToken formToken;
        HttpServletRequest a4 = ServletUtils.getRequest();
        if (this.casOutHandler.isLogoutRequest(a4)) {
            String a5 = CommonUtils.safeGetParameter((HttpServletRequest)a4, (String)"logoutRequest");
            BaseAuthorizingRealm baseAuthorizingRealm = this;
            User a6 = baseAuthorizingRealm.casOutHandler.destroySession(a4, a5);
            baseAuthorizingRealm.onLogoutSuccess(a6, a4);
            return null;
        }
        if (authcToken == null) {
            return null;
        }
        FormToken a7 = null;
        Map a8 = null;
        AuthenticationToken authenticationToken = authcToken;
        if (authcToken instanceof FormToken) {
            formToken = a7 = (FormToken)authenticationToken;
        } else {
            Assertion assertion;
            if (!(authenticationToken instanceof CasToken) || !ObjectUtils.toBoolean(M.ALLATORIxDEMO().get(a.ALLATORIxDEMO("T?q0A"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("?j5#")).append(Global.getText(a.ALLATORIxDEMO("A(A\u007f^>U8\\\u007fF(B4g?Y?]&\\"), new String[0])).toString());
            a3 = (CasToken)authcToken;
            a2 = (String)a3.getCredentials();
            if (this.ticketValidator == null) {
                this.ticketValidator = new Cas20ServiceTicketValidator(this.casServerUrl);
                ((Cas20ServiceTicketValidator)this.ticketValidator).setEncoding("UTF-8");
            }
            Object var7_11 = null;
            try {
                assertion = this.ticketValidator.validate((String)a2, this.casServerCallbackUrl);
            }
            catch (TicketValidationException a9) {
                return null;
            }
            AttributePrincipal attributePrincipal = a = assertion.getPrincipal();
            a3.setUserId(attributePrincipal.getName());
            a8 = attributePrincipal.getAttributes();
            a7 = new FormToken();
            a7.setUsername(a.getName());
            Map a10 = Maps.newHashMap();
            FormToken formToken2 = a7;
            a10.put("ticket", a2);
            formToken = formToken2;
            formToken2.setParams(a10);
        }
        if (StringUtils.isBlank((CharSequence)formToken.getUsername())) {
            throw new AuthenticationException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("?j5#")).append(Global.getText(a.ALLATORIxDEMO("\"K\"\u001c=]6[?\u001c0Q2]$\\%{\"p=S?Y"), new String[0])).toString());
        }
        if (StringUtils.isBlank((CharSequence)a7.getSsoToken()) && !(authcToken instanceof CasToken)) {
            a3 = (String)(a7.getParams() == null ? null : a7.getParams().get(BaseEntity.ALLATORIxDEMO("6|$p1|\u0006`\"|")));
            if (BaseAuthorizingRealm.isValidCodeLogin(a7.getUsername(), (String)a3, a.ALLATORIxDEMO("D0^8V"))) {
                a2 = UserUtils.getSession();
                String string = (String)a2.getAttribute((Object)"validCode");
                if (a7.getCaptcha() == null || !a7.getCaptcha().toUpperCase().equals(string)) {
                    throw new AuthenticationException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("?j5#")).append(Global.getText(a.ALLATORIxDEMO("\"K\"\u001c=]6[?\u001c'S=[5q>V4w#@>@"), new String[0])).toString());
                }
                a2.removeAttribute((Object)"validCode");
            }
        }
        if (!M.ALLATORIxDEMO(a4)) {
            throw new AuthenticationException(BaseEntity.ALLATORIxDEMO("?j5#\u7629\u5f4c\u5963\u8d3c\uff5e\u8bee\u8006\u7ce2\u7bf3\u741f\u540a\u83ae\u5384\u8ba1\u53bd\uff18"));
        }
        a3 = UserUtils.getByLoginCode(a7.getUsername());
        if (a3 != null) {
            return this.newAuthenticationInfo((User)a3, a7);
        }
        if (!(authcToken instanceof CasToken)) return null;
        if (!ObjectUtils.toBoolean(a8.get(a.ALLATORIxDEMO("[\"s=^>E\u0012^8W?F\u0012@4S%W\u0004A4@"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, a.ALLATORIxDEMO("<A6\b\u7579\u6205q\u202e")).append(a7.getUsername()).append(BaseEntity.ALLATORIxDEMO("\u2004r\u5731\u677e\u7ce2\u7e8d\u4e34\u4e5f\u5b41\u577a5r\u8bee\u8006\u7ce2\u7bf3\u741f\u540a7")).toString());
        Object object = a3 = new User(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(BaseEntity.ALLATORIxDEMO("'j7k\u0011v6|")))));
        Map map = a8;
        Object object2 = a3;
        Map map2 = a8;
        Object object3 = a3;
        Map map3 = a8;
        Object object4 = a3;
        ((User)object4).setLoginCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(a.ALLATORIxDEMO("^>U8\\\u0012]5W")))));
        ((User)object4).setPassword(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(BaseEntity.ALLATORIxDEMO("\"x!j%v }")))));
        ((User)a3).setUserName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get(a.ALLATORIxDEMO("$A4@\u001fS<W")))));
        ((User)object3).setEmail(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get("email"))));
        ((User)object3).setMobile(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(BaseEntity.ALLATORIxDEMO("?v0p>|")))));
        ((User)a3).setPhone(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(a.ALLATORIxDEMO("B9]?W")))));
        ((User)object2).setUserType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(BaseEntity.ALLATORIxDEMO("'j7k\u0006`\"|")))));
        ((User)object2).setRefCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(a.ALLATORIxDEMO("@4T\u0012]5W")))));
        ((User)a3).setRefName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(BaseEntity.ALLATORIxDEMO("k7\u007f\u001cx?|")))));
        ((User)object).setMgrType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(a.ALLATORIxDEMO("_6@\u0005K!W")))));
        ((DataEntity)object).setStatus(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(BaseEntity.ALLATORIxDEMO("!m3m'j")))));
        if ("employee".equals(((User)a3).getUserType())) {
            try {
                this.casCreateEmpUser((User)a3, a8);
            }
            catch (ValidationException a11) {
                throw new AuthenticationException(new StringBuilder().insert(0, a.ALLATORIxDEMO("<A6\b")).append(a11.getMessage()).toString());
            }
            a3 = UserUtils.getByLoginCode(a7.getUsername());
            if (a3 == null) return null;
            return this.newAuthenticationInfo((User)a3, a7);
        }
        try {
            a2 = SpringUtils.getBean(CasCreateUser.class);
            if (a2 == null) return null;
            a2.createUser((User)a3, a8);
            return null;
        }
        catch (NoSuchBeanDefinitionException a12) {
            throw new AuthenticationException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("?j5#\u757a\u622er\u2005")).append(a7.getUsername()).append(a.ALLATORIxDEMO("\u202f}\u0012\u7c2a\u57b9q\u202e")).append(((User)a3).getUserType()).append(BaseEntity.ALLATORIxDEMO("\u2004r\u5731\u677e\u7ce2\u7e8d\u4e34\u4e5f\u5b41\u577a5r\u8bee\u8006\u7ce2\u7bf3\u741f\u540a7")).toString());
        }
    }

    public void setCasOutHandler(CasOutHandler casOutHandler) {
        this.casOutHandler = casOutHandler;
    }

    public static boolean isValidCodeLogin(String loginCode, String deviceType, String operation) {
        String a2;
        int a222;
        String a3;
        Long[] a4;
        Map a5 = (Map)CacheUtils.get(a.ALLATORIxDEMO("=]6[?t0[=W5\u007f0B"));
        if (a5 == null) {
            a5 = Maps.newHashMap();
            CacheUtils.put(BaseEntity.ALLATORIxDEMO(">v5p<_3p>|6T3i"), a5);
        }
        if ((a4 = (Long[])a5.get(a3 = loginCode)) == null) {
            Long[] longArray = new Long[2];
            longArray[0] = 0L;
            longArray[1] = 0L;
            a4 = longArray;
        }
        Long a6 = a4[0];
        Long a7 = a4[1];
        if (a.ALLATORIxDEMO("D0^8V").equals(operation)) {
            if (a7 != 0L) {
                a222 = ObjectUtils.toInteger((Object)Global.getConfig(BaseEntity.ALLATORIxDEMO("!`!7>v5p<74x;u7}\u001cl?X4m7k\u001ev1r\u001fp<l&|"), a.ALLATORIxDEMO("c\u0002")));
                if (System.currentTimeMillis() / 60000L - a7 <= (long)a222) {
                    String[] stringArray = new String[1];
                    stringArray[0] = String.valueOf(a222);
                    throw new AuthenticationException(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("?j5#")).append(Global.getText(a.ALLATORIxDEMO("A(A\u007f^>U8\\\u007fT0[=W5|$_\u001d]2Y"), stringArray)).toString());
                }
                Long[] longArray = new Long[2];
                longArray[0] = a6;
                longArray[1] = 0L;
                a5.put(a3, longArray);
            }
        } else if (BaseEntity.ALLATORIxDEMO("4x;u7}").equals(operation)) {
            Long a222 = a6;
            Long l2 = a6 = Long.valueOf(a222 + 1L);
            a222 = ObjectUtils.toInteger((Object)Global.getConfig(a.ALLATORIxDEMO("A(A\u007f^>U8\\\u007fT0[=W5|$_\u0010T%W#~>Q:s2Q>G?F"), BaseEntity.ALLATORIxDEMO("+b)")));
            if (a6 >= (long)a222) {
                a7 = System.currentTimeMillis() / 60000L;
            }
            Long[] longArray = new Long[2];
            longArray[0] = a6;
            longArray[1] = a7;
            a5.put(a3, longArray);
        } else if (a.ALLATORIxDEMO("A$Q2W\"A").equals(operation)) {
            a5.remove(a3);
        }
        a222 = ObjectUtils.toInteger((Object)Global.getConfig(BaseEntity.ALLATORIxDEMO("j+j|u=~;w|\u007f3p>|6W't\u0013\u007f&| O3u;}\u0011v6|"), a.ALLATORIxDEMO("\u0003a\u0002")));
        if (StringUtils.isNotBlank((CharSequence)deviceType) && StringUtils.isNotBlank((CharSequence)(a2 = Global.getConfig(new StringBuilder().insert(0, BaseEntity.ALLATORIxDEMO("!`!7>v5p<74x;u7}\u001cl?X4m7k\u0004x>p6Z=}77")).append(deviceType).toString())))) {
            a222 = ObjectUtils.toInteger((Object)a2);
        }
        return a6 >= (long)a222;
    }

    protected final AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            return null;
        }
        AuthorizationInfo a2 = null;
        a2 = (AuthorizationInfo)UserUtils.getCache("authInfo");
        if (a2 == null && (a2 = this.doGetAuthorizationInfo(principals)) != null) {
            UserUtils.putCache("authInfo", a2);
        }
        return a2;
    }
}

