/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.utils;

import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.codec.Md5Utils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.annotation.MyBatisDao;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.config.CoreConfig;
import com.jeesite.modules.msg.utils.MsgPushUtils;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.H;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtils {
    private static final String USER_CACHE_USER_TYPE_AND_REF_CODE_ = "type_ref_";
    public static final String CACHE_MENU_LIST = "menuList";
    private static final String USER_CACHE_CODE_ = "code_";
    private static final String USER_CACHE_LOGIN_CODE_ = "login_";
    private static Lock userCacheLock = new ReentrantLock();
    private static final String USER_CACHE = "userCache";
    public static final String CACHE_AUTH_INFO = "authInfo";
    private static Logger logger = LoggerFactory.getLogger(UserUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getByLoginCode(String loginCode) {
        if (StringUtils.isBlank((CharSequence)loginCode)) {
            return null;
        }
        String a2 = new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(loginCode).toString();
        String a3 = (String)CacheUtils.get(USER_CACHE, a2);
        if (a3 != null) {
            return UserUtils.get(a3);
        }
        userCacheLock.lock();
        try {
            a3 = (String)CacheUtils.get(USER_CACHE, a2);
            if (a3 != null) {
                User user = UserUtils.get(a3);
                return user;
            }
            User a4 = new User();
            a4.setLoginCode(loginCode);
            a4 = H.ALLATORIxDEMO().getByLoginCode(a4);
            a4 = UserUtils.returnUser(a4);
            if (a4 != null) {
                User user = (User)a4.clone();
                return user;
            }
        }
        finally {
            userCacheLock.unlock();
        }
        return null;
    }

    public static void clearFoxbpmCache() {
        Class<?> a22 = Class.forName(CoreConfig.ALLATORIxDEMO("- %|$=:02?l7,5+<'|+?2>l1#1*7l\u0011#1*7\u0017&+>"));
        try {
            a22.getMethod(MsgPushUtils.ALLATORIxDEMO("?u9x.P8|2m5m%Z=z4|"), new Class[0]).invoke(null, new Object[0]);
            return;
        }
        catch (Exception a3) {
            try {
                a3.printStackTrace();
                return;
            }
            catch (ClassNotFoundException a22) {
                return;
            }
        }
    }

    public static Session getSession() {
        try {
            Subject a2 = UserUtils.getSubject();
            Session a3 = a2.getSession(false);
            if (a3 == null) {
                a3 = a2.getSession();
            }
            if (a3 != null) {
                return a3;
            }
        }
        catch (UnavailableSecurityManagerException a2) {
        }
        catch (InvalidSessionException a2) {
            // empty catch block
        }
        return new SimpleSession();
    }

    public static void clearCache(User user) {
        CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_CODE_).append(user.getUserCode()).toString());
        CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(StringUtils.isNotBlank((CharSequence)user.getCorpCode()) ? new StringBuilder().insert(0, user.getCorpCode()).append(CoreConfig.ALLATORIxDEMO("\r")).toString() : "").append(user.getLoginCode()).toString());
        CacheUtils.remove(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(user.getUserType()).append(MsgPushUtils.ALLATORIxDEMO("F")).append(user.getRefCode()).toString());
        UserUtils.clearFoxbpmCache();
    }

    public static Object getCache(String key, Object defaultValue) {
        Object a2 = UserUtils.getCache(key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static List<Menu> getMenuTree() {
        ArrayList a2 = ListUtils.newArrayList();
        List<Menu> a3 = UserUtils.getMenuList();
        H.ALLATORIxDEMO().convertChildList(a3, a2, "0");
        return a3;
    }

    public static String getUserTypeValue(String userType, String key) {
        if (H.ALLATORIxDEMO() == null) {
            throw new ServiceException(CoreConfig.ALLATORIxDEMO("(7'!+&'|;?.\u4e7f\u76c6'170|7!' \u0016+27\u000f32\u911f\u7f2c\u4e5f\u6b21\u783c\u6254\u6cf3\u674b\u5bc8\u4e0b\u3050"));
        }
        if ("none".equals(userType)) {
            return null;
        }
        Map a2 = (Map)H.ALLATORIxDEMO().get(userType);
        if (a2 != null && a2.get(key) != null) {
            return (String)a2.get(key);
        }
        logger.warn(new StringBuilder().insert(0, MsgPushUtils.ALLATORIxDEMO("6|9j5m97%t0\u4e34\u76d8l/|.7)j9k\b`,|\u0011x,\u6cb8\u6755\u9154\u7f32\u2005")).append(userType).append(CoreConfig.ALLATORIxDEMO("\u204f\u756a\u6265\u7c39\u57d9\u76c6\u204e")).append(key).append(MsgPushUtils.ALLATORIxDEMO("\u2004\u5060\u301b")).toString());
        return null;
    }

    private static /* synthetic */ User returnUser(User user) {
        if (user == null) {
            return null;
        }
        User user2 = user;
        UserUtils.loadRefObj(user2);
        user2.setRoleList(H.ALLATORIxDEMO().findListByUserCode(new Role(user)));
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_CODE_).append(user.getId()).toString(), user);
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_LOGIN_CODE_).append(user.getCorpCode()).append(CoreConfig.ALLATORIxDEMO("\r")).append(user.getLoginCode()).toString(), user.getUserCode());
        CacheUtils.put(USER_CACHE, new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(user.getUserType()).append(MsgPushUtils.ALLATORIxDEMO("F")).append(user.getRefCode()).toString(), user.getUserCode());
        return user;
    }

    public static LoginInfo getLoginInfo() {
        try {
            Subject a2 = UserUtils.getSubject();
            LoginInfo a3 = (LoginInfo)a2.getPrincipal();
            if (a3 != null) {
                return a3;
            }
        }
        catch (UnavailableSecurityManagerException a2) {
        }
        catch (InvalidSessionException a2) {
            // empty catch block
        }
        return null;
    }

    public static Object getCache(String key) {
        return UserUtils.getSession().getAttribute((Object)key);
    }

    public static String getSsoToken(String username) {
        String a2 = Global.getConfig(CoreConfig.ALLATORIxDEMO("!*;0=l!1=l!'1076\u0019'+"));
        if (StringUtils.isBlank((CharSequence)a2)) {
            logger.warn(MsgPushUtils.ALLATORIxDEMO("\u5c02\u603e\u65db\u4eef|j4p.vrj/vrj9z.|(R9`|\u4e23\u7a26\uff15\u8bab\u8ba7\u7f32\u5417\u51d1\u64d4\u4f00\u301b"));
            return null;
        }
        if (ObjectUtils.toBoolean((Object)Global.getConfig(CoreConfig.ALLATORIxDEMO("1:+ -|1!-|'<! ;\"6\u0019'+"), "true")).booleanValue()) {
            a2 = Global.getPropertyDecodeAndEncode(MsgPushUtils.ALLATORIxDEMO(":/=zl)d,l+n}8-k\u007fm\u007f9,d|l}:\u007fj\u007fl!d*"), CoreConfig.ALLATORIxDEMO("!*;0=l!1=l!'1076\u0019'+"), a2);
        }
        return Md5Utils.md5((String)new StringBuilder().insert(0, a2).append(username).append(DateUtils.getDate((String)MsgPushUtils.ALLATORIxDEMO("%`%`\u0011T8}"))).toString());
    }

    public static void clearCache() {
        UserUtils.removeCache(CACHE_AUTH_INFO);
        UserUtils.removeCache(CACHE_MENU_LIST);
        UserUtils.clearCache(UserUtils.getUser());
    }

    public static User getUser() {
        User a2;
        LoginInfo a3 = UserUtils.getLoginInfo();
        if (a3 != null && (a2 = UserUtils.get(a3.getId())) != null) {
            return a2;
        }
        return new User();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadRefObj(User user) {
        if (user.getRefObj() != null) return;
        if (!StringUtils.isNotBlank((CharSequence)user.getUserType())) return;
        if (!StringUtils.isNotBlank((CharSequence)user.getRefCode())) return;
        String a2 = UserUtils.getUserTypeValue(user.getUserType(), CoreConfig.ALLATORIxDEMO("6#="));
        if (!StringUtils.isNotBlank((CharSequence)a2)) return;
        try {
            User user2;
            Object a3;
            block6: {
                int n;
                a3 = SpringUtils.getBean(a2);
                Class<?>[] classArray = a3.getClass().getInterfaces();
                int n2 = classArray.length;
                int n3 = n = 0;
                while (n3 < n2) {
                    MyBatisDao a4 = classArray[n].getAnnotation(MyBatisDao.class);
                    if (a4 != null) {
                        Class[] classArray2 = new Class[1];
                        classArray2[0] = String.class;
                        Object[] objectArray = new Object[1];
                        objectArray[0] = user.getRefCode();
                        user.setRefObj(a4.entity().getConstructor(classArray2).newInstance(objectArray));
                        user2 = user;
                        break block6;
                    }
                    n3 = ++n;
                }
                user2 = user;
            }
            if (user2.getRefObj() == null) return;
            Class[] classArray = new Class[1];
            classArray[0] = Object.class;
            Object[] objectArray = new Object[1];
            objectArray[0] = user.getRefObj();
            Object a5 = a3.getClass().getMethod(MsgPushUtils.ALLATORIxDEMO("~9m"), classArray).invoke(a3, objectArray);
            if (a5 == null) return;
            user.setRefObj(a5);
            return;
        }
        catch (Exception a6) {
            a6.printStackTrace();
        }
    }

    public static AuthorizationInfo getAuthInfo() {
        return (AuthorizationInfo)UserUtils.getCache(CACHE_AUTH_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User get(String userCode) {
        User a2;
        Object a3;
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        HttpServletRequest a4 = ServletUtils.getRequest();
        if (a4 != null) {
            a3 = (User)a4.getAttribute(CoreConfig.ALLATORIxDEMO("\u001d\r7!' \u001d\r") + userCode);
            if (a3 != null) {
                return a3;
            }
        }
        if ((a2 = (User)CacheUtils.get(USER_CACHE, (String)(a3 = new StringBuilder().insert(0, USER_CACHE_CODE_).append(userCode).toString()))) != null) {
            return (User)a2.clone();
        }
        userCacheLock.lock();
        try {
            a2 = (User)CacheUtils.get(USER_CACHE, (String)a3);
            if (a2 != null) {
                User user = (User)a2.clone();
                return user;
            }
            User a5 = new User(userCode);
            a2 = H.ALLATORIxDEMO().get(a5);
            a2 = UserUtils.returnUser(a2);
            if (a4 != null) {
                a4.setAttribute(new StringBuilder().insert(0, MsgPushUtils.ALLATORIxDEMO("\u0003F)j9k\u0003F")).append(userCode).toString(), (Object)a2);
            }
            if (a2 != null) {
                User user = (User)a2.clone();
                return user;
            }
            User user = null;
            return user;
        }
        finally {
            userCacheLock.unlock();
        }
    }

    public static void removeCache(String key) {
        UserUtils.getSession().removeAttribute((Object)key);
    }

    /*
     * Unable to fully structure code
     */
    public static List<Menu> getMenuListByParentCode(String parentCode) {
        block8: {
            block10: {
                block9: {
                    a = (Map)UserUtils.getCache("menuList");
                    if (a == null) {
                        a = MapUtils.newConcurrentMap();
                        UserUtils.putCache("menuList", a);
                    }
                    a = null;
                    if (parentCode != null) {
                        a = (List<Menu>)a.get(parentCode);
                    }
                    if (a != null) break block8;
                    a = new Menu();
                    a.setParentCode(parentCode);
                    a = UserUtils.getLoginInfo();
                    if (a != null) {
                        a.setSysCode(a.getParam(CoreConfig.ALLATORIxDEMO("!;!\u0001=&7"), "default"));
                    } else {
                        a.setSysCode("default");
                    }
                    a = UserUtils.getUser();
                    if (!User.isSuperAdmin(a.getUserCode())) break block9;
                    a.setWeight_gte(Menu.SUPER_ADMIN_GET_MENU_MIN_WEIGHT);
                    a = H.ALLATORIxDEMO().findList(a);
                    v0 = parentCode;
                    break block10;
                }
                if (!"none".equals(a.getUserType()) && StringUtils.isNotBlank((CharSequence)(a = Global.getConfig(new StringBuilder().insert(0, MsgPushUtils.ALLATORIxDEMO("/`/7)j9kr}9\u007f=l0m\u000ev0|\u001fv8|/7")).append(a.getUserType()).toString())))) {
                    a.setDefaultRoleCodes(StringUtils.split((String)a, (char)','));
                }
                if (!"1".equals(a.getMgrType())) ** GOTO lbl41
                v1 = a;
                if (a.getDefaultRoleCodes() != null) {
                    v2 = a = SetUtils.newHashSet((Object[])v1.getDefaultRoleCodes());
                    v2.add(Role.CORP_ADMIN_ROLE_CODE);
                    a.setDefaultRoleCodes(v2.toArray(new String[a.size()]));
                    v3 = a;
                } else {
                    v4 = new String[1];
                    v4[0] = Role.CORP_ADMIN_ROLE_CODE;
                    v1.setDefaultRoleCodes(v4);
lbl41:
                    // 2 sources

                    v3 = a;
                }
                v3.setUserCode(a.getId());
                a = H.ALLATORIxDEMO().findByUserCode(a);
                v0 = parentCode;
            }
            if (v0 != null) {
                a.put(parentCode, a);
            }
        }
        return a;
    }

    public static List<User> findCorpList() {
        User a2 = new User();
        return H.ALLATORIxDEMO().findCorpList(a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getByTypeAndRef(String userType, String refCode) {
        if (StringUtils.isBlank((CharSequence)userType) || StringUtils.isBlank((CharSequence)refCode)) {
            return null;
        }
        String a2 = new StringBuilder().insert(0, USER_CACHE_USER_TYPE_AND_REF_CODE_).append(userType).append(CoreConfig.ALLATORIxDEMO("\r")).append(refCode).toString();
        String a3 = (String)CacheUtils.get(USER_CACHE, a2);
        if (a3 != null) {
            return UserUtils.get(a3);
        }
        userCacheLock.lock();
        try {
            User a4;
            a3 = (String)CacheUtils.get(USER_CACHE, a2);
            if (a3 != null) {
                User user = UserUtils.get(a3);
                return user;
            }
            User user = new User();
            void v0 = a4;
            v0.setUserType(userType);
            v0.setRefCode(refCode);
            a4 = H.ALLATORIxDEMO().getByUserTypeAndRefCode(a4);
            a4 = UserUtils.returnUser(a4);
            if (a4 != null) {
                User user2 = (User)a4.clone();
                return user2;
            }
        }
        finally {
            userCacheLock.unlock();
        }
        return null;
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static void putCache(String key, Object value) {
        UserUtils.getSession().setAttribute((Object)key, value);
    }

    public static List<Menu> getMenuList() {
        return UserUtils.getMenuListByParentCode(null);
    }
}

