/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.cache.F;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.modules.config.TransactionConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    private static final String SYS_CACHE = "sysCache";

    public static Object get(String cacheName, String key, Object defaultValue) {
        Object a2 = CacheUtils.get(cacheName, key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static void removeAll(String cacheName) {
        Iterator a2;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        Iterator iterator = a2 = a4.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = a2;
            iterator = iterator2;
            a3.remove(iterator2.next());
        }
        logger.info(TransactionConfig.ALLATORIxDEMO("\u6e0d\u7475\u7f1b\u5b2b\uff12Ss\u000e(N6Ss\u000e"), (Object)cacheName, (Object)a4);
    }

    public static Object get(String key) {
        return CacheUtils.get(SYS_CACHE, key);
    }

    public static Object get(String key, Object defaultValue) {
        Object a2 = CacheUtils.get(key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static Cache<String, Object> getCache(String cacheName) {
        Cache a2 = F.ALLATORIxDEMO().getCache(cacheName);
        if (a2 == null) {
            throw new RuntimeException(new StringBuilder().insert(0, TransactionConfig.ALLATORIxDEMO("\u5f5b\u523e\u7cf3\u7eac\u4e25\u6cd2\u6701\u5be9\u4e41\u206f")).append(cacheName).append(TransactionConfig.ALLATORIxDEMO("\u2015\u8faa\u4e22\u7f60\u5b50\u3071")).toString());
        }
        return a2;
    }

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }

    public static void put(String cacheName, String key, Object value) {
        CacheUtils.getCache(cacheName).put((Object)key, value);
    }

    public static Object get(String cacheName, String key) {
        return CacheUtils.getCache(cacheName).get((Object)key);
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove((Object)key);
    }

    public static void removeByKeyPrefix(String cacheName, String keyPrefix) {
        String a2 = keyPrefix;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        HashSet a5 = SetUtils.newHashSet();
        for (String a6 : a4) {
            if (!StringUtils.startsWith((CharSequence)a6, (CharSequence)a2)) continue;
            a3.remove((Object)a6);
            a5.add(a6);
        }
        logger.info(TransactionConfig.ALLATORIxDEMO("\u6e0d\u7475\u7f1b\u5b2b\uff12Ss\u000e(N6Ss\u000e"), (Object)cacheName, (Object)a5);
    }

    public static String[] getCacheNames() {
        return F.ALLATORIxDEMO().getCacheNames();
    }

    public static void clearCache() {
        int n;
        String a2 = Global.getConfig(TransactionConfig.ALLATORIxDEMO("m\u001bk\u0012k\u001bm]k\u001fm\u0012z=i\u001em\u0000"));
        if (StringUtils.isBlank((CharSequence)a2)) {
            return;
        }
        String[] stringArray = a2.split(TransactionConfig.ALLATORIxDEMO("_"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            CacheUtils.removeAll(stringArray[n++]);
            n3 = n;
        }
    }
}

