/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.config;

import com.jeesite.common.config.Global;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.shiro.session.CacheSessionDAO;
import com.jeesite.common.shiro.session.JedisSessionDAO;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.shiro.session.SessionManager;
import com.jeesite.modules.sys.utils.RoleUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SessionConfig {
    @Bean(name={"sessionDAO"})
    @ConditionalOnMissingBean(value={SessionDAO.class})
    @ConditionalOnProperty(name={"redis.cacheAndSession"}, havingValue="true", matchIfMissing=false)
    public SessionDAO sessionDAORedis() {
        JedisSessionDAO a2;
        JedisSessionDAO jedisSessionDAO = a2 = new JedisSessionDAO();
        a2.setSessionIdGenerator(new IdGen());
        jedisSessionDAO.setSessionKeyPrefix(new StringBuilder().insert(0, Global.getProperty(BaseEntity.ALLATORIxDEMO("v\u0001`\rwJo\u0001}4v\u0001b\r|"))).append(RoleUtils.ALLATORIxDEMO("UmU{OgHW")).toString());
        return a2;
    }

    @Bean(name={"sessionDAO"})
    @ConditionalOnMissingBean(value={SessionDAO.class})
    @ConditionalOnProperty(name={"redis.cacheAndSession"}, havingValue="false", matchIfMissing=true)
    public SessionDAO sessionDAO(CacheManager shiroCacheManager) {
        CacheSessionDAO a2;
        CacheSessionDAO cacheSessionDAO = a2 = new CacheSessionDAO();
        a2.setSessionIdGenerator(new IdGen());
        cacheSessionDAO.setActiveSessionsCacheName(BaseEntity.ALLATORIxDEMO("e\u0007p\rr\u0001W\u0001w\u0017m\u000bj\u0017G\u0005g\fa"));
        cacheSessionDAO.setCacheManager(shiroCacheManager);
        return cacheSessionDAO;
    }

    @Bean
    public SimpleCookie sessionIdCookie() {
        SimpleCookie simpleCookie = new SimpleCookie();
        simpleCookie.setName(Global.getProperty(RoleUtils.ALLATORIxDEMO("{C{UaIf\b{C{UaIfolegIcOmhiKm")));
        return simpleCookie;
    }

    @Bean
    public SessionManager sessionManager(SessionDAO sessionDAO, SimpleCookie sessionIdCookie) {
        SessionManager a2;
        SessionManager sessionManager = a2 = new SessionManager();
        SessionManager sessionManager2 = a2;
        SessionManager sessionManager3 = a2;
        a2.setSessionDAO(sessionDAO);
        sessionManager3.setSessionIdUrlRewritingEnabled(false);
        sessionManager3.setGlobalSessionTimeout(ObjectUtils.toLong((Object)Global.getProperty(BaseEntity.ALLATORIxDEMO("\u0017a\u0017w\rk\n*\u0017a\u0017w\rk\nP\ri\u0001k\u0011p"))));
        sessionManager2.setSessionValidationInterval(ObjectUtils.toLong((Object)Global.getProperty(RoleUtils.ALLATORIxDEMO("{C{UaIf\b{C{UaIfraKmI}RKJmGf"))));
        sessionManager2.setSessionValidationSchedulerEnabled(true);
        sessionManager.setSessionIdCookie((Cookie)sessionIdCookie);
        sessionManager.setSessionIdCookieEnabled(true);
        return sessionManager;
    }
}

