/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.m.f.M;
import com.jeesite.common.m.p.a;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import com.jeesite.modules.sys.utils.ModuleUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(a.ALLATORIxDEMO().get(M.ALLATORIxDEMO("\u0016T:U\u0012"))).booleanValue()) {
            return this.renderResult("false", ModuleUtils.ALLATORIxDEMO("\u5f02\u5271\u7219\u6710\u677b\u5f3c\u656f\u6b58\u52ce\u80c1\uff50"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", M.ALLATORIxDEMO("\u5415\u52d8\u5ba0\u6586\u5652\u5941\u8d1f\uff71"));
        }
        return this.renderResult("true", ModuleUtils.ALLATORIxDEMO("\u5413\u52f9\u5ba6\u65a7\u5654\u6241\u52a3\uff50"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(a.ALLATORIxDEMO().get(M.ALLATORIxDEMO("\u0016T:U\u0012"))).booleanValue()) {
            return this.renderResult("false", ModuleUtils.ALLATORIxDEMO("\u5f02\u5271\u7219\u6710\u677b\u5f3c\u656f\u6b58\u52ce\u80c1\uff50"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", M.ALLATORIxDEMO("\u66f2\u5066\u8fa0\u8876\u6260\u52a5\uff71"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(a.ALLATORIxDEMO().get(ModuleUtils.ALLATORIxDEMO("7R\u001bS3"))).booleanValue()) {
            return this.renderResult("false", M.ALLATORIxDEMO("\u5f23\u5277\u7238\u6716\u675a\u5f3a\u654e\u6b5e\u52ef\u80c7\uff71"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", ModuleUtils.ALLATORIxDEMO("\u5060\u6b33\u5ba6\u65a7\u5654\u5960\u8d19\uff50"));
        }
        return this.renderResult("true", M.ALLATORIxDEMO("\u5066\u6b12\u5ba0\u6586\u5652\u6260\u52a5\uff71"));
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        List a2 = this.jobService.findList(job);
        a2 = ListUtils.listOrderBy(a2, (String)orderBy);
        return a2;
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a2 = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a2 = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a2 != null) {
                throw new ValidationException(ModuleUtils.ALLATORIxDEMO("\u545c\u79cc\u539b\u7ef8\u545c\u5dce\u7e9e\u5b64\u5779"));
            }
        }
        if (a2 == null) {
            a2 = new JobEntity();
        }
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a2;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(M.ALLATORIxDEMO("\u0019I\"O\u001eT\u0019T\u0017"), (Object)a2);
        return ModuleUtils.ALLATORIxDEMO("<S5I=Y\"\u0013;S3\u0013;S3p8O%");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(JobEntity jobEntity, Model model) {
        void job;
        void model2;
        model2.addAttribute(M.ALLATORIxDEMO("\u001aU\u0012\u007f\u001eN\u0019N\t"), (Object)job);
        return ModuleUtils.ALLATORIxDEMO("<S5I=Y\"\u0013;S3\u0013;S3z>N<");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a2 = new StringBuilder();
        try {
            void a3;
            CronExpression a4 = new CronExpression(cron);
            if (num <= 0) {
                a2.append(ModuleUtils.ALLATORIxDEMO("\u007f#S?\u8854\u8fef\u5f33\u6b32\u7852\u3053"));
                return this.renderResult("true", a2.toString());
            }
            a2.append(M.ALLATORIxDEMO("LJN\u673a\u8fa1") + num + ModuleUtils.ALLATORIxDEMO("\u6b1d\u8f81\u8870\u65a7\u95c8\uff4b\u0000~Lo"));
            Date a5 = new Date();
            boolean bl = false;
            void v0 = a3;
            while (v0 <= num) {
                if ((a5 = a4.getTimeAfter(a5)) == null) {
                    return this.renderResult("true", a2.toString());
                }
                a2.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a5)).append(M.ALLATORIxDEMO("L\u0015\u0012HN")).toString());
                v0 = ++a3;
            }
            return this.renderResult("true", a2.toString());
        }
        catch (ParseException a6) {
            return this.renderResult("false", new StringBuilder().insert(0, M.ALLATORIxDEMO("y\u0002U\u001e\u8852\u8fce\u5f35\u9569\u8bd5\uff6a")).append(a6.getMessage()).toString());
        }
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(a.ALLATORIxDEMO().get(ModuleUtils.ALLATORIxDEMO("7R\u001bS3"))).booleanValue()) {
            return this.renderResult("false", M.ALLATORIxDEMO("\u5f23\u5277\u7238\u6716\u675a\u5f3a\u654e\u6b5e\u52ef\u80c7\uff71"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", ModuleUtils.ALLATORIxDEMO("\u6033\u5931\u8f81\u8870\u6241\u52a3\uff50"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(a.ALLATORIxDEMO().get(M.ALLATORIxDEMO("\u0016T:U\u0012"))).booleanValue()) {
            return this.renderResult("false", ModuleUtils.ALLATORIxDEMO("\u5f02\u5271\u7219\u6710\u677b\u5f3c\u656f\u6b58\u52ce\u80c1\uff50"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", M.ALLATORIxDEMO("\u8fa0\u8876\u4e70\u6b1b\u6260\u52a5\uff71"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(a.ALLATORIxDEMO().get(ModuleUtils.ALLATORIxDEMO("7R\u001bS3"))).booleanValue()) {
            return this.renderResult("false", M.ALLATORIxDEMO("\u5f23\u5277\u7238\u6716\u675a\u5f3a\u654e\u6b5e\u52ef\u80c7\uff71"));
        }
        this.jobService.save(job);
        return this.renderResult("true", ModuleUtils.ALLATORIxDEMO("\u4f8c\u5b64\u6241\u52a3\uff50"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity jobEntity) {
        void job;
        JobController jobController = this;
        jobController.jobService.delete((JobEntity)job);
        return jobController.renderResult("true", M.ALLATORIxDEMO("\u5250\u965e\u6260\u52a5\uff71"));
    }
}

