/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service;

import com.jeesite.common.callback.MethodCallback;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.entity.Page;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mapper.JsonMapper;
import com.jeesite.common.network.IpUtils;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.shiro.realm.BaseAuthorizingRealm;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.msg.utils.MsgPushUtils;
import com.jeesite.modules.state.web.StateServerController;
import com.jeesite.modules.sys.dao.UserDao;
import com.jeesite.modules.sys.dao.UserDataScopeDao;
import com.jeesite.modules.sys.dao.UserRoleDao;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.entity.UserDataScope;
import com.jeesite.modules.sys.entity.UserRole;
import com.jeesite.modules.sys.service.a;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
@Transactional(readOnly=true)
public class UserService
extends CrudService<UserDao, User> {
    private static Pattern lowerCaseExp;
    private static Pattern specialExp;
    private static Pattern upperCaseExp;
    @Autowired
    private UserRoleDao userRoleDao;
    private static Pattern numberExp;
    @Autowired
    private UserDataScopeDao userDataScopeDao;

    @Override
    @Transactional(readOnly=false)
    public void save(User user) {
        if (user.getIsNewRecord()) {
            if (StringUtils.isBlank((CharSequence)user.getUserCode())) {
                User user2 = user;
                this.genId(user2, user2.getLoginCode());
            }
            if (((UserDao)this.dao).get(user) != null) {
                throw UserService.newValidationException(UserService.text(StateServerController.ALLATORIxDEMO("^n^9XdHe\u0003{BpDynxIrhoDdYd"), new String[0]));
            }
            String a2 = user.getPassword();
            if (StringUtils.isBlank((CharSequence)a2)) {
                a2 = Global.getConfig(MsgPushUtils.ALLATORIxDEMO("\u0010g\u00100\u0016m\u0006lMw\rw\u0017N\u0002m\u0010i\fl\u0007"));
            }
            User user3 = user;
            User user4 = user;
            user4.setPassword(UserService.encryptPassword(a2));
            user3.setPwdSecurityLevel(UserService.getPwdSecurityLevel(a2));
            User user5 = user;
            user4.setPwdUpdateDate(new Date());
            if (StringUtils.isBlank((CharSequence)user3.getUserType())) {
                user.setUserType("none");
            }
            if (StringUtils.isBlank((CharSequence)user.getMgrType())) {
                user.setMgrType("0");
            }
        }
        super.save(user);
        UserUtils.clearCache(user);
    }

    public List<User> findCorpList(User user) {
        return ((UserDao)this.dao).findCorpList(user);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        return BaseAuthorizingRealm.validatePassword(plainPassword, password);
    }

    @Override
    public User get(User user) {
        return super.get(user);
    }

    @Override
    public Page<User> findPage(Page<User> page, User user) {
        return super.findPage(page, user);
    }

    public List<User> findListByRoleCode(User user) {
        return ((UserDao)this.dao).findListByRoleCode(user);
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void updateUserInfo(User user) {
        a = user.getAvatarBase64();
        if (!StringUtils.isNotBlank((CharSequence)a)) ** GOTO lbl13
        if (StateServerController.ALLATORIxDEMO("R`GyN").equals(a)) {
            v0 = user;
            v1 = v0;
            v0.setAvatar("");
        } else {
            a = new StringBuilder().insert(0, MsgPushUtils.ALLATORIxDEMO("\u0002h\u0002j\u0002lL")).append(user.getCorpCode()).append(StateServerController.ALLATORIxDEMO("8")).append(user.getUserType()).append(MsgPushUtils.ALLATORIxDEMO("L")).append(user.getUserCode()).append(StateServerController.ALLATORIxDEMO("9")).append(FileUtils.getFileExtensionByImageBase64((String)a)).toString();
            FileUtils.writeToFileByImageBase64((String)Global.getUserfilesBaseDir(a), (String)a);
            user.setAvatar("/userfiles/" + a);
lbl13:
            // 2 sources

            v1 = user;
        }
        v1.preUpdate();
        ((UserDao)this.dao).updateUserInfo(user);
        UserUtils.clearCache(user);
    }

    public User getByLoginCode(User user) {
        return ((UserDao)this.dao).getByLoginCode(user);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void saveAuthDataScope(User user) {
        void a2;
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)user.getUserCode())) {
            return;
        }
        UserDataScope userDataScope = new UserDataScope();
        void v0 = a2;
        v0.setUserCode(user.getUserCode());
        v0.setCtrlPermi("2".equals(user.getMgrType()) ? "2" : "1");
        this.userDataScopeDao.deleteByEntity(a2);
        List<UserDataScope> a3 = user.getUserDataScopeList();
        Iterator<UserDataScope> iterator = a3.iterator();
        Iterator<UserDataScope> iterator2 = iterator;
        while (iterator2.hasNext()) {
            iterator.next().setCtrlPermi(a2.getCtrlPermi());
            iterator2 = iterator;
        }
        ListUtils.pageList(a3, (int)100, (MethodCallback)new a(this));
        UserUtils.clearCache(user);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void updatePassword(String userCode, String newPassword) {
        int a2;
        void a3;
        User a4 = UserUtils.get(userCode);
        if (a4 == null) {
            throw new ServiceException(new StringBuilder().insert(0, userCode).append(UserService.text(MsgPushUtils.ALLATORIxDEMO("m\u001amMk\u0010{\u00110\u0016m\u0006l q\u0007{-q\u0017[\u001bw\u0010j\u0010"), new String[0])).toString());
        }
        User user = new User();
        void v0 = a3;
        v0.setUserCode(a4.getUserCode());
        v0.setCorpCode(a4.getCorpCode_());
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            newPassword = Global.getConfig(StateServerController.ALLATORIxDEMO("dTd\u0003b^r_9DyDc}v^dZx_s"));
        }
        if ((a2 = UserService.getPwdSecurityLevel(newPassword)) != 0) {
            int a5 = ObjectUtils.toInteger((Object)Global.getConfig(MsgPushUtils.ALLATORIxDEMO("\u0010g\u00100\u0016m\u0006lMn\u0002m\u0010i\fl\u0007S\fz\nx\u001aP\fj1{\u0013{\u0002j-k\u000e"), "1"));
            List a6 = (List)JsonMapper.fromJson((String)a4.getPwdUpdateRecord(), List.class);
            if (a6 == null) {
                a6 = ListUtils.newArrayList();
                if (a4.getPwdUpdateDate() == null) {
                    a4.setPwdUpdateDate(new Date());
                }
                Object[] objectArray = new String[2];
                objectArray[0] = a4.getPassword();
                objectArray[1] = DateUtils.formatDateTime((Date)a4.getPwdUpdateDate());
                a6.add(ListUtils.newArrayList((Object[])objectArray));
            }
            for (List a7 : a6) {
                if (!UserService.validatePassword(newPassword, (String)a7.get(0))) continue;
                String[] stringArray = new String[1];
                stringArray[0] = String.valueOf(a5);
                throw new ServiceException(UserService.text(StateServerController.ALLATORIxDEMO("^n^9XdHe\u0003gLd^`BeIZBsDqTYBc\u007fr]rLc"), stringArray));
            }
            a3.setPassword(UserService.encryptPassword(newPassword));
            Object[] objectArray = new String[2];
            objectArray[0] = a3.getPassword();
            objectArray[1] = DateUtils.getDateTime();
            a6.add(ListUtils.newArrayList((Object[])objectArray));
            if (a6.size() > a5) {
                List list = a6;
                list.subList(0, list.size() - a5).clear();
            }
            a3.setPwdUpdateRecord(JsonMapper.toJson((Object)a6));
        } else {
            a3.setPassword(UserService.encryptPassword(newPassword));
            a3.setPwdUpdateRecord(a4.getPwdUpdateRecord());
        }
        Global.assertDemoMode();
        void v5 = a3;
        v5.setPwdSecurityLevel(a2);
        v5.setPwdUpdateDate(new Date());
        ((UserDao)this.dao).updatePassword((User)a3);
        UserUtils.clearCache((User)a3);
    }

    public User getByUserTypeAndRefCode(User user) {
        return ((UserDao)this.dao).getByUserTypeAndRefCode(user);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void updateUserLoginInfo(User user) {
        void user2;
        void v0 = user2;
        v0.setOldLastLoginIp(v0.getLastLoginIp());
        v0.setOldLastLoginDate(v0.getLastLoginDate());
        v0.setLastLoginIp(IpUtils.getRemoteAddr((HttpServletRequest)ServletUtils.getRequest()));
        void v1 = user2;
        v0.setLastLoginDate(new Date());
        ((UserDao)this.dao).updateLoginInfo((User)user2);
    }

    /*
     * Unable to fully structure code
     */
    public static String passwordModifyValid(User user, Model model) {
        a = null;
        a = Global.getConfig(MsgPushUtils.ALLATORIxDEMO("\u0010g\u00100\u0016m\u0006lMw\rw\u0017N\u0002m\u0010i\fl\u0007S\fz\nx\u001a"));
        if (!"0".equals(a) && (a = Boolean.valueOf(UserService.validatePassword(Global.getConfig(StateServerController.ALLATORIxDEMO("dTd\u0003b^r_9DyDc}v^dZx_s")), user.getPassword()))).booleanValue()) {
            a = UserService.text(MsgPushUtils.ALLATORIxDEMO("m\u001amMk\u0010{\u00110\np\nj3\u007f\u0010m\u0014q\u0011z.q\u0007w\u0005g7w\u0013"), new String[0]);
            if ("1".equals(a)) {
                model.addAttribute(StateServerController.ALLATORIxDEMO("zBsDqTGLd^`BeICDg"), (Object)a);
            } else if ("2".equals(a)) {
                a = a;
            }
        }
        a = Global.getConfig(MsgPushUtils.ALLATORIxDEMO("\u0010g\u00100\u0016m\u0006lMn\u0002m\u0010i\fl\u0007S\fz\nx\u001a"));
        if (a == null || "0".equals(a)) ** GOTO lbl36
        a = ObjectUtils.toInteger((Object)Global.getConfig(StateServerController.ALLATORIxDEMO("^n^9XdHe\u0003gLd^`BeIZBsDqTTTtAr")));
        v0 = a = user.getPwdUpdateDate() == null ? 0L : DateUtils.pastDays((Date)user.getPwdUpdateDate());
        if (user.getPwdUpdateDate() != null && a < (long)a) ** GOTO lbl36
        a = null;
        if (a == 0L) {
            a = UserService.text(MsgPushUtils.ALLATORIxDEMO("m\u001amMk\u0010{\u00110\np\nj3\u007f\u0010m\u0014q\u0011z.q\u0007w\u0005g7w\u0013"), new String[0]);
        } else {
            v1 = new String[1];
            v1[0] = String.valueOf(a);
            a = UserService.text(StateServerController.ALLATORIxDEMO("^n^9XdHe\u0003gLd^`BeIZBsDqTCDg"), v1);
        }
        if ("1".equals(a)) {
            v2 = a;
            model.addAttribute(MsgPushUtils.ALLATORIxDEMO("\u000eq\u0007w\u0005g3\u007f\u0010m\u0014q\u0011z7w\u0013"), (Object)a);
        } else {
            if ("2".equals(a)) {
                a = a;
            }
lbl36:
            // 5 sources

            v2 = a;
        }
        if (v2 != null) {
            return new StringBuilder().insert(0, Global.getAdminPath()).append(StateServerController.ALLATORIxDEMO("\u0002dTd\u0002b^r_8DyKx\u0012x]*]`I1XeA*")).append(Global.getAdminPath()).append(MsgPushUtils.ALLATORIxDEMO("Lw\rz\u0006fEs\u0010y^")).append(a).toString();
        }
        return null;
    }

    public List<UserDataScope> findDataScopeList(UserDataScope userDataScope) {
        return this.userDataScopeDao.findList(userDataScope);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateStatus(User user) {
        User user2 = user;
        super.updateStatus(user2);
        UserUtils.clearCache(user2);
    }

    public static String encryptPassword(String plainPassword) {
        return BaseAuthorizingRealm.encryptPassword(plainPassword);
    }

    @Override
    public List<User> findList(User user) {
        return super.findList(user);
    }

    private static /* synthetic */ int getPwdSecurityLevel(String newPassword) {
        int a2 = 0;
        if (!StringUtils.equals((CharSequence)newPassword, (CharSequence)Global.getConfig(StateServerController.ALLATORIxDEMO("dTd\u0003b^r_9DyDc}v^dZx_s")))) {
            int a3;
            int a4;
            int a5;
            int a6;
            int a7 = newPassword.length() >= 8 ? 1 : 0;
            int a8 = a7 + (a6 = upperCaseExp.matcher(newPassword).find() ? 1 : 0) + (a5 = lowerCaseExp.matcher(newPassword).find() ? 1 : 0) + (a4 = numberExp.matcher(newPassword).find() ? 1 : 0) + (a3 = specialExp.matcher(newPassword).find() ? 1 : 0);
            a2 = a8 == 0 ? 0 : (a8 == 1 ? 1 : (a8 == 2 ? 2 : (a8 == 3 || a8 == 4 ? 3 : 4)));
            int a9 = ObjectUtils.toInteger((Object)Global.getConfig(MsgPushUtils.ALLATORIxDEMO("m\u001amMk\u0010{\u00110\u0013\u007f\u0010m\u0014q\u0011z.q\u0007w\u0005g0{\u0000k\u0011w\u0017g/{\u0015{\u000f")));
            if (a9 > 0 && a9 > a2) {
                throw new ServiceException(UserService.text(StateServerController.ALLATORIxDEMO("^n^9XdHe\u0003gLd^`BeIZBsDqTDHtXeDcT[HaH{"), new String[0]));
            }
        }
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void saveAuth(User user) {
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)user.getUserCode())) {
            return;
        }
        UserRole a2 = new UserRole();
        a2.setUserCode(user.getUserCode());
        this.userRoleDao.deleteByEntity(a2);
        List<UserRole> a3 = user.getUserRoleList();
        if (!user.getCurrentUser().isAdmin()) {
            Iterator<void> iterator;
            void a4;
            List a5 = ListUtils.extractToList(a3, (String)MsgPushUtils.ALLATORIxDEMO("l\fr\u0006]\fz\u0006"), null, (boolean)true);
            UserDataScope userDataScope = new UserDataScope();
            List list = a5;
            void v1 = a4;
            a4.setUserCode(user.getCurrentUser().getUserCode());
            v1.setCtrlType(Role.class.getSimpleName());
            v1.setCtrlData_in(list.toArray(new String[list.size()]));
            a4.setCtrlPermi("2");
            List<void> list2 = this.userDataScopeDao.findList(a4);
            a3.clear();
            Iterator<void> iterator2 = iterator = list2.iterator();
            while (iterator2.hasNext()) {
                void a6;
                UserDataScope a7 = (UserDataScope)iterator.next();
                UserRole userRole = new UserRole();
                iterator2 = iterator;
                void v4 = a6;
                v4.setUserCode(user.getUserCode());
                v4.setRoleCode(a7.getCtrlData());
                a3.add((UserRole)v4);
            }
        } else {
            Iterator<UserRole> a5;
            Iterator<UserRole> iterator = a5 = a3.iterator();
            while (iterator.hasNext()) {
                void var4_5;
                UserRole a4 = (UserRole)var4_5.next();
                iterator = var4_5;
                a4.setUserCode(user.getUserCode());
            }
        }
        if (ListUtils.isNotEmpty(a3)) {
            this.userRoleDao.insertBatch(user.getUserRoleList());
        }
        UserUtils.clearCache(user);
    }

    static /* synthetic */ UserDataScopeDao access$000(UserService x0) {
        return x0.userDataScopeDao;
    }

    @Transactional(readOnly=false)
    public void updateQuestion(User user) {
        Global.assertDemoMode();
        user.setPwdQuestUpdateDate(new Date());
        ((UserDao)this.dao).updateQuestion(user);
        UserUtils.clearCache(user);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(User user) {
        User user2 = user;
        super.delete(user2);
        UserUtils.clearCache(user2);
    }

    static {
        upperCaseExp = Pattern.compile(StateServerController.ALLATORIxDEMO("Ll:wJ"));
        lowerCaseExp = Pattern.compile(MsgPushUtils.ALLATORIxDEMO("8\u007fNd>"));
        numberExp = Pattern.compile(StateServerController.ALLATORIxDEMO("L\u001d:\u0014J"));
        specialExp = Pattern.compile(MsgPushUtils.ALLATORIxDEMO("8`B^@:FB=8?4K7<5?e?cY<?b_ \\~?3^B8B>%?9?BOBM1>"));
    }

    public String checkLoginCode(String oldLoginCode, String loginCode) {
        User a2 = new User();
        String string = loginCode;
        a2.setLoginCode(string);
        if (string != null && loginCode.equals(oldLoginCode)) {
            return "true";
        }
        if (loginCode != null && this.getByLoginCode(a2) == null) {
            return "true";
        }
        return "false";
    }

    /*
     * WARNING - void declaration
     */
    @Transactional(readOnly=false)
    public void updateMgrType(User user) {
        void user2;
        user2.preUpdate();
        ((UserDao)this.dao).updateMgrType((User)user2);
        UserUtils.clearCache((User)user2);
    }
}

