/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.session;

import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.m.G;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.shiro.session.StaticSession;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.config.CoreConfig;
import com.jeesite.modules.sys.utils.CorpUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSessionDAO
extends CachingSessionDAO
implements SessionDAO {
    private Logger logger;

    public CacheSessionDAO() {
        CacheSessionDAO cacheSessionDAO = this;
        cacheSessionDAO.logger = LoggerFactory.getLogger(cacheSessionDAO.getClass());
    }

    protected Serializable doCreate(Session session) {
        Object a2;
        HttpServletRequest a3 = ServletUtils.getRequest();
        if (a3 != null && ServletUtils.isStaticFile((String)(a2 = a3.getRequestURI()))) {
            return null;
        }
        CacheSessionDAO cacheSessionDAO = this;
        a2 = cacheSessionDAO.generateSessionId(session);
        cacheSessionDAO.assignSessionId(session, (Serializable)a2);
        cacheSessionDAO.update(session);
        return a2;
    }

    public Collection<Session> getActiveSessions() {
        return super.getActiveSessions();
    }

    public void update(Session session) throws UnknownSessionException {
        this.doUpdate(session);
    }

    protected void doUpdate(Session session) {
        CacheSessionDAO cacheSessionDAO;
        if (session == null || session.getId() == null) {
            return;
        }
        if (session instanceof ValidatingSession) {
            if (((ValidatingSession)session).isValid()) {
                CacheSessionDAO cacheSessionDAO2 = this;
                cacheSessionDAO = cacheSessionDAO2;
                Session session2 = session;
                cacheSessionDAO2.cache(session2, session2.getId());
            } else {
                CacheSessionDAO cacheSessionDAO3 = this;
                cacheSessionDAO = cacheSessionDAO3;
                cacheSessionDAO3.uncache(session);
            }
        } else {
            CacheSessionDAO cacheSessionDAO4 = this;
            cacheSessionDAO = cacheSessionDAO4;
            Session session3 = session;
            cacheSessionDAO4.cache(session3, session3.getId());
        }
        cacheSessionDAO.logger.debug(CoreConfig.ALLATORIxDEMO("4F%W5SaM<\u0016"), (Object)session.getId());
    }

    public void delete(Session session) {
        this.doDelete(session);
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        return this.doReadSession(sessionId);
    }

    protected void doDelete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        CacheSessionDAO cacheSessionDAO = this;
        cacheSessionDAO.uncache(session);
        cacheSessionDAO.logger.debug(G.ALLATORIxDEMO("j\nb\nz\n.\u0014sO"), (Object)session.getId());
    }

    public Serializable create(Session session) {
        return this.doCreate(session);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean excludeLeave, boolean excludeVisitor) {
        return this.getActiveSessions(excludeLeave, excludeVisitor, null, null, null);
    }

    @Override
    public Collection<Session> getActiveSessions(boolean excludeLeave, boolean excludeVisitor, String excludeSessionId, String includeSessionId, String includeUserCode) {
        String a2 = null;
        if (Global.isUseCorpModel().booleanValue()) {
            a2 = CorpUtils.getCurrentCorpCode();
        }
        HashMap a3 = MapUtils.newHashMap();
        Iterator iterator = super.getActiveSessions().iterator();
        block0: while (true) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                LoginInfo a4;
                Session a5 = (Session)iterator.next();
                String a6 = a5.getId().toString();
                if ("1".equals(a6)) continue block0;
                if (a6.equals(excludeSessionId)) {
                    iterator2 = iterator;
                    continue;
                }
                if (excludeLeave && DateUtils.pastMinutes((Date)a5.getLastAccessTime()) > 3L) {
                    iterator2 = iterator;
                    continue;
                }
                PrincipalCollection a7 = (PrincipalCollection)a5.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                String a8 = "";
                String a9 = "";
                String a10 = "";
                LoginInfo loginInfo = a4 = a7 != null ? (LoginInfo)a7.getPrimaryPrincipal() : null;
                if (a4 != null) {
                    LoginInfo loginInfo2 = a4;
                    a8 = loginInfo2.getId();
                    a9 = loginInfo2.getParam(CoreConfig.ALLATORIxDEMO("\"Y3F\u0002Y%S"));
                    a10 = loginInfo2.getParam(G.ALLATORIxDEMO("j\nx\u0006m\nZ\u0016~\n"));
                }
                if (a2 != null && !StringUtils.equals((CharSequence)a2, (CharSequence)a9)) {
                    iterator2 = iterator;
                    continue;
                }
                if (excludeVisitor && StringUtils.isBlank((CharSequence)a8)) {
                    iterator2 = iterator;
                    continue;
                }
                boolean a11 = true;
                if (StringUtils.isNotBlank((CharSequence)includeSessionId) && !StringUtils.equals((CharSequence)includeSessionId, (CharSequence)a6)) {
                    a11 = false;
                }
                if (StringUtils.isNotBlank((CharSequence)includeUserCode) && !StringUtils.equals((CharSequence)includeUserCode, (CharSequence)a8)) {
                    a11 = false;
                }
                if (!a11) continue block0;
                Session a12 = (Session)a3.get(a8 + a10);
                if (a12 != null) {
                    if (a12.getLastAccessTime().getTime() <= a5.getLastAccessTime().getTime()) continue block0;
                    a3.put(new StringBuilder().insert(0, a8).append(a10).toString(), a5);
                    continue block0;
                }
                a3.put(new StringBuilder().insert(0, a8).append(a10).toString(), a5);
                continue block0;
            }
            break;
        }
        return a3.values();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Session doReadSession(Serializable sessionId) {
        try {
            String a2;
            Session a3 = null;
            HttpServletRequest a4 = ServletUtils.getRequest();
            if (a4 != null) {
                a2 = a4.getRequestURI();
                if (ServletUtils.isStaticFile((String)a2)) {
                    return StaticSession.INSTANCE;
                }
                a3 = (Session)a4.getAttribute(new StringBuilder().insert(0, CoreConfig.ALLATORIxDEMO("2S2E(Y/i")).append(sessionId).toString());
            }
            if (a3 != null) {
                return a3;
            }
            CacheSessionDAO cacheSessionDAO = this;
            a2 = cacheSessionDAO.getCachedSession(sessionId);
            cacheSessionDAO.logger.debug(G.ALLATORIxDEMO("\u001dk\u000ej<k\u001c}\u0006a\u0001.\u0014sOu\u0012"), (Object)sessionId, (Object)(a4 != null ? a4.getRequestURI() : ""));
            if (a4 != null && a2 != null) {
                a4.setAttribute(CoreConfig.ALLATORIxDEMO("2S2E(Y/i") + sessionId, (Object)a2);
            }
            return a2;
        }
        catch (UnknownSessionException a5) {
            return null;
        }
    }
}

