/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.m.u.B;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.config.CoreConfig;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import com.jeesite.modules.sys.utils.RoleUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity jobEntity) {
        void job;
        JobController jobController = this;
        jobController.jobService.delete((JobEntity)job);
        return jobController.renderResult("true", CoreConfig.ALLATORIxDEMO("\u5216\u9625\u6226\u52de\uff37"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(B.ALLATORIxDEMO().get(RoleUtils.ALLATORIxDEMO("\u0007>+?\u0003"))).booleanValue()) {
            return this.renderResult("false", CoreConfig.ALLATORIxDEMO("\u5f65\u520c\u727e\u676d\u671c\u5f41\u6508\u6b25\u52a9\u80bc\uff37"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", RoleUtils.ALLATORIxDEMO("\u500c\u6b03\u5bca\u6597\u5638\u5950\u8d75\uff60"));
        }
        return this.renderResult("true", CoreConfig.ALLATORIxDEMO("\u501d\u6b54\u5bdb\u65c0\u5629\u6226\u52de\uff37"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(JobEntity jobEntity, Model model) {
        void job;
        void model2;
        model2.addAttribute(RoleUtils.ALLATORIxDEMO("\u000b?\u0003\u0015\u000f$\b$\u0018"), (Object)job);
        return CoreConfig.ALLATORIxDEMO("[.R4Z$En\\.Tn\\.T\u0007Y3[");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(B.ALLATORIxDEMO().get(RoleUtils.ALLATORIxDEMO("\u0007>+?\u0003"))).booleanValue()) {
            return this.renderResult("false", CoreConfig.ALLATORIxDEMO("\u5f65\u520c\u727e\u676d\u671c\u5f41\u6508\u6b25\u52a9\u80bc\uff37"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", RoleUtils.ALLATORIxDEMO("\u8fb1\u881c\u4e61\u6b71\u6271\u52cf\uff60"));
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        List a2 = this.jobService.findList(job);
        a2 = ListUtils.listOrderBy(a2, (String)orderBy);
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a2;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(CoreConfig.ALLATORIxDEMO("_2d4X/_/Q"), (Object)a2);
        return RoleUtils.ALLATORIxDEMO("\f?\u0005%\r5\u0012\u007f\u000b?\u0003\u007f\u000b?\u0003\u001c\b#\u0015");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(B.ALLATORIxDEMO().get(CoreConfig.ALLATORIxDEMO("P/|.T"))).booleanValue()) {
            return this.renderResult("false", RoleUtils.ALLATORIxDEMO("\u5f32\u521d\u7229\u677c\u674b\u5f50\u655f\u6b34\u52fe\u80ad\uff60"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", CoreConfig.ALLATORIxDEMO("\u6054\u594c\u8fe6\u880d\u6226\u52de\uff37"));
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a2 = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a2 = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a2 != null) {
                throw new ValidationException(RoleUtils.ALLATORIxDEMO("\u546c\u79a0\u53ab\u7e94\u546c\u5da2\u7eae\u5b08\u5749"));
            }
        }
        if (a2 == null) {
            a2 = new JobEntity();
        }
        return a2;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(B.ALLATORIxDEMO().get(CoreConfig.ALLATORIxDEMO("P/|.T"))).booleanValue()) {
            return this.renderResult("false", RoleUtils.ALLATORIxDEMO("\u5f32\u521d\u7229\u677c\u674b\u5f50\u655f\u6b34\u52fe\u80ad\uff60"));
        }
        this.jobService.save(job);
        return this.renderResult("true", CoreConfig.ALLATORIxDEMO("\u4feb\u5b19\u6226\u52de\uff37"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(B.ALLATORIxDEMO().get(RoleUtils.ALLATORIxDEMO("\u0007>+?\u0003"))).booleanValue()) {
            return this.renderResult("false", CoreConfig.ALLATORIxDEMO("\u5f65\u520c\u727e\u676d\u671c\u5f41\u6508\u6b25\u52a9\u80bc\uff37"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", RoleUtils.ALLATORIxDEMO("\u547f\u52c9\u5bca\u6597\u5638\u5950\u8d75\uff60"));
        }
        return this.renderResult("true", CoreConfig.ALLATORIxDEMO("\u546e\u529e\u5bdb\u65c0\u5629\u6226\u52de\uff37"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(B.ALLATORIxDEMO().get(RoleUtils.ALLATORIxDEMO("\u0007>+?\u0003"))).booleanValue()) {
            return this.renderResult("false", CoreConfig.ALLATORIxDEMO("\u5f65\u520c\u727e\u676d\u671c\u5f41\u6508\u6b25\u52a9\u80bc\uff37"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", RoleUtils.ALLATORIxDEMO("\u66e3\u500c\u8fb1\u881c\u6271\u52cf\uff60"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a2 = new StringBuilder();
        try {
            void a3;
            CronExpression a4 = new CronExpression(cron);
            if (num <= 0) {
                a2.append(RoleUtils.ALLATORIxDEMO("\u0013\u0013?\u000f\u8838\u8fdf\u5f5f\u6b02\u783e\u3063"));
                return this.renderResult("true", a2.toString());
            }
            a2.append(CoreConfig.ALLATORIxDEMO("\n1\b\u6741\u8fe7") + num + RoleUtils.ALLATORIxDEMO("\u6b71\u8fb1\u881c\u6597\u95a4\uff7blN _"));
            Date a5 = new Date();
            boolean bl = false;
            void v0 = a3;
            while (v0 <= num) {
                if ((a5 = a4.getTimeAfter(a5)) == null) {
                    return this.renderResult("true", a2.toString());
                }
                a2.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a5)).append(CoreConfig.ALLATORIxDEMO("\nnT3\b")).toString());
                v0 = ++a3;
            }
            return this.renderResult("true", a2.toString());
        }
        catch (ParseException a6) {
            return this.renderResult("false", new StringBuilder().insert(0, CoreConfig.ALLATORIxDEMO("\u0002D.X\u8829\u8f88\u5f4e\u952f\u8bae\uff2c")).append(a6.getMessage()).toString());
        }
    }
}

