/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service;

import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.m.r.a;
import com.jeesite.common.service.TreeService;
import com.jeesite.modules.job.m.m;
import com.jeesite.modules.sys.dao.MenuDao;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MenuService
extends TreeService<MenuDao, Menu> {
    private static final String CACHE_MENU_NAME_PATH_MAP = "menuNamePathMap";

    @Override
    @Transactional(readOnly=false)
    public void delete(Menu entity) {
        MenuService menuService = this;
        super.delete(entity);
        menuService.clearMenuCache();
    }

    @Override
    protected void updateChildNode(Menu childEntity, Menu parentEntity) {
        Menu menu = childEntity;
        menu.setSysCode(parentEntity.getSysCode());
        menu.getSqlMap().updateTreeDataExtSql(m.ALLATORIxDEMO("\bS\bu\u0018E\u001fO[\u0017[\t\u0000Y\u0002Y8E\u001fO\u0006"));
        super.updateChildNode(childEntity, parentEntity);
    }

    @Override
    public Menu get(Menu menu) {
        return super.get(menu);
    }

    public List<Menu> findByRoleCode(Menu menu) {
        return ((MenuDao)this.dao).findByRoleCode(menu);
    }

    private /* synthetic */ void clearMenuCache() {
        UserUtils.removeCache("menuList");
        UserUtils.removeCache("authInfo");
        CacheUtils.remove(CACHE_MENU_NAME_PATH_MAP);
    }

    public List<Menu> findByUserCode(Menu menu) {
        return ((MenuDao)this.dao).findByUserCode(menu);
    }

    @Override
    public List<Menu> findList(Menu menu) {
        return super.findList(menu);
    }

    @Transactional(readOnly=false)
    public void disableByModuleCodes(String moduleCodes) {
        Menu a2 = new Menu();
        a2.setStatus("2");
        Menu a3 = new Menu();
        a3.setModuleCodes(moduleCodes);
        ((MenuDao)this.dao).updateStatusByEntity(a2, a3);
        this.clearMenuCache();
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Menu entity) {
        MenuService menuService = this;
        super.save(entity);
        menuService.clearMenuCache();
    }

    @Transactional(readOnly=false)
    public void enableByModuleCodes(String moduleCodes) {
        Menu a2 = new Menu();
        a2.setStatus("0");
        Menu a3 = new Menu();
        a3.setModuleCodes(moduleCodes);
        ((MenuDao)this.dao).updateStatusByEntity(a2, a3);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateTreeSort(Menu menu) {
        MenuService menuService = this;
        super.updateTreeSort(menu);
        menuService.clearMenuCache();
    }

    public String getMenuNamePath(String href, String permission) {
        Object object;
        Object a2;
        Map a3;
        block11: {
            String[] stringArray;
            a3 = (Map)CacheUtils.get(CACHE_MENU_NAME_PATH_MAP);
            if (a3 == null) {
                a3 = MapUtils.newLinkedHashMap();
                a2 = this.findList(new Menu());
                stringArray = a2.iterator();
                while (stringArray.hasNext()) {
                    int n;
                    Menu a4 = (Menu)stringArray.next();
                    String a5 = StringUtils.substringBefore((String)a4.getMenuHref(), (String)a.ALLATORIxDEMO("\u001f"));
                    if (StringUtils.isNotBlank((CharSequence)a5)) {
                        if (StringUtils.endsWith((CharSequence)a5, (CharSequence)m.ALLATORIxDEMO("T"))) {
                            String string = a5;
                            a5 = StringUtils.substring((String)string, (int)(string.length() - 1));
                        }
                        a3.put(a5, a4.getTreeNames());
                        a3.put(StringUtils.substringBeforeLast((String)a5, (String)a.ALLATORIxDEMO("\u000f")), a4.getTreeNames());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)a4.getPermission())) continue;
                    String[] stringArray2 = StringUtils.split((String)a4.getPermission(), (String)m.ALLATORIxDEMO("W"));
                    int n2 = stringArray2.length;
                    int n3 = n = 0;
                    while (n3 < n2) {
                        String a6 = stringArray2[n];
                        a3.put(a6, a4.getTreeNames());
                        a3.put(StringUtils.substringBeforeLast((String)a6, (String)a.ALLATORIxDEMO("\u001a")), StringUtils.substringBeforeLast((String)a4.getTreeNames(), (String)m.ALLATORIxDEMO("T")));
                        n3 = ++n;
                    }
                }
                CacheUtils.put(CACHE_MENU_NAME_PATH_MAP, a3);
            }
            if (StringUtils.endsWith((CharSequence)href, (CharSequence)a.ALLATORIxDEMO("\u000f"))) {
                String string = href;
                href = StringUtils.substring((String)string, (int)(string.length() - 1));
            }
            if ((a2 = (String)a3.get(href)) == null) {
                int n;
                stringArray = StringUtils.split((String)permission, (String)m.ALLATORIxDEMO("W"));
                int n4 = stringArray.length;
                int n5 = n = 0;
                while (n5 < n4) {
                    String a7 = stringArray[n];
                    a2 = (String)a3.get(a7);
                    if (StringUtils.isNotBlank((CharSequence)a2)) {
                        object = a2;
                        break block11;
                    }
                    n5 = ++n;
                }
            }
            object = a2;
        }
        if (object == null) {
            a2 = (String)a3.get(StringUtils.substringBeforeLast((String)href, (String)a.ALLATORIxDEMO("\u000f")));
        }
        if (a2 == null) {
            return "";
        }
        return a2;
    }
}

