/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.session;

import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.i.j.H;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.shiro.session.StaticSession;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.job.i.E;
import com.jeesite.modules.sys.utils.CorpUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSessionDAO
extends CachingSessionDAO
implements SessionDAO {
    private Logger logger;

    protected Serializable doCreate(Session session) {
        Object a;
        HttpServletRequest a2 = ServletUtils.getRequest();
        if (a2 != null && ServletUtils.isStaticFile((String)(a = a2.getRequestURI()))) {
            return null;
        }
        CacheSessionDAO cacheSessionDAO = this;
        a = cacheSessionDAO.generateSessionId(session);
        cacheSessionDAO.assignSessionId(session, (Serializable)a);
        cacheSessionDAO.update(session);
        return a;
    }

    public Session readSession(Serializable sessionId) throws UnknownSessionException {
        return this.doReadSession(sessionId);
    }

    protected void doDelete(Session session) {
        if (session == null || session.getId() == null) {
            return;
        }
        CacheSessionDAO cacheSessionDAO = this;
        cacheSessionDAO.uncache(session);
        cacheSessionDAO.logger.debug(E.ALLATORIxDEMO("\u0012a\u001aa\u0002aV\u007f\u000b$"), (Object)session.getId());
    }

    @Override
    public Collection<Session> getActiveSessions(boolean excludeLeave, boolean excludeVisitor, String excludeSessionId, String includeSessionId, String includeUserCode) {
        String a = null;
        if (Global.isUseCorpModel().booleanValue()) {
            a = CorpUtils.getCurrentCorpCode();
        }
        HashMap a2 = MapUtils.newHashMap();
        Iterator iterator = super.getActiveSessions().iterator();
        block0: while (true) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                LoginInfo a3;
                Session a4 = (Session)iterator.next();
                String a5 = a4.getId().toString();
                if ("1".equals(a5)) continue block0;
                if (a5.equals(excludeSessionId)) {
                    iterator2 = iterator;
                    continue;
                }
                if (excludeLeave && DateUtils.pastMinutes((Date)a4.getLastAccessTime()) > 3L) {
                    iterator2 = iterator;
                    continue;
                }
                PrincipalCollection a6 = (PrincipalCollection)a4.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                String a7 = "";
                String a8 = "";
                String a9 = "";
                LoginInfo loginInfo = a3 = a6 != null ? (LoginInfo)a6.getPrimaryPrincipal() : null;
                if (a3 != null) {
                    LoginInfo loginInfo2 = a3;
                    a7 = loginInfo2.getId();
                    a8 = loginInfo2.getParam(H.ALLATORIxDEMO("yVhIYV~\\"));
                    a9 = loginInfo2.getParam(E.ALLATORIxDEMO("\u0012a\u0000m\u0015a\"}\u0006a"));
                }
                if (a != null && !StringUtils.equals((CharSequence)a, (CharSequence)a8)) {
                    iterator2 = iterator;
                    continue;
                }
                if (excludeVisitor && StringUtils.isBlank((CharSequence)a7)) {
                    iterator2 = iterator;
                    continue;
                }
                boolean a10 = true;
                if (StringUtils.isNotBlank((CharSequence)includeSessionId) && !StringUtils.equals((CharSequence)includeSessionId, (CharSequence)a5)) {
                    a10 = false;
                }
                if (StringUtils.isNotBlank((CharSequence)includeUserCode) && !StringUtils.equals((CharSequence)includeUserCode, (CharSequence)a7)) {
                    a10 = false;
                }
                if (!a10) continue block0;
                Session a11 = (Session)a2.get(a7 + a9);
                if (a11 != null) {
                    if (a11.getLastAccessTime().getTime() <= a4.getLastAccessTime().getTime()) continue block0;
                    a2.put(new StringBuilder().insert(0, a7).append(a9).toString(), a4);
                    continue block0;
                }
                a2.put(new StringBuilder().insert(0, a7).append(a9).toString(), a4);
                continue block0;
            }
            break;
        }
        return a2.values();
    }

    public Collection<Session> getActiveSessions() {
        return super.getActiveSessions();
    }

    public void update(Session session) throws UnknownSessionException {
        this.doUpdate(session);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Session doReadSession(Serializable sessionId) {
        try {
            String a;
            Session a2 = null;
            HttpServletRequest a3 = ServletUtils.getRequest();
            if (a3 != null) {
                a = a3.getRequestURI();
                if (ServletUtils.isStaticFile((String)a)) {
                    return StaticSession.INSTANCE;
                }
                a2 = (Session)a3.getAttribute(new StringBuilder().insert(0, H.ALLATORIxDEMO("i\\iJsVtf")).append(sessionId).toString());
            }
            if (a2 != null) {
                return a2;
            }
            CacheSessionDAO cacheSessionDAO = this;
            a = cacheSessionDAO.getCachedSession(sessionId);
            cacheSessionDAO.logger.debug(E.ALLATORIxDEMO("v\u0013e\u0012W\u0013w\u0005m\u0019jV\u007f\u000b$\ry"), (Object)sessionId, (Object)(a3 != null ? a3.getRequestURI() : ""));
            if (a3 != null && a != null) {
                a3.setAttribute(H.ALLATORIxDEMO("i\\iJsVtf") + sessionId, (Object)a);
            }
            return a;
        }
        catch (UnknownSessionException a) {
            return null;
        }
    }

    @Override
    public Collection<Session> getActiveSessions(boolean excludeLeave, boolean excludeVisitor) {
        return this.getActiveSessions(excludeLeave, excludeVisitor, null, null, null);
    }

    public CacheSessionDAO() {
        CacheSessionDAO cacheSessionDAO = this;
        cacheSessionDAO.logger = LoggerFactory.getLogger(cacheSessionDAO.getClass());
    }

    protected void doUpdate(Session session) {
        CacheSessionDAO cacheSessionDAO;
        if (session == null || session.getId() == null) {
            return;
        }
        if (session instanceof ValidatingSession) {
            if (((ValidatingSession)session).isValid()) {
                CacheSessionDAO cacheSessionDAO2 = this;
                cacheSessionDAO = cacheSessionDAO2;
                Session session2 = session;
                cacheSessionDAO2.cache(session2, session2.getId());
            } else {
                CacheSessionDAO cacheSessionDAO3 = this;
                cacheSessionDAO = cacheSessionDAO3;
                cacheSessionDAO3.uncache(session);
            }
        } else {
            CacheSessionDAO cacheSessionDAO4 = this;
            cacheSessionDAO = cacheSessionDAO4;
            Session session3 = session;
            cacheSessionDAO4.cache(session3, session3.getId());
        }
        cacheSessionDAO.logger.debug(E.ALLATORIxDEMO("\u0003t\u0012e\u0002aV\u007f\u000b$"), (Object)session.getId());
    }

    public void delete(Session session) {
        this.doDelete(session);
    }

    public Serializable create(Session session) {
        return this.doCreate(session);
    }
}

