/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.service;

import com.beust.jcommander.internal.Lists;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.RoutingDataSource;
import com.jeesite.common.i.v.d;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.query.QueryTable;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.modules.file.entity.FileUploadParms;
import com.jeesite.modules.job.dao.JobDao;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.i.E;
import com.jeesite.modules.job.listener.JobDetalListener;
import com.jeesite.modules.job.listener.JobSchedulerListener;
import com.jeesite.modules.job.listener.JobTriggerListener;
import com.jeesite.modules.job.service.JobLogService;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"dbUpgrade"})
@Transactional(readOnly=true)
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobService
extends CrudService<JobDao, JobEntity> {
    @Autowired
    private RoutingDataSource dataSource;
    @Autowired
    private JobLogService jobLogService;
    private SchedulerFactoryBean scheduler;

    public boolean isRunning() {
        block3: {
            try {
                if (this.getScheduler().isInStandbyMode() || !this.getScheduler().isStarted()) break block3;
                return true;
            }
            catch (Exception a) {
                this.logger.error(QueryTable.ALLATORIxDEMO("\u83f1\u53fd\u5bdc\u65dd\u562e\u729d\u6047\u65dd\u5977\u8d0e\uff47"), (Throwable)a);
                return false;
            }
        }
        return false;
    }

    @Transactional(readOnly=false)
    public void pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(FileUploadParms.ALLATORIxDEMO("=P\u0011Q9"))).booleanValue()) {
            return;
        }
        job.setStatus("2");
        super.updateStatus(job);
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a2 = jobService.getScheduler().getTrigger(a);
            jobService.getScheduler().pauseJob(a2.getJobKey());
            jobService.getScheduler().pauseTrigger(a2.getKey());
            return;
        }
        catch (SchedulerException a) {
            throw new ServiceException(QueryTable.ALLATORIxDEMO("\u66c4\u5077\u8f96\u8867\u5977\u8d0e\uff47"), a);
        }
    }

    public boolean startAll() {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(FileUploadParms.ALLATORIxDEMO("=P\u0011Q9"))).booleanValue()) {
            return false;
        }
        try {
            JobService jobService = this;
            jobService.scheduler.setStartupDelay(0);
            jobService.scheduler.start();
        }
        catch (Exception a) {
            this.logger.error(QueryTable.ALLATORIxDEMO("\u5404\u52ee\u5bb1\u65b0\u5643\u5977\u8d0e\uff47"), (Throwable)a);
            return false;
        }
        return true;
    }

    @PostConstruct
    private /* synthetic */ void initialize() throws Exception {
        JobEntity a;
        if (Global.isTestProfileActive()) {
            return;
        }
        JobService jobService = this;
        jobService.scheduler = new SchedulerFactoryBean();
        jobService.scheduler.setAutoStartup(ObjectUtils.toBoolean((Object)Global.getProperty(FileUploadParms.ALLATORIxDEMO("1Q9\u0010:K/Q\bJ:L/K+"), "true")).booleanValue());
        jobService.scheduler.setStartupDelay(ObjectUtils.toInteger((Object)Global.getProperty(QueryTable.ALLATORIxDEMO("A)IhX2J4_3[\u0002N*J?"), FileUploadParms.ALLATORIxDEMO("\bk"))).intValue());
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(QueryTable.ALLATORIxDEMO(" E\fD$"))).booleanValue()) {
            this.scheduler.afterPropertiesSet();
            return;
        }
        JobService jobService2 = this;
        jobService2.scheduler.setQuartzProperties(E.ALLATORIxDEMO());
        JobService jobService3 = this;
        jobService2.scheduler.setDataSource((DataSource)((Object)jobService3.dataSource));
        jobService3.scheduler.afterPropertiesSet();
        if (jobService2.scheduler.isAutoStartup()) {
            this.scheduler.start();
        }
        JobEntity jobEntity = a = new JobEntity();
        jobEntity.setStatus("");
        for (JobEntity a2 : super.findList(jobEntity)) {
            if ("1".equals(a.getStatus())) {
                this.delete(a);
                continue;
            }
            try {
                this.save(a2, false);
            }
            catch (Exception a3) {
                this.logger.warn(a3.getMessage(), (Throwable)a3);
            }
        }
        try {
            ListenerManager a4;
            ListenerManager listenerManager = a4 = this.getScheduler().getListenerManager();
            a4.addJobListener((JobListener)new JobDetalListener(this.jobLogService));
            listenerManager.addTriggerListener((TriggerListener)new JobTriggerListener(this.jobLogService));
            a4.addSchedulerListener((SchedulerListener)new JobSchedulerListener(this.jobLogService));
            return;
        }
        catch (SchedulerException a5) {
            this.logger.error(FileUploadParms.ALLATORIxDEMO("\u4f07\u4e24\u768a\u5412\u4ed0\u4ec8\u5f59\u5e06\uff5a"), (Throwable)a5);
            return;
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler.getScheduler();
    }

    @Transactional(readOnly=false)
    public void resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(QueryTable.ALLATORIxDEMO(" E\fD$"))).booleanValue()) {
            return;
        }
        job.setStatus("0");
        super.updateStatus(job);
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a2 = jobService.getScheduler().getTrigger(a);
            jobService.getScheduler().resumeJob(a2.getJobKey());
            jobService.getScheduler().resumeTrigger(a2.getKey());
            return;
        }
        catch (SchedulerException a) {
            throw new ServiceException(FileUploadParms.ALLATORIxDEMO("\u6039\u5933\u8f8b\u8872\u596a\u8d1b\uff5a"), a);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(QueryTable.ALLATORIxDEMO(" E\fD$"))).booleanValue()) {
            return;
        }
        super.delete(job);
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            Trigger a2 = this.getScheduler().getTrigger(a);
            if (a2 != null) {
                JobService jobService = this;
                jobService.getScheduler().deleteJob(a2.getJobKey());
                jobService.getScheduler().unscheduleJob(a2.getKey());
                return;
            }
        }
        catch (SchedulerException a) {
            throw new ServiceException(FileUploadParms.ALLATORIxDEMO("\u527b\u965a\u596a\u8d1b\uff5a"), a);
        }
    }

    @Override
    public List<JobEntity> findList(JobEntity job) {
        List a = Lists.newArrayList();
        try {
            Scheduler a2 = this.getScheduler();
            Iterator iterator = a2.getTriggerGroupNames().iterator();
            while (iterator.hasNext()) {
                GroupMatcher a3 = GroupMatcher.groupEquals((String)((String)iterator.next()));
                for (TriggerKey a4 : a2.getTriggerKeys(a3)) {
                    Trigger a5 = a2.getTrigger(a4);
                    if (!(a5 instanceof CronTriggerImpl)) continue;
                    a.add(new JobEntity().convert(a2, (CronTriggerImpl)a5));
                }
            }
        }
        catch (Exception a6) {
            this.logger.error(QueryTable.ALLATORIxDEMO("\u67a3\u8bc9\u4ebd\u528a\u5251\u8843\u5977\u8d0e\uff47"), (Throwable)a6);
        }
        return a;
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void save(JobEntity job, boolean isSaveToDb) {
        block6: {
            block7: {
                if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(FileUploadParms.ALLATORIxDEMO("=P\u0011Q9"))).booleanValue()) {
                    return;
                }
                v0 = job;
                a = E.ALLATORIxDEMO(v0);
                a = E.ALLATORIxDEMO(v0, a);
                if (!isSaveToDb) break block6;
                if (!job.getIsNewRecord()) break block7;
                v1 = this;
                v2 = v1;
                super.insert(job);
                ** GOTO lbl17
            }
            super.update(job);
        }
        try {
            v2 = this;
lbl17:
            // 2 sources

            v2.getScheduler().addJob(a, true);
            v3 = this;
            if (this.getScheduler().getTrigger(a.getKey()) != null) {
                v3.getScheduler().rescheduleJob(a.getKey(), (Trigger)a);
            } else {
                v3.getScheduler().scheduleJob((Trigger)a);
            }
            if ("2".equals(job.getStatus())) {
                v4 = this;
                v4.getScheduler().pauseJob(a.getJobKey());
                v4.getScheduler().pauseTrigger(a.getKey());
                return;
            }
        }
        catch (Exception a) {
            throw new ServiceException(QueryTable.ALLATORIxDEMO("\u6dbd\u528b\u8be7\u5239\u4ebd\u528a\u5977\u8d0e\uff47"), a);
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void save(JobEntity job) {
        this.save(job, true);
    }

    @Override
    public JobEntity get(JobEntity job) {
        JobEntity a = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)job.getJobName()) && StringUtils.isNotBlank((CharSequence)job.getJobGroup())) {
                TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
                Trigger a3 = this.getScheduler().getTrigger(a2);
                if (a3 instanceof CronTriggerImpl) {
                    a = new JobEntity().convert(this.getScheduler(), (CronTriggerImpl)a3);
                }
            }
        }
        catch (SchedulerException a4) {
            this.logger.error(FileUploadParms.ALLATORIxDEMO("\u83ec\u53e8\u596a\u8d1b\uff5a"), (Throwable)a4);
        }
        return a;
    }

    @Transactional(readOnly=false)
    public void runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(QueryTable.ALLATORIxDEMO(" E\fD$"))).booleanValue()) {
            return;
        }
        try {
            TriggerKey a = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a2 = jobService.getScheduler().getTrigger(a);
            jobService.getScheduler().triggerJob(a2.getJobKey());
            return;
        }
        catch (SchedulerException a) {
            throw new ServiceException(FileUploadParms.ALLATORIxDEMO("\u8f8b\u8872\u4e5b\u6b1f\u596a\u8d1b\uff5a"), a);
        }
    }

    public boolean stopAll() {
        if (!ObjectUtils.toBoolean(d.ALLATORIxDEMO().get(QueryTable.ALLATORIxDEMO(" E\fD$"))).booleanValue()) {
            return false;
        }
        try {
            this.scheduler.stop();
        }
        catch (Exception a) {
            this.logger.error(FileUploadParms.ALLATORIxDEMO("\u5062\u6b39\u5ba4\u65ad\u5656\u596a\u8d1b\uff5a"), (Throwable)a);
            return false;
        }
        return true;
    }
}

