/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.modules.state.web.StateServerController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public class JedisUtils {
    private static JedisPool jedisPool;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectList(String key, List<Object> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            Iterator<Object> iterator;
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a3.del(key);
            }
            ArrayList a4 = ListUtils.newArrayList();
            Iterator<Object> iterator2 = iterator = value.iterator();
            while (iterator2.hasNext()) {
                Iterator<Object> iterator3 = iterator;
                iterator2 = iterator3;
                Object a5 = iterator3.next();
                a4.add(JedisUtils.toBytes(a5));
            }
            a2 = a3.rpush(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(StateServerController.b("t\fs&e\u0003b\ns%n\u001asI|\u0014'T'\u0012z"), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(BaseEntity.b("l\rk'}\u0002z\u000bk$v\u001bkHd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsObject(String key) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.exists(JedisUtils.getBytesKey(key));
            logger.debug(StateServerController.b("b\u0011n\u001as\u001aH\u000bm\fd\u001d'\u0012z"), (Object)key);
            return a2;
        }
        catch (Exception a4) {
            logger.warn(BaseEntity.b("z\u0010v\u001bk\u001bP\nu\r|\u001c?\u0013b"), (Object)key, (Object)a4);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long del(String key) {
        Jedis jedis;
        long a2;
        block7: {
            a2 = 0L;
            Jedis a3 = null;
            try {
                a3 = JedisUtils.getResource();
                if (a3.exists(key).booleanValue()) {
                    Jedis jedis2 = a3;
                    jedis = jedis2;
                    a2 = jedis2.del(key);
                    logger.debug(StateServerController.b("\rb\u0005'\u0012z"), (Object)key);
                    break block7;
                }
                logger.debug(BaseEntity.b("{\rsHd\u0015?\u0006p\u001c?\rg\u0001l\u001cl"), (Object)key);
                jedis = a3;
            }
            catch (Exception a4) {
                logger.warn(StateServerController.b("\rb\u0005'\u0012z"), (Object)key, (Object)a4);
                return a2;
            }
            finally {
                JedisUtils.returnResource(a3);
            }
        }
        JedisUtils.returnResource(jedis);
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mapPut(String key, Map<String, String> value) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.hmset(key, value);
            logger.debug(BaseEntity.b("\u0005~\u0018O\u001dkHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("\u0004f\u0019W\u001csI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static Object getObjectKey(byte[] key) {
        try {
            return ObjectUtils.toString((Object)key);
        }
        catch (UnsupportedOperationException a2) {
            try {
                return JedisUtils.toObject(key);
            }
            catch (UnsupportedOperationException a3) {
                a3.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMap(String key) {
        Map a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.hgetAll(key);
                logger.debug(BaseEntity.b("\u000fz\u001cR\toHd\u0015?U?\u0013b"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("\u000eb\u001dJ\bwI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setMap(String key, Map<String, String> value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a3.del(key);
            }
            a2 = a3.hmset(key, value);
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseEntity.b("\u001bz\u001cR\toHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("\u001ab\u001dJ\bwI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static byte[] toBytes(Object object) {
        return ObjectUtils.serializeFst((Object)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String mapObjectPut(String key, Map<String, Object> value) {
        String a2 = null;
        Jedis a3 = null;
        try {
            Iterator<Map.Entry<String, Object>> iterator;
            a3 = JedisUtils.getResource();
            HashMap a4 = MapUtils.newHashMap();
            Iterator<Map.Entry<String, Object>> iterator2 = iterator = value.entrySet().iterator();
            while (iterator2.hasNext()) {
                void a5;
                Map.Entry<String, Object> entry = iterator.next();
                iterator2 = iterator;
                a4.put(JedisUtils.getBytesKey(a5.getKey()), JedisUtils.toBytes(a5.getValue()));
            }
            a2 = a3.hmset(JedisUtils.getBytesKey(key), (Map)a4);
            logger.debug(BaseEntity.b("\u0005~\u0018P\nu\r|\u001cO\u001dkHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(StateServerController.b("\u0004f\u0019H\u000bm\fd\u001dW\u001csI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setList(String key, List<String> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a3.del(key);
            }
            a2 = a3.rpush(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseEntity.b("l\rk$v\u001bkHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("t\fs%n\u001asI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSet(String key, Set<String> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a3.del(key);
            }
            a2 = a3.sadd(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseEntity.b("\u001bz\u001cL\rkHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("\u001ab\u001dT\fsI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static Jedis getResource() throws JedisException {
        Jedis a2 = null;
        try {
            a2 = jedisPool.getResource();
            return a2;
        }
        catch (JedisException a3) {
            logger.warn(BaseEntity.b("\u000fz\u001cM\rl\u0007j\u001a|\r1"), (Throwable)a3);
            JedisUtils.returnResource(a2);
            throw a3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapRemove(String key, String mapKey) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            String[] stringArray = new String[1];
            stringArray[0] = mapKey;
            a2 = a3.hdel(key, stringArray);
            logger.debug(StateServerController.b("\u0004f\u0019U\fj\u0006q\f'\u0012zI'\u0012z"), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(BaseEntity.b("\u0005~\u0018M\rr\u0007i\r?\u0013bH?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String key) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.exists(key);
            logger.debug(StateServerController.b("b\u0011n\u001as\u001a'\u0012z"), (Object)key);
            return a2;
        }
        catch (Exception a4) {
            logger.warn(BaseEntity.b("z\u0010v\u001bk\u001b?\u0013b"), (Object)key, (Object)a4);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Set<Object> getObjectSet(String key) {
        HashSet a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                a2 = SetUtils.newHashSet();
                Set a4 = a3.smembers(JedisUtils.getBytesKey(key));
                Iterator iterator2 = iterator = a4.iterator();
                while (iterator2.hasNext()) {
                    void a5;
                    byte[] byArray = (byte[])iterator.next();
                    iterator2 = iterator;
                    a2.add(JedisUtils.toObject((byte[])a5));
                }
                logger.debug(StateServerController.b("\u000eb\u001dH\u000bm\fd\u001dT\fsI|\u0014'T'\u0012z"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a6;
            logger.warn(BaseEntity.b("\u000fz\u001cP\nu\r|\u001cL\rkHd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetObjectAdd(String key, Object ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            int n;
            a3 = JedisUtils.getResource();
            HashSet a4 = SetUtils.newHashSet();
            Object[] objectArray = value;
            int n2 = value.length;
            int n3 = n = 0;
            while (n3 < n2) {
                Object a5 = objectArray[n];
                a4.add(JedisUtils.toBytes(a5));
                n3 = ++n;
            }
            a2 = a3.rpush(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            logger.debug(StateServerController.b("t\fs:b\u001dH\u000bm\fd\u001dF\rcI|\u0014'T'\u0012z"), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(BaseEntity.b("l\rk;z\u001cP\nu\r|\u001c^\f{Hd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSet(String key) {
        Set a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.smembers(key);
                logger.debug(StateServerController.b("\u000eb\u001dT\fsI|\u0014'T'\u0012z"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(BaseEntity.b("\u000fz\u001cL\rkHd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getObjectMap(String key) {
        HashMap a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                a2 = MapUtils.newHashMap();
                Map a4 = a3.hgetAll(JedisUtils.getBytesKey(key));
                Iterator iterator2 = iterator = a4.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry a5 = iterator.next();
                    a2.put(ObjectUtils.toString(a5.getKey()), JedisUtils.toObject((byte[])a5.getValue()));
                    iterator2 = iterator;
                }
                logger.debug(StateServerController.b("\u000eb\u001dH\u000bm\fd\u001dJ\bwI|\u0014'T'\u0012z"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a6;
            logger.warn(BaseEntity.b("\u000fz\u001cP\nu\r|\u001cR\toHd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    static {
        logger = LoggerFactory.getLogger(JedisUtils.class);
        jedisPool = SpringUtils.getBean(JedisPool.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetAdd(String key, String ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.sadd(key, value);
            logger.debug(StateServerController.b("t\fs:b\u001dF\rcI|\u0014'T'\u0012z"), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(BaseEntity.b("l\rk;z\u001c^\f{Hd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.get(key);
                a2 = StringUtils.isNotBlank((CharSequence)a2) && !StateServerController.b("i\u0000k").equalsIgnoreCase(a2) ? a2 : null;
                logger.debug(BaseEntity.b("x\rkHd\u0015?U?\u0013b"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("`\fsI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.set(JedisUtils.getBytesKey(key), JedisUtils.toBytes(value));
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseEntity.b("l\rk'}\u0002z\u000bkHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("t\fs&e\u0003b\nsI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getList(String key) {
        List a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.lrange(key, 0L, -1L);
                logger.debug(BaseEntity.b("x\rk$v\u001bkHd\u0015?U?\u0013b"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("`\fs%n\u001asI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectSet(String key, Set<Object> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            Iterator<Object> iterator;
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a3.del(key);
            }
            HashSet a4 = SetUtils.newHashSet();
            Iterator<Object> iterator2 = iterator = value.iterator();
            while (iterator2.hasNext()) {
                Iterator<Object> iterator3 = iterator;
                iterator2 = iterator3;
                Object a5 = iterator3.next();
                a4.add(JedisUtils.toBytes(a5));
            }
            a2 = a3.sadd(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseEntity.b("\u001bz\u001cP\nu\r|\u001cL\rkHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(StateServerController.b("\u001ab\u001dH\u000bm\fd\u001dT\fsI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static Object toObject(byte[] bytes) {
        return ObjectUtils.unserializeFst((byte[])bytes);
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String set(String key, String value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.set(key, value);
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseEntity.b("l\rkHd\u0015?U?\u0013b"), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("t\fsI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String setObjectMap(String key, Map<String, Object> value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            Iterator<Map.Entry<String, Object>> iterator;
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a3.del(key);
            }
            HashMap a4 = MapUtils.newHashMap();
            Iterator<Map.Entry<String, Object>> iterator2 = iterator = value.entrySet().iterator();
            while (iterator2.hasNext()) {
                void a5;
                Map.Entry<String, Object> entry = iterator.next();
                iterator2 = iterator;
                a4.put(JedisUtils.getBytesKey(a5.getKey()), JedisUtils.toBytes(a5.getValue()));
            }
            a2 = a3.hmset(JedisUtils.getBytesKey(key), (Map)a4);
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseEntity.b("\u001bz\u001cP\nu\r|\u001cR\toHd\u0015?U?\u0013b"), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(StateServerController.b("\u001ab\u001dH\u000bm\fd\u001dJ\bwI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapObjectExists(String key, String mapKey) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.hexists(JedisUtils.getBytesKey(key), JedisUtils.getBytesKey(mapKey));
            logger.debug(BaseEntity.b("\u0005~\u0018P\nu\r|\u001cZ\u0010v\u001bk\u001b?\u0013bH?\u0013b"), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("\u0004f\u0019H\u000bm\fd\u001dB\u0011n\u001as\u001a'\u0012zI'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listAdd(String key, String ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.rpush(key, value);
            logger.debug(BaseEntity.b("s\u0001l\u001c^\f{Hd\u0015?U?\u0013b"), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(StateServerController.b("k\u0000t\u001dF\rcI|\u0014'T'\u0012z"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long delObject(String key) {
        Jedis jedis;
        long a2;
        block7: {
            a2 = 0L;
            Jedis a3 = null;
            try {
                a3 = JedisUtils.getResource();
                if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                    Jedis jedis2 = a3;
                    jedis = jedis2;
                    a2 = jedis2.del(JedisUtils.getBytesKey(key));
                    logger.debug(BaseEntity.b("\fz\u0004P\nu\r|\u001c?\u0013b"), (Object)key);
                    break block7;
                }
                logger.debug(StateServerController.b("c\fk&e\u0003b\nsI|\u0014'\u0007h\u001d'\f\u007f\u0000t\u001dt"), (Object)key);
                jedis = a3;
            }
            catch (Exception a4) {
                logger.warn(BaseEntity.b("\fz\u0004P\nu\r|\u001c?\u0013b"), (Object)key, (Object)a4);
                return a2;
            }
            finally {
                JedisUtils.returnResource(a3);
            }
        }
        JedisUtils.returnResource(jedis);
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listObjectAdd(String key, Object ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            int n;
            a3 = JedisUtils.getResource();
            ArrayList a4 = ListUtils.newArrayList();
            Object[] objectArray = value;
            int n2 = value.length;
            int n3 = n = 0;
            while (n3 < n2) {
                Object a5 = objectArray[n];
                a4.add(JedisUtils.toBytes(a5));
                n3 = ++n;
            }
            a2 = a3.rpush(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            logger.debug(StateServerController.b("k\u0000t\u001dH\u000bm\fd\u001dF\rcI|\u0014'T'\u0012z"), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(BaseEntity.b("s\u0001l\u001cP\nu\r|\u001c^\f{Hd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapObjectRemove(String key, String mapKey) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            byte[][] byArrayArray = new byte[1][];
            byArrayArray[0] = JedisUtils.getBytesKey(mapKey);
            a2 = a3.hdel(JedisUtils.getBytesKey(key), (byte[][])byArrayArray);
            logger.debug(StateServerController.b("\u0004f\u0019H\u000bm\fd\u001dU\fj\u0006q\f'\u0012zI'\u0012z"), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(BaseEntity.b("\u0005~\u0018P\nu\r|\u001cM\rr\u0007i\r?\u0013bH?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List<Object> getObjectList(String key) {
        ArrayList a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                List a4 = a3.lrange(JedisUtils.getBytesKey(key), 0L, -1L);
                a2 = ListUtils.newArrayList();
                Iterator iterator2 = iterator = a4.iterator();
                while (iterator2.hasNext()) {
                    void a5;
                    byte[] byArray = (byte[])iterator.next();
                    iterator2 = iterator;
                    a2.add(JedisUtils.toObject((byte[])a5));
                }
                logger.debug(StateServerController.b("`\fs&e\u0003b\ns%n\u001asI|\u0014'T'\u0012z"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a6;
            logger.warn(BaseEntity.b("x\rk'}\u0002z\u000bk$v\u001bkHd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static byte[] getBytesKey(Object key) {
        if (key instanceof String) {
            return StringUtils.getBytes((String)((String)key));
        }
        return JedisUtils.toBytes(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String key) {
        Object a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a2 = JedisUtils.toObject(a3.get(JedisUtils.getBytesKey(key)));
                logger.debug(StateServerController.b("`\fs&e\u0003b\nsI|\u0014'T'\u0012z"), (Object)key, a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(BaseEntity.b("x\rk'}\u0002z\u000bkHd\u0015?U?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapExists(String key, String mapKey) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.hexists(key, mapKey);
            logger.debug(StateServerController.b("\u0004f\u0019B\u0011n\u001as\u001a'\u0012zI'\u0012z"), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(BaseEntity.b("\u0005~\u0018Z\u0010v\u001bk\u001b?\u0013bH?\u0013b"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }
}

