/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.realm;

import com.beust.jcommander.internal.Maps;
import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.codec.Sha1Utils;
import com.jeesite.common.config.Global;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.E;
import com.jeesite.common.mybatis.mapper.provider.TreeSqlProvider;
import com.jeesite.common.shiro.authc.FormToken;
import com.jeesite.common.shiro.cas.CasCreateUser;
import com.jeesite.common.shiro.cas.CasOutHandler;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.ByteSource;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class BaseAuthorizingRealm
extends AuthorizingRealm {
    public static final int SALT_SIZE = 8;
    public static final String HASH_ALGORITHM = "SHA-1";
    private String casServerCallbackUrl;
    private SessionDAO sessionDAO;
    public static final int HASH_INTERATIONS = 1024;
    private String casServerUrl;
    private TicketValidator ticketValidator;
    private CasOutHandler casOutHandler;

    public void onLogoutSuccess(User logoutUser, HttpServletRequest request) {
    }

    public final boolean supports(AuthenticationToken token) {
        if (token != null && FormToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(FormToken.class);
            return true;
        }
        if (token != null && CasToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(CasToken.class);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) {
        Object a2;
        Object a3;
        FormToken formToken;
        HttpServletRequest a4 = ServletUtils.getRequest();
        if (this.casOutHandler.isLogoutRequest(a4)) {
            String a5 = CommonUtils.safeGetParameter((HttpServletRequest)a4, (String)"logoutRequest");
            BaseAuthorizingRealm baseAuthorizingRealm = this;
            User a6 = baseAuthorizingRealm.casOutHandler.destroySession(a4, a5);
            baseAuthorizingRealm.onLogoutSuccess(a6, a4);
            return null;
        }
        if (authcToken == null) {
            return null;
        }
        FormToken a7 = null;
        Map a8 = null;
        AuthenticationToken authenticationToken = authcToken;
        if (authcToken instanceof FormToken) {
            formToken = a7 = (FormToken)authenticationToken;
        } else {
            Assertion assertion;
            if (!(authenticationToken instanceof CasToken) || !ObjectUtils.toBoolean(E.b().get(CasOutHandler.b("[G~HN"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("NPN\u0007QFZ@S\u0007IPMLhGVGR^S"), new String[0])).toString());
            a3 = (CasToken)authcToken;
            a2 = (String)a3.getCredentials();
            if (this.ticketValidator == null) {
                this.ticketValidator = new Cas20ServiceTicketValidator(this.casServerUrl);
                ((Cas20ServiceTicketValidator)this.ticketValidator).setEncoding("UTF-8");
            }
            Object var7_11 = null;
            try {
                assertion = this.ticketValidator.validate((String)a2, this.casServerCallbackUrl);
            }
            catch (TicketValidationException a9) {
                return null;
            }
            AttributePrincipal attributePrincipal = a = assertion.getPrincipal();
            a3.setUserId(attributePrincipal.getName());
            a8 = attributePrincipal.getAttributes();
            a7 = new FormToken();
            a7.setUsername(a.getName());
            Map a10 = Maps.newHashMap();
            FormToken formToken2 = a7;
            a10.put("ticket", a2);
            formToken = formToken2;
            formToken2.setParams(a10);
        }
        if (StringUtils.isBlank((CharSequence)formToken.getUsername())) {
            throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("ZDZ\u0013ERNTG\u0013H^JR\\S]tZ\u007fE\\GV"), new String[0])).toString());
        }
        if (StringUtils.isBlank((CharSequence)a7.getSsoToken()) && !(authcToken instanceof CasToken)) {
            a3 = (String)(a7.getParams() == null ? null : a7.getParams().get(TreeSqlProvider.b("J5X9M5z)^5")));
            if (BaseAuthorizingRealm.isValidCodeLogin(a7.getUsername(), (String)a3, CasOutHandler.b("KHQ@Y"))) {
                a2 = UserUtils.getSession();
                String string = (String)a2.getAttribute((Object)"validCode");
                if (a7.getCaptcha() == null || !a7.getCaptcha().toUpperCase().equals(string)) {
                    throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("ZDZ\u0013ERNTG\u0013_\\ETM~FYLx[OFO"), new String[0])).toString());
                }
                a2.removeAttribute((Object)"validCode");
            }
        }
        if (!E.b(a4)) {
            throw new AuthenticationException(TreeSqlProvider.b("C#Ij\u7655\u5f05\u591f\u8d75\uff22\u8ba7\u807a\u7cab\u7b8f\u7456\u5476\u83e7\u53f8\u8be8\u53c1\uff51"));
        }
        a3 = UserUtils.getByLoginCode(a7.getUsername());
        if (a3 != null) {
            return this.newAuthenticationInfo((User)a3, a7);
        }
        if (!(authcToken instanceof CasToken)) return null;
        if (!ObjectUtils.toBoolean(a8.get(CasOutHandler.b("TZ|EQFJjQ@XGIjOL\\]X|NLO"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, CasOutHandler.b("DNN\u0007\u7501\u620a\t\u2021")).append(a7.getUsername()).append(TreeSqlProvider.b("\u204d\u000e\u5778\u6702\u7cab\u7ef1\u4e7d\u4e23\u5b08\u5706|\u000e\u8ba7\u807a\u7cab\u7b8f\u7456\u5476~")).toString());
        Object object = a3 = new User(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(TreeSqlProvider.b("[#K\"m?J5")))));
        Map map = a8;
        Object object2 = a3;
        Map map2 = a8;
        Object object3 = a3;
        Map map3 = a8;
        Object object4 = a3;
        ((User)object4).setLoginCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(CasOutHandler.b("QFZ@SjRMX")))));
        ((User)object4).setPassword(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(TreeSqlProvider.b("^1]#Y?\\4")))));
        ((User)a3).setUserName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get(CasOutHandler.b("\\NLOg\\DX")))));
        ((User)object3).setEmail(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get("email"))));
        ((User)object3).setMobile(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(TreeSqlProvider.b("C?L9B5")))));
        ((User)a3).setPhone(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(CasOutHandler.b("MARGX")))));
        ((User)object2).setUserType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(TreeSqlProvider.b("[#K\"z)^5")))));
        ((User)object2).setRefCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(CasOutHandler.b("OL[jRMX")))));
        ((User)a3).setRefName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(TreeSqlProvider.b("\"K6`1C5")))));
        ((User)object).setMgrType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(CasOutHandler.b("PNO}DYX")))));
        ((DataEntity)object).setStatus(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(TreeSqlProvider.b("]$O$[#")))));
        if ("employee".equals(((User)a3).getUserType())) {
            try {
                this.casCreateEmpUser((User)a3, a8);
            }
            catch (ValidationException a11) {
                throw new AuthenticationException(new StringBuilder().insert(0, CasOutHandler.b("DNN\u0007")).append(a11.getMessage()).toString());
            }
            a3 = UserUtils.getByLoginCode(a7.getUsername());
            if (a3 == null) return null;
            return this.newAuthenticationInfo((User)a3, a7);
        }
        try {
            a2 = SpringUtils.getBean(CasCreateUser.class);
            if (a2 == null) return null;
            a2.createUser((User)a3, a8);
            return null;
        }
        catch (NoSuchBeanDefinitionException a12) {
            throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij\u7506\u6267\u000e\u204c")).append(a7.getUsername()).append(CasOutHandler.b("\u2020\u0005\u001d\u7c52\u57b6\t\u2021")).append(((User)a3).getUserType()).append(TreeSqlProvider.b("\u204d\u000e\u5778\u6702\u7cab\u7ef1\u4e7d\u4e23\u5b08\u5706|\u000e\u8ba7\u807a\u7cab\u7b8f\u7456\u5476~")).toString());
        }
    }

    public void setCasServerUrl(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    protected abstract void casCreateEmpUser(User var1, Map<String, Object> var2);

    /*
     * WARNING - void declaration
     */
    protected final boolean isPermitted(Permission permission, AuthorizationInfo info) {
        try {
            String a2 = StringUtils.substringBefore((String)permission.toString(), (String)CasOutHandler.b("\u0007"));
            if (a2 != null) {
                void a3;
                String string = (String)E.b().get(TreeSqlProvider.b("=A4[<K#"));
                if (StringUtils.contains((CharSequence)a3, (CharSequence)(CasOutHandler.b("\u0011") + a2 + TreeSqlProvider.b("|"))) && !StringUtils.contains((CharSequence)((String)E.b().get(CasOutHandler.b("RYXGpFY\\QLN"))), (CharSequence)new StringBuilder().insert(0, TreeSqlProvider.b("|")).append(a2).append(CasOutHandler.b("\u0011")).toString())) {
                    throw new RuntimeException(new StringBuilder().insert(0, TreeSqlProvider.b("\u000b")).append(a2).append(CasOutHandler.b("t\u6a1c\u577e\u6c9c\u6720\u63b5\u676a\uff3c")).toString());
                }
            }
        }
        catch (Exception a4) {
            throw new UnauthorizedException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(a4.getMessage()).toString());
        }
        return super.isPermitted(permission, info);
    }

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    /*
     * WARNING - void declaration
     */
    protected final AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Serializable a22;
        Object a3;
        String a4;
        Object a5;
        void a6;
        LoginInfo a7 = (LoginInfo)this.getAvailablePrincipal(principals);
        String a8 = a7.getParam(CasOutHandler.b("MX_TJX}DYX"));
        if (StringUtils.isNotBlank((CharSequence)a8)) {
            long a9 = ObjectUtils.toLong((Object)Global.getProperty(TreeSqlProvider.b("]5]#G?@~]5]#G?@\u0004G=K?[$")));
            long a10 = ObjectUtils.toLong((Object)Global.getProperty(new StringBuilder().insert(0, CasOutHandler.b("ZXZN@RG\u0013")).append(a8).append(TreeSqlProvider.b("}5]#G?@\u0004G=K?[$")).toString()));
            UserUtils.getSession().setTimeout(a10 > 0L ? a10 : a9);
        }
        HttpServletRequest a11 = ServletUtils.getRequest();
        String string = a7.getParam("ticket");
        this.casOutHandler.recordSession(a11, (String)a6);
        if (!ObjectUtils.toBoolean((Object)Global.getConfig(CasOutHandler.b("NAT[R\u0007TZ|EQFJdHEI@|MY[qFZ@S"), "true")).booleanValue() && (a5 = this.sessionDAO.getActiveSessions(false, true, a4 = UserUtils.getSession().getId().toString(), null, a7.getId())).size() > 0) {
            if (UserUtils.getSubject().isAuthenticated()) {
                Iterator iterator = a5.iterator();
                while (iterator.hasNext()) {
                    a3 = (Session)iterator.next();
                    PrincipalCollection a12 = (PrincipalCollection)a3.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                    a22 = a12 != null ? (LoginInfo)a12.getPrimaryPrincipal() : null;
                    if (a22 == null || !StringUtils.equals((CharSequence)((LoginInfo)a22).getParam(TreeSqlProvider.b("J5X9M5z)^5")), (CharSequence)a7.getParam(CasOutHandler.b("MX_TJX}DYX")))) continue;
                    this.sessionDAO.delete((Session)a3);
                }
            } else {
                UserUtils.getSubject().logout();
                throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("ZU@OF\u0013DHEI@|MY[pLNZ\\NX"), new String[0])).toString());
            }
        }
        if ((a = UserUtils.get(a7.getId())) == null) {
            return null;
        }
        a5 = UserUtils.getSession();
        Session session = a5;
        a5.setAttribute((Object)TreeSqlProvider.b("[#K\"m?J5"), (Object)a.getUserCode());
        session.setAttribute((Object)CasOutHandler.b("\\NLOg\\DX"), (Object)a.getUserName());
        session.setAttribute((Object)TreeSqlProvider.b("[#K\"z)^5"), (Object)a.getUserType());
        SimpleAuthorizationInfo a13 = new SimpleAuthorizationInfo();
        a3 = UserUtils.getMenuList();
        for (Serializable a22 : a3) {
            int n;
            if (!StringUtils.isNotBlank((CharSequence)((Menu)a22).getPermission())) continue;
            String[] stringArray = StringUtils.split((String)((Menu)a22).getPermission(), (String)CasOutHandler.b("\u0011"));
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                void a14;
                String string2 = stringArray[n];
                a13.addStringPermission((String)a14);
                n3 = ++n;
            }
        }
        a13.addStringPermission(TreeSqlProvider.b("[#K\""));
        Iterator<DataEntity> iterator = a.getRoleList().iterator();
        Iterator<DataEntity> iterator2 = iterator;
        while (iterator2.hasNext()) {
            a22 = (Role)iterator.next();
            iterator2 = iterator;
            a13.addRole(((Role)a22).getRoleCode());
        }
        return a13;
    }

    public void setCasServerCallbackUrl(String casServerCallbackUrl) {
        this.casServerCallbackUrl = casServerCallbackUrl;
    }

    public static boolean isValidCodeLogin(String loginCode, String deviceType, String operation) {
        String a2;
        int a222;
        String a3;
        Long[] a4;
        Map a5 = (Map)CacheUtils.get(CasOutHandler.b("ERNTG{HTEXMpHM"));
        if (a5 == null) {
            a5 = Maps.newHashMap();
            CacheUtils.put(TreeSqlProvider.b("B?I9@\u0016O9B5J\u001dO "), a5);
        }
        if ((a4 = (Long[])a5.get(a3 = loginCode)) == null) {
            Long[] longArray = new Long[2];
            longArray[0] = 0L;
            longArray[1] = 0L;
            a4 = longArray;
        }
        Long a6 = a4[0];
        Long a7 = a4[1];
        if (CasOutHandler.b("KHQ@Y").equals(operation)) {
            if (a7 != 0L) {
                a222 = ObjectUtils.toInteger((Object)Global.getConfig(TreeSqlProvider.b("])]~B?I9@~H1G<K4`%C\u0011H$K\"b?M;c9@%Z5"), CasOutHandler.b("\u001b\r")));
                if (System.currentTimeMillis() / 60000L - a7 <= (long)a222) {
                    String[] stringArray = new String[1];
                    stringArray[0] = String.valueOf(a222);
                    throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("NPN\u0007QFZ@S\u0007[HTEXMs\\PeRJV"), stringArray)).toString());
                }
                Long[] longArray = new Long[2];
                longArray[0] = a6;
                longArray[1] = 0L;
                a5.put(a3, longArray);
            }
        } else if (TreeSqlProvider.b("H1G<K4").equals(operation)) {
            Long a222 = a6;
            Long l2 = a6 = Long.valueOf(a222 + 1L);
            a222 = ObjectUtils.toInteger((Object)Global.getConfig(CasOutHandler.b("NPN\u0007QFZ@S\u0007[HTEXMs\\Ph[]X[qF^B|J^FHGI"), TreeSqlProvider.b("b\u001e`")));
            if (a6 >= (long)a222) {
                a7 = System.currentTimeMillis() / 60000L;
            }
            Long[] longArray = new Long[2];
            longArray[0] = a6;
            longArray[1] = a7;
            a5.put(a3, longArray);
        } else if (CasOutHandler.b("N\\^JXZN").equals(operation)) {
            a5.remove(a3);
        }
        a222 = ObjectUtils.toInteger((Object)Global.getConfig(TreeSqlProvider.b("#W#\u0000<A7G>\u00006O9B5J\u001e[=o6Z5\\\u0006O<G4m?J5"), CasOutHandler.b("\f\u0019\r")));
        if (StringUtils.isNotBlank((CharSequence)deviceType) && StringUtils.isNotBlank((CharSequence)(a2 = Global.getConfig(new StringBuilder().insert(0, TreeSqlProvider.b("])]~B?I9@~H1G<K4`%C\u0011H$K\"x1B9J\u0013A4K~")).append(deviceType).toString())))) {
            a222 = ObjectUtils.toInteger((Object)a2);
        }
        return a6 >= (long)a222;
    }

    public void setCasOutHandler(CasOutHandler casOutHandler) {
        this.casOutHandler = casOutHandler;
    }

    public void onLoginSuccess(PrincipalCollection principals) {
    }

    public static boolean validatePassword(String plainPassword, String password) {
        try {
            String string = EncodeUtils.decodeHtml((String)plainPassword);
            byte[] a2 = EncodeUtils.decodeHex((String)password.substring(0, 16));
            byte[] a3 = Sha1Utils.sha1((byte[])string.getBytes(), (byte[])a2, (int)1024);
            return password.equals(EncodeUtils.encodeHex((byte[])a2) + EncodeUtils.encodeHex((byte[])a3));
        }
        catch (Exception a4) {
            return false;
        }
    }

    protected final void assertCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) throws AuthenticationException {
        if (authcToken instanceof FormToken) {
            FormToken a2 = (FormToken)authcToken;
            if (StringUtils.isNotBlank((CharSequence)a2.getSsoToken())) {
                FormToken formToken = a2;
                String a3 = UserUtils.getSsoToken(formToken.getUsername());
                if (StringUtils.equals((CharSequence)formToken.getSsoToken(), (CharSequence)a3)) {
                    return;
                }
                throw new IncorrectCredentialsException(CasOutHandler.b("PZZ\u0013\u63b5\u676a\u4ed9\u7265\u9524\u8bc6\uff31\u8bde\u51b0\u8bfc\u4e3d\u6b08\u622b\u807d\u7cc6\u7b88\u743b\u5471\u303f"));
            }
            super.assertCredentialsMatch((AuthenticationToken)a2, info);
            return;
        }
        if (authcToken instanceof CasToken) {
            return;
        }
        throw new IncorrectCredentialsException(new StringBuilder().insert(0, TreeSqlProvider.b("=]7\u0014\u4e5d\u6501\u6351\u76aa\u63d8\u676d\u4eb4\u7262\u7c2b\u57a5\uff4a")).append(authcToken).toString());
    }

    protected final AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            return null;
        }
        AuthorizationInfo a2 = null;
        a2 = (AuthorizationInfo)UserUtils.getCache("authInfo");
        if (a2 == null && (a2 = this.doGetAuthorizationInfo(principals)) != null) {
            UserUtils.putCache("authInfo", a2);
        }
        return a2;
    }

    private final /* synthetic */ SimpleAuthenticationInfo newAuthenticationInfo(User user, FormToken token) {
        int a2;
        if (Global.isUseCorpModel().booleanValue()) {
            token.getParams().put(CasOutHandler.b("JR[MjRMX"), user.getCorpCode_());
        }
        if (StringUtils.equals((CharSequence)((CharSequence)E.b().get(TreeSqlProvider.b("Z)^5"))), (CharSequence)"0") && !user.isAdmin() && (a2 = this.sessionDAO.getActiveSessions(true, true).size()) >= 10) {
            throw new AuthenticationException(CasOutHandler.b("DNN\u0007\u7652\u5f68\u5918\u8d18\uff25\u6095\u76ad\u5f6e\u5264\u7646\u5f7c\u4e87\u6559\u5dcf\u8dac\u8ffa\u9679\u520b\uff25\u8bca\u807d\u7cc6\u7b88\u743b\u5471\uff3c"));
        }
        if (!"0".equals(user.getStatus())) {
            if ("2".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("NPN\u0007QFZ@S\u0007\\J^FHGImTZ\\KQLY"), new String[0])).toString());
            }
            if ("3".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("ZDZ\u0013ERNTG\u0013H^JR\\S]{[XLGLY"), new String[0])).toString());
            }
            if ("4".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("ZDZ\u0013ERNTG\u0013H^JR\\S]|\\Y@ILY"), new String[0])).toString());
            }
            throw new AuthenticationException(new StringBuilder().insert(0, TreeSqlProvider.b("C#Ij")).append(Global.getText(CasOutHandler.b("ZDZ\u0013ERNTG\u0013H^JR\\S]tGKHQ@Y"), new String[0])).toString());
        }
        byte[] a22 = EncodeUtils.decodeHex((String)user.getPassword().substring(0, 16));
        return new SimpleAuthenticationInfo((Object)new LoginInfo(user, token.getParams()), (Object)user.getPassword().substring(16), ByteSource.Util.bytes((byte[])a22), this.getName());
    }

    public static String encryptPassword(String plainPassword) {
        String a2 = EncodeUtils.decodeHtml((String)plainPassword);
        byte[] a3 = Sha1Utils.genSalt((int)8);
        byte[] a4 = Sha1Utils.sha1((byte[])a2.getBytes(), (byte[])a3, (int)1024);
        return new StringBuilder().insert(0, EncodeUtils.encodeHex((byte[])a3)).append(EncodeUtils.encodeHex((byte[])a4)).toString();
    }

    public BaseAuthorizingRealm() {
        BaseAuthorizingRealm baseAuthorizingRealm = this;
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher(HASH_ALGORITHM);
        hashedCredentialsMatcher.setHashIterations(1024);
        baseAuthorizingRealm.setCredentialsMatcher((CredentialsMatcher)hashedCredentialsMatcher);
    }
}

