/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.realm;

import com.beust.jcommander.internal.Maps;
import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.codec.Sha1Utils;
import com.jeesite.common.config.Global;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.H;
import com.jeesite.common.shiro.authc.FormToken;
import com.jeesite.common.shiro.cas.CasCreateUser;
import com.jeesite.common.shiro.cas.CasOutHandler;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.config.DataSourceConfig;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.ByteSource;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class BaseAuthorizingRealm
extends AuthorizingRealm {
    public static final int HASH_INTERATIONS = 1024;
    private TicketValidator ticketValidator;
    private SessionDAO sessionDAO;
    public static final int SALT_SIZE = 8;
    public static final String HASH_ALGORITHM = "SHA-1";
    private String casServerCallbackUrl;
    private CasOutHandler casOutHandler;
    private String casServerUrl;

    public BaseAuthorizingRealm() {
        BaseAuthorizingRealm baseAuthorizingRealm = this;
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher(HASH_ALGORITHM);
        hashedCredentialsMatcher.setHashIterations(1024);
        baseAuthorizingRealm.setCredentialsMatcher((CredentialsMatcher)hashedCredentialsMatcher);
    }

    public static String encryptPassword(String plainPassword) {
        String a2 = EncodeUtils.decodeHtml((String)plainPassword);
        byte[] a3 = Sha1Utils.genSalt((int)8);
        byte[] a4 = Sha1Utils.sha1((byte[])a2.getBytes(), (byte[])a3, (int)1024);
        return new StringBuilder().insert(0, EncodeUtils.encodeHex((byte[])a3)).append(EncodeUtils.encodeHex((byte[])a4)).toString();
    }

    public static boolean validatePassword(String plainPassword, String password) {
        try {
            String string = EncodeUtils.decodeHtml((String)plainPassword);
            byte[] a2 = EncodeUtils.decodeHex((String)password.substring(0, 16));
            byte[] a3 = Sha1Utils.sha1((byte[])string.getBytes(), (byte[])a2, (int)1024);
            return password.equals(EncodeUtils.encodeHex((byte[])a2) + EncodeUtils.encodeHex((byte[])a3));
        }
        catch (Exception a4) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Serializable a22;
        Object a3;
        String a4;
        Object a5;
        void a6;
        LoginInfo a7 = (LoginInfo)this.getAvailablePrincipal(principals);
        String a8 = a7.getParam(Page.true("\u000f\u0005\u001d\t\b\u0005?\u0019\u001b\u0005"));
        if (StringUtils.isNotBlank((CharSequence)a8)) {
            long a9 = ObjectUtils.toLong((Object)Global.getProperty(DataSourceConfig.true("\u001d\u000f\u001d\u0019\u0007\u0005\u0000D\u001d\u000f\u001d\u0019\u0007\u0005\u0000>\u0007\u0007\u000b\u0005\u001b\u001e")));
            long a10 = ObjectUtils.toLong((Object)Global.getProperty(new StringBuilder().insert(0, Page.true("\u0018\u0005\u0018\u0013\u0002\u000f\u0005N")).append(a8).append(DataSourceConfig.true("=\u000f\u001d\u0019\u0007\u0005\u0000>\u0007\u0007\u000b\u0005\u001b\u001e")).toString()));
            UserUtils.getSession().setTimeout(a10 > 0L ? a10 : a9);
        }
        HttpServletRequest a11 = ServletUtils.getRequest();
        String string = a7.getParam("ticket");
        this.casOutHandler.recordSession(a11, (String)a6);
        if (!ObjectUtils.toBoolean((Object)Global.getConfig(Page.true("\u0013\u0003\t\u0019\u000fE\t\u0018!\u0007\f\u0004\u0017&\u0015\u0007\u0014\u0002!\u000f\u0004\u0019,\u0004\u0007\u0002\u000e"), "true")).booleanValue() && (a5 = this.sessionDAO.getActiveSessions(false, true, a4 = UserUtils.getSession().getId().toString(), null, a7.getId())).size() > 0) {
            if (UserUtils.getSubject().isAuthenticated()) {
                Iterator iterator = a5.iterator();
                while (iterator.hasNext()) {
                    a3 = (Session)iterator.next();
                    PrincipalCollection a12 = (PrincipalCollection)a3.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                    a22 = a12 != null ? (LoginInfo)a12.getPrimaryPrincipal() : null;
                    if (a22 == null || !StringUtils.equals((CharSequence)((LoginInfo)a22).getParam(DataSourceConfig.true("\n\u000f\u0018\u0003\r\u000f:\u0013\u001e\u000f")), (CharSequence)a7.getParam(Page.true("\u000f\u0005\u001d\t\b\u0005?\u0019\u001b\u0005")))) continue;
                    this.sessionDAO.delete((Session)a3);
                }
            } else {
                UserUtils.getSubject().logout();
                throw new AuthenticationException(new StringBuilder().insert(0, DataSourceConfig.true("\u0003\u0019\tP")).append(Global.getText(Page.true("\u0018\b\u0002\u0012\u0004N\u0006\u0015\u0007\u0014\u0002!\u000f\u0004\u0019-\u000e\u0013\u0018\u0001\f\u0005"), new String[0])).toString());
            }
        }
        if ((a = UserUtils.get(a7.getId())) == null) {
            return null;
        }
        a5 = UserUtils.getSession();
        Session session = a5;
        a5.setAttribute((Object)DataSourceConfig.true("\u001b\u0019\u000b\u0018-\u0005\n\u000f"), (Object)a.getUserCode());
        session.setAttribute((Object)Page.true("\u001e\u0013\u000e\u0012%\u0001\u0006\u0005"), (Object)a.getUserName());
        session.setAttribute((Object)DataSourceConfig.true("\u001b\u0019\u000b\u0018:\u0013\u001e\u000f"), (Object)a.getUserType());
        SimpleAuthorizationInfo a13 = new SimpleAuthorizationInfo();
        a3 = UserUtils.getMenuList();
        for (Serializable a22 : a3) {
            int n;
            if (!StringUtils.isNotBlank((CharSequence)((Menu)a22).getPermission())) continue;
            String[] stringArray = StringUtils.split((String)((Menu)a22).getPermission(), (String)Page.true("L"));
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                void a14;
                String string2 = stringArray[n];
                a13.addStringPermission((String)a14);
                n3 = ++n;
            }
        }
        a13.addStringPermission(DataSourceConfig.true("\u001b\u0019\u000b\u0018"));
        Iterator<DataEntity> iterator = a.getRoleList().iterator();
        Iterator<DataEntity> iterator2 = iterator;
        while (iterator2.hasNext()) {
            a22 = (Role)iterator.next();
            iterator2 = iterator;
            a13.addRole(((Role)a22).getRoleCode());
        }
        return a13;
    }

    private final /* synthetic */ SimpleAuthenticationInfo newAuthenticationInfo(User user, FormToken token) {
        int a2;
        if (Global.isUseCorpModel().booleanValue()) {
            token.getParams().put(Page.true("\b\u000f\u0019\u0010(\u000f\u000f\u0005"), user.getCorpCode_());
        }
        if (StringUtils.equals((CharSequence)((CharSequence)H.true().get(DataSourceConfig.true("\u001a\u0013\u001e\u000f"))), (CharSequence)"0") && !user.isAdmin() && (a2 = this.sessionDAO.getActiveSessions(true, true).size()) >= 10) {
            throw new AuthenticationException(Page.true("\u0006\u0013\fZ\u7610\u5f35\u595a\u8d45\uff67\u60c8\u76ef\u5f33\u5226\u761b\u5f3e\u4eda\u651b\u5d92\u8dee\u8fa7\u963b\u5256\uff67\u8b97\u803f\u7c9b\u7bca\u7466\u5433\uff61"));
        }
        if (!"0".equals(user.getStatus())) {
            if ("2".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, DataSourceConfig.true("\u0003\u0019\tP")).append(Global.getText(Page.true("\u0013\u0012\u0013E\f\u0004\u0007\u0002\u000eE\u0001\b\u0003\u0004\u0015\u0005\u0014/\t\u0018\u0001\t\f\u000e\u0004"), new String[0])).toString());
            }
            if ("3".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, DataSourceConfig.true("\u0003\u0019\tP")).append(Global.getText(Page.true("\u0018\u0019\u0018N\u0007\u000f\f\t\u0005N\n\u0003\b\u000f\u001e\u000e\u001f&\u0019\u0005\u000e\u001a\u000e\u0004"), new String[0])).toString());
            }
            if ("4".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, DataSourceConfig.true("\u0003\u0019\tP")).append(Global.getText(Page.true("\u0018\u0019\u0018N\u0007\u000f\f\t\u0005N\n\u0003\b\u000f\u001e\u000e\u001f!\u001e\u0004\u0002\u0014\u000e\u0004"), new String[0])).toString());
            }
            throw new AuthenticationException(new StringBuilder().insert(0, DataSourceConfig.true("\u0003\u0019\tP")).append(Global.getText(Page.true("\u0018\u0019\u0018N\u0007\u000f\f\t\u0005N\n\u0003\b\u000f\u001e\u000e\u001f)\u0005\u0016\n\f\u0002\u0004"), new String[0])).toString());
        }
        byte[] a22 = EncodeUtils.decodeHex((String)user.getPassword().substring(0, 16));
        return new SimpleAuthenticationInfo((Object)new LoginInfo(user, token.getParams()), (Object)user.getPassword().substring(16), ByteSource.Util.bytes((byte[])a22), this.getName());
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean isPermitted(Permission permission, AuthorizationInfo info) {
        try {
            String a2 = StringUtils.substringBefore((String)permission.toString(), (String)DataSourceConfig.true("P"));
            if (a2 != null) {
                void a3;
                String string = (String)H.true().get(Page.true("\r\u0004\u0004\u001e\f\u000e\u0013"));
                if (StringUtils.contains((CharSequence)a3, (CharSequence)(DataSourceConfig.true("F") + a2 + Page.true("L"))) && !StringUtils.contains((CharSequence)((String)H.true().get(DataSourceConfig.true("\u0005\u001e\u000f\u0000'\u0001\u000e\u001b\u0006\u000b\u0019"))), (CharSequence)new StringBuilder().insert(0, Page.true("L")).append(a2).append(DataSourceConfig.true("F")).toString())) {
                    throw new RuntimeException(new StringBuilder().insert(0, Page.true(";")).append(a2).append(DataSourceConfig.true("3\u6a4b\u5739\u6ccb\u6767\u63e2\u672d\uff6b")).toString());
                }
            }
        }
        catch (Exception a4) {
            throw new UnauthorizedException(new StringBuilder().insert(0, Page.true("\u0006\u0013\fZ")).append(a4.getMessage()).toString());
        }
        return super.isPermitted(permission, info);
    }

    protected abstract void casCreateEmpUser(User var1, Map<String, Object> var2);

    protected final AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            return null;
        }
        AuthorizationInfo a2 = null;
        a2 = (AuthorizationInfo)UserUtils.getCache("authInfo");
        if (a2 == null && (a2 = this.doGetAuthorizationInfo(principals)) != null) {
            UserUtils.putCache("authInfo", a2);
        }
        return a2;
    }

    public void setCasOutHandler(CasOutHandler casOutHandler) {
        this.casOutHandler = casOutHandler;
    }

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) {
        Object a2;
        Object a3;
        FormToken formToken;
        HttpServletRequest a4 = ServletUtils.getRequest();
        if (this.casOutHandler.isLogoutRequest(a4)) {
            String a5 = CommonUtils.safeGetParameter((HttpServletRequest)a4, (String)"logoutRequest");
            BaseAuthorizingRealm baseAuthorizingRealm = this;
            User a6 = baseAuthorizingRealm.casOutHandler.destroySession(a4, a5);
            baseAuthorizingRealm.onLogoutSuccess(a6, a4);
            return null;
        }
        if (authcToken == null) {
            return null;
        }
        FormToken a7 = null;
        Map a8 = null;
        AuthenticationToken authenticationToken = authcToken;
        if (authcToken instanceof FormToken) {
            formToken = a7 = (FormToken)authenticationToken;
        } else {
            Assertion assertion;
            if (!(authenticationToken instanceof CasToken) || !ObjectUtils.toBoolean(H.true().get(DataSourceConfig.true("\f\u0000)\u000f\u0019"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, Page.true("\u0006\u0013\fZ")).append(Global.getText(DataSourceConfig.true("\u0019\u0017\u0019@\u0006\u0001\r\u0007\u0004@\u001e\u0017\u001a\u000b?\u0000\u0001\u0000\u0005\u0019\u0004"), new String[0])).toString());
            a3 = (CasToken)authcToken;
            a2 = (String)a3.getCredentials();
            if (this.ticketValidator == null) {
                this.ticketValidator = new Cas20ServiceTicketValidator(this.casServerUrl);
                ((Cas20ServiceTicketValidator)this.ticketValidator).setEncoding("UTF-8");
            }
            Object var7_11 = null;
            try {
                assertion = this.ticketValidator.validate((String)a2, this.casServerCallbackUrl);
            }
            catch (TicketValidationException a9) {
                return null;
            }
            AttributePrincipal attributePrincipal = a = assertion.getPrincipal();
            a3.setUserId(attributePrincipal.getName());
            a8 = attributePrincipal.getAttributes();
            a7 = new FormToken();
            a7.setUsername(a.getName());
            Map a10 = Maps.newHashMap();
            FormToken formToken2 = a7;
            a10.put("ticket", a2);
            formToken = formToken2;
            formToken2.setParams(a10);
        }
        if (StringUtils.isBlank((CharSequence)formToken.getUsername())) {
            throw new AuthenticationException(new StringBuilder().insert(0, Page.true("\u0006\u0013\fZ")).append(Global.getText(DataSourceConfig.true("\u001d\u0013\u001dD\u0002\u0005\t\u0003\u0000D\u000f\t\r\u0005\u001b\u0004\u001a#\u001d(\u0002\u000b\u0000\u0001"), new String[0])).toString());
        }
        if (StringUtils.isBlank((CharSequence)a7.getSsoToken()) && !(authcToken instanceof CasToken)) {
            a3 = (String)(a7.getParams() == null ? null : a7.getParams().get(Page.true("\u000f\u0005\u001d\t\b\u0005?\u0019\u001b\u0005")));
            if (BaseAuthorizingRealm.isValidCodeLogin(a7.getUsername(), (String)a3, DataSourceConfig.true("\u001c\u000f\u0006\u0007\u000e"))) {
                a2 = UserUtils.getSession();
                String string = (String)a2.getAttribute((Object)"validCode");
                if (a7.getCaptcha() == null || !a7.getCaptcha().toUpperCase().equals(string)) {
                    throw new AuthenticationException(new StringBuilder().insert(0, Page.true("\u0006\u0013\fZ")).append(Global.getText(DataSourceConfig.true("\u001d\u0013\u001dD\u0002\u0005\t\u0003\u0000D\u0018\u000b\u0002\u0003\n)\u0001\u000e\u000b/\u001c\u0018\u0001\u0018"), new String[0])).toString());
                }
                a2.removeAttribute((Object)"validCode");
            }
        }
        if (!H.true(a4)) {
            throw new AuthenticationException(Page.true("\u0006\u0013\fZ\u7610\u5f35\u595a\u8d45\uff67\u8b97\u803f\u7c9b\u7bca\u7466\u5433\u83d7\u53bd\u8bd8\u5384\uff61"));
        }
        a3 = UserUtils.getByLoginCode(a7.getUsername());
        if (a3 != null) {
            return this.newAuthenticationInfo((User)a3, a7);
        }
        if (!(authcToken instanceof CasToken)) return null;
        if (!ObjectUtils.toBoolean(a8.get(DataSourceConfig.true("\u0003\u001d+\u0002\u0006\u0001\u001d-\u0006\u0007\u000f\u0000\u001e-\u0018\u000b\u000b\u001a\u000f;\u0019\u000b\u0018"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, DataSourceConfig.true("\u0003\u0019\tP\u7546\u625dN\u2076")).append(a7.getUsername()).append(Page.true("\u207dK\u5748\u6747\u7c9b\u7eb4\u4e4d\u4e66\u5b38\u5743LK\u8b97\u803f\u7c9b\u7bca\u7466\u5433N")).toString());
        Object object = a3 = new User(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.true("\u001e\u0013\u000e\u0012(\u000f\u000f\u0005")))));
        Map map = a8;
        Object object2 = a3;
        Map map2 = a8;
        Object object3 = a3;
        Map map3 = a8;
        Object object4 = a3;
        ((User)object4).setLoginCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(DataSourceConfig.true("\u0006\u0001\r\u0007\u0004-\u0005\n\u000f")))));
        ((User)object4).setPassword(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.true("\u001b\u0001\u0018\u0013\u001c\u000f\u0019\u0004")))));
        ((User)a3).setUserName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get(DataSourceConfig.true("\u001b\u0019\u000b\u0018 \u000b\u0003\u000f")))));
        ((User)object3).setEmail(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get("email"))));
        ((User)object3).setMobile(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.true("\u0006\u000f\t\t\u0007\u0005")))));
        ((User)a3).setPhone(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(DataSourceConfig.true("\u001a\u0006\u0005\u0000\u000f")))));
        ((User)object2).setUserType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(Page.true("\u001e\u0013\u000e\u0012?\u0019\u001b\u0005")))));
        ((User)object2).setRefCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(DataSourceConfig.true("\u0018\u000b\f-\u0005\n\u000f")))));
        ((User)a3).setRefName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(Page.true("\u0012\u000e\u0006%\u0001\u0006\u0005")))));
        ((User)object).setMgrType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(DataSourceConfig.true("\u0007\t\u0018:\u0013\u001e\u000f")))));
        ((DataEntity)object).setStatus(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.true("\u0018\u0014\n\u0014\u001e\u0013")))));
        if ("employee".equals(((User)a3).getUserType())) {
            try {
                this.casCreateEmpUser((User)a3, a8);
            }
            catch (ValidationException a11) {
                throw new AuthenticationException(new StringBuilder().insert(0, DataSourceConfig.true("\u0003\u0019\tP")).append(a11.getMessage()).toString());
            }
            a3 = UserUtils.getByLoginCode(a7.getUsername());
            if (a3 == null) return null;
            return this.newAuthenticationInfo((User)a3, a7);
        }
        try {
            a2 = SpringUtils.getBean(CasCreateUser.class);
            if (a2 == null) return null;
            a2.createUser((User)a3, a8);
            return null;
        }
        catch (NoSuchBeanDefinitionException a12) {
            throw new AuthenticationException(new StringBuilder().insert(0, Page.true("\u0006\u0013\fZ\u7543\u6257K\u207c")).append(a7.getUsername()).append(DataSourceConfig.true("\u2077BJ\u7c15\u57e1N\u2076")).append(((User)a3).getUserType()).append(Page.true("\u207dK\u5748\u6747\u7c9b\u7eb4\u4e4d\u4e66\u5b38\u5743LK\u8b97\u803f\u7c9b\u7bca\u7466\u5433N")).toString());
        }
    }

    public void setCasServerUrl(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    public static boolean isValidCodeLogin(String loginCode, String deviceType, String operation) {
        String a2;
        int a222;
        String a3;
        Long[] a4;
        Map a5 = (Map)CacheUtils.get(DataSourceConfig.true("\u0002\u0005\t\u0003\u0000,\u000f\u0003\u0002\u000f\n'\u000f\u001a"));
        if (a5 == null) {
            a5 = Maps.newHashMap();
            CacheUtils.put(Page.true("\u0007\u000f\f\t\u0005&\n\t\u0007\u0005\u000f-\n\u0010"), a5);
        }
        if ((a4 = (Long[])a5.get(a3 = loginCode)) == null) {
            Long[] longArray = new Long[2];
            longArray[0] = 0L;
            longArray[1] = 0L;
            a4 = longArray;
        }
        Long a6 = a4[0];
        Long a7 = a4[1];
        if (DataSourceConfig.true("\u001c\u000f\u0006\u0007\u000e").equals(operation)) {
            if (a7 != 0L) {
                a222 = ObjectUtils.toInteger((Object)Global.getConfig(Page.true("\u0018\u0019\u0018N\u0007\u000f\f\t\u0005N\r\u0001\u0002\f\u000e\u0004%\u0015\u0006!\r\u0014\u000e\u0012'\u000f\b\u000b&\t\u0005\u0015\u001f\u0005"), DataSourceConfig.true("\\Z")));
                if (System.currentTimeMillis() / 60000L - a7 <= (long)a222) {
                    String[] stringArray = new String[1];
                    stringArray[0] = String.valueOf(a222);
                    throw new AuthenticationException(new StringBuilder().insert(0, Page.true("\u0006\u0013\fZ")).append(Global.getText(DataSourceConfig.true("\u0019\u0017\u0019@\u0006\u0001\r\u0007\u0004@\f\u000f\u0003\u0002\u000f\n$\u001b\u0007\"\u0005\r\u0001"), stringArray)).toString());
                }
                Long[] longArray = new Long[2];
                longArray[0] = a6;
                longArray[1] = 0L;
                a5.put(a3, longArray);
            }
        } else if (Page.true("\r\u0001\u0002\f\u000e\u0004").equals(operation)) {
            Long a222 = a6;
            Long l2 = a6 = Long.valueOf(a222 + 1L);
            a222 = ObjectUtils.toInteger((Object)Global.getConfig(DataSourceConfig.true("\u0019\u0017\u0019@\u0006\u0001\r\u0007\u0004@\f\u000f\u0003\u0002\u000f\n$\u001b\u0007/\f\u001a\u000f\u001c&\u0001\t\u0005+\r\t\u0001\u001f\u0000\u001e"), Page.true("R[P")));
            if (a6 >= (long)a222) {
                a7 = System.currentTimeMillis() / 60000L;
            }
            Long[] longArray = new Long[2];
            longArray[0] = a6;
            longArray[1] = a7;
            a5.put(a3, longArray);
        } else if (DataSourceConfig.true("\u0019\u001b\t\r\u000f\u001d\u0019").equals(operation)) {
            a5.remove(a3);
        }
        a222 = ObjectUtils.toInteger((Object)Global.getConfig(Page.true("\u0013\u0012\u0013E\f\u0004\u0007\u0002\u000eE\u0006\n\t\u0007\u0005\u000f.\u001e\r*\u0006\u001f\u0005\u00196\n\f\u0002\u0004(\u000f\u000f\u0005"), DataSourceConfig.true("[^Z")));
        if (StringUtils.isNotBlank((CharSequence)deviceType) && StringUtils.isNotBlank((CharSequence)(a2 = Global.getConfig(new StringBuilder().insert(0, Page.true("\u0018\u0019\u0018N\u0007\u000f\f\t\u0005N\r\u0001\u0002\f\u000e\u0004%\u0015\u0006!\r\u0014\u000e\u0012=\u0001\u0007\t\u000f#\u0004\u0004\u000eN")).append(deviceType).toString())))) {
            a222 = ObjectUtils.toInteger((Object)a2);
        }
        return a6 >= (long)a222;
    }

    protected final void assertCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) throws AuthenticationException {
        if (authcToken instanceof FormToken) {
            FormToken a2 = (FormToken)authcToken;
            if (StringUtils.isNotBlank((CharSequence)a2.getSsoToken())) {
                FormToken formToken = a2;
                String a3 = UserUtils.getSsoToken(formToken.getUsername());
                if (StringUtils.equals((CharSequence)formToken.getSsoToken(), (CharSequence)a3)) {
                    return;
                }
                throw new IncorrectCredentialsException(DataSourceConfig.true("\u0007\u001d\rT\u63e2\u672d\u4e8e\u7222\u9573\u8b81\uff66\u8b99\u51e7\u8bbb\u4e6a\u6b4f\u627c\u803a\u7c91\u7bcf\u746c\u5436\u3068"));
            }
            super.assertCredentialsMatch((AuthenticationToken)a2, info);
            return;
        }
        if (authcToken instanceof CasToken) {
            return;
        }
        throw new IncorrectCredentialsException(new StringBuilder().insert(0, Page.true("\r\u0018\u0007Q\u4e6d\u6544\u6361\u76ef\u63e8\u6728\u4e84\u7227\u7c1b\u57e0\uff7a")).append(authcToken).toString());
    }

    public final boolean supports(AuthenticationToken token) {
        if (token != null && FormToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(FormToken.class);
            return true;
        }
        if (token != null && CasToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(CasToken.class);
            return true;
        }
        return false;
    }

    public void onLoginSuccess(PrincipalCollection principals) {
    }

    public void onLogoutSuccess(User logoutUser, HttpServletRequest request) {
    }

    public void setCasServerCallbackUrl(String casServerCallbackUrl) {
        this.casServerCallbackUrl = casServerCallbackUrl;
    }
}

