/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.session;

import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.network.IpUtils;
import com.jeesite.common.shiro.session.StaticSession;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.file.entity.FileUploadParms;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
extends DefaultWebSessionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSessionManager.class);

    public long getTimeout(SessionKey key) {
        try {
            return super.getTimeout(key);
        }
        catch (InvalidSessionException a2) {
            return 0L;
        }
    }

    protected Session newSessionInstance(SessionContext context) {
        Session a2 = super.newSessionInstance(context);
        if (a2 instanceof SimpleSession) {
            ((SimpleSession)a2).setHost(IpUtils.getRemoteAddr((HttpServletRequest)ServletUtils.getRequest()));
        }
        return a2;
    }

    public void validateSessions() {
        super.validateSessions();
    }

    public Object getAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.getAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    public Session start(SessionContext context) {
        try {
            return super.start(context);
        }
        catch (Exception a2) {
            return StaticSession.INSTANCE;
        }
    }

    private /* synthetic */ String getSessionIdCookieValue(ServletRequest request, ServletResponse response) {
        if (!this.isSessionIdCookieEnabled()) {
            log.debug(FileUploadParms.true("Vlvzlfk)LM%jjfn``)lz%mlzdkila)()vlvzlfk)lm%~lei)kfq)gl%hfxp`wla)c{jd%h%{`xplv}%jjfn``'"));
            return null;
        }
        if (!(request instanceof HttpServletRequest)) {
            log.debug(BaseEntity.true("L/}(j4{z}?~/j){zf)/4`./;azG.{*\\?},c?{\bj+z?|./w/9n4a5{zh?{z|?|)f5azF\u001e/9`5d3jt/z]?{/}4f4hza/c6!"));
            return null;
        }
        HttpServletRequest a2 = (HttpServletRequest)request;
        return this.getSessionIdCookie().readValue(a2, WebUtils.toHttp((ServletResponse)response));
    }

    public Object removeAttribute(SessionKey sessionKey, Object attributeKey) {
        try {
            return super.removeAttribute(sessionKey, attributeKey);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    public Collection<Object> getAttributeKeys(SessionKey key) {
        try {
            return super.getAttributeKeys(key);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(SessionKey sessionKey, Object object, Object object2) {
        try {
            void value;
            void attributeKey;
            void sessionKey2;
            super.setAttribute((SessionKey)sessionKey2, (Object)attributeKey, (Object)value);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    public void setTimeout(SessionKey key, long maxIdleTimeInMillis) {
        try {
            super.setTimeout(key, maxIdleTimeInMillis);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    public String getHost(SessionKey key) {
        try {
            return super.getHost(key);
        }
        catch (InvalidSessionException a2) {
            return null;
        }
    }

    public void touch(SessionKey key) {
        block4: {
            Session a22;
            block5: {
                HttpServletRequest a3;
                block6: {
                    a22 = this.doGetSession(key);
                    if (a22 == null) break block4;
                    a3 = ServletUtils.getRequest();
                    if (a3 == null) break block5;
                    if (!ServletUtils.isStaticFile((String)a3.getRequestURI())) break block6;
                    return;
                }
                String a4 = a3.getParameter(FileUploadParms.true("ZVkfq\\umd}`Z`zv`jg"));
                if (!"true".equals(a4) && !"1".equals(a4)) break block5;
                return;
            }
            try {
                a22.touch();
                this.onChange(a22);
                return;
            }
            catch (InvalidSessionException a22) {
                // empty catch block
            }
        }
    }

    public Date getStartTimestamp(SessionKey key) {
        try {
            return super.getStartTimestamp(key);
        }
        catch (InvalidSessionException a2) {
            return new Date();
        }
    }

    public void stop(SessionKey key) {
        try {
            super.stop(key);
            return;
        }
        catch (InvalidSessionException invalidSessionException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Serializable getSessionId(ServletRequest request, ServletResponse response) {
        String string;
        String a2 = this.getSessionIdCookieValue(request, response);
        if (StringUtils.isNotBlank((CharSequence)a2)) {
            string = a2;
            request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)BaseEntity.true("9`5d3j"));
        } else {
            a2 = request.getParameter(FileUploadParms.true("VZzlm"));
            if (StringUtils.isNotBlank((CharSequence)a2)) {
                if (WebUtils.isTrue((ServletRequest)request, (String)BaseEntity.true("\u0005P9`5d3j"))) {
                    void a3;
                    HttpServletRequest a4 = (HttpServletRequest)request;
                    HttpServletResponse a5 = (HttpServletResponse)response;
                    Cookie a6 = this.getSessionIdCookie();
                    SimpleCookie simpleCookie = new SimpleCookie(a6);
                    void v1 = a3;
                    v1.setValue(a2);
                    v1.saveTo(a4, a5);
                }
                request.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_SOURCE, (Object)FileUploadParms.true("|we"));
            }
            string = a2;
        }
        if (string != null) {
            ServletRequest servletRequest = request;
            servletRequest.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID, (Object)a2);
            servletRequest.setAttribute(ShiroHttpServletRequest.REFERENCED_SESSION_ID_IS_VALID, (Object)Boolean.TRUE);
        }
        return a2;
    }

    public Date getLastAccessTime(SessionKey key) {
        try {
            return super.getLastAccessTime(key);
        }
        catch (InvalidSessionException a2) {
            return new Date();
        }
    }

    protected Session retrieveSession(SessionKey sessionKey) {
        try {
            return super.retrieveSession(sessionKey);
        }
        catch (UnknownSessionException a2) {
            return null;
        }
    }
}

