/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.s.g.H;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.config.DataSourceConfig;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(H.true().get(DataSourceConfig.true("\f\u0000 \u0001\b"))).booleanValue()) {
            return this.renderResult("false", Page.true("\u5f33\u5226\u7228\u6747\u674a\u5f6b\u655e\u6b0f\u52ff\u8096\uff61"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", DataSourceConfig.true("\u5441\u52c2\u5bf4\u659c\u5606\u595b\u8d4b\uff6b"));
        }
        return this.renderResult("true", Page.true("\u5444\u52c8\u5bf1\u6596\u5603\u6270\u52f4\uff61"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a2;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(DataSourceConfig.true("\u0003\u001d8\u001b\u0004\u0000\u0003\u0000\r"), (Object)a2);
        return Page.true("\r\u0004\u0004\u001e\f\u000e\u0013D\n\u0004\u0002D\n\u0004\u0002'\t\u0018\u0014");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(DataSourceConfig.true("\f\u0000 \u0001\b"))).booleanValue()) {
            return this.renderResult("false", Page.true("\u5f33\u5226\u7228\u6747\u674a\u5f6b\u655e\u6b0f\u52ff\u8096\uff61"));
        }
        this.jobService.save(job);
        return this.renderResult("true", DataSourceConfig.true("\u4fb7\u5b36\u627a\u52f1\uff6b"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(Page.true("\u0006\u0005*\u0004\u0002"))).booleanValue()) {
            return this.renderResult("false", DataSourceConfig.true("\u5f39\u5223\u7222\u6742\u6740\u5f6e\u6554\u6b0a\u52f5\u8093\uff6b"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", Page.true("\u6002\u5966\u8fb0\u8827\u6270\u52f4\uff61"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(H.true().get(DataSourceConfig.true("\f\u0000 \u0001\b"))).booleanValue()) {
            return this.renderResult("false", Page.true("\u5f33\u5226\u7228\u6747\u674a\u5f6b\u655e\u6b0f\u52ff\u8096\uff61"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", DataSourceConfig.true("\u5032\u6b08\u5bf4\u659c\u5606\u595b\u8d4b\uff6b"));
        }
        return this.renderResult("true", Page.true("\u5037\u6b02\u5bf1\u6596\u5603\u6270\u52f4\uff61"));
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        List a2 = this.jobService.findList(job);
        a2 = ListUtils.listOrderBy(a2, (String)orderBy);
        return a2;
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a2 = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a2 = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a2 != null) {
                throw new ValidationException(DataSourceConfig.true("\u5467\u799e\u53a0\u7eaa\u5467\u5d9c\u7ea5\u5b36\u5742"));
            }
        }
        if (a2 == null) {
            a2 = new JobEntity();
        }
        return a2;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(Page.true("\u0006\u0005*\u0004\u0002"))).booleanValue()) {
            return this.renderResult("false", DataSourceConfig.true("\u5f39\u5223\u7222\u6742\u6740\u5f6e\u6554\u6b0a\u52f5\u8093\uff6b"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", Page.true("\u66e2\u5037\u8fb0\u8827\u6270\u52f4\uff61"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(JobEntity jobEntity, Model model) {
        void job;
        void model2;
        model2.addAttribute(DataSourceConfig.true("\u0000\u0001\b+\u0004\u001a\u0003\u001a\u0013"), (Object)job);
        return Page.true("\r\u0004\u0004\u001e\f\u000e\u0013D\n\u0004\u0002D\n\u0004\u0002-\u000f\u0019\r");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity jobEntity) {
        void job;
        JobController jobController = this;
        jobController.jobService.delete((JobEntity)job);
        return jobController.renderResult("true", DataSourceConfig.true("\u524a\u960a\u627a\u52f1\uff6b"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a2 = new StringBuilder();
        try {
            void a3;
            CronExpression a4 = new CronExpression(cron);
            if (num <= 0) {
                a2.append(DataSourceConfig.true("-\u0018\u0001\u0004\u8806\u8fd4\u5f61\u6b09\u7800\u3068"));
                return this.renderResult("true", a2.toString());
            }
            a2.append(Page.true("\\\u001b^\u676b\u8fb1") + num + DataSourceConfig.true("\u6b4f\u8fba\u8822\u659c\u959a\uff70RE\u001eT"));
            Date a5 = new Date();
            boolean bl = false;
            void v0 = a3;
            while (v0 <= num) {
                if ((a5 = a4.getTimeAfter(a5)) == null) {
                    return this.renderResult("true", a2.toString());
                }
                a2.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a5)).append(Page.true("\\D\u0002\u0019^")).toString());
                v0 = ++a3;
            }
            return this.renderResult("true", a2.toString());
        }
        catch (ParseException a6) {
            return this.renderResult("false", new StringBuilder().insert(0, Page.true("(\u0012\u0004\u000e\u8803\u8fde\u5f64\u9579\u8b84\uff7a")).append(a6.getMessage()).toString());
        }
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(H.true().get(DataSourceConfig.true("\f\u0000 \u0001\b"))).booleanValue()) {
            return this.renderResult("false", Page.true("\u5f33\u5226\u7228\u6747\u674a\u5f6b\u655e\u6b0f\u52ff\u8096\uff61"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", DataSourceConfig.true("\u8fba\u8822\u4e6a\u6b4f\u627a\u52f1\uff6b"));
    }
}

