/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.cache.F;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.v.g.e;
import com.jeesite.common.v.v.D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    private static final String SYS_CACHE = "sysCache";

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }

    public static void clearCache() {
        int n;
        String a2 = Global.getConfig(D.super((Object)"=\u00189\u00132\u00119Z\u000f((\u0004\"64\u0010/\u0011"));
        if (StringUtils.isBlank((CharSequence)a2)) {
            return;
        }
        String[] stringArray = a2.split(e.super("u"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            CacheUtils.removeAll(stringArray[n++]);
            n3 = n;
        }
    }

    public static void removeAll(String cacheName) {
        Iterator a2;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        Iterator iterator = a2 = a4.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = a2;
            iterator = iterator2;
            a3.remove(iterator2.next());
        }
        logger.info(D.super((Object)"\u6e54\u747f\u7f4f\u5b2c\uff76d6\u0018pEk]1\u001f"), (Object)cacheName, (Object)a4);
    }

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove((Object)key);
    }

    public static void removeByKeyPrefix(String cacheName, String keyPrefix) {
        String a2 = keyPrefix;
        Cache<String, Object> a3 = CacheUtils.getCache(cacheName);
        Set a4 = a3.keys();
        HashSet a5 = SetUtils.newHashSet();
        for (String a6 : a4) {
            if (!StringUtils.startsWith((CharSequence)a6, (CharSequence)a2)) continue;
            a3.remove((Object)a6);
            a5.add(a6);
        }
        logger.info(e.super("\u6e19\u7444\u7f02\u5b17\uff3b_{#=~&f|$"), (Object)cacheName, (Object)a5);
    }

    public static Object get(String cacheName, String key) {
        return CacheUtils.getCache(cacheName).get((Object)key);
    }

    public static Object get(String key) {
        return CacheUtils.get(SYS_CACHE, key);
    }

    public static Object get(String key, Object defaultValue) {
        Object a2 = CacheUtils.get(key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static void put(String cacheName, String key, Object value) {
        CacheUtils.getCache(cacheName).put((Object)key, value);
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static Cache<String, Object> getCache(String cacheName) {
        Cache a2 = F.super().getCache(cacheName);
        if (a2 == null) {
            throw new RuntimeException(new StringBuilder().insert(0, D.super((Object)"\u5f3f\u5209\u7cb6\u7eba\u4e7d\u6cd9\u675c\u5be7\u4e03\u207e")).append(cacheName).append(e.super("\u2000\u8f9a\u4e32\u7f55\u5b5f\u305b")).toString());
        }
        return a2;
    }

    public static Object get(String cacheName, String key, Object defaultValue) {
        Object a2 = CacheUtils.get(cacheName, key);
        if (a2 != null) {
            return a2;
        }
        return defaultValue;
    }

    public static String[] getCacheNames() {
        return F.super().getCacheNames();
    }
}

