/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.BaseService;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.modules.file.utils.FileUploadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public class JedisUtils {
    private static Logger logger = LoggerFactory.getLogger(JedisUtils.class);
    private static JedisPool jedisPool = SpringUtils.getBean(JedisPool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listAdd(String key, String ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.rpush(key, value);
            logger.debug(FileUploadUtils.super("(e:b\u0012T\u00111/qi4lm."), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(BaseService.super("E:W=\u007f\u000b|nB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setObject(String key, Object value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.set(JedisUtils.getBytesKey(key), JedisUtils.toBytes(value));
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(FileUploadUtils.super("6d0C+|6S\u00011/qi4lm."), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(BaseService.super("[;]\u001cF#[\flnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetObjectAdd(String key, Object ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            int n;
            a3 = JedisUtils.getResource();
            HashSet a4 = SetUtils.newHashSet();
            Object[] objectArray = value;
            int n2 = value.length;
            int n3 = n = 0;
            while (n3 < n2) {
                Object a5 = objectArray[n];
                a4.add(JedisUtils.toBytes(a5));
                n3 = ++n;
            }
            a2 = a3.rpush(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            logger.debug(FileUploadUtils.super("6.z|\u000ft\nc.i*b\u0012T\u00111/qi4lm."), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(BaseService.super("[q\u0017#b+g<C6G=\u007f\u000b|nB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsObject(String key) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.exists(JedisUtils.getBytesKey(key));
            logger.debug(FileUploadUtils.super("!t e'C:s>i*}lm."), (Object)key);
            return a2;
        }
        catch (Exception a4) {
            logger.warn(BaseService.super("L+M:J\u001cW,S6G\"\u00012C"), (Object)key, (Object)a4);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String key) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.exists(key);
            logger.debug(FileUploadUtils.super("\u0010i=\u007f=zlm."), (Object)key);
            return a2;
        }
        catch (Exception a4) {
            logger.warn(BaseService.super("}6P P%\u00012C"), (Object)key, (Object)a4);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getMap(String key) {
        Map a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.hgetAll(key);
                logger.debug(FileUploadUtils.super("k,b\u001eQ\u00051/qi4lm."), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(BaseService.super("4A=s\u000ehnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String set(String key, String value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.set(key, value);
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(FileUploadUtils.super(" U\u00011/qi4lm."), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(BaseService.super("M\nlnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String setObjectMap(String key, Map<String, Object> value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            Iterator<Map.Entry<String, Object>> iterator;
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a3.del(key);
            }
            HashMap a4 = MapUtils.newHashMap();
            Iterator<Map.Entry<String, Object>> iterator2 = iterator = value.entrySet().iterator();
            while (iterator2.hasNext()) {
                void a5;
                Map.Entry<String, Object> entry = iterator.next();
                iterator2 = iterator;
                a4.put(JedisUtils.getBytesKey(a5.getKey()), JedisUtils.toBytes(a5.getValue()));
            }
            a2 = a3.hmset(JedisUtils.getBytesKey(key), (Map)a4);
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(FileUploadUtils.super("\\\u000ft\nc.i*b\u001eQ\u00051/qi4lm."), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(BaseService.super("\u0003b+g<C6G=s\u000ehnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long listObjectAdd(String key, Object ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            int n;
            a3 = JedisUtils.getResource();
            ArrayList a4 = ListUtils.newArrayList();
            Object[] objectArray = value;
            int n2 = value.length;
            int n3 = n = 0;
            while (n3 < n2) {
                Object a5 = objectArray[n];
                a4.add(JedisUtils.toBytes(a5));
                n3 = ++n;
            }
            a2 = a3.rpush(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            logger.debug(FileUploadUtils.super("bF\u0019t\nc.i*b\u0012T\u00111/qi4lm."), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(BaseService.super("\u000f\u0019t+g<C6G=\u007f\u000b|nB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSet(String key, Set<String> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a3.del(key);
            }
            a2 = a3.sadd(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(FileUploadUtils.super("\u007f,b\u0000U\u00011/qi4lm."), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(BaseService.super(" A=m\nlnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static Object toObject(byte[] bytes) {
        return ObjectUtils.unserializeFst((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectSet(String key, Set<Object> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            Iterator<Object> iterator;
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a3.del(key);
            }
            HashSet a4 = SetUtils.newHashSet();
            Iterator<Object> iterator2 = iterator = value.iterator();
            while (iterator2.hasNext()) {
                Iterator<Object> iterator3 = iterator;
                iterator2 = iterator3;
                Object a5 = iterator3.next();
                a4.add(JedisUtils.toBytes(a5));
            }
            a2 = a3.sadd(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(FileUploadUtils.super("\\\u000ft\nc.i*b\u0000U\u00011/qi4lm."), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(BaseService.super("\u0003b+g<C6G=m\nlnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapObjectRemove(String key, String mapKey) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            byte[][] byArrayArray = new byte[1][];
            byArrayArray[0] = JedisUtils.getBytesKey(mapKey);
            a2 = a3.hdel(JedisUtils.getBytesKey(key), (byte[][])byArrayArray);
            logger.debug(FileUploadUtils.super("&o_%b/d'x\u001bs>_\u0003ttw4)lm."), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(BaseService.super("y\u0002\u0000H=B;J'v,S\u0000n+\u0019(Yv\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Set<Object> getObjectSet(String key) {
        HashSet a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                a2 = SetUtils.newHashSet();
                Set a4 = a3.smembers(JedisUtils.getBytesKey(key));
                Iterator iterator2 = iterator = a4.iterator();
                while (iterator2.hasNext()) {
                    void a5;
                    byte[] byArray = (byte[])iterator.next();
                    iterator2 = iterator;
                    a2.add(JedisUtils.toObject((byte[])a5));
                }
                logger.debug(FileUploadUtils.super("H\u000ft\nc.i*b\u0000U\u00011/qi4lm."), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a6;
            logger.warn(BaseService.super("\u0017b+g<C6G=m\nlnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static byte[] getBytesKey(Object key) {
        if (key instanceof String) {
            return StringUtils.getBytes((String)((String)key));
        }
        return JedisUtils.toBytes(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getObjectMap(String key) {
        HashMap a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                a2 = MapUtils.newHashMap();
                Map a4 = a3.hgetAll(JedisUtils.getBytesKey(key));
                Iterator iterator2 = iterator = a4.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry a5 = iterator.next();
                    a2.put(ObjectUtils.toString(a5.getKey()), JedisUtils.toObject((byte[])a5.getValue()));
                    iterator2 = iterator;
                }
                logger.debug(FileUploadUtils.super("H\u000ft\nc.i*b\u001eQ\u00051/qi4lm."), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a6;
            logger.warn(BaseService.super("\u0017b+g<C6G=s\u000ehnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setSetAdd(String key, String ... value) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.sadd(key, value);
            logger.debug(FileUploadUtils.super("6d0_,b\u0012T\u00111/qi4lm."), (Object)key, (Object)value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(BaseService.super("[;]\u0000A=\u007f\u000b|nB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long mapRemove(String key, String mapKey) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            String[] stringArray = new String[1];
            stringArray[0] = mapKey;
            a2 = a3.hdel(key, stringArray);
            logger.debug(FileUploadUtils.super("l%|\u001bs>_\u0003ttw4)lm."), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(BaseService.super("3H#v,S\u0000n+\u0019(Yv\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static Object getObjectKey(byte[] key) {
        try {
            return ObjectUtils.toString((Object)key);
        }
        catch (UnsupportedOperationException a2) {
            try {
                return JedisUtils.toObject(key);
            }
            catch (UnsupportedOperationException a3) {
                a3.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getList(String key) {
        List a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.lrange(key, 0L, -1L);
                logger.debug(FileUploadUtils.super("#i=Z:C\u00011/qi4lm."), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(BaseService.super("N6P\u0005W\u001clnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String key) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.get(key);
                a2 = StringUtils.isNotBlank((CharSequence)a2) && !FileUploadUtils.super("\"\u007f?").equalsIgnoreCase(a2) ? a2 : null;
                logger.debug(BaseService.super("Y\nlnB.\u0004k\u00012C"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(FileUploadUtils.super("4U\u00011/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setList(String key, List<String> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a3.del(key);
            }
            a2 = a3.rpush(key, (String[])value.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseService.super("Z6P\u0005W\u001clnB.\u0004k\u00012C"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(FileUploadUtils.super("7i=Z:C\u00011/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setObjectList(String key, List<Object> value, int cacheSeconds) {
        long a2 = 0L;
        Jedis a3 = null;
        try {
            Iterator<Object> iterator;
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a3.del(key);
            }
            ArrayList a4 = ListUtils.newArrayList();
            Iterator<Object> iterator2 = iterator = value.iterator();
            while (iterator2.hasNext()) {
                Iterator<Object> iterator3 = iterator;
                iterator2 = iterator3;
                Object a5 = iterator3.next();
                a4.add(JedisUtils.toBytes(a5));
            }
            a2 = a3.rpush(JedisUtils.getBytesKey(key), (byte[][])a4.toArray());
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseService.super("\u0010\u0015s\u0010J4L0P\u0005W\u001clnB.\u0004k\u00012C"), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(FileUploadUtils.super("}J\u001eO'k!o=Z:C\u00011/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static byte[] toBytes(Object object) {
        return ObjectUtils.serializeFst((Object)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String mapPut(String key, Map<String, String> value) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.hmset(key, value);
            logger.debug(BaseService.super(">E9n\u001alnB.\u0004k\u00012C"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(FileUploadUtils.super("a(f\u0003E\u00011/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    public static Jedis getResource() throws JedisException {
        Jedis a2 = null;
        try {
            a2 = jedisPool.getResource();
            return a2;
        }
        catch (JedisException a3) {
            logger.warn(BaseService.super(".[\u001bJ+J<Q$B,\u0010"), (Throwable)a3);
            JedisUtils.returnResource(a2);
            throw a3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long delObject(String key) {
        Jedis jedis;
        long a2;
        block7: {
            a2 = 0L;
            Jedis a3 = null;
            try {
                a3 = JedisUtils.getResource();
                if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                    Jedis jedis2 = a3;
                    jedis = jedis2;
                    a2 = jedis2.del(JedisUtils.getBytesKey(key));
                    logger.debug(FileUploadUtils.super("r6\\:s>i*}lm."), (Object)key);
                    break block7;
                }
                logger.debug(BaseService.super("Lq\u000f?e5M=]s_4\u001e\u0001w:\u00196\\?R=M"), (Object)key);
                jedis = a3;
            }
            catch (Exception a4) {
                logger.warn(FileUploadUtils.super("r6\\:s>i*}lm."), (Object)key, (Object)a4);
                return a2;
            }
            finally {
                JedisUtils.returnResource(a3);
            }
        }
        JedisUtils.returnResource(jedis);
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSet(String key) {
        Set a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a2 = a3.smembers(key);
                logger.debug(BaseService.super("4A=m\nlnB.\u0004k\u00012C"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(FileUploadUtils.super("k,b\u0000U\u00011/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setMap(String key, Map<String, String> value, int cacheSeconds) {
        String a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(key).booleanValue()) {
                a3.del(key);
            }
            a2 = a3.hmset(key, value);
            if (cacheSeconds != 0) {
                a3.expire(key, cacheSeconds);
            }
            logger.debug(BaseService.super(" A=s\u000ehnB.\u0004k\u00012C"), (Object)key, value);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a4;
            logger.warn(FileUploadUtils.super("\u007f,b\u001eQ\u00051/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static String mapObjectPut(String key, Map<String, Object> value) {
        String a2 = null;
        Jedis a3 = null;
        try {
            Iterator<Map.Entry<String, Object>> iterator;
            a3 = JedisUtils.getResource();
            HashMap a4 = MapUtils.newHashMap();
            Iterator<Map.Entry<String, Object>> iterator2 = iterator = value.entrySet().iterator();
            while (iterator2.hasNext()) {
                void a5;
                Map.Entry<String, Object> entry = iterator.next();
                iterator2 = iterator;
                a4.put(JedisUtils.getBytesKey(a5.getKey()), JedisUtils.toBytes(a5.getValue()));
            }
            a2 = a3.hmset(JedisUtils.getBytesKey(key), (Map)a4);
            logger.debug(BaseService.super("\u001df/g<C6G=n\u001alnB.\u0004k\u00012C"), (Object)key, value);
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = value;
            objectArray[2] = a6;
            logger.warn(FileUploadUtils.super("B\u000bp\nc.i*b\u0003E\u00011/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List<Object> getObjectList(String key) {
        ArrayList a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                Iterator iterator;
                List a4 = a3.lrange(JedisUtils.getBytesKey(key), 0L, -1L);
                a2 = ListUtils.newArrayList();
                Iterator iterator2 = iterator = a4.iterator();
                while (iterator2.hasNext()) {
                    void a5;
                    byte[] byArray = (byte[])iterator.next();
                    iterator2 = iterator;
                    a2.add(JedisUtils.toObject((byte[])a5));
                }
                logger.debug(BaseService.super("\u0004\u0015s\u0010J4L0P\u0005W\u001clnB.\u0004k\u00012C"), (Object)key, (Object)a2);
            }
            return a2;
        }
        catch (Exception a6) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a6;
            logger.warn(FileUploadUtils.super("iJ\u001eO'k!o=Z:C\u00011/qi4lm."), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long del(String key) {
        Jedis jedis;
        long a2;
        block7: {
            a2 = 0L;
            Jedis a3 = null;
            try {
                a3 = JedisUtils.getResource();
                if (a3.exists(key).booleanValue()) {
                    Jedis jedis2 = a3;
                    jedis = jedis2;
                    a2 = jedis2.del(key);
                    logger.debug(BaseService.super("7A:\u00012C"), (Object)key);
                    break block7;
                }
                logger.debug(FileUploadUtils.super("!d(,2ks^\u001aeti1`?b "), (Object)key);
                jedis = a3;
            }
            catch (Exception a4) {
                logger.warn(BaseService.super("7A:\u00012C"), (Object)key, (Object)a4);
                return a2;
            }
            finally {
                JedisUtils.returnResource(a3);
            }
        }
        JedisUtils.returnResource(jedis);
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(String key) {
        Object a2 = null;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            if (a3.exists(JedisUtils.getBytesKey(key)).booleanValue()) {
                a2 = JedisUtils.toObject(a3.get(JedisUtils.getBytesKey(key)));
                logger.debug(FileUploadUtils.super("\"d0C+|6S\u00011/qi4lm."), (Object)key, a2);
            }
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = a2;
            objectArray[2] = a4;
            logger.warn(BaseService.super("O;]\u001cF#[\flnB.\u0004k\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapExists(String key, String mapKey) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.hexists(key, mapKey);
            logger.debug(FileUploadUtils.super("l%|\fn:C\u0001btw4)lm."), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(BaseService.super("3H#a1W\u001cl=\u0019(Yv\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mapObjectExists(String key, String mapKey) {
        boolean a2 = false;
        Jedis a3 = null;
        try {
            a3 = JedisUtils.getResource();
            a2 = a3.hexists(JedisUtils.getBytesKey(key), JedisUtils.getBytesKey(mapKey));
            logger.debug(FileUploadUtils.super("&o_%b/d'x\fn:C\u0001btw4)lm."), (Object)key, (Object)mapKey);
            return a2;
        }
        catch (Exception a4) {
            Object[] objectArray = new Object[3];
            objectArray[0] = key;
            objectArray[1] = mapKey;
            objectArray[2] = a4;
            logger.warn(BaseService.super("y\u0002\u0000H=B;J'a1W\u001cl=\u0019(Yv\u00012C"), objectArray);
            return a2;
        }
        finally {
            JedisUtils.returnResource(a3);
        }
    }
}

