/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.realm;

import com.beust.jcommander.internal.Maps;
import com.jeesite.common.cache.CacheUtils;
import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.codec.Sha1Utils;
import com.jeesite.common.config.Global;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.B;
import com.jeesite.common.shiro.authc.FormToken;
import com.jeesite.common.shiro.cas.CasCreateUser;
import com.jeesite.common.shiro.cas.CasOutHandler;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.shiro.session.SessionDAO;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.common.v.v.D;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.util.ByteSource;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class BaseAuthorizingRealm
extends AuthorizingRealm {
    private String casServerUrl;
    private String casServerCallbackUrl;
    public static final int HASH_INTERATIONS = 1024;
    public static final String HASH_ALGORITHM = "SHA-1";
    private TicketValidator ticketValidator;
    private CasOutHandler casOutHandler;
    public static final int SALT_SIZE = 8;
    private SessionDAO sessionDAO;

    public final boolean supports(AuthenticationToken token) {
        if (token != null && FormToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(FormToken.class);
            return true;
        }
        if (token != null && CasToken.class.isAssignableFrom(token.getClass())) {
            this.setAuthenticationTokenClass(CasToken.class);
            return true;
        }
        return false;
    }

    public static String encryptPassword(String plainPassword) {
        String a2 = EncodeUtils.decodeHtml((String)plainPassword);
        byte[] a3 = Sha1Utils.genSalt((int)8);
        byte[] a4 = Sha1Utils.sha1((byte[])a2.getBytes(), (byte[])a3, (int)1024);
        return new StringBuilder().insert(0, EncodeUtils.encodeHex((byte[])a3)).append(EncodeUtils.encodeHex((byte[])a4)).toString();
    }

    public void setCasServerCallbackUrl(String casServerCallbackUrl) {
        this.casServerCallbackUrl = casServerCallbackUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) {
        Object a2;
        Object a3;
        FormToken formToken;
        HttpServletRequest a4 = ServletUtils.getRequest();
        if (this.casOutHandler.isLogoutRequest(a4)) {
            String a5 = CommonUtils.safeGetParameter((HttpServletRequest)a4, (String)"logoutRequest");
            BaseAuthorizingRealm baseAuthorizingRealm = this;
            User a6 = baseAuthorizingRealm.casOutHandler.destroySession(a4, a5);
            baseAuthorizingRealm.onLogoutSuccess(a6, a4);
            return null;
        }
        if (authcToken == null) {
            return null;
        }
        FormToken a7 = null;
        Map a8 = null;
        AuthenticationToken authenticationToken = authcToken;
        if (authcToken instanceof FormToken) {
            formToken = a7 = (FormToken)authenticationToken;
        } else {
            Assertion assertion;
            if (!(authenticationToken instanceof CasToken) || !ObjectUtils.toBoolean(B.super().get(D.super((Object)"\u0016;>5\u000f"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"\u0010)\u000bm\u0007?\u001f>\u0011p\u0002\u001239!6\u001b;\u0012#\u0012"), new String[0])).toString());
            a3 = (CasToken)authcToken;
            a2 = (String)a3.getCredentials();
            if (this.ticketValidator == null) {
                this.ticketValidator = new Cas20ServiceTicketValidator(this.casServerUrl);
                ((Cas20ServiceTicketValidator)this.ticketValidator).setEncoding("UTF-8");
            }
            Object var7_11 = null;
            try {
                assertion = this.ticketValidator.validate((String)a2, this.casServerCallbackUrl);
            }
            catch (TicketValidationException a9) {
                return null;
            }
            AttributePrincipal attributePrincipal = a = assertion.getPrincipal();
            a3.setUserId(attributePrincipal.getName());
            a8 = attributePrincipal.getAttributes();
            a7 = new FormToken();
            a7.setUsername(a.getName());
            Map a10 = Maps.newHashMap();
            FormToken formToken2 = a7;
            a10.put("ticket", a2);
            formToken = formToken2;
            formToken2.setParams(a10);
        }
        if (StringUtils.isBlank((CharSequence)formToken.getUsername())) {
            throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"%\u00078M<\u0017$\u0002>V6\u001c=\u0019\u001e-(=+29\u001c:\u0017"), new String[0])).toString());
        }
        if (StringUtils.isBlank((CharSequence)a7.getSsoToken()) && !(authcToken instanceof CasToken)) {
            a3 = (String)(a7.getParams() == null ? null : a7.getParams().get(Page.super("}~XEIMs\\VA")));
            if (BaseAuthorizingRealm.isValidCodeLogin(a7.getUsername(), (String)a3, D.super((Object)"\u00064\u0011=\u0018"))) {
                a2 = UserUtils.getSession();
                String string = (String)a2.getAttribute((Object)"validCode");
                if (a7.getCaptcha() == null || !a7.getCaptcha().toUpperCase().equals(string)) {
                    throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"%\u00078M<\u0017$\u0002>V!\u001e2\u001f\u000f\u00003\u0010=5'\u000f;\u000e"), new String[0])).toString());
                }
                a2.removeAttribute((Object)"validCode");
            }
        }
        if (!B.super(a4)) {
            throw new AuthenticationException(Page.super("OSV\t\u7659\u5f75\u5914\u8d02\uff20\u8bd9\u804d\u7ce0\u7b8f\u742a\u5472\u839f\u53f1\u8b9d\u53c9\uff25"));
        }
        a3 = UserUtils.getByLoginCode(a7.getUsername());
        if (a3 != null) {
            return this.newAuthenticationInfo((User)a3, a7);
        }
        if (!(authcToken instanceof CasToken)) return null;
        if (!ObjectUtils.toBoolean(a8.get(D.super((Object)"\u00178\"<\u0014,\u001c\u0013\u0014>\u001a0\u0002(19\u0015,\u0015\u0000\u000e1\u000e"))).booleanValue()) throw new AuthenticationException(new StringBuilder().insert(0, D.super((Object)"1\u0007?J\u757d\u624at\u2060")).append(a7.getUsername()).append(Page.super("\u203d\u0011\u571b\u670e\u7cdb\u7efa\u4e0a\u4e21\u5b76\u57317\u000e\u8bdb\u807e\u7cd3\u7b86\u7423\u547e\n")).toString());
        Object object = a3 = new User(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.super("[_OZdJBA")))));
        Map map = a8;
        Object object2 = a3;
        Map map2 = a8;
        Object object3 = a3;
        Map map3 = a8;
        Object object4 = a3;
        ((User)object4).setLoginCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(D.super((Object)"/3\u00131\u001e\u0016\u00120\u0019")))));
        ((User)object4).setPassword(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.super("^MY[PJT@")))));
        ((User)a3).setUserName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get(D.super((Object)")\u0007=\u0002\u001b\u001c9\u0019")))));
        ((User)object3).setEmail(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map3.get("email"))));
        ((User)object3).setMobile(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.super("GGELJA")))));
        ((User)a3).setPhone(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(D.super((Object)"\u0000=\u0012:\u0019")))));
        ((User)object2).setUserType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map2.get(Page.super("[_OZs\\VA")))));
        ((User)object2).setRefCode(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(D.super((Object)"\u0006=\u0016\u0016\u00120\u0019")))));
        ((User)a3).setRefName(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(Page.super("^ONiDKA")))));
        ((User)object).setMgrType(EncodeUtils.decodeUrl((String)ObjectUtils.toString(map.get(D.super((Object)"\u0019?\u0002\u0001\u0004$\u0019")))));
        ((DataEntity)object).setStatus(EncodeUtils.decodeUrl((String)ObjectUtils.toString(a8.get(Page.super("Y\\FQSW")))));
        if ("employee".equals(((User)a3).getUserType())) {
            try {
                this.casCreateEmpUser((User)a3, a8);
            }
            catch (ValidationException a11) {
                throw new AuthenticationException(new StringBuilder().insert(0, D.super((Object)"8\u000e3F")).append(a11.getMessage()).toString());
            }
            a3 = UserUtils.getByLoginCode(a7.getUsername());
            if (a3 == null) return null;
            return this.newAuthenticationInfo((User)a3, a7);
        }
        try {
            a2 = SpringUtils.getBean(CasCreateUser.class);
            if (a2 == null) return null;
            a2.createUser((User)a3, a8);
            return null;
        }
        catch (NoSuchBeanDefinitionException a12) {
            throw new AuthenticationException(new StringBuilder().insert(0, Page.super("C_M\u0012\u750f\u6212\u0006\u2038")).append(a7.getUsername()).append(D.super((Object)"\u2069tP\u7c2e\u57f6t\u2060")).append(((User)a3).getUserType()).append(Page.super("\u203d\u0011\u571b\u670e\u7cdb\u7efa\u4e0a\u4e21\u5b76\u57317\u000e\u8bdb\u807e\u7cd3\u7b86\u7423\u547e\n")).toString());
        }
    }

    protected final AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            return null;
        }
        AuthorizationInfo a2 = null;
        a2 = (AuthorizationInfo)UserUtils.getCache("authInfo");
        if (a2 == null && (a2 = this.doGetAuthorizationInfo(principals)) != null) {
            UserUtils.putCache("authInfo", a2);
        }
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    protected final AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Serializable a22;
        Object a3;
        String a4;
        Object a5;
        void a6;
        LoginInfo a7 = (LoginInfo)this.getAvailablePrincipal(principals);
        String a8 = a7.getParam(D.super((Object)"\u000f&*\u001d;\u0015\u0001\u0004$\u0019"));
        if (StringUtils.isNotBlank((CharSequence)a8)) {
            long a9 = ObjectUtils.toLong((Object)Global.getProperty(Page.super("J^QSX\\L\u000eVB_]pt@xCEBJSP")));
            long a10 = ObjectUtils.toLong((Object)Global.getProperty(new StringBuilder().insert(0, D.super((Object)"/\u0011+\u0003<\u0012:R")).append(a8).append(Page.super("vB_]pt@xCEBJSP")).toString()));
            UserUtils.getSession().setTimeout(a10 > 0L ? a10 : a9);
        }
        HttpServletRequest a11 = ServletUtils.getRequest();
        String string = a7.getParam("ticket");
        this.casOutHandler.recordSession(a11, (String)a6);
        if (!ObjectUtils.toBoolean((Object)Global.getConfig(D.super((Object)"\u00169\u0010$\u0011e\n#9/\u0007?\u000f\u001a\n2\u0002\u0002\u00028\u0010*<:\u001a=\u0012"), "true")).booleanValue() && (a5 = this.sessionDAO.getActiveSessions(false, true, a4 = UserUtils.getSession().getId().toString(), null, a7.getId())).size() > 0) {
            if (UserUtils.getSubject().isAuthenticated()) {
                Iterator iterator = a5.iterator();
                while (iterator.hasNext()) {
                    a3 = (Session)iterator.next();
                    PrincipalCollection a12 = (PrincipalCollection)a3.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                    a22 = a12 != null ? (LoginInfo)a12.getPrimaryPrincipal() : null;
                    if (a22 == null || !StringUtils.equals((CharSequence)((LoginInfo)a22).getParam(Page.super("}~XEIMs\\VA")), (CharSequence)a7.getParam(D.super((Object)"\u000f&*\u001d;\u0015\u0001\u0004$\u0019")))) continue;
                    this.sessionDAO.delete((Session)a3);
                }
            } else {
                UserUtils.getSubject().logout();
                throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"8\u000b9\n,E=\r;\u000b77\u000f'.9=\u0003&\u001c3\u0019"), new String[0])).toString());
            }
        }
        if ((a = UserUtils.get(a7.getId())) == null) {
            return null;
        }
        a5 = UserUtils.getSession();
        Session session = a5;
        a5.setAttribute((Object)Page.super("[_OZdJBA"), (Object)a.getUserCode());
        session.setAttribute((Object)D.super((Object)")\u0007=\u0002\u001b\u001c9\u0019"), (Object)a.getUserName());
        session.setAttribute((Object)Page.super("[_OZs\\VA"), (Object)a.getUserType());
        SimpleAuthorizationInfo a13 = new SimpleAuthorizationInfo();
        a3 = UserUtils.getMenuList();
        for (Serializable a22 : a3) {
            int n;
            if (!StringUtils.isNotBlank((CharSequence)((Menu)a22).getPermission())) continue;
            String[] stringArray = StringUtils.split((String)((Menu)a22).getPermission(), (String)D.super((Object)"P"));
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                void a14;
                String string2 = stringArray[n];
                a13.addStringPermission((String)a14);
                n3 = ++n;
            }
        }
        a13.addStringPermission(Page.super("RVCV"));
        Iterator<DataEntity> iterator = a.getRoleList().iterator();
        Iterator<DataEntity> iterator2 = iterator;
        while (iterator2.hasNext()) {
            a22 = (Role)iterator.next();
            iterator2 = iterator;
            a13.addRole(((Role)a22).getRoleCode());
        }
        return a13;
    }

    protected final void assertCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) throws AuthenticationException {
        if (authcToken instanceof FormToken) {
            FormToken a2 = (FormToken)authcToken;
            if (StringUtils.isNotBlank((CharSequence)a2.getSsoToken())) {
                FormToken formToken = a2;
                String a3 = UserUtils.getSsoToken(formToken.getUsername());
                if (StringUtils.equals((CharSequence)formToken.getSsoToken(), (CharSequence)a3)) {
                    return;
                }
                throw new IncorrectCredentialsException(D.super((Object)"\u00138\u0004j\u63f0\u6700\u4e8f\u721c\u9561\u8bb8\uff73\u8ba9\u51fb\u8bbe\u4e43\u6b7d\u6262\u800c\u7c8b\u7bf4\u747b\u540c\u307e"));
            }
            super.assertCredentialsMatch((AuthenticationToken)a2, info);
            return;
        }
        if (authcToken instanceof CasToken) {
            return;
        }
        throw new IncorrectCredentialsException(new StringBuilder().insert(0, Page.super("MV@\u0016\u4e23\u6536\u631a\u76aa\u63a4\u6769\u4ecc\u726b\u7c5e\u57ad\uff3e")).append(authcToken).toString());
    }

    public void onLoginSuccess(PrincipalCollection principals) {
    }

    public void setSessionDAO(SessionDAO sessionDAO) {
        this.sessionDAO = sessionDAO;
    }

    public BaseAuthorizingRealm() {
        BaseAuthorizingRealm baseAuthorizingRealm = this;
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher(HASH_ALGORITHM);
        hashedCredentialsMatcher.setHashIterations(1024);
        baseAuthorizingRealm.setCredentialsMatcher((CredentialsMatcher)hashedCredentialsMatcher);
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean isPermitted(Permission permission, AuthorizationInfo info) {
        try {
            String a2 = StringUtils.substringBefore((String)permission.toString(), (String)D.super((Object)"F"));
            if (a2 != null) {
                void a3;
                String string = (String)B.super().get(Page.super("AELRICW"));
                if (StringUtils.contains((CharSequence)a3, (CharSequence)(D.super((Object)"P") + a2 + Page.super("\b"))) && !StringUtils.contains((CharSequence)((String)B.super().get(D.super((Object)"\u0019\u001b&297\u0014 \u00111\u000f"))), (CharSequence)new StringBuilder().insert(0, Page.super("\b")).append(a2).append(D.super((Object)"P")).toString())) {
                    throw new RuntimeException(new StringBuilder().insert(0, Page.super("\u007f")).append(a2).append(D.super((Object)"\u0001\u6a55\u570f\u6cd1\u675c\u63f5\u6717\uff7d")).toString());
                }
            }
        }
        catch (Exception a4) {
            throw new UnauthorizedException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(a4.getMessage()).toString());
        }
        return super.isPermitted(permission, info);
    }

    protected abstract void casCreateEmpUser(User var1, Map<String, Object> var2);

    public void onLogoutSuccess(User logoutUser, HttpServletRequest request) {
    }

    public void setCasOutHandler(CasOutHandler casOutHandler) {
        this.casOutHandler = casOutHandler;
    }

    private final /* synthetic */ SimpleAuthenticationInfo newAuthenticationInfo(User user, FormToken token) {
        int a2;
        if (Global.isUseCorpModel().booleanValue()) {
            token.getParams().put(D.super((Object)"?\u001b*\u0000\u0016\u00120\u0019"), user.getCorpCode_());
        }
        if (StringUtils.equals((CharSequence)((CharSequence)B.super().get(Page.super("S\\VA"))), (CharSequence)"0") && !user.isAdmin() && (a2 = this.sessionDAO.getActiveSessions(true, true).size()) >= 10) {
            throw new AuthenticationException(D.super((Object)"!\u0017*_\u762a\u5f2c\u5967\u8d5b\uff47\u60cb\u76d4\u5f2b\u520e\u7610\u5f05\u4ec2\u6527\u5d8d\u8ddb\u8fb1\u963b\u5275\uff50\u8b83\u800c\u7c8b\u7bf4\u747b\u540c\uff7d"));
        }
        if (!"0".equals(user.getStatus())) {
            if ("2".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"\n/\re\u000f?\u001f*\u0005~\u00194\u001c1\u0003\u00057\u0018\u001d+\u00117\u00111\u0018"), new String[0])).toString());
            }
            if ("3".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"%\u00078M<\u0017$\u0002>V6\u001c=\u0019\u001e-(2*\u00150\u00071\u0018"), new String[0])).toString());
            }
            if ("4".equals(user.getStatus())) {
                throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"%\u00078M<\u0017$\u0002>V6\u001c=\u0019\u001e-(5-\u0014<\t1\u0018"), new String[0])).toString());
            }
            throw new AuthenticationException(new StringBuilder().insert(0, Page.super("JVA\u001e")).append(Global.getText(D.super((Object)"%\u00078M<\u0017$\u0002>V6\u001c=\u0019\u001e-(=6\u00064\u0011=\u0018"), new String[0])).toString());
        }
        byte[] a22 = EncodeUtils.decodeHex((String)user.getPassword().substring(0, 16));
        return new SimpleAuthenticationInfo((Object)new LoginInfo(user, token.getParams()), (Object)user.getPassword().substring(16), ByteSource.Util.bytes((byte[])a22), this.getName());
    }

    public void setCasServerUrl(String casServerUrl) {
        this.casServerUrl = casServerUrl;
    }

    public static boolean validatePassword(String plainPassword, String password) {
        try {
            String string = EncodeUtils.decodeHtml((String)plainPassword);
            byte[] a2 = EncodeUtils.decodeHex((String)password.substring(0, 16));
            byte[] a3 = Sha1Utils.sha1((byte[])string.getBytes(), (byte[])a2, (int)1024);
            return password.equals(EncodeUtils.encodeHex((byte[])a2) + EncodeUtils.encodeHex((byte[])a3));
        }
        catch (Exception a4) {
            return false;
        }
    }

    public static boolean isValidCodeLogin(String loginCode, String deviceType, String operation) {
        String a2;
        int a222;
        String a3;
        Long[] a4;
        Map a5 = (Map)CacheUtils.get(Page.super("IHKGw]OEFMChGT"));
        if (a5 == null) {
            a5 = Maps.newHashMap();
            CacheUtils.put(D.super((Object)";\u00109\u001f\u0005\u0005=\u001d4\u0015105\f"), a5);
        }
        if ((a4 = (Long[])a5.get(a3 = loginCode)) == null) {
            Long[] longArray = new Long[2];
            longArray[0] = 0L;
            longArray[1] = 0L;
            a4 = longArray;
        }
        Long a6 = a4[0];
        Long a7 = a4[1];
        if (Page.super("^FIO@").equals(operation)) {
            if (a7 != 0L) {
                a222 = ObjectUtils.toInteger((Object)Global.getConfig(D.super((Object)"/\r\u000b~ \u000b*\f?W0\u001f\"\u000f5\u001c\r\u001e=91\u000b;\u0004',?\u001f\u0015\u0019;\b \u0019"), Page.super("\u0014\u0014")));
                if (System.currentTimeMillis() / 60000L - a7 <= (long)a222) {
                    String[] stringArray = new String[1];
                    stringArray[0] = String.valueOf(a222);
                    throw new AuthenticationException(new StringBuilder().insert(0, D.super((Object)"8\u000e3F")).append(Global.getText(Page.super("U@H\fL^TKN\u000bAMGu~Jb_EkJEO"), stringArray)).toString());
                }
                Long[] longArray = new Long[2];
                longArray[0] = a6;
                longArray[1] = 0L;
                a5.put(a3, longArray);
            }
        } else if (D.super((Object)">\u0011<\u00111\u0018").equals(operation)) {
            Long a222 = a6;
            Long l2 = a6 = Long.valueOf(a222 + 1L);
            a222 = ObjectUtils.toInteger((Object)Global.getConfig(Page.super("IW_$dQ[VS\rGEOU^FnD^cFQB^bvxEmIKHPHP"), D.super((Object)"OdL")));
            if (a6 >= (long)a222) {
                a7 = System.currentTimeMillis() / 60000L;
            }
            Long[] longArray = new Long[2];
            longArray[0] = a6;
            longArray[1] = a7;
            a5.put(a3, longArray);
        } else if (Page.super("__KD@UW").equals(operation)) {
            a5.remove(a3);
        }
        a222 = ObjectUtils.toInteger((Object)Global.getConfig(D.super((Object)"\u0007\u0001#b\b\"\u00028\u0017x\u0018*\n<\u001d'%%\u0015\u0016\u0019*\u0013\u0019\u0015=\u00181\u0014\u0016\u00120\u0019"), Page.super("\u0014\u0016\u0014")));
        if (StringUtils.isNotBlank((CharSequence)deviceType) && StringUtils.isNotBlank((CharSequence)(a2 = Global.getConfig(new StringBuilder().insert(0, D.super((Object)"/\r\u000b~ \u000b*\f?W0\u001f\"\u000f5\u001c\r\u001e=91\u000b;\u0004=\"0\u001d<3:\u00191R")).append(deviceType).toString())))) {
            a222 = ObjectUtils.toInteger((Object)a2);
        }
        return a6 >= (long)a222;
    }
}

