/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.service;

import com.beust.jcommander.internal.Lists;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.RoutingDataSource;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.v.g.D;
import com.jeesite.modules.file.utils.FileUploadUtils;
import com.jeesite.modules.job.dao.JobDao;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.listener.JobDetalListener;
import com.jeesite.modules.job.listener.JobSchedulerListener;
import com.jeesite.modules.job.listener.JobTriggerListener;
import com.jeesite.modules.job.service.JobLogService;
import com.jeesite.modules.job.v.F;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"dbUpgrade"})
@Transactional(readOnly=true)
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobService
extends CrudService<JobDao, JobEntity> {
    @Autowired
    private RoutingDataSource dataSource;
    private SchedulerFactoryBean scheduler;
    @Autowired
    private JobLogService jobLogService;

    @Override
    public List<JobEntity> findList(JobEntity job) {
        List a2 = Lists.newArrayList();
        try {
            Scheduler a3 = this.getScheduler();
            Iterator iterator = a3.getTriggerGroupNames().iterator();
            while (iterator.hasNext()) {
                GroupMatcher a4 = GroupMatcher.groupEquals((String)((String)iterator.next()));
                for (TriggerKey a5 : a3.getTriggerKeys(a4)) {
                    Trigger a6 = a3.getTrigger(a5);
                    if (!(a6 instanceof CronTriggerImpl)) continue;
                    a2.add(new JobEntity().convert(a3, (CronTriggerImpl)a6));
                }
            }
        }
        catch (Exception a7) {
            this.logger.error(FileUploadUtils.super("\u67b7\u8bf1\u4ead\u52ad\u525e\u886e\u5972\u8d25\uff44"), (Throwable)a7);
        }
        return a2;
    }

    public boolean startAll() {
        if (!ObjectUtils.toBoolean(D.super().get(F.super((Object)"\u001b\u007f\u001a~2"))).booleanValue()) {
            return false;
        }
        try {
            JobService jobService = this;
            jobService.scheduler.setStartupDelay(0);
            jobService.scheduler.start();
        }
        catch (Exception a2) {
            this.logger.error(FileUploadUtils.super("\u543c\u52fe\u5b96\u65bf\u566e\u5972\u8d25\uff44"), (Throwable)a2);
            return false;
        }
        return true;
    }

    @Transactional(readOnly=false)
    public void pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(F.super((Object)"/`\u0005w;"))).booleanValue()) {
            return;
        }
        job.setStatus("2");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().pauseJob(a3.getJobKey());
            jobService.getScheduler().pauseTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(FileUploadUtils.super("\u66d4\u5050\u8f99\u884a\u5972\u8d25\uff44"), a4);
        }
    }

    @Override
    public JobEntity get(JobEntity job) {
        JobEntity a2 = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)job.getJobName()) && StringUtils.isNotBlank((CharSequence)job.getJobGroup())) {
                TriggerKey a3 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
                Trigger a4 = this.getScheduler().getTrigger(a3);
                if (a4 instanceof CronTriggerImpl) {
                    a2 = new JobEntity().convert(this.getScheduler(), (CronTriggerImpl)a4);
                }
            }
        }
        catch (SchedulerException a5) {
            this.logger.error(F.super((Object)"\u83ec\u53ce\u5968\u8d2c\uff49"), (Throwable)a5);
        }
        return a2;
    }

    @Override
    @Transactional(readOnly=false)
    public void save(JobEntity job) {
        this.save(job, true);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(FileUploadUtils.super("/h\to'"))).booleanValue()) {
            return;
        }
        super.delete(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            Trigger a3 = this.getScheduler().getTrigger(a2);
            if (a3 != null) {
                JobService jobService = this;
                jobService.getScheduler().deleteJob(a3.getJobKey());
                jobService.getScheduler().unscheduleJob(a3.getKey());
                return;
            }
        }
        catch (SchedulerException a4) {
            throw new ServiceException(F.super((Object)"\u5279\u966d\u5979\u8d3d\uff58"), a4);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void save(JobEntity job, boolean isSaveToDb) {
        block6: {
            block7: {
                if (!ObjectUtils.toBoolean(D.super().get(FileUploadUtils.super("/h\to'"))).booleanValue()) {
                    return;
                }
                v0 = job;
                a = F.super(v0);
                a = F.super(v0, a);
                if (!isSaveToDb) break block6;
                if (!job.getIsNewRecord()) break block7;
                v1 = this;
                v2 = v1;
                super.insert(job);
                ** GOTO lbl17
            }
            super.update(job);
        }
        try {
            v2 = this;
lbl17:
            // 2 sources

            v2.getScheduler().addJob(a, true);
            v3 = this;
            if (this.getScheduler().getTrigger(a.getKey()) != null) {
                v3.getScheduler().rescheduleJob(a.getKey(), (Trigger)a);
            } else {
                v3.getScheduler().scheduleJob((Trigger)a);
            }
            if ("2".equals(job.getStatus())) {
                v4 = this;
                v4.getScheduler().pauseJob(a.getJobKey());
                v4.getScheduler().pauseTrigger(a.getKey());
                return;
            }
        }
        catch (Exception a) {
            throw new ServiceException(F.super((Object)"\u6da2\u52ae\u8bee\u520e\u4ea6\u52aa\u597b\u8d3d\uff58"), a);
        }
    }

    @Transactional(readOnly=false)
    public void resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(FileUploadUtils.super("/h\to'"))).booleanValue()) {
            return;
        }
        job.setStatus("0");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().resumeJob(a3.getJobKey());
            jobService.getScheduler().resumeTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(F.super((Object)"\u602d\u5905\u8f99\u885c\u5960\u8d3d\uff58"), a4);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler.getScheduler();
    }

    @Transactional(readOnly=false)
    public void runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(FileUploadUtils.super("/h\to'"))).booleanValue()) {
            return;
        }
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().triggerJob(a3.getJobKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(F.super((Object)"\u8fa3\u885f\u4e52\u6b3f\u596e\u8d3d\uff58"), a4);
        }
    }

    public boolean stopAll() {
        if (!ObjectUtils.toBoolean(D.super().get(FileUploadUtils.super("/h\to'"))).booleanValue()) {
            return false;
        }
        try {
            this.scheduler.stop();
        }
        catch (Exception a2) {
            this.logger.error(F.super((Object)"\u5051\u6b2e\u5ba6\u658b\u5679\u5961\u8d34\uff51"), (Throwable)a2);
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        block3: {
            try {
                if (this.getScheduler().isInStandbyMode() || !this.getScheduler().isStarted()) break block3;
                return true;
            }
            catch (Exception a2) {
                this.logger.error(FileUploadUtils.super("\u83f2\u53c1\u5bc8\u65e5\u563e\u72ba\u6048\u65f0\u5972\u8d25\uff44"), (Throwable)a2);
                return false;
            }
        }
        return false;
    }

    @PostConstruct
    private /* synthetic */ void initialize() throws Exception {
        JobEntity a2;
        if (Global.isTestProfileActive()) {
            return;
        }
        JobService jobService = this;
        jobService.scheduler = new SchedulerFactoryBean();
        jobService.scheduler.setAutoStartup(ObjectUtils.toBoolean((Object)Global.getProperty(F.super((Object)"?f*:4i)~\u0003`4u2m)"), "true")).booleanValue());
        jobService.scheduler.setStartupDelay(ObjectUtils.toInteger((Object)Global.getProperty(FileUploadUtils.super("m-T]s1v g#|\rc/a<"), F.super((Object)".i"))).intValue());
        if (!ObjectUtils.toBoolean(D.super().get(FileUploadUtils.super("/h\to'"))).booleanValue()) {
            this.scheduler.afterPropertiesSet();
            return;
        }
        JobService jobService2 = this;
        jobService2.scheduler.setQuartzProperties(F.super());
        JobService jobService3 = this;
        jobService2.scheduler.setDataSource((DataSource)((Object)jobService3.dataSource));
        jobService3.scheduler.afterPropertiesSet();
        if (jobService2.scheduler.isAutoStartup()) {
            this.scheduler.start();
        }
        JobEntity jobEntity = a2 = new JobEntity();
        jobEntity.setStatus("");
        for (JobEntity a3 : super.findList(jobEntity)) {
            if ("1".equals(a2.getStatus())) {
                this.delete(a2);
                continue;
            }
            try {
                this.save(a3, false);
            }
            catch (Exception a4) {
                this.logger.warn(a4.getMessage(), (Throwable)a4);
            }
        }
        try {
            ListenerManager a5;
            ListenerManager listenerManager = a5 = this.getScheduler().getListenerManager();
            a5.addJobListener((JobListener)new JobDetalListener(this.jobLogService));
            listenerManager.addTriggerListener((TriggerListener)new JobTriggerListener(this.jobLogService));
            a5.addSchedulerListener((SchedulerListener)new JobSchedulerListener(this.jobLogService));
            return;
        }
        catch (SchedulerException a6) {
            this.logger.error(F.super((Object)"\u4f01\u4e0b\u7681\u5438\u4ede\u4ef1\u5f44\u5e20\uff58"), (Throwable)a6);
            return;
        }
    }
}

