/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.v.d.D;
import com.jeesite.common.v.g.A;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import com.jeesite.modules.sys.utils.ValidCodeUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(ValidCodeUtils.super("\f6) \u0016"))).booleanValue()) {
            return this.renderResult("false", A.super((Object)"\u5f0d\u526e\u720b\u670c\u676a\u5f20\u657e\u6b4d\u52d6\u80c3\uff5f"));
        }
        this.jobService.save(job);
        return this.renderResult("true", ValidCodeUtils.super("\u4fb7\u5b00\u6273\u52d0\uff75"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(JobEntity jobEntity, Model model) {
        void job;
        void model2;
        model2.addAttribute(A.super((Object)")O\"e.] J'"), (Object)job);
        return ValidCodeUtils.super("(=\r&\u0004,\u0001`\u001e=\u000b~\u0000>\b\u001e\f=\u0019");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(D.super().get(A.super((Object)"&G\u0003Q<"))).booleanValue()) {
            return this.renderResult("false", ValidCodeUtils.super("\u5f27\u521f\u7221\u677d\u6740\u5f51\u6554\u6b3c\u52fc\u80b2\uff75"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", A.super((Object)"\u507c\u6b22\u5bba\u65b6\u5641\u5978\u8d1b\uff5f"));
        }
        return this.renderResult("true", ValidCodeUtils.super("\u500d\u6b08\u5bcb\u659c\u5630\u6273\u52d0\uff75"));
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a2 = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a2 = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a2 != null) {
                throw new ValidationException(A.super((Object)"\u544e\u79d0\u538a\u7ee4\u544d\u5ddb\u7e86\u5b66\u5776"));
            }
        }
        if (a2 == null) {
            a2 = new JobEntity();
        }
        return a2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a2 = new StringBuilder();
        try {
            void a3;
            CronExpression a4 = new CronExpression(cron);
            if (num <= 0) {
                a2.append(A.super((Object)"`1O.\u8848\u8ffe\u5f26\u6b2a\u7850\u305c"));
                return this.renderResult("true", a2.toString());
            }
            a2.append(ValidCodeUtils.super("V(]\u674f\u8fa5") + num + A.super((Object)"\u6b02\u8f93\u886c\u65b6\u95d4\uff5a\u0015fN`"));
            Date a5 = new Date();
            boolean bl = false;
            void v0 = a3;
            while (v0 <= num) {
                if ((a5 = a4.getTimeAfter(a5)) == null) {
                    return this.renderResult("true", a2.toString());
                }
                a2.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a5)).append(ValidCodeUtils.super("Vw\u0001=J")).toString());
                v0 = ++a3;
            }
            return this.renderResult("true", a2.toString());
        }
        catch (ParseException a6) {
            return this.renderResult("false", new StringBuilder().insert(0, ValidCodeUtils.super("\u0011\u001b>\u0004\u8839\u8fd4\u5f57\u957a\u8ba0\uff6e")).append(a6.getMessage()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity jobEntity) {
        void job;
        JobController jobController = this;
        jobController.jobService.delete((JobEntity)job);
        return jobController.renderResult("true", A.super((Object)"\u5260\u964d\u6259\u52a1\uff5f"));
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        List a2 = this.jobService.findList(job);
        a2 = ListUtils.listOrderBy(a2, (String)orderBy);
        return a2;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(ValidCodeUtils.super("\f6) \u0016"))).booleanValue()) {
            return this.renderResult("false", A.super((Object)"\u5f0d\u526e\u720b\u670c\u676a\u5f20\u657e\u6b4d\u52d6\u80c3\uff5f"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", ValidCodeUtils.super("\u8fba\u881d\u4e6a\u6b79\u6273\u52d0\uff75"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(A.super((Object)"&G\u0003Q<"))).booleanValue()) {
            return this.renderResult("false", ValidCodeUtils.super("\u5f27\u521f\u7221\u677d\u6740\u5f51\u6554\u6b3c\u52fc\u80b2\uff75"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", A.super((Object)"\u66c2\u507c\u8f90\u8865\u6259\u52a1\uff5f"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a2;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(ValidCodeUtils.super("\u0000\"8$\u00046\n!\u0013"), (Object)a2);
        return A.super((Object)"\u0002L'W.]+\u00114L!\u000f*O\"e M*");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(D.super().get(ValidCodeUtils.super("\f6) \u0016"))).booleanValue()) {
            return this.renderResult("false", A.super((Object)"\u5f0d\u526e\u720b\u670c\u676a\u5f20\u657e\u6b4d\u52d6\u80c3\uff5f"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", ValidCodeUtils.super("\u6008\u595c\u8fba\u8814\u6273\u52d0\uff75"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(D.super().get(A.super((Object)"&G\u0003Q<"))).booleanValue()) {
            return this.renderResult("false", ValidCodeUtils.super("\u5f27\u521f\u7221\u677d\u6740\u5f51\u6554\u6b3c\u52fc\u80b2\uff75"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", A.super((Object)"\u540f\u52e8\u5bba\u65b6\u5641\u5978\u8d1b\uff5f"));
        }
        return this.renderResult("true", ValidCodeUtils.super("\u547e\u52c2\u5bcb\u659c\u5630\u6273\u52d0\uff75"));
    }
}

