/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.CrudService;
import com.jeesite.modules.sys.dao.DictTypeDao;
import com.jeesite.modules.sys.entity.DictType;
import com.jeesite.modules.sys.service.DictDataService;
import com.jeesite.modules.sys.utils.DictUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DictTypeService
extends CrudService<DictTypeDao, DictType> {
    @Autowired
    private DictDataService dictDataService;

    @Transactional(readOnly=false)
    public void save(DictType dictType, DictType old) {
        DictType dictType2 = dictType;
        super.save(dictType2);
        if (!StringUtils.equals((CharSequence)dictType2.getDictType(), (CharSequence)old.getDictType())) {
            this.dictDataService.updateDictTypeByDictType(dictType.getDictType(), old.getDictType());
        }
        DictUtils.clearDictCache();
    }

    @Override
    public Page<DictType> findPage(Page<DictType> page, DictType dictType) {
        return super.findPage(page, dictType);
    }

    @Override
    @Transactional(readOnly=false)
    public void updateStatus(DictType dictType) {
        super.updateStatus(dictType);
        DictUtils.clearDictCache();
    }

    @Override
    public DictType get(DictType dictType) {
        if (dictType == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)dictType.getDictType())) {
            DictType a2 = new DictType();
            a2.setDictType(dictType.getDictType());
            return ((DictTypeDao)this.dao).getByEntity(a2);
        }
        return super.get(dictType);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(DictType dictType) {
        DictTypeService dictTypeService = this;
        super.delete(dictType);
        dictTypeService.dictDataService.deleteByDictType(dictType.getDictType());
        DictUtils.clearDictCache();
    }
}

