/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.service;

import com.beust.jcommander.internal.Lists;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.RoutingDataSource;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.y.g.k;
import com.jeesite.common.y.m.c;
import com.jeesite.modules.job.dao.JobDao;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.listener.JobDetalListener;
import com.jeesite.modules.job.listener.JobSchedulerListener;
import com.jeesite.modules.job.listener.JobTriggerListener;
import com.jeesite.modules.job.service.JobLogService;
import com.jeesite.modules.job.y.H;
import com.jeesite.modules.sys.web.ValidCodeController;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.quartz.JobListener;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@DependsOn(value={"dbUpgrade"})
@Transactional(readOnly=true)
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobService
extends CrudService<JobDao, JobEntity> {
    private SchedulerFactoryBean scheduler;
    @Autowired
    private JobLogService jobLogService;
    @Autowired
    private RoutingDataSource dataSource;

    @Override
    public JobEntity get(JobEntity job) {
        JobEntity a2 = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)job.getJobName()) && StringUtils.isNotBlank((CharSequence)job.getJobGroup())) {
                TriggerKey a3 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
                Trigger a4 = this.getScheduler().getTrigger(a3);
                if (a4 instanceof CronTriggerImpl) {
                    a2 = new JobEntity().convert(this.getScheduler(), (CronTriggerImpl)a4);
                }
            }
        }
        catch (SchedulerException a5) {
            this.logger.error(c.const("\u8383\u538e\u5905\u8d7d\uff35"), (Throwable)a5);
        }
        return a2;
    }

    @Transactional(readOnly=false)
    public void runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(ValidCodeController.const("k\u000eG\u000fo"))).booleanValue()) {
            return;
        }
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().triggerJob(a3.getJobKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(c.const("\u8fe4\u8814\u4e34\u6b79\u5905\u8d7d\uff35"), a4);
        }
    }

    @Transactional(readOnly=false)
    public void pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(ValidCodeController.const("k\u000eG\u000fo"))).booleanValue()) {
            return;
        }
        job.setStatus("2");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().pauseJob(a3.getJobKey());
            jobService.getScheduler().pauseTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(c.const("\u66b6\u5004\u8fe4\u8814\u5905\u8d7d\uff35"), a4);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler.getScheduler();
    }

    @Override
    public List<JobEntity> findList(JobEntity job) {
        List a2 = Lists.newArrayList();
        try {
            Scheduler a3 = this.getScheduler();
            Iterator iterator = a3.getTriggerGroupNames().iterator();
            while (iterator.hasNext()) {
                GroupMatcher a4 = GroupMatcher.groupEquals((String)((String)iterator.next()));
                for (TriggerKey a5 : a3.getTriggerKeys(a4)) {
                    Trigger a6 = a3.getTrigger(a5);
                    if (!(a6 instanceof CronTriggerImpl)) continue;
                    a2.add(new JobEntity().convert(a3, (CronTriggerImpl)a6));
                }
            }
        }
        catch (Exception a7) {
            this.logger.error(ValidCodeController.const("\u67e8\u8b82\u4ef6\u52c1\u521a\u8808\u593c\u8d45\uff0c"), (Throwable)a7);
        }
        return a2;
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(c.const("R6~7V"))).booleanValue()) {
            return;
        }
        super.delete(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            Trigger a3 = this.getScheduler().getTrigger(a2);
            if (a3 != null) {
                JobService jobService = this;
                jobService.getScheduler().deleteJob(a3.getJobKey());
                jobService.getScheduler().unscheduleJob(a3.getKey());
                return;
            }
        }
        catch (SchedulerException a4) {
            throw new ServiceException(ValidCodeController.const("\u522d\u9604\u593c\u8d45\uff0c"), a4);
        }
    }

    @Transactional(readOnly=false)
    public void resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(c.const("R6~7V"))).booleanValue()) {
            return;
        }
        job.setStatus("0");
        super.updateStatus(job);
        try {
            TriggerKey a2 = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
            JobService jobService = this;
            Trigger a3 = jobService.getScheduler().getTrigger(a2);
            jobService.getScheduler().resumeJob(a3.getJobKey());
            jobService.getScheduler().resumeTrigger(a3.getKey());
            return;
        }
        catch (SchedulerException a4) {
            throw new ServiceException(ValidCodeController.const("\u606f\u596d\u8fdd\u882c\u593c\u8d45\uff0c"), a4);
        }
    }

    public boolean startAll() {
        if (!ObjectUtils.toBoolean(k.const().get(c.const("R6~7V"))).booleanValue()) {
            return false;
        }
        try {
            JobService jobService = this;
            jobService.scheduler.setStartupDelay(0);
            jobService.scheduler.start();
        }
        catch (Exception a2) {
            this.logger.error(ValidCodeController.const("\u544f\u52a5\u5bfa\u65fb\u5608\u593c\u8d45\uff0c"), (Throwable)a2);
            return false;
        }
        return true;
    }

    @PostConstruct
    private /* synthetic */ void const() throws Exception {
        JobEntity jobEntity;
        JobService a2;
        if (Global.isTestProfileActive()) {
            return;
        }
        JobService jobService = a2;
        jobService.scheduler = new SchedulerFactoryBean();
        jobService.scheduler.setAutoStartup(ObjectUtils.toBoolean((Object)Global.getProperty(c.const("^7VvU-@7g,U*@-D"), "true")).booleanValue());
        jobService.scheduler.setStartupDelay(ObjectUtils.toInteger((Object)Global.getProperty(ValidCodeController.const("\nb\u0002#\u0013y\u0001\u007f\u0014x\u0010I\u0005a\u0001t"), c.const("n\u0004"))).intValue());
        if (!ObjectUtils.toBoolean(k.const().get(ValidCodeController.const("k\u000eG\u000fo"))).booleanValue()) {
            a2.scheduler.afterPropertiesSet();
            return;
        }
        JobService jobService2 = a2;
        jobService2.scheduler.setQuartzProperties(H.const());
        JobService jobService3 = a2;
        jobService2.scheduler.setDataSource((DataSource)((Object)jobService3.dataSource));
        jobService3.scheduler.afterPropertiesSet();
        if (jobService2.scheduler.isAutoStartup()) {
            a2.scheduler.start();
        }
        JobEntity jobEntity2 = jobEntity = new JobEntity();
        jobEntity2.setStatus("");
        ListenerManager listenerManager = super.findList(jobEntity2).iterator();
        while (listenerManager.hasNext()) {
            JobEntity jobEntity3 = listenerManager.next();
            if ("1".equals(jobEntity.getStatus())) {
                a2.delete(jobEntity);
                continue;
            }
            try {
                a2.save(jobEntity3, false);
            }
            catch (Exception exception) {
                a2.logger.warn(exception.getMessage(), (Throwable)exception);
            }
        }
        try {
            ListenerManager listenerManager2 = listenerManager = a2.getScheduler().getListenerManager();
            listenerManager.addJobListener((JobListener)new JobDetalListener(a2.jobLogService));
            listenerManager2.addTriggerListener((TriggerListener)new JobTriggerListener(a2.jobLogService));
            listenerManager.addSchedulerListener((SchedulerListener)new JobSchedulerListener(a2.jobLogService));
            return;
        }
        catch (SchedulerException schedulerException) {
            a2.logger.error(c.const("\u4f68\u4e42\u76e5\u5474\u4ebf\u4eae\u5f36\u5e60\uff35"), (Throwable)schedulerException);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Transactional(readOnly=false)
    public void save(JobEntity job, boolean isSaveToDb) {
        block6: {
            block7: {
                if (!ObjectUtils.toBoolean(k.const().get(ValidCodeController.const("k\u000eG\u000fo"))).booleanValue()) {
                    return;
                }
                v0 = job;
                a = H.const(v0);
                a = H.const(v0, a);
                if (!isSaveToDb) break block6;
                if (!job.getIsNewRecord()) break block7;
                v1 = this;
                v2 = v1;
                super.insert(job);
                ** GOTO lbl17
            }
            super.update(job);
        }
        try {
            v2 = this;
lbl17:
            // 2 sources

            v2.getScheduler().addJob(a, true);
            v3 = this;
            if (this.getScheduler().getTrigger(a.getKey()) != null) {
                v3.getScheduler().rescheduleJob(a.getKey(), (Trigger)a);
            } else {
                v3.getScheduler().scheduleJob((Trigger)a);
            }
            if ("2".equals(job.getStatus())) {
                v4 = this;
                v4.getScheduler().pauseJob(a.getJobKey());
                v4.getScheduler().pauseTrigger(a.getKey());
                return;
            }
        }
        catch (Exception a) {
            throw new ServiceException(c.const("\u6dcf\u52f8\u8b95\u524a\u4ecf\u52f9\u5905\u8d7d\uff35"), a);
        }
    }

    public boolean isRunning() {
        block3: {
            try {
                if (this.getScheduler().isInStandbyMode() || !this.getScheduler().isStarted()) break block3;
                return true;
            }
            catch (Exception a2) {
                this.logger.error(ValidCodeController.const("\u83ba\u53b6\u5b97\u6596\u5665\u72d6\u600c\u6596\u593c\u8d45\uff0c"), (Throwable)a2);
                return false;
            }
        }
        return false;
    }

    @Override
    @Transactional(readOnly=false)
    public void save(JobEntity job) {
        this.save(job, true);
    }

    public boolean stopAll() {
        if (!ObjectUtils.toBoolean(k.const().get(c.const("R6~7V"))).booleanValue()) {
            return false;
        }
        try {
            this.scheduler.stop();
        }
        catch (Exception a2) {
            this.logger.error(ValidCodeController.const("\u503c\u6b6f\u5bfa\u65fb\u5608\u593c\u8d45\uff0c"), (Throwable)a2);
            return false;
        }
        return true;
    }
}

