/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.BaseService;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Config;
import com.jeesite.modules.sys.service.ConfigService;
import com.jeesite.modules.sys.utils.ValidCodeUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/config"})
public class ConfigController
extends BaseController {
    @Autowired
    private ConfigService configService;

    @ModelAttribute
    public Config get(String id, boolean isNewRecord) {
        return (Config)this.configService.get(id, isNewRecord);
    }

    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"list"})
    public String list(Config config, Model model) {
        return ValidCodeUtils.const("[xRbZrE8EnE8UxXq_pz~Ec");
    }

    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Config> listData(Config config, HttpServletRequest request, HttpServletResponse response) {
        return this.configService.findPage(new Page<Config>(request, response), config);
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Config config, HttpServletRequest request) {
        Config a2 = (Config)super.getWebDataBinderSource(request);
        if (a2 != null && "1".equals(a2.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", BaseService.const("\u8dd0\u674a\u6497\u4f55\uff56\u53e3\u6753\u8d8c\u7efd\u7ba8\u745c\u5451\u6217\u80f4\u4fb4\u6530\u7ca1\u7ed6\u652a\u6367\uff5b"));
        }
        if (!config.getCurrentUser().isSuperAdmin()) {
            Config config2 = config;
            config2.setConfigName(a2.getConfigName());
            config2.setConfigKey(a2.getConfigKey());
        }
        this.configService.save(config);
        return this.renderResult("true", ValidCodeUtils.const("\u4fca\u5b6e\u53d5\u6546\u6207\u52a9\uff16"));
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Config config, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(BaseService.const("3z\tp)")))) {
            return this.renderResult("false", ValidCodeUtils.const("\u8d9d\u6775\u64da\u4f6a\uff1b_denE\u9749\u6ce3\u53d5\u6546\uff16"));
        }
        Config a2 = (Config)super.getWebDataBinderSource(request);
        if (a2 != null && "1".equals(a2.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", BaseService.const("\u8dd0\u674a\u6497\u4f55\uff56\u53e3\u6753\u8d8c\u7efd\u7ba8\u745c\u5451\u6217\u80f4\u4fb4\u6530\u7ca1\u7ed6\u652a\u6367\uff5b"));
        }
        this.configService.delete(config);
        return this.renderResult("true", ValidCodeUtils.const("\u5237\u9652\u53d5\u6546\u6207\u52a9\uff16"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"form"})
    public String form(Config config, Model model) {
        void config2;
        void model2;
        model2.addAttribute(BaseService.const("j5g<`="), (Object)config2);
        return ValidCodeUtils.const("[xRbZrE8EnE8UxXq_ppxDz");
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"checkConfigKey"})
    @ResponseBody
    public String checkConfigKey(String oldConfigKey, String configKey) {
        Config a2 = new Config();
        String string = configKey;
        a2.setConfigKey(string);
        if (string != null && configKey.equals(oldConfigKey)) {
            return "true";
        }
        if (configKey != null && this.configService.findCount(a2) == 0L) {
            return "true";
        }
        return "false";
    }
}

