/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.query.QueryOrder;
import com.jeesite.common.web.BaseController;
import com.jeesite.common.y.m.k;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a2 = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a2 = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a2 != null) {
                throw new ValidationException(QueryOrder.const("\u5458\u7991\u539f\u7ea5\u5458\u5d93\u7e9a\u5b39\u577d"));
            }
        }
        if (a2 == null) {
            a2 = new JobEntity();
        }
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(JobEntity jobEntity, Model model) {
        void job;
        void model2;
        model2.addAttribute(BaseEntity.const("m\be\"i\u0013n\u0013~"), (Object)job);
        return QueryOrder.const("8\u000e1\u00149\u0004&N?\u000e7N?\u000e7':\u00138");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(BaseEntity.const("a\tM\be"))).booleanValue()) {
            return this.renderResult("false", QueryOrder.const("\u5f06\u522c\u721d\u674d\u677f\u5f61\u656b\u6b05\u52ca\u809c\uff54"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", BaseEntity.const("\u6685\u503b\u8fd7\u882b\u6217\u52f8\uff06"));
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        List a2 = this.jobService.findList(job);
        a2 = ListUtils.listOrderBy(a2, (String)orderBy);
        return a2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity jobEntity) {
        void job;
        JobController jobController = this;
        jobController.jobService.delete((JobEntity)job);
        return jobController.renderResult("true", QueryOrder.const("\u5275\u9605\u6245\u52fe\uff54"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(k.const().get(BaseEntity.const("a\tM\be"))).booleanValue()) {
            return this.renderResult("false", QueryOrder.const("\u5f06\u522c\u721d\u674d\u677f\u5f61\u656b\u6b05\u52ca\u809c\uff54"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", BaseEntity.const("\u503b\u6b65\u5bfd\u65f1\u560f\u5936\u8d42\uff06"));
        }
        return this.renderResult("true", QueryOrder.const("\u503d\u6b37\u5bfb\u65a3\u5609\u6245\u52fe\uff54"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(k.const().get(BaseEntity.const("a\tM\be"))).booleanValue()) {
            return this.renderResult("false", QueryOrder.const("\u5f06\u522c\u721d\u674d\u677f\u5f61\u656b\u6b05\u52ca\u809c\uff54"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", BaseEntity.const("\u5448\u52af\u5bfd\u65f1\u560f\u5936\u8d42\uff06"));
        }
        return this.renderResult("true", QueryOrder.const("\u544e\u52fd\u5bfb\u65a3\u5609\u6245\u52fe\uff54"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(BaseEntity.const("a\tM\be"))).booleanValue()) {
            return this.renderResult("false", QueryOrder.const("\u5f06\u522c\u721d\u674d\u677f\u5f61\u656b\u6b05\u52ca\u809c\uff54"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", BaseEntity.const("\u6065\u596a\u8fd7\u882b\u6217\u52f8\uff06"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(QueryOrder.const("3\u000f\u001f\u000e7"))).booleanValue()) {
            return this.renderResult("false", BaseEntity.const("\u5f54\u522a\u724f\u674b\u672d\u5f67\u6539\u6b03\u5298\u809a\uff06"));
        }
        this.jobService.save(job);
        return this.renderResult("true", QueryOrder.const("\u4f88\u5b39\u6245\u52fe\uff54"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a2 = new StringBuilder();
        try {
            void a3;
            CronExpression a4 = new CronExpression(cron);
            if (num <= 0) {
                a2.append(QueryOrder.const("\"'\u000e;\u8809\u8feb\u5f6e\u6b36\u780f\u3057"));
                return this.renderResult("true", a2.toString());
            }
            a2.append(BaseEntity.const(";\u00179\u6767\u8fd6") + num + QueryOrder.const("\u6b40\u8f85\u882d\u65a3\u9595\uff4f]z\u0011k"));
            Date a5 = new Date();
            boolean bl = false;
            void v0 = a3;
            while (v0 <= num) {
                if ((a5 = a4.getTimeAfter(a5)) == null) {
                    return this.renderResult("true", a2.toString());
                }
                a2.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a5)).append(BaseEntity.const(";He\u00159")).toString());
                v0 = ++a3;
            }
            return this.renderResult("true", a2.toString());
        }
        catch (ParseException a6) {
            return this.renderResult("false", new StringBuilder().insert(0, BaseEntity.const("$u\bi\u880f\u8fb9\u5f68\u951e\u8b88\uff1d")).append(a6.getMessage()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a2;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(QueryOrder.const("<\u0012\u0007\u0014;\u000f<\u000f2"), (Object)a2);
        return BaseEntity.const("j\bc\u0012k\u0002tHm\beHm\be+n\u0014s");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(k.const().get(QueryOrder.const("3\u000f\u001f\u000e7"))).booleanValue()) {
            return this.renderResult("false", BaseEntity.const("\u5f54\u522a\u724f\u674b\u672d\u5f67\u6539\u6b03\u5298\u809a\uff06"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", QueryOrder.const("\u8f85\u882d\u4e55\u6b40\u6245\u52fe\uff54"));
    }
}

