/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.cache;

import com.jeesite.common.cache.d;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.shiro.z.B;
import java.util.HashSet;
import java.util.Set;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.SysInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtils {
    private static Logger logger = LoggerFactory.getLogger(CacheUtils.class);
    private static final String SYS_CACHE = "sysCache";

    public static void removeCache(String cacheName) {
        d.ALLATORIxDEMO().ALLATORIxDEMO(cacheName);
        logger.info(FileSystem.ALLATORIxDEMO("!)>#%)\u0010-0$6vs7."), (Object)cacheName);
    }

    public static <V> V get(String cacheName, String key) {
        return (V)CacheUtils.getCache(cacheName).get(key);
    }

    public static <V> V get(String key) {
        return (V)CacheUtils.get(SYS_CACHE, key);
    }

    public static <V> void put(String cacheName, String key, V value, long timeToLiveInSeconds) {
        CacheUtils.getCache(cacheName).ALLATORIxDEMO(key, value, timeToLiveInSeconds);
    }

    public static void remove(String key) {
        CacheUtils.remove(SYS_CACHE, key);
    }

    public static <V> void put(String cacheName, String key, V value) {
        CacheUtils.getCache(cacheName).put(key, value);
    }

    public static <K, V> B<K, V> getCache(String cacheName) {
        B a = d.ALLATORIxDEMO().ALLATORIxDEMO(cacheName);
        if (a == null) {
            throw new RuntimeException(new StringBuilder().insert(0, SysInfo.ALLATORIxDEMO("\u5f0b\u521f\u7ca3\u7e8d\u4e75\u6cf3\u6751\u5bc8\u4e11\u204e")).append(cacheName).append(FileSystem.ALLATORIxDEMO("\u2051\u8f8a\u4e66\u7f40\u5b14\u3051")).toString());
        }
        return a;
    }

    public static void removeByKeyPrefix(String cacheName, String keyPrefix) {
        String a = keyPrefix;
        B a2 = CacheUtils.getCache(cacheName);
        Set a3 = a2.keys();
        HashSet a4 = SetUtils.newHashSet();
        for (String a5 : a3) {
            if (a != null && !StringUtils.startsWith((CharSequence)a5, (CharSequence)a)) continue;
            a2.remove(a5);
            a4.add(a5);
        }
        logger.info(SysInfo.ALLATORIxDEMO(" =?7$=\u0010!\u0019=+\b =41*br#/xofr#/"), (Object)cacheName, (Object)a4);
    }

    public static void remove(String cacheName, String key) {
        CacheUtils.getCache(cacheName).remove(key);
    }

    public static void put(String key, Object value, long timeToLiveInSeconds) {
        CacheUtils.put(SYS_CACHE, key, value, timeToLiveInSeconds);
    }

    public static void removeByKeyPrefix(String keyPrefix) {
        CacheUtils.removeByKeyPrefix(SYS_CACHE, keyPrefix);
    }

    public static void clearCache() {
        int n;
        String a = Global.getConfig(FileSystem.ALLATORIxDEMO(" <!%=+}/2/;)}/?)2>\u001d->) "));
        if (StringUtils.isBlank((CharSequence)a)) {
            return;
        }
        String[] stringArray = a.split(SysInfo.ALLATORIxDEMO("~"));
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            CacheUtils.removeCache(stringArray[n++]);
            n3 = n;
        }
    }

    public static void clear(String cacheName) {
        CacheUtils.getCache(cacheName).clear();
        logger.info(FileSystem.ALLATORIxDEMO("0 6-!vs7."), (Object)cacheName);
    }

    public static Set<String> getCacheNames() {
        return d.ALLATORIxDEMO().ALLATORIxDEMO();
    }

    public static void put(String key, Object value) {
        CacheUtils.put(SYS_CACHE, key, value);
    }

    public static <V> V get(String cacheName, String key, V defaultValue) {
        String a = CacheUtils.get(cacheName, key);
        if (a != null) {
            return (V)a;
        }
        return defaultValue;
    }

    public static <V> V get(String key, V defaultValue) {
        V a = CacheUtils.get(key);
        if (a != null) {
            return a;
        }
        return defaultValue;
    }
}

