/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.xa.DruidXADataSource;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.datasource.DataSourceHolder;
import com.jeesite.common.datasource.z.d;
import com.jeesite.common.j2cache.cache.support.redis.ConfigureNotifyKeyspaceEventsAction;
import com.jeesite.common.lang.StringUtils;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.hyperic.sigar.DirUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jta.atomikos.AtomikosDataSourceBean;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource
extends AbstractRoutingDataSource {
    private Map<Object, Object> targetDataSources;
    private static final Logger logger = LoggerFactory.getLogger(RoutingDataSource.class);
    private Object defaultTargetDataSource;

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources = targetDataSources;
        super.setTargetDataSources(this.targetDataSources);
    }

    protected Object determineCurrentLookupKey() {
        return DataSourceHolder.getDataSourceName();
    }

    public void removeTargetDataSource(String dataSourceName) {
        this.targetDataSources.remove(dataSourceName);
        logger.debug(new StringBuilder().insert(0, ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u0006J9@\"Jt[5]3J \u000f0N Nt\\;Z&L1\u0015t")).append(dataSourceName).toString());
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        if (defaultTargetDataSource == null) {
            logger.warn(DirUsage.ALLATORIxDEMO("qlV)FlDhWeV)VhPnG}\u0002mC}C)QfW{Al\u0002`Q)L|Ne\f"));
            return;
        }
        this.defaultTargetDataSource = defaultTargetDataSource;
        super.setDefaultTargetDataSource(this.defaultTargetDataSource);
        logger.debug(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u0007J \u000f0J2N!C \u000f N&H1[tK5[5\u000f'@!]7Jt\\!L7J'\\z"));
    }

    public static DataSource createDataSource(String dataSourceName) throws SQLException {
        boolean a = Global.getPropertyToBoolean(DirUsage.ALLATORIxDEMO("cFkA'H}C'GgCkNlF"), "false");
        return RoutingDataSource.createDataSource(dataSourceName, a);
    }

    public RoutingDataSource() throws SQLException {
        RoutingDataSource routingDataSource = this;
        routingDataSource.setTargetDataSources(MapUtils.newConcurrentMap());
    }

    public void initJeeSiteTargetDataSource() {
        Object a;
        try {
            a = RoutingDataSource.createDataSource("default");
            this.setDefaultTargetDataSource(a);
        }
        catch (SQLException a2) {
            logger.error(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("f:F \u000f N&H1[tK5[5\u000f'@!]7JtJ&];]n\u000f0J2N!C "), (Throwable)a2);
        }
        a = Global.getProperty(DirUsage.ALLATORIxDEMO("cFkA'FhVhqfW{AllhOlQ"));
        if (StringUtils.isNotBlank((CharSequence)a)) {
            int n;
            String[] stringArray = StringUtils.split((String)a, (String)ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("x"));
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String a3 = stringArray[n];
                try {
                    a3 = StringUtils.trim((String)a3);
                    DataSource a4 = RoutingDataSource.createDataSource(a3);
                    this.addTargetDataSource(a3, a4);
                }
                catch (SQLException a5) {
                    logger.error(new StringBuilder().insert(0, DirUsage.ALLATORIxDEMO("kgK}\u0002}C{ElV)FhVh\u0002zM|PjG)G{PfP3\u0002")).append(a3).toString(), (Throwable)a5);
                }
                n3 = ++n;
            }
        }
    }

    public static DataSource createDataSource(String dataSourceName, boolean isJta) throws SQLException {
        DruidXADataSource druidXADataSource;
        String a;
        if (StringUtils.isBlank((CharSequence)dataSourceName)) {
            dataSourceName = "default";
        }
        String a2 = ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("E0M7");
        if (!"default".equals(dataSourceName)) {
            a2 = new StringBuilder().insert(0, a2).append(".").append(dataSourceName).toString();
        }
        if (StringUtils.isBlank((CharSequence)(a = Global.getProperty(new StringBuilder().insert(0, a2).append(DirUsage.ALLATORIxDEMO("\f}[yG")).toString()))) && !ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("E0M7").equals(a2)) {
            a2 = DirUsage.ALLATORIxDEMO("cFkA");
            a = Global.getProperty(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("z[-_1")).toString());
        }
        if (StringUtils.isBlank((CharSequence)a)) {
            return null;
        }
        DruidXADataSource a3 = null;
        (isJta ? (a3 = new DruidXADataSource()) : (a3 = new DruidDataSource())).setName(dataSourceName);
        DruidXADataSource druidXADataSource2 = a3;
        druidXADataSource2.setDriverClassName(Global.getProperty(a2 + DirUsage.ALLATORIxDEMO("\fmP`TlP")));
        a3.setUrl(Global.getProperty(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u0001!]8")).toString()));
        druidXADataSource2.setUsername(Global.getProperty(new StringBuilder().insert(0, a2).append(DirUsage.ALLATORIxDEMO("\f|QlPgCdG")).toString()));
        druidXADataSource2.setPassword(Global.getProperty(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("z_5\\'X;]0")).toString()));
        CharSequence[] charSequenceArray = new CharSequence[3];
        charSequenceArray[0] = a3.getDriverClassName();
        charSequenceArray[1] = a3.getUrl();
        charSequenceArray[2] = a3.getUsername();
        if (StringUtils.isAnyBlank((CharSequence[])charSequenceArray)) {
            a3.close();
            return null;
        }
        String a4 = Global.getProperty(new StringBuilder().insert(0, a2).append(DirUsage.ALLATORIxDEMO("'VlQ}qxN")).toString());
        DruidXADataSource druidXADataSource3 = a3;
        if (StringUtils.isNotBlank((CharSequence)a4)) {
            druidXADataSource3.setTestWhileIdle(true);
            DruidXADataSource druidXADataSource4 = a3;
            druidXADataSource = druidXADataSource4;
            druidXADataSource4.setValidationQuery(a4);
        } else {
            druidXADataSource3.setTestWhileIdle(false);
            logger.warn(new StringBuilder().insert(0, ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u5f07\u5262t")).append(a2).append(DirUsage.ALLATORIxDEMO("\f}GzVZSe\u0002\u6723\u8b9c\u7f67\uff2e\u7cf2\u7efd\u5c0f\u4e2f\u4f13\u8ff9\u8845\u7a58\u95fb\u8ffc\u63ac\u68e2\u67ec\u3020")).toString());
            druidXADataSource = a3;
        }
        druidXADataSource.setInitialSize(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u0001$@;CzF:F ")).toString(), "1").intValue());
        DruidXADataSource druidXADataSource5 = a3;
        druidXADataSource5.setMinIdle(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(DirUsage.ALLATORIxDEMO("\fyMfN'O`L@FeG")).toString(), "3").intValue());
        druidXADataSource5.setMaxActive(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("z_;@8\u00019N,n7[=Y1")).toString(), DirUsage.ALLATORIxDEMO(";\u0012")).intValue());
        druidXADataSource5.setMaxWait((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("z_;@8\u00019N,x5F ")).toString(), DirUsage.ALLATORIxDEMO("\u00149\u00129\u0012")).intValue());
        druidXADataSource5.setTestOnBorrow(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u0001$@;Cz[1\\ `:m;]&@#")).toString(), "false").booleanValue());
        druidXADataSource5.setTestOnReturn(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(DirUsage.ALLATORIxDEMO("'RfMe\f}GzVFL[G}W{L")).toString(), "false").booleanValue());
        druidXADataSource5.setTimeBetweenEvictionRunsMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("z_;@8\u0001 F9J\u0016J X1J:j\"F7[=@:}!A'b=C8F'")).toString(), DirUsage.ALLATORIxDEMO("\u00149\u00129\u0012")).intValue());
        druidXADataSource5.setMinEvictableIdleTimeMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u0001$@;CzB=A\u0011Y=L N6C1f0C1{=B1b=C8F'")).toString(), DirUsage.ALLATORIxDEMO("\u0013;\u00129\u00129\u0012")).intValue());
        druidXADataSource5.setMaxEvictableIdleTimeMillis((long)Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u0001$@;CzB5W\u0011Y=L N6C1f0C1{=B1b=C8F'")).toString(), DirUsage.ALLATORIxDEMO("\u00131\u00129\u00129\u0012")).intValue());
        druidXADataSource5.setRemoveAbandoned(Global.getPropertyToBoolean(new StringBuilder().insert(0, a2).append(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("z_;@8\u0001&J9@\"J\u0015M5A0@:J0")).toString(), "true").booleanValue());
        druidXADataSource5.setRemoveAbandonedTimeout(Global.getPropertyToInteger(new StringBuilder().insert(0, a2).append(DirUsage.ALLATORIxDEMO("'RfMe\f{GdM\u007fGH@hLmMgGmv`OlM|V")).toString(), ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\u001de\u001fd")).intValue());
        if (DirUsage.ALLATORIxDEMO("fPhAeG").equals(a)) {
            DruidXADataSource druidXADataSource6 = a3;
            druidXADataSource6.setPoolPreparedStatements(true);
            druidXADataSource6.setMaxPoolPreparedStatementPerConnectionSize(druidXADataSource6.getMaxActive());
        }
        DruidXADataSource druidXADataSource7 = a3;
        druidXADataSource7.setFilters(ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("\\ N "));
        druidXADataSource7.getProxyFilters().add(new d(a2));
        a3.init();
        if (druidXADataSource7 instanceof XADataSource) {
            AtomikosDataSourceBean a5 = new AtomikosDataSourceBean();
            a5.setXaDataSource((XADataSource)a3);
            AtomikosDataSourceBean atomikosDataSourceBean = a5;
            a5.setUniqueResourceName(a3.getName());
            atomikosDataSourceBean.setMinPoolSize(0);
            atomikosDataSourceBean.setMaxPoolSize(a3.getMaxActive());
            return atomikosDataSourceBean;
        }
        return a3;
    }

    public void addTargetDataSource(String dataSourceName, DataSource dataSource) {
        if (dataSource == null) {
            logger.warn(new StringBuilder().insert(0, DirUsage.ALLATORIxDEMO("HFm\u0002}C{ElV)FhVh\u0002zM|PjG)Kz\u0002gWeN3\u0002")).append(dataSourceName).toString());
            return;
        }
        this.targetDataSources.put(dataSourceName, dataSource);
        logger.debug(new StringBuilder().insert(0, ConfigureNotifyKeyspaceEventsAction.ALLATORIxDEMO("n0Kt[5]3J \u000f0N Nt\\;Z&L1\u000f'Z7L1\\'\u0015t")).append(dataSourceName).toString());
    }

    public DataSource getTargetDataSource(String dataSourceName) {
        if (StringUtils.isBlank((CharSequence)dataSourceName) || "default".equals(dataSourceName)) {
            return (DataSource)this.defaultTargetDataSource;
        }
        Object a = this.targetDataSources.get(dataSourceName);
        if (a == null) {
            return (DataSource)this.defaultTargetDataSource;
        }
        return (DataSource)a;
    }
}

