/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.service;

import com.jeesite.common.config.Global;
import com.jeesite.common.dao.TreeDao;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.entity.TreeEntity;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.query.QueryType;
import com.jeesite.common.service.TreeQueryService;
import com.jeesite.common.service.api.TreeQueryServiceApi;
import com.jeesite.common.z.B;
import java.util.List;
import org.apache.ibatis.binding.BindingException;
import org.hyperic.sigar.ProcCredName;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public abstract class TreeService<D extends TreeDao<T>, T extends TreeEntity<T>>
extends TreeQueryService<D, T>
implements TreeQueryServiceApi<T> {
    protected void updateChildNode(T childEntity, T parentEntity) {
        this.updateTreeData(childEntity);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(T entity) {
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)((BaseEntity)entity).getId())) {
            return;
        }
        TreeEntity a = (TreeEntity)this.newEntity();
        a.getSqlMap().getWhere().andBracket(((BaseEntity)entity).getIdColumnName(), QueryType.EQ, ((BaseEntity)entity).getId()).or(ProcCredName.ALLATORIxDEMO("\t\u0006\u000b\u0002\u0017\u0013&\u0004\u0016\u0003\u001c\u0014"), QueryType.LIKE, new StringBuilder().insert(0, B.ALLATORIxDEMO("r")).append(((BaseEntity)entity).getId()).append(ProcCredName.ALLATORIxDEMO("K")).toString()).endBracket();
        ((TreeDao)this.dao).deleteByEntity(a);
        if (entity != null && ((TreeEntity)entity).getParent() != null) {
            this.updateTreeLeaf(((TreeEntity)entity).getParent());
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void fixTreeData(List<T> list, String parentCode, String parentCodes, String treeSorts, String treeNames) {
        for (TreeEntity treeEntity : list) {
            void a;
            TreeService treeService;
            void a2;
            void v0 = a2;
            a2.setParentCodes(parentCodes + parentCode + B.ALLATORIxDEMO("r"));
            void v1 = a2;
            v0.setTreeSorts(new StringBuilder().insert(0, treeSorts).append(StringUtils.leftPad((String)String.valueOf(v1.getTreeSort()), (int)10, (String)"0")).append(ProcCredName.ALLATORIxDEMO("K")).toString());
            v0.setTreeLevel(v1.getParentCodes().replaceAll(B.ALLATORIxDEMO("O\u00008\u0003"), "").length() - 1);
            if (StringUtils.isNotBlank((CharSequence)treeNames)) {
                treeService = this;
                void v3 = a2;
                v3.setTreeNames(new StringBuilder().insert(0, treeNames).append(ProcCredName.ALLATORIxDEMO("H")).append(v3.getTreeName_()).toString());
            } else {
                void v4 = a2;
                v4.setTreeNames(v4.getTreeName_());
                treeService = this;
            }
            treeService.updateTreeData(a2);
            TreeService treeService2 = this;
            treeService2.updateTreeLeaf(a2);
            TreeEntity treeEntity2 = (TreeEntity)treeService2.newEntity();
            void v6 = a;
            v6.setStatus(null);
            v6.setParentCode(a2.getId());
            List<void> a3 = this.findList(v6);
            if (a3.size() <= 0) continue;
            this.fixTreeData(a3, a.getParentCode(), a2.getParentCodes(), a2.getTreeSorts(), a2.getTreeNames());
        }
    }

    @Transactional(readOnly=false, isolation=Isolation.READ_UNCOMMITTED)
    private /* synthetic */ void updateTreeData(T entity) {
        if ("0".equals(((BaseEntity)entity).getId())) {
            return;
        }
        try {
            ((TreeDao)this.dao).updateTreeData(entity);
            return;
        }
        catch (BindingException a) {
            this.logger.warn(B.ALLATORIxDEMO("+d:u*q\u000eu,q0`\u001d{:q-"), (Throwable)a);
            return;
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void updateStatus(T entity) {
        Global.assertDemoMode();
        if (StringUtils.isBlank((CharSequence)((BaseEntity)entity).getId())) {
            return;
        }
        ((TreeDao)this.dao).updateStatus(entity);
        if (entity != null && ((TreeEntity)entity).getParent() != null) {
            this.updateTreeLeaf(((TreeEntity)entity).getParent());
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void fixTreeData() {
        this.fixTreeData("0");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(readOnly=false)
    public void save(T entity) {
        TreeService treeService;
        TreeEntity treeEntity;
        TreeEntity a = super.get(entity);
        if (entity.getParent() == null || StringUtils.isBlank((CharSequence)entity.getParentCode()) || "0".equals(entity.getParentCode())) {
            TreeEntity treeEntity2 = entity;
            treeEntity = treeEntity2;
            treeEntity2.setParent(null);
        } else {
            entity.setParent((TreeEntity)((Object)super.get(entity.getParentCode())));
            treeEntity = entity;
        }
        if (treeEntity.getParent() == null) {
            entity.setParent((TreeEntity)this.newEntity("0"));
            TreeEntity treeEntity3 = entity;
            ((TreeEntity)treeEntity3.getParent()).setParentCodes("");
            ((TreeEntity)treeEntity3.getParent()).setTreeSorts("");
        }
        TreeEntity treeEntity4 = entity;
        String a2 = treeEntity4.getParentCodes();
        String a3 = treeEntity4.getTreeSorts();
        String a4 = treeEntity4.getTreeNames();
        TreeEntity treeEntity5 = entity;
        treeEntity4.setParentCodes(((TreeEntity)entity.getParent()).getParentCodes() + entity.getParentCode() + ProcCredName.ALLATORIxDEMO("K"));
        if (treeEntity4.getTreeSort() == null) {
            entity.setTreeSort(30);
        }
        TreeEntity treeEntity6 = entity;
        TreeEntity treeEntity7 = entity;
        treeEntity6.setTreeSorts(new StringBuilder().insert(0, ((TreeEntity)entity.getParent()).getTreeSorts()).append(StringUtils.leftPad((String)String.valueOf(treeEntity7.getTreeSort()), (int)10, (String)"0")).append(B.ALLATORIxDEMO("r")).toString());
        treeEntity6.setTreeLevel(treeEntity7.getParentCodes().replaceAll(ProcCredName.ALLATORIxDEMO("\"9U:"), "").length() - 1);
        if (treeEntity6.getIsNewRecord()) {
            entity.setTreeLeaf("1");
        }
        TreeEntity treeEntity8 = entity;
        treeEntity8.setTreeName_(null);
        if (StringUtils.isNotBlank((CharSequence)((TreeEntity)treeEntity8.getParent()).getTreeNames())) {
            treeService = this;
            TreeEntity treeEntity9 = entity;
            treeEntity9.setTreeNames(new StringBuilder().insert(0, ((TreeEntity)treeEntity9.getParent()).getTreeNames()).append(B.ALLATORIxDEMO("q")).append(entity.getTreeName_()).toString());
        } else {
            TreeEntity treeEntity10 = entity;
            treeEntity10.setTreeNames(treeEntity10.getTreeName_());
            treeService = this;
        }
        super.save(entity);
        if (a2 != null) {
            void a5;
            TreeEntity treeEntity11 = (TreeEntity)this.newEntity();
            a5.setParentCodes(new StringBuilder().insert(0, a2).append(entity.getId()).append(ProcCredName.ALLATORIxDEMO("UB")).toString());
            for (TreeEntity treeEntity12 : ((TreeDao)this.dao).findByParentCodesLike(a5)) {
                if (treeEntity12.getParentCodes() == null) continue;
                TreeEntity treeEntity13 = treeEntity12;
                treeEntity13.setParentCodes(StringUtils.replaceOnce((String)treeEntity13.getParentCodes(), (String)a2, (String)entity.getParentCodes()));
                treeEntity13.setTreeSorts(StringUtils.replaceOnce((String)treeEntity13.getTreeSorts(), (String)a3, (String)entity.getTreeSorts()));
                treeEntity13.setTreeLevel(treeEntity13.getParentCodes().replaceAll(B.ALLATORIxDEMO("O\u00008\u0003"), "").length() - 1);
                treeEntity13.setTreeNames(StringUtils.replaceOnce((String)treeEntity13.getTreeNames(), (String)a4, (String)entity.getTreeNames()));
                this.updateChildNode(treeEntity13, entity);
            }
        }
        if (a != null && a.getParent() != null) {
            this.updateTreeLeaf(a.getParent());
        }
        if (entity != null && entity.getParent() != null && !StringUtils.equals((CharSequence)entity.getParentCode(), (CharSequence)(a == null ? "" : a.getParentCode()))) {
            this.updateTreeLeaf(entity.getParent());
        }
    }

    @Transactional(readOnly=false, isolation=Isolation.READ_UNCOMMITTED)
    private /* synthetic */ void updateTreeLeaf(T entity) {
        if ("0".equals(((BaseEntity)entity).getId())) {
            return;
        }
        try {
            ((TreeDao)this.dao).updateTreeLeaf(entity);
            return;
        }
        catch (BindingException a) {
            this.logger.warn(ProcCredName.ALLATORIxDEMO("\f\u0017\u001d\u0006\r\u0002-\u0015\u001c\u00025\u0002\u0018\u0001"), (Throwable)a);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(readOnly=false)
    public void fixTreeData(String parentCode) {
        void a;
        TreeEntity treeEntity = (TreeEntity)this.newEntity();
        TreeService treeService = this;
        void v1 = a;
        v1.setStatus(null);
        v1.setParentCode(parentCode);
        treeService.fixTreeData(treeService.findList(a), a.getParentCode(), "", "", "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional(readOnly=false)
    public void updateTreeSort(T entity) {
        TreeEntity treeEntity;
        Object a;
        Global.assertDemoMode();
        if (entity.getTreeSort() == null) {
            entity.setTreeSort(30);
        }
        if (entity.getTreeSorts() == null || entity.getParentCodes() == null) {
            a = ((TreeDao)this.dao).get(entity);
            TreeEntity treeEntity2 = entity;
            TreeEntity treeEntity3 = a;
            entity.setParent(treeEntity3.getParent());
            treeEntity2.setParentCodes(treeEntity3.getParentCodes());
            treeEntity2.setTreeSorts(((TreeEntity)a).getTreeSorts());
        }
        if (entity.getParent() == null || StringUtils.isBlank((CharSequence)entity.getParentCode()) || "0".equals(entity.getParentCode())) {
            TreeEntity treeEntity4 = entity;
            treeEntity = treeEntity4;
            treeEntity4.setParent(null);
        } else {
            entity.setParent((TreeEntity)((Object)super.get(entity.getParentCode())));
            treeEntity = entity;
        }
        if (treeEntity.getParent() == null) {
            entity.setParent((TreeEntity)this.newEntity("0"));
            TreeEntity treeEntity5 = entity;
            ((TreeEntity)treeEntity5.getParent()).setParentCodes("");
            ((TreeEntity)treeEntity5.getParent()).setTreeSorts("");
        }
        TreeEntity treeEntity6 = entity;
        a = treeEntity6.getParentCodes();
        String a2 = treeEntity6.getTreeSorts();
        TreeEntity treeEntity7 = entity;
        treeEntity6.setTreeSorts(((TreeEntity)entity.getParent()).getTreeSorts() + StringUtils.leftPad((String)String.valueOf(entity.getTreeSort()), (int)10, (String)"0") + B.ALLATORIxDEMO("r"));
        ((TreeDao)this.dao).updateTreeSort(entity);
        if (a != null) {
            void a3;
            TreeEntity treeEntity8 = (TreeEntity)this.newEntity();
            a3.setParentCodes(new StringBuilder().insert(0, (String)a).append(entity.getId()).append(ProcCredName.ALLATORIxDEMO("B")).toString());
            for (TreeEntity treeEntity9 : ((TreeDao)this.dao).findByParentCodesLike(a3)) {
                if (treeEntity9.getParentCodes() == null) continue;
                TreeEntity treeEntity10 = treeEntity9;
                treeEntity10.setTreeSorts(StringUtils.replaceOnce((String)treeEntity10.getTreeSorts(), (String)a2, (String)entity.getTreeSorts()));
                ((TreeDao)this.dao).updateTreeSort(treeEntity9);
            }
        }
    }
}

