/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.j2cache.cache.support.utils.J2CacheConfigUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.common.web.d.C;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.NetRoute;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled", "web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a = new StringBuilder();
        try {
            void a2;
            CronExpression a3 = new CronExpression(cron);
            if (num <= 0) {
                a.append(J2CacheConfigUtils.ALLATORIxDEMO("\u0018Z4F\u8833\u8f96\u5f54\u6b4b\u7835\u302a"));
                return this.renderResult("true", a.toString());
            }
            a.append(NetRoute.ALLATORIxDEMO("\u0003\u0015\u0001\u6765\u8fee") + num + J2CacheConfigUtils.ALLATORIxDEMO("\u6b7a\u8ff8\u8817\u65de\u95af\uff32g\u0007+\u0016"));
            Date a4 = new Date();
            boolean bl = false;
            void v0 = a2;
            while (v0 <= num) {
                if ((a4 = a3.getTimeAfter(a4)) == null) {
                    return this.renderResult("true", a.toString());
                }
                a.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a4)).append(NetRoute.ALLATORIxDEMO("\u0003J]\u0017\u0001")).toString());
                v0 = ++a2;
            }
            return this.renderResult("true", a.toString());
        }
        catch (ParseException a5) {
            return this.renderResult("false", new StringBuilder().insert(0, NetRoute.ALLATORIxDEMO("&M\nQ\u880d\u8f81\u5f6a\u9526\u8b8a\uff25")).append(a5.getMessage()).toString());
        }
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.ALLATORIxDEMO().get(J2CacheConfigUtils.ALLATORIxDEMO("N5b4J"))).booleanValue()) {
            return this.renderResult("false", NetRoute.ALLATORIxDEMO("\u5f6c\u5228\u7277\u6749\u6715\u5f65\u6501\u6b01\u52a0\u8098\uff3e"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", J2CacheConfigUtils.ALLATORIxDEMO("\u8ff8\u8817\u4e28\u6b7a\u6238\u52c4\uff29"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.ALLATORIxDEMO().get(NetRoute.ALLATORIxDEMO("Y\u000bu\n]"))).booleanValue()) {
            return this.renderResult("false", J2CacheConfigUtils.ALLATORIxDEMO("\u5f7b\u5216\u7260\u6777\u6702\u5f5b\u6516\u6b3f\u52b7\u80a6\uff29"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", NetRoute.ALLATORIxDEMO("\u66bd\u5039\u8fef\u8829\u622f\u52fa\uff3e"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(C.ALLATORIxDEMO().get(J2CacheConfigUtils.ALLATORIxDEMO("N5b4J"))).booleanValue()) {
            return this.renderResult("false", NetRoute.ALLATORIxDEMO("\u5f6c\u5228\u7277\u6749\u6715\u5f65\u6501\u6b01\u52a0\u8098\uff3e"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", J2CacheConfigUtils.ALLATORIxDEMO("\u5007\u6b4a\u5bc1\u65de\u5633\u5919\u8d7e\uff29"));
        }
        return this.renderResult("true", NetRoute.ALLATORIxDEMO("\u5039\u6b5d\u5bff\u65c9\u560d\u622f\u52fa\uff3e"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(C.ALLATORIxDEMO().get(J2CacheConfigUtils.ALLATORIxDEMO("N5b4J"))).booleanValue()) {
            return this.renderResult("false", NetRoute.ALLATORIxDEMO("\u5f6c\u5228\u7277\u6749\u6715\u5f65\u6501\u6b01\u52a0\u8098\uff3e"));
        }
        JobEntity jobEntity = job;
        jobEntity.setInvokeTarget(EncodeUtils.decodeBase64String((String)jobEntity.getInvokeTarget()));
        JobController jobController = this;
        jobController.jobService.save(job);
        return jobController.renderResult("true", J2CacheConfigUtils.ALLATORIxDEMO("\u4ff5\u5b03\u6238\u52c4\uff29"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(C.ALLATORIxDEMO().get(NetRoute.ALLATORIxDEMO("Y\u000bu\n]"))).booleanValue()) {
            return this.renderResult("false", J2CacheConfigUtils.ALLATORIxDEMO("\u5f7b\u5216\u7260\u6777\u6702\u5f5b\u6516\u6b3f\u52b7\u80a6\uff29"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", NetRoute.ALLATORIxDEMO("\u544a\u5297\u5bff\u65c9\u560d\u590e\u8d40\uff3e"));
        }
        return this.renderResult("true", J2CacheConfigUtils.ALLATORIxDEMO("\u5474\u5280\u5bc1\u65de\u5633\u6238\u52c4\uff29"));
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a != null) {
                throw new ValidationException(NetRoute.ALLATORIxDEMO("\u5432\u7995\u53f5\u7ea1\u5432\u5d97\u7ef0\u5b3d\u5717"));
            }
        }
        if (a == null) {
            a = new JobEntity();
        }
        return a;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(@ModelAttribute(value="job") JobEntity job, Model model) {
        if (job.getMisfireInstruction() == null) {
            job.setMisfireInstruction(2);
        }
        if (StringUtils.isBlank((CharSequence)job.getConcurrent())) {
            job.setConcurrent("0");
        }
        model.addAttribute("job", (Object)job);
        return J2CacheConfigUtils.ALLATORIxDEMO("E4L.D>[tB4JtB4J\u001dG)E");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.ALLATORIxDEMO().get(NetRoute.ALLATORIxDEMO("Y\u000bu\n]"))).booleanValue()) {
            return this.renderResult("false", J2CacheConfigUtils.ALLATORIxDEMO("\u5f7b\u5216\u7260\u6777\u6702\u5f5b\u6516\u6b3f\u52b7\u80a6\uff29"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", NetRoute.ALLATORIxDEMO("\u605d\u5968\u8fef\u8829\u622f\u52fa\uff3e"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(C.ALLATORIxDEMO().get(J2CacheConfigUtils.ALLATORIxDEMO("N5b4J"))).booleanValue()) {
            return this.renderResult("false", NetRoute.ALLATORIxDEMO("\u5f6c\u5228\u7277\u6749\u6715\u5f65\u6501\u6b01\u52a0\u8098\uff3e"));
        }
        this.jobService.delete(job);
        return this.renderResult("true", J2CacheConfigUtils.ALLATORIxDEMO("\u5208\u963f\u6238\u52c4\uff29"));
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = NetRoute.ALLATORIxDEMO("U\n]+^\bZ");
        }
        List a = this.jobService.findList(job);
        a = ListUtils.listOrderBy(a, (String)orderBy);
        return a;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(J2CacheConfigUtils.ALLATORIxDEMO("A(z.F5A5O"), (Object)a);
        return NetRoute.ALLATORIxDEMO("R\n[\u0010S\u0000LJU\n]JU\n])V\u0016K");
    }
}

