/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.query.QueryWhereEntity;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Config;
import com.jeesite.modules.sys.service.ConfigService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.ProcCred;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/config"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class ConfigController
extends BaseController {
    @Autowired
    private ConfigService configService;

    @ModelAttribute
    public Config get(String id, boolean isNewRecord) {
        return (Config)this.configService.get(id, isNewRecord);
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Config config, HttpServletRequest request) {
        Config a = (Config)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", QueryWhereEntity.ALLATORIxDEMO("\u8dc3\u6748\u6484\u4f57\uff45\u53e1\u6740\u8d8e\u7eee\u7baa\u744f\u5453\u6204\u80f6\u4fa7\u6532\u7cb2\u7ed4\u6539\u6365\uff48"));
        }
        if (!config.getCurrentUser().isSuperAdmin()) {
            Config config2 = config;
            config2.setConfigName(a.getConfigName());
            config2.setConfigKey(a.getConfigKey());
        }
        this.configService.save(config);
        return this.renderResult("true", ProcCred.ALLATORIxDEMO("\u4fe7\u5b15\u53f8\u653d\u622a\u52d2\uff3b"));
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"checkConfigKey"})
    @ResponseBody
    public String checkConfigKey(String oldConfigKey, String configKey) {
        Config a = new Config();
        String string = configKey;
        a.setConfigKey(string);
        if (string != null && configKey.equals(oldConfigKey)) {
            return "true";
        }
        if (configKey != null && this.configService.findCount(a) == 0L) {
            return "true";
        }
        return "false";
    }

    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"list"})
    public String list(Config config, Model model) {
        return QueryWhereEntity.ALLATORIxDEMO("f&o<g,xfx0xfh&e/b.G x=");
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Config config, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(ProcCred.ALLATORIxDEMO("S>i4I")))) {
            return this.renderResult("false", QueryWhereEntity.ALLATORIxDEMO("\u8dc3\u6748\u6484\u4f57\uff45b:X0x\u9717\u6cde\u538b\u657b\uff48"));
        }
        Config a = (Config)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ProcCred.ALLATORIxDEMO("\u8db0\u670e\u64f7\u4f11\uff36\u53a7\u6733\u8dc8\u7e9d\u7bec\u743c\u5415\u6277\u80b0\u4fd4\u6574\u7cc1\u7e92\u654a\u6323\uff3b"));
        }
        this.configService.delete(config);
        return this.renderResult("true", QueryWhereEntity.ALLATORIxDEMO("\u5269\u966f\u538b\u657b\u6259\u5294\uff48"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Config> listData(Config config, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        void response;
        void request;
        void config2;
        config2.setPage(new Page((HttpServletRequest)request, (HttpServletResponse)response));
        return this.configService.findPage((Config)config2);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"form"})
    public String form(Config config, Model model) {
        void config2;
        void model2;
        model2.addAttribute(ProcCred.ALLATORIxDEMO(".U#\\$]"), (Object)config2);
        return QueryWhereEntity.ALLATORIxDEMO("f&o<g,xfx0xfh&e/b.M&y$");
    }
}

