/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.autoconfigure.sys.FileAutoConfiguration;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Module;
import com.jeesite.modules.sys.service.ModuleService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.ProcCred;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/module"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class ModuleController
extends BaseController {
    @Autowired
    private ModuleService moduleService;

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"checkModuleCode"})
    @ResponseBody
    public String checkModuleCode(String oldCode, String moduleCode) {
        Module a = new Module();
        String string = moduleCode;
        a.setModuleCode(string);
        if (string != null && moduleCode.equals(oldCode)) {
            return "true";
        }
        if (moduleCode != null && this.moduleService.get(a) == null) {
            return "true";
        }
        return "false";
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"list"})
    public String list(Module module, Model model) {
        void module2;
        module2.setStatus("");
        return ProcCred.ALLATORIxDEMO(" U)O!_>\u0015>C>\u0015 U)O!_\u0001S>N");
    }

    @ModelAttribute
    public Module get(String moduleCode, boolean isNewRecord) {
        return (Module)this.moduleService.get(moduleCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", FileAutoConfiguration.ALLATORIxDEMO("\u8d9d\u673b\u64da\u4f24\uff1b\u5392\u671e\u8dfd\u7eb0\u7bd9\u7411\u5420\u625a\u8085\u4ff9\u6541\u6b73\u6508\u6379\uff79"));
        }
        module.setStatus("0");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, ProcCred.ALLATORIxDEMO("\u5462\u7512\u6a6c\u576d")).append(module.getModuleName()).append(FileAutoConfiguration.ALLATORIxDEMO("\u6207\u52e7")).toString());
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ProcCred.ALLATORIxDEMO("\u8dc7\u6779\u6480\u4f66\uff41\u53d0\u6744\u8dbf\u7eea\u7b9b\u744b\u5462\u6200\u80c7\u4fa3\u6503\u6b29\u654a\u6323\uff3b"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", FileAutoConfiguration.ALLATORIxDEMO("\u6840\u5fd4\u6a59\u5740\uff74\u4e1a\u5139\u8baf\u79f9\u753f\uff79"));
        }
        this.moduleService.delete(module);
        return this.renderResult("true", ProcCred.ALLATORIxDEMO("\u521a\u9629\u6a1b\u571a\u622a\u52d2\uff3b"));
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", FileAutoConfiguration.ALLATORIxDEMO("\u8d9d\u673b\u64da\u4f24\uff1b\u5392\u671e\u8dfd\u7eb0\u7bd9\u7411\u5420\u625a\u8085\u4ff9\u6541\u6b73\u6508\u6379\uff79"));
        }
        if ("core".equals(module.getModuleCode())) {
            return this.renderResult("false", ProcCred.ALLATORIxDEMO("\u6802\u5f8e\u6a1b\u571a\uff36\u4e40\u517b\u8bf5\u79bb\u7565\uff3b"));
        }
        module.setStatus("2");
        ModuleController moduleController = this;
        moduleController.moduleService.updateStatus(module);
        return moduleController.renderResult("true", new StringBuilder().insert(0, FileAutoConfiguration.ALLATORIxDEMO("\u504b\u7550\u6a36\u572f")).append(module.getModuleName()).append(ProcCred.ALLATORIxDEMO("\u625d\u52a5")).toString());
    }

    @RequiresPermissions(value={"sys:module:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Module module) {
        if (!module.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", FileAutoConfiguration.ALLATORIxDEMO("\u8d9d\u673b\u64da\u4f24\uff1b\u5392\u671e\u8dfd\u7eb0\u7bd9\u7411\u5420\u625a\u8085\u4ff9\u6541\u6b73\u6508\u6379\uff79"));
        }
        this.moduleService.save(module);
        return this.renderResult("true", ProcCred.ALLATORIxDEMO("\u4fe7\u5b15\u6a1b\u571a\u622a\u52d2\uff3b"));
    }

    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"form"})
    public String form(Module module, Model model) {
        if (StringUtils.isBlank((CharSequence)module.getMainClassName())) {
            module.setMainClassName(FileAutoConfiguration.ALLATORIxDEMO("\u001bx\u00159\u0012r\u001dd\u0011c\u001d9\u0015x\u001cb\u0014r\u000b9\u000bn\u000b9\u000fr\u001a94x\u001f~\u0016T\u0017y\fe\u0017{\u0014r\n"));
        }
        model.addAttribute(ProcCred.ALLATORIxDEMO(" U)O!_"), (Object)module);
        return FileAutoConfiguration.ALLATORIxDEMO("z\u0017s\r{\u001ddWd\u0001dWz\u0017s\r{\u001dQ\u0017e\u0015");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:module:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Module> listData(Module module, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        void response;
        void request;
        void module2;
        module2.setPage(new Page((HttpServletRequest)request, (HttpServletResponse)response));
        return this.moduleService.findPage((Module)module2);
    }
}

