/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.RoleDataScope;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.MenuService;
import com.jeesite.modules.sys.service.RoleService;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.utils.RoleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ThreadCpu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/role"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class RoleController
extends BaseController {
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private MenuService menuService;

    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"deleteAuthUser"})
    @ResponseBody
    public String deleteAuthUser(Role role, HttpServletRequest request) {
        Role a = (Role)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !role.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ProcMem.ALLATORIxDEMO("\u8ddd\u6761\u649a\u4f7e\uff5b\u53c8\u675e\u8da7\u7ef0\u7b83\u7451\u547a\u621a\u80df\u4fb9\u651b\u7cac\u7efd\u6527\u634c\uff56"));
        }
        this.roleService.deleteAuthUser(role);
        return this.renderResult("true", ThreadCpu.ALLATORIxDEMO("\u53db\u6dfc\u7525\u6243\u5481\u89a6\u827f\u63fc\u674e\u6264\u5292"));
    }

    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Role role, HttpServletRequest request) {
        Role a = (Role)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !role.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ThreadCpu.ALLATORIxDEMO("\u8d87\u6737\u64c0\u4f28\uff01\u539e\u6704\u8df1\u7eaa\u7bd5\u740b\u542c\u6240\u8089\u4fe3\u654d\u7cf6\u7eab\u657d\u631a\uff0c"));
        }
        role.setStatus("2");
        RoleController roleController = this;
        roleController.roleService.updateStatus(role);
        return roleController.renderResult("true", ProcMem.ALLATORIxDEMO("\u500b\u750a\u8985\u8250\u6247\u52bd\uff56"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"formAuthDataScope"})
    public String formAuthDataScope(Role role, String checkbox, Model model, HttpServletRequest request) {
        void a;
        void a2;
        RoleDataScope roleDataScope = new RoleDataScope();
        a2.setRoleCode(role.getRoleCode());
        List<RoleDataScope> list = this.roleService.findDataScopeList((RoleDataScope)a2);
        model.addAttribute(ThreadCpu.ALLATORIxDEMO("\u007f\u001ba\u0011I\u0015y\u0015^\u0017b\u0004h8d\u0007y"), (Object)a);
        model.addAttribute(ProcMem.ALLATORIxDEMO("P8N2"), (Object)role);
        return ThreadCpu.ALLATORIxDEMO("`\u001bi\u0001a\u0011~[~\r~[\u007f\u001ba\u0011K\u001b\u007f\u0019L\u0001y\u001cI\u0015y\u0015^\u0017b\u0004h");
    }

    @RequiresPermissions(value={"sys:role:view"})
    @RequestMapping(value={"list"})
    public String list(Role role, Model model) {
        return ProcMem.ALLATORIxDEMO("O8F\"N2QxQ.QxP8N2n>Q#");
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkRoleName"})
    @ResponseBody
    public String checkRoleName(String oldRoleName, String roleName) {
        Role a = new Role();
        String string = roleName;
        a.setRoleName(string);
        if (string != null && roleName.equals(oldRoleName)) {
            return "true";
        }
        if (roleName != null && this.roleService.getByRoleName(a) == null) {
            return "true";
        }
        return "false";
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:role:view"})
    @RequestMapping(value={"menuTreeData"})
    @ResponseBody
    public Map<String, Object> menuTreeData(Role role, HttpServletRequest request) {
        Iterator<Menu> iterator;
        RoleController roleController;
        HashMap a = MapUtils.newHashMap();
        Menu a2 = new Menu();
        User a3 = role.getCurrentUser();
        if (a3.isSuperAdmin()) {
            roleController = this;
            a2.setWeight_lt(Menu.WEIGHT_SUPER_ADMIN);
        } else if ("1".equals(a3.getMgrType())) {
            roleController = this;
            a2.setWeight_lt(Menu.WEIGHT_CORP_ADMIN);
        } else {
            Menu menu = a2;
            if ("2".equals(a3.getMgrType())) {
                menu.setWeight_lt(Menu.WEIGHT_SEC_ADMIN);
                roleController = this;
            } else {
                menu.setWeight_lt(Menu.WEIGHT_DEFAULT);
                roleController = this;
            }
        }
        List<Menu> a4 = roleController.menuService.findList(a2);
        LinkedHashMap a5 = MapUtils.newLinkedHashMap();
        Iterator<Menu> iterator2 = iterator = a4.iterator();
        while (iterator2.hasNext()) {
            void a6;
            Menu a7 = iterator.next();
            List a8 = (List)a5.get(a7.getSysCode());
            if (a8 == null) {
                a8 = ListUtils.newArrayList();
                a5.put(a7.getSysCode(), a8);
            }
            HashMap hashMap = MapUtils.newHashMap();
            iterator2 = iterator;
            a6.put(ThreadCpu.ALLATORIxDEMO("\u001di"), a7.getMenuCode());
            a6.put(ProcMem.ALLATORIxDEMO("'k3"), a7.getParentCode());
            a6.put(ThreadCpu.ALLATORIxDEMO("\u001al\u0019h"), new StringBuilder().insert(0, a7.getMenuName()).append(ProcMem.ALLATORIxDEMO("\u001e1M9VwA8N8Pj\u0001o\u001ao\u001cw\u00049@$Rl\u0002qL5Q'\u0019w")).append(StringUtils.abbr((String)new StringBuilder().insert(0, ObjectUtils.toString((Object)a7.getPermission())).append(ThreadCpu.ALLATORIxDEMO("T+\u001ao\u0007}O-")).append(ObjectUtils.toString((Object)a7.getMenuHref())).toString(), (int)50)).append(ProcMem.ALLATORIxDEMO("k\r1M9Vi")).toString());
            a6.put(ThreadCpu.ALLATORIxDEMO("y\u001dy\u0018h"), new StringBuilder().insert(0, a7.getMenuName()).append(ProcMem.ALLATORIxDEMO("\u00049@$Rl")).append(ObjectUtils.toString((Object)a7.getPermission())).append(ThreadCpu.ALLATORIxDEMO("\u0007")).append(ObjectUtils.toString((Object)a7.getMenuHref())).toString());
            a8.add(a6);
        }
        HashMap hashMap = a;
        hashMap.put(ProcMem.ALLATORIxDEMO(":G9W\u001aC'"), a5);
        a2 = new Menu();
        a2.setRoleCode(role.getRoleCode());
        List<Menu> a9 = this.menuService.findByRoleCode(a2);
        a.put(ThreadCpu.ALLATORIxDEMO("\u0006b\u0018h9h\u001ax8d\u0007y"), a9);
        return hashMap;
    }

    @RequiresPermissions(value={"sys:role:view"})
    @RequestMapping(value={"form"})
    public String form(Role role, String op, Model model) {
        if (role.getIsNewRecord()) {
            Role role2 = role;
            Role role3 = role;
            role3.setRoleSort((int)this.roleService.findCount(role3) * 10);
            role2.setUserType("employee");
            role2.setIsSys("0");
        }
        model.addAttribute(ProcMem.ALLATORIxDEMO("M'"), (Object)op);
        model.addAttribute(ThreadCpu.ALLATORIxDEMO("\u0006b\u0018h"), (Object)role);
        return ProcMem.ALLATORIxDEMO("O8F\"N2QxQ.QxP8N2d8P:");
    }

    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"saveAuthDataScope"})
    @ResponseBody
    public String saveAuthDataScope(Role role, HttpServletRequest request) {
        Role a = (Role)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !role.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ThreadCpu.ALLATORIxDEMO("\u8d87\u6737\u64c0\u4f28\uff01\u539e\u6704\u8df1\u7eaa\u7bd5\u740b\u542c\u6240\u8089\u4fe3\u654d\u7cf6\u7eab\u657d\u631a\uff0c"));
        }
        this.roleService.saveAuthDataScope(role);
        return this.renderResult("true", ProcMem.ALLATORIxDEMO("\u89f0\u8225\u63aa\u6714\u6552\u6339\u6761\u9607\u6232\u52c8"));
    }

    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Role role, HttpServletRequest request) {
        Role a = (Role)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !role.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ThreadCpu.ALLATORIxDEMO("\u8d87\u6737\u64c0\u4f28\uff01\u539e\u6704\u8df1\u7eaa\u7bd5\u740b\u542c\u6240\u8089\u4fe3\u654d\u7cf6\u7eab\u657d\u631a\uff0c"));
        }
        role.setStatus("0");
        RoleController roleController = this;
        roleController.roleService.updateStatus(role);
        return roleController.renderResult("true", ProcMem.ALLATORIxDEMO("\u5478\u750a\u8985\u8250\u6247\u52bd\uff56"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"formAuthUser"})
    public String formAuthUser(Role role, Model model, HttpServletRequest request) {
        Iterator<User> iterator;
        HashMap a = MapUtils.newHashMap();
        User a2 = new User(role);
        Iterator<User> iterator2 = iterator = this.userService.findListByRoleCode(a2).iterator();
        while (iterator2.hasNext()) {
            void a3;
            User user = iterator.next();
            iterator2 = iterator;
            a.put(a3.getUserCode(), a3);
        }
        model.addAttribute(ThreadCpu.ALLATORIxDEMO("i\u0015y\u0015@\u0015}"), (Object)a);
        model.addAttribute(ProcMem.ALLATORIxDEMO("P8N2"), (Object)role);
        return ThreadCpu.ALLATORIxDEMO("\u0019b\u0010x\u0018h\u0007\"\u0007t\u0007\"\u0006b\u0018h2b\u0006`5x\u0000e!~\u0011\u007f");
    }

    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Role role, HttpServletRequest request) {
        if (Role.CORP_ADMIN_ROLE_CODE.equals(role.getRoleCode())) {
            return this.renderResult("false", ProcMem.ALLATORIxDEMO("\u977c\u6c82\u64ef\u4f0b\uff2e\u6b33\u89f0\u8225\u4e18\u51d2\u7f4c\u8985\u8250\uff5b\u4e2f\u5116\u8b9a\u5277\u9646\uff56"));
        }
        Role a = (Role)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !role.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ThreadCpu.ALLATORIxDEMO("\u8d87\u6737\u64c0\u4f28\uff01\u539e\u6704\u8df1\u7eaa\u7bd5\u740b\u542c\u6240\u8089\u4fe3\u654d\u7cf6\u7eab\u657d\u631a\uff0c"));
        }
        this.roleService.delete(role);
        return this.renderResult("true", ProcMem.ALLATORIxDEMO("\u5277\u9646\u8985\u8250\u6247\u52bd\uff56"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(String userType, Boolean isAll, String isShowCode, String ctrlPermi) {
        void a;
        ArrayList a2 = ListUtils.newArrayList();
        Role role = new Role();
        a.setStatus("0");
        if (isAll == null || !isAll.booleanValue()) {
            a.setUserType((String)StringUtils.defaultIfBlank((CharSequence)userType, (CharSequence)"employee"));
            this.roleService.addDataScopeFilter((Role)a, ctrlPermi);
        }
        this.roleService.findList((Role)a).forEach(e2 -> {
            HashMap a = MapUtils.newHashMap();
            a.put(ProcMem.ALLATORIxDEMO("K3"), e2.getId());
            a.put(ThreadCpu.ALLATORIxDEMO("}=i"), "0");
            a.put(ProcMem.ALLATORIxDEMO("L6O2"), StringUtils.getTreeNodeName((String)isShowCode, (String)e2.getRoleCode(), (String)e2.getRoleName()));
            a2.add(a);
        });
        return a2;
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"hasUserRole"})
    @ResponseBody
    public Boolean hasUserRole(String userCode, String roleCode) {
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            return RoleUtils.hasUserRole(userCode, roleCode);
        }
        return RoleUtils.hasCurrentUserRole(roleCode);
    }

    @ModelAttribute
    public Role get(String roleCode, boolean isNewRecord) {
        return (Role)this.roleService.get(roleCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:role:edit"})
    @RequestMapping(value={"saveAuthUser"})
    @ResponseBody
    public String saveAuthUser(Role role, HttpServletRequest request) {
        Role a = (Role)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !role.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ThreadCpu.ALLATORIxDEMO("\u8d87\u6737\u64c0\u4f28\uff01\u539e\u6704\u8df1\u7eaa\u7bd5\u740b\u542c\u6240\u8089\u4fe3\u654d\u7cf6\u7eab\u657d\u631a\uff0c"));
        }
        this.roleService.saveAuthUser(role);
        return this.renderResult("true", ProcMem.ALLATORIxDEMO("\u8985\u8250\u63df\u6761\u7e8e\u750a\u6260\u6232\u52c8"));
    }

    @RequiresPermissions(value={"sys:role:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Role role, String oldRoleName, String op, HttpServletRequest request) {
        Role a = (Role)super.getWebDataBinderSource(request);
        if (a != null && "1".equals(a.getIsSys()) && !role.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", ThreadCpu.ALLATORIxDEMO("\u8d87\u6737\u64c0\u4f28\uff01\u539e\u6704\u8df1\u7eaa\u7bd5\u740b\u542c\u6240\u8089\u4fe3\u654d\u7cf6\u7eab\u657d\u631a\uff0c"));
        }
        if (!role.getCurrentUser().isSuperAdmin() && "1".equals(role.getIsSys())) {
            return this.renderResult("false", ProcMem.ALLATORIxDEMO("\u4fff\u5b0f\u5913\u8d72\uff2e\u53bd\u672b\u7cac\u7efd\u7bf6\u7424\u540f\u626f\u80aa\u4fff\u5b0f\u4e18\u7cac\u7efd\u8985\u8250\uff56"));
        }
        if (!"true".equals(this.checkRoleName(oldRoleName, role.getRoleName()))) {
            return this.renderResult("false", new StringBuilder().insert(0, ThreadCpu.ALLATORIxDEMO("\u4fd0\u5b2c\u89df\u8206*")).append(role.getRoleName()).append(ProcMem.ALLATORIxDEMO("\u0005\u5966\u8d07{\u0002\u8985\u8250\u545a\u79d2\u5da5\u5b7a\u577f")).toString());
        }
        String[] stringArray = new String[2];
        stringArray[0] = "add";
        stringArray[1] = "edit";
        if (StringUtils.inString((String)op, (String[])stringArray)) {
            this.roleService.save(role);
        }
        String[] stringArray2 = new String[2];
        stringArray2[0] = "add";
        stringArray2[1] = "auth";
        if (StringUtils.inString((String)op, (String[])stringArray2)) {
            this.roleService.saveAuth(role);
        }
        return this.renderResult("true", new StringBuilder().insert(0, ThreadCpu.ALLATORIxDEMO("\u4fd0\u5b2c\u89df\u8206*")).append(role.getRoleName()).append(ProcMem.ALLATORIxDEMO("\u0005\u6247\u52bd\uff56")).toString());
    }

    @RequiresPermissions(value={"sys:role:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Role> listData(Role role, String ctrlPermi, HttpServletRequest request, HttpServletResponse response) {
        if (!role.getCurrentUser().isSuperAdmin()) {
            this.roleService.addDataScopeFilter(role, ctrlPermi);
        }
        role.setPage(new Page(request, response));
        return this.roleService.findPage(role);
    }
}

