/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.jni;

import com.jeesite.common.mybatis.mapper.query.QueryDataScope;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.jni.ArchName;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.FileSystemUsage;

public class ArchLoader {
    public static final boolean IS_NETWARE;
    private String packageName;
    public static final boolean IS_LINUX;
    public static final boolean IS_HPUX;
    public static final boolean IS_SOLARIS;
    private File nativeLibrary;
    private String resourcePath;
    private boolean loaded;
    private Object loadLock;
    private String name;
    public static final boolean IS_DARWIN;
    public static final boolean IS_OSF1;
    private String libName;
    private static final String osName;
    private String jarName;
    public static final boolean IS_FREEBSD;
    private Class loaderClass;
    private String version;
    public static final boolean IS_WIN32;
    public static final boolean IS_AIX;

    protected void systemLoad(String name) {
        System.load(name);
    }

    public ClassLoader getClassLoader() {
        return this.getLoaderClass().getClassLoader();
    }

    public ArchLoader(Class loaderClass) {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        ArchLoader archLoader3 = this;
        ArchLoader archLoader4 = this;
        archLoader4.loadLock = new Object();
        archLoader3.loaded = false;
        archLoader3.libName = null;
        archLoader2.setLoaderClass(loaderClass);
        String a = loaderClass.getName();
        int a2 = a.lastIndexOf(".");
        a = a.substring(0, a2);
        archLoader2.setPackageName(a);
        String string = a;
        a2 = string.lastIndexOf(".");
        archLoader.setName(string.substring(a2 + 1));
        ArchLoader archLoader5 = this;
        archLoader5.setJarName(new StringBuilder().insert(0, archLoader5.getName()).append(".jar").toString());
        archLoader.setResourcePath(archLoader.toResName(a));
    }

    public void setJarName(String value) {
        this.jarName = value;
    }

    public String getLibName() {
        return this.libName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLibrary(String path) throws ArchNotSupportedException, ArchLoaderException {
        try {
            ArchLoader archLoader;
            String a = this.getLibraryName();
            if (path == null) {
                path = System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(FileSystemUsage.ALLATORIxDEMO("Jr\u0005v\f")).toString());
            }
            if (path != null) {
                if (path.equals(QueryDataScope.ALLATORIxDEMO("H"))) {
                    return;
                }
                ArchLoader archLoader2 = this;
                archLoader = archLoader2;
                archLoader2.findJarPath(null, false);
                this.findNativeLibrary(path, a);
            } else {
                if (this.findJarPath(a, false) == null) {
                    this.findInJavaLibraryPath(a);
                }
                archLoader = this;
            }
            ArchLoader archLoader3 = this;
            if (archLoader.nativeLibrary != null) {
                archLoader3.systemLoad(this.nativeLibrary.toString());
                return;
            }
            archLoader3.systemLoadLibrary(a);
            return;
        }
        catch (RuntimeException a) {
            String a2 = a.getMessage();
            if (a2 == null) {
                a2 = a.getClass().getName();
            }
            String a3 = new StringBuilder().insert(0, FileSystemUsage.ALLATORIxDEMO("\"c\rn\u0001fDv\u000b\"\bm\u0005fD")).append(this.libName).append(QueryDataScope.ALLATORIxDEMO("TE")).append(a2).toString();
            throw new ArchLoaderException(a3);
        }
    }

    public void setResourcePath(String value) {
        this.resourcePath = value;
    }

    public void setLibName(String value) {
        this.libName = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path) throws ArchNotSupportedException, ArchLoaderException {
        Object object = this.loadLock;
        synchronized (object) {
            block4: {
                if (!this.loaded) break block4;
                return;
            }
            this.loadLibrary(path);
            this.loaded = true;
            return;
        }
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getDefaultLibName() throws ArchNotSupportedException {
        return System.getProperty(new StringBuilder().insert(0, this.getPackageName()).append(FileSystemUsage.ALLATORIxDEMO(",\bk\u0006l\u0005o\u0001")).toString(), new StringBuilder().insert(0, QueryDataScope.ALLATORIxDEMO("\u0004\u0004\u0018\u0004")).append(this.getArchLibName()).toString());
    }

    public String getLibraryName() throws ArchNotSupportedException {
        String a = this.getLibName();
        if (a == null) {
            ArchLoader archLoader = this;
            a = archLoader.getDefaultLibName();
            archLoader.setLibName(a);
        }
        String a2 = ArchLoader.getLibraryPrefix();
        String a3 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a2).append(a).append(a3).toString();
    }

    public String getVersionedLibraryName() {
        if (this.version == null) {
            return null;
        }
        try {
            this.getLibraryName();
        }
        catch (ArchNotSupportedException a) {
            return null;
        }
        String a = ArchLoader.getLibraryPrefix();
        String a2 = ArchLoader.getLibraryExtension();
        return new StringBuilder().insert(0, a).append(this.libName).append('-').append(this.version).append(a2).toString();
    }

    public void setLoaderClass(Class value) {
        this.loaderClass = value;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public ArchLoader() {
        ArchLoader archLoader = this;
        ArchLoader archLoader2 = this;
        archLoader2.loadLock = new Object();
        archLoader.loaded = false;
        archLoader.libName = null;
    }

    public static String getLibraryExtension() {
        if (IS_WIN32) {
            return FileSystemUsage.ALLATORIxDEMO(",\u0000n\b");
        }
        if (IS_NETWARE) {
            return QueryDataScope.ALLATORIxDEMO("@\u000b\u0002\b");
        }
        if (IS_DARWIN) {
            return FileSystemUsage.ALLATORIxDEMO(",\u0000{\bk\u0006");
        }
        if (IS_HPUX) {
            return QueryDataScope.ALLATORIxDEMO("K\u001d\t");
        }
        return FileSystemUsage.ALLATORIxDEMO("Jq\u000b");
    }

    private /* synthetic */ String toResName(String name) {
        int a;
        StringBuffer a2 = new StringBuffer(name);
        int n = a = 0;
        while (n < a2.length()) {
            if (a2.charAt(a) == '.') {
                a2.setCharAt(a, '/');
            }
            n = ++a;
        }
        return a2.toString();
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    protected boolean containsNativeLibrary(File dir, String name) {
        if (name == null) {
            return false;
        }
        File a = new File(dir, name);
        if (a.exists()) {
            this.nativeLibrary = a;
            return true;
        }
        return false;
    }

    protected boolean findNativeLibrary(String dir, String name) {
        File a = new File(dir).getAbsoluteFile();
        if (this.containsNativeLibrary(a, name)) {
            return true;
        }
        if (this.containsNativeLibrary(a, this.getVersionedLibraryName())) {
            return true;
        }
        return this.containsNativeLibrary(a, ArchLoader.getLibraryPrefix() + this.getName() + ArchLoader.getLibraryExtension());
    }

    public static String getLibraryPrefix() {
        if (IS_WIN32 || IS_NETWARE) {
            return "";
        }
        return QueryDataScope.ALLATORIxDEMO("\t\u0007\u0007");
    }

    private /* synthetic */ String findJarPath(String libName, boolean isRequired) throws ArchLoaderException {
        String a;
        URL uRL;
        Object a2;
        URL a3;
        String a4;
        block11: {
            if (this.getJarName() == null) {
                throw new ArchLoaderException(FileSystemUsage.ALLATORIxDEMO("\u000ec\u0016L\u0005o\u0001\"\rqDl\u0011n\b"));
            }
            ArchLoader archLoader = this;
            a4 = archLoader.getResourcePath();
            ClassLoader a5 = archLoader.getClassLoader();
            a3 = a5.getResource(a4);
            if (!archLoader.isJarURL(a3)) {
                a3 = null;
            }
            if (a3 == null && a5 instanceof URLClassLoader) {
                int a6;
                a2 = ((URLClassLoader)a5).getURLs();
                int n = a6 = 0;
                while (n < ((URL[])a2).length) {
                    if (this.isJarURL(a2[a6])) {
                        uRL = a3 = a2[a6];
                        break block11;
                    }
                    n = ++a6;
                }
            }
            uRL = a3;
        }
        if (uRL == null) {
            if (isRequired) {
                throw new ArchLoaderException(new StringBuilder().insert(0, QueryDataScope.ALLATORIxDEMO("0\u0000\u0004\f\t\u000bE\u001a\nN\u0003\u0007\u000b\nE")).append(this.getJarName()).toString());
            }
            return null;
        }
        a4 = a3.getFile();
        if (a4.startsWith(FileSystemUsage.ALLATORIxDEMO("\u0002k\bg^"))) {
            a4 = a4.substring(5);
        }
        a2 = new File(a4);
        String a7 = this.getJarName();
        Object object = a2;
        while (object != null && !((File)a2).getName().startsWith(a7)) {
            object = ((File)a2).getParentFile();
        }
        if (libName == null) {
            libName = a7;
        }
        if (a2 != null && (a2 = ((File)a2).getParentFile()) != null && this.findNativeLibrary(a = URLDecoder.decode(((File)a2).toString()), libName)) {
            return a;
        }
        return null;
    }

    public String getArchLibName() throws ArchNotSupportedException {
        return new StringBuilder().insert(0, this.getName()).append(QueryDataScope.ALLATORIxDEMO("H")).append(ArchName.getName()).toString();
    }

    public String findJarPath(String libName) throws ArchLoaderException {
        return this.findJarPath(libName, true);
    }

    public String getName() {
        return this.name;
    }

    static {
        osName = System.getProperty(FileSystemUsage.ALLATORIxDEMO("\u000bqJl\u0005o\u0001"));
        IS_WIN32 = osName.startsWith(QueryDataScope.ALLATORIxDEMO("2\u0007\u000b\n\n\u0019\u0016"));
        IS_AIX = osName.equals("AIX");
        IS_HPUX = osName.equals(FileSystemUsage.ALLATORIxDEMO(",RIW<"));
        IS_SOLARIS = osName.equals(QueryDataScope.ALLATORIxDEMO("6\u001b\u000b!6"));
        IS_LINUX = osName.equals("Linux");
        IS_DARWIN = osName.equals(FileSystemUsage.ALLATORIxDEMO("O\u0005aDM7\"<")) || osName.equals(QueryDataScope.ALLATORIxDEMO("*\u0004\u001c\u0012\u0007\u000b"));
        IS_OSF1 = osName.equals(FileSystemUsage.ALLATORIxDEMO("M7DU"));
        IS_FREEBSD = osName.equals("FreeBSD");
        IS_NETWARE = osName.equals("NetWare");
    }

    public Class getLoaderClass() {
        return this.loaderClass;
    }

    public void load() throws ArchNotSupportedException, ArchLoaderException {
        this.load(null);
    }

    public String getJarName() {
        return this.jarName;
    }

    protected boolean findInJavaLibraryPath(String libName) {
        String a = System.getProperty(QueryDataScope.ALLATORIxDEMO("\u000f\u000f\u0013\u000fK\u0002\f\f\u0017\u000f\u0017\u0017K\u001e\u0004\u001a\r"), "");
        StringTokenizer a2 = new StringTokenizer(a, File.pathSeparator);
        while (a2.hasMoreTokens()) {
            a = a2.nextToken();
            if (!this.findNativeLibrary(a, libName)) continue;
            return true;
        }
        return false;
    }

    protected void systemLoadLibrary(String name) {
        System.loadLibrary(name);
    }

    public File getNativeLibrary() {
        return this.nativeLibrary;
    }

    private /* synthetic */ boolean isJarURL(URL url) {
        String a;
        if (url == null) {
            return false;
        }
        String a2 = url.getFile();
        if (a2.indexOf(a = this.getJarName()) != -1) {
            return true;
        }
        int a3 = a.indexOf(".jar");
        if (a3 != -1) {
            if ((a3 = a2.lastIndexOf(a = new StringBuilder().insert(0, a.substring(0, a3)).append(FileSystemUsage.ALLATORIxDEMO("I")).toString())) != -1) {
                a = a2.substring(a3);
                if ((a3 = a.indexOf(".jar")) == -1) {
                    return false;
                }
                String string = a;
                this.version = string.substring(a.indexOf(45) + 1, a3);
                a = string.substring(0, a3 + 4);
                this.setJarName(a);
                return true;
            }
            return false;
        }
        return false;
    }
}

