/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.common.j2cache.autoconfigure.J2CacheAutoConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ThreadCpu;

public class Cpu
implements Serializable {
    long irq;
    long total;
    long nice;
    long stolen;
    long wait;
    long sys;
    long softIrq;
    long idle;
    private static final long serialVersionUID = 8076L;
    long user;

    public long getSys() {
        return this.sys;
    }

    public long getUser() {
        return this.user;
    }

    public long getIrq() {
        return this.irq;
    }

    public long getTotal() {
        return this.total;
    }

    public long getSoftIrq() {
        return this.softIrq;
    }

    public long getNice() {
        return this.nice;
    }

    public long getWait() {
        return this.wait;
    }

    public String toString() {
        return this.toMap().toString();
    }

    public long getStolen() {
        return this.stolen;
    }

    public native void gather(Sigar var1) throws SigarException;

    static Cpu fetch(Sigar sigar) throws SigarException {
        Cpu cpu = new Cpu();
        cpu.gather(sigar);
        return cpu;
    }

    /*
     * WARNING - void declaration
     */
    void copyTo(Cpu cpu) {
        void copy;
        void v0 = copy;
        Cpu cpu2 = this;
        void v2 = copy;
        Cpu cpu3 = this;
        void v4 = copy;
        Cpu cpu4 = this;
        copy.user = cpu4.user;
        v4.sys = cpu4.sys;
        v4.nice = this.nice;
        copy.idle = cpu3.idle;
        v2.wait = cpu3.wait;
        v2.irq = this.irq;
        copy.softIrq = cpu2.softIrq;
        v0.stolen = cpu2.stolen;
        v0.total = this.total;
    }

    public long getIdle() {
        return this.idle;
    }

    public Map toMap() {
        HashMap<String, String> a = new HashMap<String, String>();
        String a2 = String.valueOf(this.user);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a2)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("\u0000S0R"), a2);
        }
        String a3 = String.valueOf(this.sys);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a3)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("s,S"), a3);
        }
        String a4 = String.valueOf(this.nice);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a4)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("\u001bI6E"), a4);
        }
        String a5 = String.valueOf(this.idle);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a5)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("\u001cD9E"), a5);
        }
        String a6 = String.valueOf(this.wait);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a6)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("\u0002A<T"), a6);
        }
        String a7 = String.valueOf(this.irq);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a7)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("i'Q"), a7);
        }
        String a8 = String.valueOf(this.softIrq);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a8)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("s:F!i'Q"), a8);
        }
        String a9 = String.valueOf(this.stolen);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a9)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("\u0006T:L0N"), a9);
        }
        String a10 = String.valueOf(this.total);
        if (!ThreadCpu.ALLATORIxDEMO("Y<").equals(a10)) {
            a.put(J2CacheAutoConfiguration.ALLATORIxDEMO("t:T4L"), a10);
        }
        return a;
    }

    public Cpu() {
        Cpu cpu = this;
        Cpu cpu2 = this;
        Cpu cpu3 = this;
        Cpu cpu4 = this;
        this.user = 0L;
        cpu4.sys = 0L;
        cpu4.nice = 0L;
        cpu3.idle = 0L;
        cpu3.wait = 0L;
        cpu2.irq = 0L;
        cpu2.softIrq = 0L;
        cpu.stolen = 0L;
        cpu.total = 0L;
    }
}

