/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.common.cache.JedisUtils;
import java.io.Serializable;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.Sigar;

public class CpuPerc
implements Serializable {
    private double user;
    private double sys;
    private double softIrq;
    private double nice;
    private double combined;
    private static final long serialVersionUID = 1393671L;
    private double wait;
    private double stolen;
    private double idle;
    private double irq;

    public static String format(double val) {
        int a;
        String a2 = String.valueOf(val * 100.0);
        int n = a = a2.indexOf(".") + 1;
        String a3 = new StringBuilder().insert(0, a2.substring(0, a)).append(a2.substring(n, n + 1)).toString();
        return new StringBuilder().insert(0, a3).append(DirUsage.ALLATORIxDEMO("\u0007")).toString();
    }

    public double getSys() {
        return this.sys;
    }

    public double getUser() {
        return this.user;
    }

    CpuPerc() {
    }

    public double getIdle() {
        return this.idle;
    }

    public double getStolen() {
        return this.stolen;
    }

    public String toString() {
        return new StringBuilder().insert(0, JedisUtils.ALLATORIxDEMO("\u0016d\u0000\u0014&@4@0Go\u0014")).append(CpuPerc.format(this.user)).append(DirUsage.ALLATORIxDEMO("\u0002|QlP%\u0002")).append(CpuPerc.format(this.sys)).append(JedisUtils.ALLATORIxDEMO("\u0014&M&@0Yy\u0014")).append(CpuPerc.format(this.nice)).append(DirUsage.ALLATORIxDEMO("\u0002gKjG%\u0002")).append(CpuPerc.format(this.wait)).append(JedisUtils.ALLATORIxDEMO("\u0014\"U<@y\u0014")).append(CpuPerc.format(this.idle)).append(DirUsage.ALLATORIxDEMO("\u0002`FeG")).toString();
    }

    public double getWait() {
        return this.wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CpuPerc calculate(Cpu oldCpu, Cpu curCpu) {
        try (Sigar a = new Sigar();){
            CpuPerc cpuPerc = CpuPerc.fetch(a, oldCpu, curCpu);
            return cpuPerc;
        }
    }

    public double getIrq() {
        return this.irq;
    }

    native void gather(Sigar var1, Cpu var2, Cpu var3);

    static CpuPerc fetch(Sigar sigar, Cpu oldCpu, Cpu curCpu) {
        CpuPerc cpuPerc = new CpuPerc();
        cpuPerc.gather(sigar, oldCpu, curCpu);
        return cpuPerc;
    }

    public double getSoftIrq() {
        return this.softIrq;
    }

    public double getCombined() {
        return this.combined;
    }

    public double getNice() {
        return this.nice;
    }
}

