/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.common.j2cache.cache.support.utils.J2CacheConfigUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.hyperic.jni.ArchLoaderException;
import org.hyperic.sigar.C;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.FileAttrs;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;

public class FileInfo
extends FileAttrs
implements Serializable {
    public static final int TYPE_CHR = 3;
    public static final int MODE_UEXECUTE = 256;
    private boolean lstat;
    public static final int MODE_GWRITE = 32;
    private FileInfo oldInfo;
    public static final int TYPE_BLK = 4;
    private static final long serialVersionUID = 607239L;
    public static final int TYPE_PIPE = 5;
    public static final int MODE_WEXECUTE = 1;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(ArchLoaderException.ALLATORIxDEMO("oZo7Fs\u0002_j-Oz"));
    public static final int TYPE_LNK = 6;
    public static final int TYPE_SOCK = 7;
    public static final int MODE_GEXECUTE = 16;
    public static final int MODE_WWRITE = 2;
    public static final int TYPE_REG = 1;
    public static final int MODE_WREAD = 4;
    private transient Sigar sigar;
    public static final int TYPE_UNKFILE = 8;
    public static final int MODE_UREAD = 1024;
    private DirStat stat;
    public static final int MODE_GREAD = 64;
    public static final int MODE_UWRITE = 512;
    public static final int TYPE_DIR = 2;
    String name;
    private boolean dirStatEnabled;
    public static final int TYPE_NOFILE = 0;

    public String diff() {
        if (this.oldInfo == null) {
            return "";
        }
        FileInfo fileInfo = this;
        return fileInfo.diff(fileInfo.oldInfo);
    }

    public boolean modified() throws SigarException, SigarFileNotFoundException {
        if (this.oldInfo == null) {
            this.oldInfo = new FileInfo();
            if (this.dirStatEnabled) {
                this.oldInfo.stat = new DirStat();
            }
        }
        FileInfo fileInfo = this;
        fileInfo.copyTo(fileInfo.oldInfo);
        if (fileInfo.dirStatEnabled) {
            FileInfo fileInfo2 = this;
            fileInfo2.stat.copyTo(fileInfo2.oldInfo.stat);
        }
        FileInfo fileInfo3 = this;
        fileInfo3.stat();
        return fileInfo3.mtime != this.oldInfo.mtime;
    }

    public FileInfo getPreviousInfo() {
        return this.oldInfo;
    }

    private static native /* synthetic */ String getPermissionsString(long var0);

    public FileInfo() {
        FileInfo fileInfo = this;
        this.dirStatEnabled = false;
        fileInfo.stat = null;
        fileInfo.oldInfo = null;
    }

    public boolean changed() throws SigarException, SigarFileNotFoundException {
        return this.modified() || this.ctime != this.oldInfo.ctime;
    }

    public String diff(FileInfo info) {
        FileInfo fileInfo;
        ArrayList<C> a = new ArrayList<C>();
        if (this.getMtime() != info.getMtime()) {
            fileInfo = this;
            FileInfo fileInfo2 = this;
            a.add(new C(fileInfo2, J2CacheConfigUtils.ALLATORIxDEMO("e/A6M"), FileInfo.DATE_FORMAT.format(new Date(info.getMtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo2.getMtime()))));
        } else if (this.getCtime() != info.getCtime()) {
            fileInfo = this;
            FileInfo fileInfo3 = this;
            a.add(new C(fileInfo3, ArchLoaderException.ALLATORIxDEMO("TV~Or"), FileInfo.DATE_FORMAT.format(new Date(info.getCtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo3.getCtime()))));
        } else {
            return "";
        }
        if (fileInfo.getPermissions() != info.getPermissions()) {
            FileInfo fileInfo4 = this;
            a.add(new C(fileInfo4, J2CacheConfigUtils.ALLATORIxDEMO("x>Z6["), info.getPermissionsString(), fileInfo4.getPermissionsString()));
        }
        if (this.getType() != info.getType()) {
            FileInfo fileInfo5 = this;
            a.add(new C(fileInfo5, "Type", info.getTypeString(), fileInfo5.getTypeString()));
        }
        if (this.getUid() != info.getUid()) {
            a.add(new C(this, ArchLoaderException.ALLATORIxDEMO("BKs"), info.getUid(), this.getUid()));
        }
        if (this.getGid() != info.getGid()) {
            a.add(new C(this, J2CacheConfigUtils.ALLATORIxDEMO("o2L"), info.getGid(), this.getGid()));
        }
        if (this.getSize() != info.getSize()) {
            a.add(new C(this, ArchLoaderException.ALLATORIxDEMO("q~Xr"), info.getSize(), this.getSize()));
        }
        if (!OperatingSystem.IS_WIN32) {
            if (this.getInode() != info.getInode()) {
                a.add(new C(this, J2CacheConfigUtils.ALLATORIxDEMO("a5G?M"), info.getInode(), this.getInode()));
            }
            if (this.getDevice() != info.getDevice()) {
                a.add(new C(this, ArchLoaderException.ALLATORIxDEMO("frT~Ar"), info.getDevice(), this.getDevice()));
            }
            if (this.getNlink() != info.getNlink()) {
                a.add(new C(this, J2CacheConfigUtils.ALLATORIxDEMO("f7A5C"), info.getNlink(), this.getNlink()));
            }
        }
        FileInfo fileInfo6 = this;
        StringBuffer a2 = fileInfo6.format(a);
        if (fileInfo6.dirStatEnabled) {
            a2.append(this.diff(info.stat));
        }
        return a2.toString();
    }

    private /* synthetic */ StringBuffer format(ArrayList changes) {
        int a;
        StringBuffer a2 = new StringBuffer();
        if (changes.size() == 0) {
            return a2;
        }
        int a3 = changes.size();
        int n = a = 0;
        while (n < a3) {
            Object e2 = changes.get(a);
            a2.append('{').append(e2).append('}');
            n = ++a;
        }
        return a2;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o.equals(this.name);
    }

    public String getPermissionsString() {
        return FileInfo.getPermissionsString(this.permissions);
    }

    private static native /* synthetic */ String getTypeString(int var0);

    /*
     * Enabled aggressive block sorting
     */
    public char getTypeChar() {
        switch (this.type) {
            case 2: {
                return 'd';
            }
            case 3: {
                return 'c';
            }
            case 4: {
                return 'b';
            }
            case 5: {
                return 'p';
            }
            case 6: {
                return 'l';
            }
            case 7: {
                return 's';
            }
        }
        return '-';
    }

    static FileInfo fetchLinkInfo(Sigar sigar, String name) throws SigarException {
        return FileInfo.fetchInfo(sigar, name, false);
    }

    static FileInfo fetchFileInfo(Sigar sigar, String name) throws SigarException {
        return FileInfo.fetchInfo(sigar, name, true);
    }

    private static native /* synthetic */ int getMode(long var0);

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getMode() {
        return FileInfo.getMode(this.permissions);
    }

    public void enableDirStat(boolean value) {
        this.dirStatEnabled = value;
        if (this.dirStatEnabled) {
            block5: {
                if (this.type != 2) {
                    throw new IllegalArgumentException(new StringBuilder().insert(0, this.name).append(J2CacheConfigUtils.ALLATORIxDEMO("\b2[{F4\\{I{L2Z>K/G)Q")).toString());
                }
                if (this.stat != null) break block5;
                this.stat = this.sigar.getDirStat(this.name);
                return;
            }
            try {
                FileInfo fileInfo = this;
                fileInfo.stat.gather(fileInfo.sigar, this.name);
                return;
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
        }
    }

    native void gatherLink(Sigar var1, String var2) throws SigarException;

    public String diff(DirStat stat) {
        DirStat a = this.stat;
        ArrayList<C> a2 = new ArrayList<C>();
        if (a.files != stat.files) {
            a2.add(new C(this, ArchLoaderException.ALLATORIxDEMO("QK{Gd"), stat.getFiles(), a.getFiles()));
        }
        if (a.subdirs != stat.subdirs) {
            a2.add(new C(this, J2CacheConfigUtils.ALLATORIxDEMO("{.J?A)["), stat.getSubdirs(), a.getSubdirs()));
        }
        if (a.symlinks != stat.symlinks) {
            a2.add(new C(this, ArchLoaderException.ALLATORIxDEMO("qnO{KyId"), stat.getSymlinks(), a.getSymlinks()));
        }
        if (a.chrdevs != stat.chrdevs) {
            a2.add(new C(this, J2CacheConfigUtils.ALLATORIxDEMO("k3Z?M-["), stat.getChrdevs(), a.getChrdevs()));
        }
        if (a.blkdevs != stat.blkdevs) {
            a2.add(new C(this, ArchLoaderException.ALLATORIxDEMO("UN|FrTd"), stat.getBlkdevs(), a.getBlkdevs()));
        }
        if (a.sockets != stat.sockets) {
            a2.add(new C(this, J2CacheConfigUtils.ALLATORIxDEMO("{4K0M/["), stat.getSockets(), a.getSockets()));
        }
        if (a.total != stat.total) {
            a2.add(new C(this, ArchLoaderException.ALLATORIxDEMO("CMcC{"), stat.getTotal(), a.getTotal()));
        }
        return this.format(a2).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ FileInfo fetchInfo(Sigar sigar, String name, boolean followSymlinks) throws SigarException {
        FileInfo a;
        block3: {
            a = new FileInfo();
            try {
                if (!followSymlinks) break block3;
                a.gather(sigar, name);
                a.lstat = false;
            }
            catch (SigarException sigarException) {
                void a2;
                void v0 = a2;
                v0.setMessage(name + J2CacheConfigUtils.ALLATORIxDEMO("a\b") + a2.getMessage());
                throw v0;
            }
        }
        a.gatherLink(sigar, name);
        a.lstat = true;
        FileInfo fileInfo = a;
        fileInfo.sigar = sigar;
        fileInfo.name = name;
        return a;
    }

    public void stat() throws SigarException, SigarFileNotFoundException {
        FileInfo fileInfo;
        FileInfo fileInfo2 = this;
        long a = fileInfo2.mtime;
        if (fileInfo2.lstat) {
            FileInfo fileInfo3 = this;
            FileInfo fileInfo4 = this;
            fileInfo = fileInfo4;
            fileInfo3.gatherLink(fileInfo3.sigar, fileInfo4.name);
        } else {
            FileInfo fileInfo5 = this;
            fileInfo = fileInfo5;
            FileInfo fileInfo6 = this;
            fileInfo6.gather(fileInfo5.sigar, fileInfo6.name);
        }
        if (fileInfo.dirStatEnabled && a != this.mtime) {
            FileInfo fileInfo7 = this;
            fileInfo7.stat.gather(fileInfo7.sigar, this.name);
        }
    }

    public String getTypeString() {
        return FileInfo.getTypeString(this.type);
    }
}

