/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.win32.FileVersion;

public class FileSystem
implements Serializable {
    private static final long serialVersionUID = 9641L;
    public static final int TYPE_NETWORK = 3;
    int type;
    public static final int TYPE_CDROM = 5;
    String dirName;
    String typeName;
    public static final int TYPE_UNKNOWN = 0;
    String options;
    long flags;
    public static final int TYPE_SWAP = 6;
    public static final int TYPE_NONE = 1;
    String sysTypeName;
    public static final int TYPE_RAM_DISK = 4;
    String devName;
    public static final int TYPE_LOCAL_DISK = 2;

    public int getType() {
        return this.type;
    }

    public static String ALLATORIxDEMO(String s) {
        int n = s.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 4 << 4 ^ (3 ^ 5) << 1;
        int cfr_ignored_0 = (2 ^ 5) << 4 ^ (2 << 2 ^ 1);
        int n4 = n2;
        int n5 = 5 << 4 ^ 3;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(s.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(s.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    public String getSysTypeName() {
        return this.sysTypeName;
    }

    public String getDirName() {
        return this.dirName;
    }

    public String getOptions() {
        return this.options;
    }

    static FileSystem fetch(Sigar sigar) throws SigarException {
        FileSystem fileSystem = new FileSystem();
        fileSystem.gather(sigar);
        return fileSystem;
    }

    public native void gather(Sigar var1) throws SigarException;

    public long getFlags() {
        return this.flags;
    }

    /*
     * WARNING - void declaration
     */
    void copyTo(FileSystem fileSystem) {
        void copy;
        void v0 = copy;
        FileSystem fileSystem2 = this;
        void v2 = copy;
        FileSystem fileSystem3 = this;
        copy.dirName = this.dirName;
        copy.devName = fileSystem3.devName;
        v2.typeName = fileSystem3.typeName;
        v2.sysTypeName = this.sysTypeName;
        copy.options = fileSystem2.options;
        v0.type = fileSystem2.type;
        v0.flags = this.flags;
    }

    public Map toMap() {
        HashMap<String, String> a = new HashMap<String, String>();
        String a2 = String.valueOf(this.dirName);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a2)) {
            a.put(FileVersion.ALLATORIxDEMO("`gV@EcA"), a2);
        }
        String a3 = String.valueOf(this.devName);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a3)) {
            a.put(FileVersion.ALLATORIxDEMO("`kR@EcA"), a3);
        }
        String a4 = String.valueOf(this.typeName);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a4)) {
            a.put(FileVersion.ALLATORIxDEMO("Z]~A@EcA"), a4);
        }
        String a5 = String.valueOf(this.sysTypeName);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a5)) {
            a.put(FileVersion.ALLATORIxDEMO("wwWZ]~A@EcA"), a5);
        }
        String a6 = String.valueOf(this.options);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a6)) {
            a.put(FileVersion.ALLATORIxDEMO("k~PgK`W"), a6);
        }
        String a7 = String.valueOf(this.type);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a7)) {
            a.put("Type", a7);
        }
        String a8 = String.valueOf(this.flags);
        if (!FileVersion.ALLATORIxDEMO("#\u0015").equals(a8)) {
            a.put(DirStat.ALLATORIxDEMO("e%B.P"), a8);
        }
        return a;
    }

    public String toString() {
        return this.getDirName();
    }

    public FileSystem() {
        FileSystem fileSystem = this;
        FileSystem fileSystem2 = this;
        FileSystem fileSystem3 = this;
        this.dirName = null;
        fileSystem3.devName = null;
        fileSystem3.typeName = null;
        fileSystem2.sysTypeName = null;
        fileSystem2.options = null;
        fileSystem.type = 0;
        fileSystem.flags = 0L;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDevName() {
        return this.devName;
    }
}

