/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.modules.sys.utils.ConfigUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.sigar.FileTail;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.NfsClientV3;

public class FileWatcherThread
implements Runnable {
    private long interval;
    public static final int DEFAULT_INTERVAL = 300000;
    private Thread thread;
    private static FileWatcherThread instance = null;
    private Set watchers;
    private boolean shouldDie;

    public static synchronized FileWatcherThread getInstance() {
        if (instance == null) {
            instance = new FileWatcherThread();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check() {
        Set set = this.watchers;
        synchronized (set) {
            Iterator a = this.watchers.iterator();
            while (a.hasNext()) {
                FileWatcher a2 = (FileWatcher)a.next();
                try {
                    a2.check();
                }
                catch (Exception a3) {
                    FileTail.error(new StringBuilder().insert(0, NfsClientV3.ALLATORIxDEMO("\u0011%!34.'?!/d.<(!;0\"+%~k")).append(a3.getMessage()).toString(), a3);
                    continue;
                }
                break;
            }
            return;
        }
    }

    @Override
    public void run() {
        FileWatcherThread fileWatcherThread = this;
        while (!fileWatcherThread.shouldDie) {
            this.check();
            try {
                Thread.sleep(this.interval);
                fileWatcherThread = this;
            }
            catch (InterruptedException interruptedException) {
                fileWatcherThread = this;
            }
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public FileWatcherThread() {
        FileWatcherThread fileWatcherThread = this;
        fileWatcherThread.thread = null;
        fileWatcherThread.shouldDie = false;
        this.interval = 300000L;
        FileWatcherThread fileWatcherThread2 = this;
        fileWatcherThread2.watchers = Collections.synchronizedSet(new HashSet());
    }

    public void die() {
        this.shouldDie = true;
    }

    public synchronized void doStop() {
        if (this.thread == null) {
            return;
        }
        FileWatcherThread fileWatcherThread = this;
        fileWatcherThread.die();
        fileWatcherThread.thread.interrupt();
        this.thread = null;
    }

    public synchronized void doStart() {
        if (this.thread != null) {
            return;
        }
        FileWatcherThread fileWatcherThread = this;
        this.thread = new Thread((Runnable)this, ConfigUtils.ALLATORIxDEMO("#6\t:2>\u0011<\r:\u0017\u000b\r-\u0000>\u0001"));
        fileWatcherThread.thread.setDaemon(true);
        fileWatcherThread.thread.start();
    }

    public void add(FileWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void remove(FileWatcher watcher) {
        this.watchers.remove(watcher);
    }
}

