/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetRoute
implements Serializable {
    long use;
    long flags;
    String gateway;
    long mtu;
    long refcnt;
    long metric;
    long irtt;
    long window;
    private static final long serialVersionUID = 13039L;
    String destination;
    String ifname;
    String mask;

    public String getDestination() {
        return this.destination;
    }

    public String toString() {
        return this.toMap().toString();
    }

    public NetRoute() {
        NetRoute netRoute = this;
        NetRoute netRoute2 = this;
        NetRoute netRoute3 = this;
        NetRoute netRoute4 = this;
        NetRoute netRoute5 = this;
        this.destination = null;
        netRoute5.gateway = null;
        netRoute5.flags = 0L;
        netRoute4.refcnt = 0L;
        netRoute4.use = 0L;
        netRoute3.metric = 0L;
        netRoute3.mask = null;
        netRoute2.mtu = 0L;
        netRoute2.window = 0L;
        netRoute.irtt = 0L;
        netRoute.ifname = null;
    }

    public Map toMap() {
        HashMap<String, String> a = new HashMap<String, String>();
        String a2 = String.valueOf(this.destination);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a2)) {
            a.put(ProcCredName.ALLATORIxDEMO("#\u001c\u0014\r\u000e\u0017\u0006\r\u000e\u0016\t"), a2);
        }
        String a3 = String.valueOf(this.gateway);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a3)) {
            a.put(ProcCredName.ALLATORIxDEMO(" \u0018\u0013\u001c\u0010\u0018\u001e"), a3);
        }
        String a4 = String.valueOf(this.flags);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a4)) {
            a.put(ProcCredName.ALLATORIxDEMO("!\u0015\u0006\u001e\u0014"), a4);
        }
        String a5 = String.valueOf(this.refcnt);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a5)) {
            a.put(ProcCredName.ALLATORIxDEMO("+\u0002\u001f\u0004\u0017\u0013"), a5);
        }
        String a6 = String.valueOf(this.use);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a6)) {
            a.put(ProcCredName.ALLATORIxDEMO("2\n\u0002"), a6);
        }
        String a7 = String.valueOf(this.metric);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a7)) {
            a.put(ProcCredName.ALLATORIxDEMO("4\u0002\r\u0015\u0010\u0004"), a7);
        }
        String a8 = String.valueOf(this.mask);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a8)) {
            a.put(ProcCredName.ALLATORIxDEMO("4\u0006\n\f"), a8);
        }
        String a9 = String.valueOf(this.mtu);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a9)) {
            a.put(ProcCredName.ALLATORIxDEMO("*\r\u0012"), a9);
        }
        String a10 = String.valueOf(this.window);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a10)) {
            a.put(ProcCredName.ALLATORIxDEMO(".\u000e\u0017\u0003\u0016\u0010"), a10);
        }
        String a11 = String.valueOf(this.irtt);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a11)) {
            a.put(ProcCredName.ALLATORIxDEMO("0\u0015\r\u0013"), a11);
        }
        String a12 = String.valueOf(this.ifname);
        if (!DirStat.ALLATORIxDEMO("d\u0012").equals(a12)) {
            a.put(ProcCredName.ALLATORIxDEMO("0\u0001\u0017\u0006\u0014\u0002"), a12);
        }
        return a;
    }

    public long getUse() {
        return this.use;
    }

    public String getIfname() {
        return this.ifname;
    }

    public long getRefcnt() {
        return this.refcnt;
    }

    public String getGateway() {
        return this.gateway;
    }

    public long getFlags() {
        return this.flags;
    }

    public native void gather(Sigar var1) throws SigarException;

    public static String ALLATORIxDEMO(String s) {
        int n = s.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = (3 ^ 5) << 4 ^ 5;
        int cfr_ignored_0 = (3 ^ 5) << 3 ^ (3 ^ 5);
        int n4 = n2;
        int n5 = (2 ^ 5) << 3 ^ (2 ^ 5);
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(s.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(s.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    public long getIrtt() {
        return this.irtt;
    }

    public long getMetric() {
        return this.metric;
    }

    /*
     * WARNING - void declaration
     */
    void copyTo(NetRoute netRoute) {
        void copy;
        void v0 = copy;
        NetRoute netRoute2 = this;
        void v2 = copy;
        NetRoute netRoute3 = this;
        void v4 = copy;
        NetRoute netRoute4 = this;
        void v6 = copy;
        v6.destination = this.destination;
        v6.gateway = this.gateway;
        copy.flags = netRoute4.flags;
        v4.refcnt = netRoute4.refcnt;
        v4.use = this.use;
        copy.metric = netRoute3.metric;
        v2.mask = netRoute3.mask;
        v2.mtu = this.mtu;
        copy.window = netRoute2.window;
        v0.irtt = netRoute2.irtt;
        v0.ifname = this.ifname;
    }

    public String getMask() {
        return this.mask;
    }

    public long getWindow() {
        return this.window;
    }

    public long getMtu() {
        return this.mtu;
    }

    static NetRoute fetch(Sigar sigar) throws SigarException {
        NetRoute netRoute = new NetRoute();
        netRoute.gather(sigar);
        return netRoute;
    }
}

