/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import com.jeesite.common.z.B;
import java.util.ArrayList;
import org.hyperic.sigar.DiskUsage;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.shell.FileCompleter;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.util.GetlineCompleter;

public class Iostat
extends SigarCommandBase {
    private static final String OUTPUT_FORMAT = "%-15s %-15s %10s %10s %7s %7s %5s %5s";
    private GetlineCompleter completer;
    private static final String[] HEADER;

    public void outputDisk(String name) throws SigarException {
        Iostat iostat;
        DiskUsage diskUsage;
        DiskUsage diskUsage2;
        Iostat iostat2 = this;
        DiskUsage a = iostat2.sigar.getDiskUsage(name);
        ArrayList<String> a2 = new ArrayList<String>();
        iostat2.printHeader();
        a2.add(name);
        a2.add(B.ALLATORIxDEMO("s"));
        a2.add(String.valueOf(a.getReads()));
        a2.add(String.valueOf(a.getWrites()));
        if (a.getReadBytes() == -1L) {
            diskUsage2 = a;
            a2.add(Mem.ALLATORIxDEMO("t"));
            a2.add(B.ALLATORIxDEMO("s"));
        } else {
            a2.add(Sigar.formatSize(a.getReadBytes()));
            a2.add(Sigar.formatSize(a.getWriteBytes()));
            diskUsage2 = a;
        }
        if (diskUsage2.getQueue() == -1.0) {
            diskUsage = a;
            a2.add(Mem.ALLATORIxDEMO("t"));
        } else {
            a2.add(this.svctm(a.getQueue()));
            diskUsage = a;
        }
        ArrayList<String> arrayList = a2;
        if (diskUsage.getServiceTime() == -1.0) {
            arrayList.add(B.ALLATORIxDEMO("s"));
            iostat = this;
        } else {
            arrayList.add(this.svctm(a.getServiceTime()));
            iostat = this;
        }
        iostat.printf(a2);
    }

    public void outputFileSystem(String arg) throws SigarException {
        String a;
        FileSystemMap a2 = this.proxy.getFileSystemMap();
        FileSystem a3 = a2.getMountPoint(a = FileCompleter.expand(arg));
        if (a3 != null) {
            Iostat iostat = this;
            iostat.printHeader();
            iostat.output(a3);
            return;
        }
        throw new SigarException(new StringBuilder().insert(0, arg).append(Mem.ALLATORIxDEMO(")\u0017fyz,j1)?`5lyf+)=`+l:}6{ ")).toString());
    }

    public void output(FileSystem fs) throws SigarException {
        Iostat iostat;
        FileSystemUsage fileSystemUsage;
        FileSystemUsage fileSystemUsage2;
        FileSystemUsage a = this.sigar.getFileSystemUsage(fs.getDirName());
        ArrayList<String> a2 = new ArrayList<String>();
        a2.add(fs.getDevName());
        a2.add(fs.getDirName());
        a2.add(String.valueOf(a.getDiskReads()));
        a2.add(String.valueOf(a.getDiskWrites()));
        if (a.getDiskReadBytes() == -1L) {
            fileSystemUsage2 = a;
            a2.add(B.ALLATORIxDEMO("s"));
            a2.add(Mem.ALLATORIxDEMO("t"));
        } else {
            a2.add(Sigar.formatSize(a.getDiskReadBytes()));
            a2.add(Sigar.formatSize(a.getDiskWriteBytes()));
            fileSystemUsage2 = a;
        }
        if (fileSystemUsage2.getDiskQueue() == -1.0) {
            fileSystemUsage = a;
            a2.add(B.ALLATORIxDEMO("s"));
        } else {
            a2.add(this.svctm(a.getDiskQueue()));
            fileSystemUsage = a;
        }
        ArrayList<String> arrayList = a2;
        if (fileSystemUsage.getDiskServiceTime() == -1.0) {
            arrayList.add(Mem.ALLATORIxDEMO("t"));
            iostat = this;
        } else {
            arrayList.add(this.svctm(a.getDiskServiceTime()));
            iostat = this;
        }
        iostat.printf(a2);
    }

    @Override
    public void output(String[] args) throws SigarException {
        int a;
        if (args.length == 1) {
            String a2 = args[0];
            if (a2.indexOf(47) != -1 || a2.indexOf(92) != -1) {
                this.outputFileSystem(a2);
                return;
            }
            this.outputDisk(a2);
            return;
        }
        Iostat iostat = this;
        FileSystem[] a3 = iostat.proxy.getFileSystemList();
        iostat.printHeader();
        int n = a = 0;
        while (n < a3.length) {
            if (a3[a].getType() == 2) {
                this.output(a3[a]);
            }
            n = ++a;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Iostat(Shell shell) {
        void shell2;
        Iostat iostat = this;
        super((Shell)shell2);
        iostat.setOutputFormat(OUTPUT_FORMAT);
        Iostat iostat2 = this;
        iostat.completer = new FileCompleter((ShellBase)shell2);
    }

    private /* synthetic */ String svctm(double val) {
        Object[] objectArray = new Object[1];
        objectArray[0] = new Double(val);
        return this.sprintf(B.ALLATORIxDEMO("{'p&8"), objectArray);
    }

    @Override
    protected boolean validateArgs(String[] args) {
        return args.length <= 1;
    }

    @Override
    public String getUsageShort() {
        return Mem.ALLATORIxDEMO("[<y6{-)?`5l*p*}<dym0z2)0&6");
    }

    public static void main(String[] stringArray) throws Exception {
        String[] args;
        System.out.println(B.ALLATORIxDEMO("T7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}\u001e}4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~7T7~4~4~4~4}7~7~4~7~4~4}7~7}7~7}7~7}4~7}7~4~4~4~4}\u001e}4~4~4~4}4}4}4~4}4~4}4}4~7~4}4}4}4}4~7~4~4~4~4~7T7~4~4~4~7}7~7~4~7~4~7}7~4}4~7~7~7}4~4}4~4~4~4~4}\u001e}4~4~4~4}4}4}7}4}7}4}4}4~7~4}7}4}4}4}7}4~4~4~4~7T7~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4}\u001e}4\u0011v8a-w?`7{04<m~U2x?`1f74\u0011v8a-w?`1f~bh:i4\u001aQ\u0013[~7T7~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4}\u001e}4~4~4~4~4~46`*dd;qc)cpu2x?`1f7:={34~4~4~4~4~4~7T7~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4~4}\u001e}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7}7T"));
        new Iostat().processCommand(args);
    }

    public Iostat() {
        Iostat iostat = this;
        iostat.setOutputFormat(OUTPUT_FORMAT);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = Mem.ALLATORIxDEMO("O0e<z z-l4");
        stringArray[1] = B.ALLATORIxDEMO("Y1a0`;p~{0");
        stringArray[2] = Mem.ALLATORIxDEMO("\u000bl8m*");
        stringArray[3] = B.ALLATORIxDEMO("C,}*q-");
        stringArray[4] = Mem.ALLATORIxDEMO("\u000b$;p-l*");
        stringArray[5] = B.ALLATORIxDEMO("\t9<m*q-");
        stringArray[6] = Mem.ALLATORIxDEMO("\b|<|<");
        stringArray[7] = B.ALLATORIxDEMO("\rb=`3");
        HEADER = stringArray;
    }

    @Override
    public String getSyntaxArgs() {
        return Mem.ALLATORIxDEMO("R?`5l*p*}<d\u0004");
    }

    public void printHeader() {
        this.printf(HEADER);
    }

    @Override
    public GetlineCompleter getCompleter() {
        return this.completer;
    }
}

