/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Tcp;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.pager.PageList;

public class Netstat
extends SigarCommandBase {
    private static boolean isStat;
    private static final int RADDR_LEN = 35;
    private static boolean isNumeric;
    private static final String[] HEADER;
    private static boolean wantPid;
    private static final int LADDR_LEN = 20;

    static {
        String[] stringArray = new String[5];
        stringArray[0] = DirUsage.ALLATORIxDEMO("r{M}M");
        stringArray[1] = PageList.ALLATORIxDEMO("P[\u007fUp\u0014]PxFyGo");
        stringArray[2] = DirUsage.ALLATORIxDEMO("dfPlKnL)cmF{GzQ");
        stringArray[3] = PageList.ALLATORIxDEMO("O@}@y");
        stringArray[4] = "";
        HEADER = stringArray;
    }

    private /* synthetic */ String formatPort(int proto, long port) {
        String a;
        if (port == 0L) {
            return DirUsage.ALLATORIxDEMO("\b");
        }
        if (!isNumeric && (a = this.sigar.getNetServicesName(proto, port)) != null) {
            return a;
        }
        return String.valueOf(port);
    }

    @Override
    public String getUsageShort() {
        return PageList.ALLATORIxDEMO("X]oDpUe\u0014rQhCsFw\u0014\u007f[rZyWh]sZo");
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void outputStats(int flags) throws SigarException {
        if ((flags & 0x10) != 0) {
            this.println(DirUsage.ALLATORIxDEMO("]Ay\u0018"));
            try {
                this.outputTcpStats();
                return;
            }
            catch (SigarException sigarException) {
                void a;
                this.println(PageList.ALLATORIxDEMO("\u0014<\u0014<") + a);
            }
        }
    }

    private /* synthetic */ void outputTcpStats() throws SigarException {
        Netstat netstat = this;
        Tcp a = netstat.sigar.getTcp();
        String a2 = DirUsage.ALLATORIxDEMO(")\u0002)\u0002");
        netstat.println(PageList.ALLATORIxDEMO("\u0014<\u0014<") + a.getActiveOpens() + DirUsage.ALLATORIxDEMO(")CjV`Tl\u0002jMgLlA}KfLz\u0002fRlL`LnQ"));
        this.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getPassiveOpens()).append(DirUsage.ALLATORIxDEMO(")RhQzK\u007fG)AfLgGjV`Mg\u0002fRlL`LnQ")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getAttemptFails()).append(DirUsage.ALLATORIxDEMO("\u0002oC`NlF)AfLgGjV`Mg\u0002hV}GdR}Q")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getEstabResets()).append(DirUsage.ALLATORIxDEMO("\u0002jMgLlA}KfL)PlQlVz\u0002{GjG`TlF")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getCurrEstab()).append(DirUsage.ALLATORIxDEMO(")AfLgGjV`MgQ)GzVh@eKzJlF")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getInSegs()).append(DirUsage.ALLATORIxDEMO(")QlEdGgVz\u0002{GjG`TlF")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getOutSegs()).append(DirUsage.ALLATORIxDEMO(")QlEdGgVz\u0002zGgF)M|V")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getRetransSegs()).append(DirUsage.ALLATORIxDEMO(")QlEdGgVz\u0002{G}PhLzO`VlF")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getInErrs()).append(DirUsage.ALLATORIxDEMO("\u0002kCm\u0002zGnOlL}Q)PlAlK\u007fGm\f")).toString());
        netstat.println(new StringBuilder().insert(0, PageList.ALLATORIxDEMO("\u0014<\u0014<")).append(a.getOutRsts()).append(DirUsage.ALLATORIxDEMO(")PlQlVz\u0002zGgV")).toString());
    }

    public Netstat(Shell shell) {
        super(shell);
    }

    @Override
    public void output(String[] args) throws SigarException {
        int a;
        int a2 = 241;
        if (args.length > 0) {
            a2 = Netstat.getFlags(args, a2);
            if (isStat) {
                this.outputStats(a2);
                return;
            }
        }
        Netstat netstat = this;
        NetConnection[] a3 = netstat.sigar.getNetConnectionList(a2);
        netstat.printf(HEADER);
        int n = a = 0;
        while (n < a3.length) {
            String a4;
            NetConnection a5 = a3[a];
            String a6 = a5.getTypeString();
            String a7 = a5.getType() == 32 ? "" : a5.getStateString();
            ArrayList<String> a8 = new ArrayList<String>();
            a8.add(a6);
            a8.add(this.formatAddress(a5.getType(), a5.getLocalAddress(), a5.getLocalPort(), 20));
            a8.add(this.formatAddress(a5.getType(), a5.getRemoteAddress(), a5.getRemotePort(), 35));
            a8.add(a7);
            Object var9_9 = null;
            if (wantPid && a5.getState() == 10) {
                try {
                    long a9 = this.sigar.getProcPort(a5.getType(), a5.getLocalPort());
                    if (a9 != 0L) {
                        String a10 = this.sigar.getProcState(a9).getName();
                        a4 = a9 + PageList.ALLATORIxDEMO("3") + a10;
                    }
                }
                catch (SigarException a9) {
                    // empty catch block
                }
            }
            if (a4 == null) {
                a4 = "";
            }
            a8.add(a4);
            this.printf(a8);
            n = ++a;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String[] args;
        System.out.println(DirUsage.ALLATORIxDEMO("(*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001\u0003\u0001)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002*(*\u0002)\u0002)\u0002)\u0002)\u0001*\u0002*\u0002)\u0002*\u0002)\u0002)\u0001*\u0002*\u0001*\u0002*\u0001*\u0002*\u0001)\u0002*\u0001*\u0002)\u0002)\u0002)\u0002)\u0001\u0003\u0001)\u0002)\u0002)\u0002)\u0001)\u0001)\u0001)\u0002)\u0001)\u0002)\u0001)\u0001)\u0002*\u0002)\u0001)\u0001)\u0001)\u0001)\u0002*\u0002)\u0002)\u0002)\u0002)\u0002*(*\u0002)\u0002)\u0002)\u0002*\u0001*\u0002*\u0002)\u0002*\u0002)\u0002*\u0001*\u0002)\u0001)\u0002*\u0002*\u0002*\u0001)\u0002)\u0001)\u0002)\u0002)\u0002)\u0002)\u0001\u0003\u0001)\u0002)\u0002)\u0002)\u0001)\u0001)\u0001*\u0001)\u0001*\u0001)\u0001)\u0001)\u0002*\u0002)\u0001*\u0001)\u0001)\u0001)\u0001*\u0001)\u0002)\u0002)\u0002)\u0002*(*\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0001\u0003\u0001)mkD|QjC}KfL)@p\u0002HNeC}M{K)mkD|QjC}M{\u0002\u007f\u0014'\u0015)fLoF\u0002*(*\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0001\u0003\u0001)\u0002)\u0002)\u0002)\u0002)\u0002)J}Vy\u0018&\r~U~\fhNeC}M{K'AfO)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002*(*\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0002)\u0001\u0003\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*\u0001*("));
        new Netstat().processCommand(args);
    }

    @Override
    protected boolean validateArgs(String[] args) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getFlags(String[] args, int flags) {
        int a;
        int a2 = 0;
        isNumeric = false;
        wantPid = false;
        isStat = false;
        int n = a = 0;
        while (true) {
            if (n >= args.length) {
                if (a2 != 0) {
                    flags &= 0xFFFFFF0F;
                    flags |= a2;
                }
                return flags;
            }
            String a3 = args[a];
            int a4 = 0;
            block13: while (true) {
                int n2 = a4;
                block14: while (n2 < a3.length()) {
                    char c2 = a3.charAt(a4);
                    ++a4;
                    switch (c2) {
                        case '-': {
                            continue block13;
                        }
                        case 'l': {
                            flags &= 0xFFFFFFFE;
                            flags |= 2;
                            n2 = a4;
                            continue block14;
                        }
                        case 'a': {
                            flags |= 3;
                            n2 = a4;
                            continue block14;
                        }
                        case 'n': {
                            isNumeric = true;
                            n2 = a4;
                            continue block14;
                        }
                        case 'p': {
                            wantPid = true;
                            n2 = a4;
                            continue block14;
                        }
                        case 's': {
                            isStat = true;
                            n2 = a4;
                            continue block14;
                        }
                        case 't': {
                            a2 |= 0x10;
                            n2 = a4;
                            continue block14;
                        }
                        case 'u': {
                            a2 |= 0x20;
                            n2 = a4;
                            continue block14;
                        }
                        case 'w': {
                            a2 |= 0x40;
                            n2 = a4;
                            continue block14;
                        }
                        case 'x': {
                            a2 |= 0x80;
                            n2 = a4;
                            continue block14;
                        }
                    }
                    System.err.println(PageList.ALLATORIxDEMO("Ar_r[kZ<[l@u[r"));
                    n2 = a4;
                }
                break;
            }
            n = ++a;
        }
    }

    private /* synthetic */ String formatAddress(int proto, String ip, long portnum, int max) {
        String a;
        int n;
        String a2 = this.formatPort(proto, portnum);
        if (NetFlags.isAnyAddress(ip)) {
            String string = DirUsage.ALLATORIxDEMO("\b");
            n = max;
        } else if (isNumeric) {
            a = ip;
            n = max;
        } else {
            try {
                a = InetAddress.getByName(ip).getHostName();
                n = max;
            }
            catch (UnknownHostException a3) {
                a = ip;
                n = max;
            }
        }
        max = n - (a2.length() + 1);
        if (a.length() > max) {
            a = a.substring(0, max);
        }
        return new StringBuilder().insert(0, a).append(PageList.ALLATORIxDEMO("&")).append(a2).toString();
    }

    public Netstat() {
    }
}

