/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.hyperic.sigar.NfsClientV3;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.cmd.CpuInfo;
import org.hyperic.sigar.cmd.Df;
import org.hyperic.sigar.cmd.Du;
import org.hyperic.sigar.cmd.FileVersionInfo;
import org.hyperic.sigar.cmd.Free;
import org.hyperic.sigar.cmd.Ifconfig;
import org.hyperic.sigar.cmd.Iostat;
import org.hyperic.sigar.cmd.Kill;
import org.hyperic.sigar.cmd.Ls;
import org.hyperic.sigar.cmd.MultiPs;
import org.hyperic.sigar.cmd.NetInfo;
import org.hyperic.sigar.cmd.Netstat;
import org.hyperic.sigar.cmd.Nfsstat;
import org.hyperic.sigar.cmd.Pidof;
import org.hyperic.sigar.cmd.ProcFileInfo;
import org.hyperic.sigar.cmd.ProcInfo;
import org.hyperic.sigar.cmd.ProcModuleInfo;
import org.hyperic.sigar.cmd.Ps;
import org.hyperic.sigar.cmd.Route;
import org.hyperic.sigar.cmd.ShowArgs;
import org.hyperic.sigar.cmd.ShowEnv;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.cmd.SysInfo;
import org.hyperic.sigar.cmd.Time;
import org.hyperic.sigar.cmd.Ulimit;
import org.hyperic.sigar.cmd.Uptime;
import org.hyperic.sigar.cmd.Version;
import org.hyperic.sigar.cmd.Who;
import org.hyperic.sigar.cmd.Win32Service;
import org.hyperic.sigar.ptql.ProcessFinder;
import org.hyperic.sigar.shell.ShellBase;
import org.hyperic.sigar.shell.ShellCommandExecException;
import org.hyperic.sigar.shell.ShellCommandHandler;
import org.hyperic.sigar.shell.ShellCommandInitException;
import org.hyperic.sigar.shell.ShellCommandUsageException;
import org.hyperic.sigar.util.Getline;

public class Shell
extends ShellBase {
    private long[] foundPids;
    private boolean isInteractive;
    private Sigar sigar;
    public static final String RCFILE_NAME = ".sigar_shellrc";
    private SigarProxy proxy;
    private static final String CLEAR_SCREEN = "\u001b[2J";

    public void registerCommands() throws ShellCommandInitException {
        Shell shell = this;
        Shell shell2 = this;
        Shell shell3 = this;
        Shell shell4 = this;
        Shell shell5 = this;
        Shell shell6 = this;
        Shell shell7 = this;
        Shell shell8 = this;
        Shell shell9 = this;
        Shell shell10 = this;
        Shell shell11 = this;
        Shell shell12 = this;
        Shell shell13 = this;
        shell13.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u001d\u0001"), new Df(this));
        shell13.registerCommandHandler(NfsClientV3.ALLATORIxDEMO(" >"), new Du(this));
        shell12.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u0015\u0014"), new Ls(this));
        shell12.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("-$7?%?"), new Iostat(this));
        shell11.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u001f\u0015\u001c\u0002"), new Free(this));
        shell11.registerCommandHandler(NfsClientV3.ALLATORIxDEMO(";%9#8"), new ShowArgs(this));
        shell10.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\t\u0002\u0017\u0011"), new ShowEnv(this));
        shell10.registerCommandHandler(NfsClientV3.ALLATORIxDEMO(";\"\"(."), new ProcFileInfo(this));
        shell9.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\t\n\u0016\u0003\f\u000b\u001c\u0014"), new ProcModuleInfo(this));
        shell9.registerCommandHandler(NfsClientV3.ALLATORIxDEMO(";-%\"$"), new ProcInfo(this));
        shell8.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u0004\t\u0012\u0010\t\u001f\b"), new CpuInfo(this));
        shell8.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("--'$*--,"), new Ifconfig(this));
        shell7.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\f\u0017\r\u000e\u0014\u0002"), new Uptime(this));
        shell7.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("48"), new Ps(this));
        shell6.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u0017\u0010\u0003\u0016\u0001"), new Pidof(this));
        shell6.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("/\"('"), new Kill(this));
        shell5.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\t\u001c\u0013\n\u0013\u0018\u0013"), new Netstat(this));
        shell5.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("%!?-%\"$"), new NetInfo(this));
        shell4.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\t\u001f\u0014\n\u0013\u0018\u0013"), new Nfsstat(this));
        shell4.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("9+>0."), new Route(this));
        shell3.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u0011\u001c\u0015\n\u000e\u0016\t"), new Version(this));
        shell3.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("&48"), new MultiPs(this));
        shell2.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u0014\u0000\u0014\u0010\t\u001f\b"), new SysInfo(this));
        shell2.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("0\")."), new Time(this));
        shell.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\f\u000b\u0010\n\u0010\u0013"), new Ulimit(this));
        shell.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("<,$"), new Who(this));
        if (SigarLoader.IS_WIN32) {
            Shell shell14 = this;
            shell14.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\u0014\u001c\u0015\u000f\u000e\u001a\u0002"), new Win32Service(this));
            shell14.registerCommandHandler(NfsClientV3.ALLATORIxDEMO("\"=!97\"+%"), new FileVersionInfo(this));
        }
        try {
            this.registerCommandHandler(ProcCredName.ALLATORIxDEMO("\r\u0002\n\u0013"), "org.hyperic.sigar.test.SigarTestRunner");
            return;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setInteractive(boolean value) {
        this.isInteractive = value;
    }

    public long[] findPids(String[] args) throws SigarException {
        if (args.length == 1 && args[0].equals(NfsClientV3.ALLATORIxDEMO("f"))) {
            return this.foundPids;
        }
        Shell shell = this;
        shell.foundPids = Shell.getPids(shell.proxy, args);
        return shell.foundPids;
    }

    public long[] findPids(String query) throws SigarException {
        String[] stringArray = new String[1];
        stringArray[0] = query;
        return this.findPids(stringArray);
    }

    @Override
    public void shutdown() {
        Shell shell;
        this.sigar.close();
        try {
            Class.forName("org.hyperic.sigar.test.SigarTestCase").getMethod(ProcCredName.ALLATORIxDEMO("\u001a\u000b\u0016\u0014\u001c4\u0010\u0000\u0018\u0015"), new Class[0]).invoke(null, new Object[0]);
            shell = this;
        }
        catch (ClassNotFoundException classNotFoundException) {
            shell = this;
        }
        catch (Exception a) {
            shell = this;
            a.printStackTrace();
        }
        catch (NoClassDefFoundError a) {
            shell = this;
        }
        super.shutdown();
    }

    public static void clearScreen() {
        System.out.print(CLEAR_SCREEN);
    }

    @Override
    public void processCommand(ShellCommandHandler handler, String[] args) throws ShellCommandUsageException, ShellCommandExecException {
        try {
            super.processCommand(handler, args);
            if (handler instanceof SigarCommandBase) {
                ((SigarCommandBase)handler).flush();
            }
            return;
        }
        finally {
            SigarProxyCache.clear(this.proxy);
        }
    }

    public String getUserDeniedMessage(long pid) {
        return SigarPermissionDeniedException.getUserDeniedMessage(this.proxy, pid);
    }

    public Shell() {
        Shell shell = this;
        this.sigar = new Sigar();
        this.proxy = SigarProxyCache.newInstance(this.sigar);
        shell.foundPids = new long[0];
        shell.isInteractive = false;
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void readCommandFile(String dir) {
        try {
            File a = new File(dir, RCFILE_NAME);
            Shell shell = this;
            shell.readRCFile(a, false);
            if (shell.isInteractive && Getline.isTTY()) {
                this.out.println(new StringBuilder().insert(0, NfsClientV3.ALLATORIxDEMO("\b$%/!/d9'k\"\"(.~k")).append(a).toString());
                return;
            }
        }
        catch (IOException a) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(ProcCredName.ALLATORIxDEMO("mZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDsDYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGZmZGYGYGYGYDZGZGYGZGYGYDZGZDZGZDZGZDYGZDZGYGYGYGYDsDYGYGYGYDYDYDYGYDYGYDYDYGZGYDYDYDYDYGZGYGYGYGYGZmZGYGYGYGZDZGZGYGZGYGZDZGYDYGZGZGZDYGYDYGYGYGYGYDsDYGYGYGYDYDYDZDYDZDYDYDYGZGYDZDYDYDYDZDYGYGYGYGZmZGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYDsDY(\u001b\u0001\f\u0014\u001a\u0006\r\u000e\u0016\tY\u0005\u0000G8\u000b\u0015\u0006\r\b\u000b\u000eY(\u001b\u0001\f\u0014\u001a\u0006\r\b\u000bG\u000fQWPY#<*6GZmZGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYDsDYGYGYGYGYGY\u000f\r\u0013\t]VH\u000e\u0010\u000eI\u0018\u000b\u0015\u0006\r\b\u000b\u000eW\u0004\u0016\nYGYGYGYGYGYGZmZGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYGYDsDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZDZm"));
        Shell a = new Shell();
        try {
            Shell shell;
            String[] args;
            if (args.length == 0) {
                a.isInteractive = true;
            }
            Shell shell2 = a;
            Shell shell3 = a;
            Shell shell4 = a;
            shell4.init("sigar", System.out, System.err);
            shell4.registerCommands();
            shell3.readCommandFile(System.getProperty(NfsClientV3.ALLATORIxDEMO(">7.6e,$).")));
            shell2.readCommandFile(".");
            shell3.readCommandFile(SigarLoader.getLocation());
            if (shell2.isInteractive) {
                Shell shell5 = a;
                shell = shell5;
                shell5.initHistory();
                Getline.setCompleter(shell5);
                shell5.run();
            } else {
                a.handleCommand(null, args);
                shell = a;
            }
            shell.shutdown();
            return;
        }
        catch (Exception a2) {
            System.err.println(new StringBuilder().insert(0, ProcCredName.ALLATORIxDEMO(",\t\u001c\u001f\t\u0002\u001a\u0013\u001c\u0003Y\u0002\u0001\u0004\u001c\u0017\r\u000e\u0016\tCG")).append(a2).toString());
            return;
        }
        finally {
            a.shutdown();
        }
    }

    private /* synthetic */ void registerCommandHandler(String name, String className) throws Exception {
        Class[] classArray = new Class[1];
        classArray[0] = this.getClass();
        Constructor<?> a = Class.forName(className).getConstructor(classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = this;
        this.registerCommandHandler(name, (ShellCommandHandler)a.newInstance(objectArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long[] getPids(SigarProxy sigar, String[] args) throws SigarException {
        int a;
        switch (args.length) {
            case 0: {
                long[] lArray = new long[1];
                lArray[0] = sigar.getPid();
                long[] a2 = lArray;
                return lArray;
            }
            case 1: {
                if (args[0].indexOf(NfsClientV3.ALLATORIxDEMO("v")) > 0) {
                    return ProcessFinder.find(sigar, args[0]);
                }
                if (args[0].equals(ProcCredName.ALLATORIxDEMO("]C"))) {
                    long[] lArray = new long[1];
                    lArray[0] = sigar.getPid();
                    long[] a3 = lArray;
                    return lArray;
                }
                long[] lArray = new long[1];
                lArray[0] = Long.parseLong(args[0]);
                long[] a4 = lArray;
                return lArray;
            }
        }
        long[] a5 = new long[args.length];
        int n = a = 0;
        while (n < args.length) {
            int n2 = a++;
            a5[n2] = Long.parseLong(args[n2]);
            n = a;
        }
        return a5;
    }

    public Sigar getSigar() {
        return this.sigar;
    }

    public SigarProxy getSigarProxy() {
        return this.proxy;
    }
}

